/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.schedule.draw.dialogform;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.domian.handler.CalServiceLengthHandler;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;
import kd.sdk.hr.hspm.common.utils.CommonUtil;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.base.AbstractFormDrawEdit;

public class EmpEntRelDrawPlugin
extends AbstractFormDrawEdit {
    private static final Log LOGGER = LogFactory.getLog(EmpEntRelDrawPlugin.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Button btnsave = (Button)this.getView().getControl("btnsave");
        btnsave.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        this.setValueFromDb(formShowParameter, "hrpi_empentrel", null);
        this.setServiceLength();
        this.getModel().setDataChanged(false);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (HRStringUtils.equals((String)source.getKey(), (String)"btnsave")) {
            if (!this.getModel().getDataChanged()) {
                LOGGER.warn("getNoChangeEmpEnt");
                HashMap<String, Boolean> retMap = new HashMap<String, Boolean>(16);
                retMap.put("success", Boolean.TRUE);
                AttacheHandlerService.getInstance().closeView(this.getView(), retMap, this.getView().getParentView());
                return;
            }
            DynamicObjectCollection empEnDys = this.buildUpdateSingleAttachData("hrpi_empentrel", this.getView(), null, null);
            HashMap<String, DynamicObjectCollection> saveOrUpdateMap = new HashMap<String, DynamicObjectCollection>(16);
            if (empEnDys != null && empEnDys.size() > 0) {
                saveOrUpdateMap.put("hrpi_empentrel", empEnDys);
            }
            FormShowParameter formShowParameter = source.getView().getFormShowParameter();
            IPageCache oldDbData = this.getView().getPageCache();
            String oldDataStr = oldDbData.get("hrpi_empentreloldDbData");
            Map oldMap = (Map)SerializationUtils.fromJsonString((String)oldDataStr, Map.class);
            this.buildEmployeeDy(saveOrUpdateMap, formShowParameter, oldMap);
            this.buildServiceLengthDys(saveOrUpdateMap, formShowParameter, oldMap);
            AttacheHandlerService.getInstance().invokeSaveOrUpdate(this.getView(), saveOrUpdateMap, true, "hrpi_empentrel", "0");
        }
    }

    private void buildServiceLengthDys(Map<String, DynamicObjectCollection> saveOrUpdateMap, FormShowParameter formShowParameter, Map<String, Object> oldMap) {
        boolean update = this.addUpdateData("adjustlength", oldMap);
        if (!update) {
            return;
        }
        String serviceLen = this.getView().getPageCache().get("servicelengthcache");
        HRBaseServiceHelper empServiceHelper = new HRBaseServiceHelper("hrpi_pernontsprop");
        Long personId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("person"));
        DynamicObject empDy = empServiceHelper.loadDynamicObject(new QFilter("person", "=", (Object)personId));
        if (empDy != null) {
            DynamicObject sendDy = empServiceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)empDy, (DynamicObject)sendDy);
            sendDy.set("entservicelen", (Object)serviceLen);
            DynamicObjectCollection empDys = new DynamicObjectCollection();
            empDys.add((Object)sendDy);
            saveOrUpdateMap.put("hrpi_pernontsprop", empDys);
        }
    }

    private DynamicObject queryEmpEntRelDy(FormShowParameter formShowParameter) {
        HRBaseServiceHelper empServiceHelper = new HRBaseServiceHelper("hrpi_empentrel");
        QFilter idFilter = new QFilter("id", "=", (Object)Long.parseLong((String)formShowParameter.getCustomParam("pkid")));
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        qFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        return empServiceHelper.queryOne("serviceagescheme,servicelength,adjustlength,startdate,enddate,boid,employee.id,labrelstatusprd", new QFilter[]{qFilter, idFilter});
    }

    private void buildEmployeeDy(Map<String, DynamicObjectCollection> saveOrUpdateMap, FormShowParameter formShowParameter, Map<String, Object> oldMap) {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity();
        boolean update = this.addUpdateData("laborrelstatus", oldMap);
        if (!update) {
            return;
        }
        HRBaseServiceHelper empServiceHelper = new HRBaseServiceHelper("hrpi_employee");
        Long empId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("employee"));
        DynamicObject empDy = empServiceHelper.loadSingle((Object)empId);
        if (empDy != null) {
            DynamicObject sendDy = empServiceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)empDy, (DynamicObject)sendDy);
            sendDy.set("laborrelstatus", dataEntity.get("laborrelstatus"));
            DynamicObjectCollection empDys = new DynamicObjectCollection();
            empDys.add((Object)sendDy);
            saveOrUpdateMap.put("hrpi_employee", empDys);
        }
    }

    private boolean addUpdateData(String field, Map<String, Object> oldMap) {
        boolean labStatusExist = this.isFieldExist(field);
        DynamicObject dataEntity = this.getView().getModel().getDataEntity();
        if (labStatusExist) {
            boolean sameWord = false;
            try {
                sameWord = CommonUtil.customObjectEquals((Object)dataEntity.get(field), (Object)oldMap.get(field), (String)"yyyy-MM-dd");
            }
            catch (Exception es) {
                LOGGER.error("handleTimeError");
            }
            return !sameWord;
        }
        return false;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (HRStringUtils.equals((String)key, (String)"adjustlength")) {
            this.setServiceLength();
        }
    }

    private void setServiceLength() {
        DynamicObject empEntDy = this.queryEmpEntRelDy(this.getView().getFormShowParameter());
        BigDecimal adjustLength = new BigDecimal(0);
        Date startDate = null;
        startDate = !this.getModel().getDataEntityType().getAllFields().containsKey("startdate") ? empEntDy.getDate("startdate") : (Date)this.getModel().getValue("startdate");
        adjustLength = !this.getModel().getDataEntityType().getAllFields().containsKey("adjustlength") ? empEntDy.getBigDecimal("adjustlength") : (BigDecimal)this.getModel().getValue("adjustlength");
        if (startDate == null) {
            if (this.getModel().getDataEntityType().getAllFields().containsKey("servicelength")) {
                this.getModel().setValue("servicelength", (Object)0);
            }
        } else {
            String scheme = empEntDy.getString("serviceagescheme");
            if ("2".equals(scheme)) {
                BigDecimal serLen;
                Map serLenMap = CalServiceLengthHandler.calcEmpentrelContinuation(Collections.singletonList(empEntDy), (String)"0", (String)"1");
                if (this.getModel().getDataEntityType().getAllFields().containsKey("servicelength") && (serLen = (BigDecimal)serLenMap.get(empEntDy.getLong("employee.mid"))) != null) {
                    BigDecimal serAdd = serLen.add(adjustLength);
                    this.getModel().setValue("servicelength", (Object)serAdd);
                    this.getView().getPageCache().put("servicelengthcache", String.valueOf(serAdd));
                }
            } else {
                Date endDate = new Date();
                long statusPro = empEntDy.getLong("labrelstatusprd.id");
                if (statusPro == 1020L) {
                    endDate = empEntDy.getDate("enddate");
                }
                BigDecimal serLength = BusinessUtils.calcYearsDiff((Date)endDate, (Date)new Date(startDate.getTime())).add(adjustLength);
                if (this.getModel().getDataEntityType().getAllFields().containsKey("servicelength")) {
                    this.getView().getPageCache().put("servicelengthcache", String.valueOf(serLength));
                    this.getModel().setValue("servicelength", (Object)serLength);
                }
            }
        }
    }
}

