/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.schedule.draw.dialogform;

import java.text.MessageFormat;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.base.AbstractFormDrawEdit;

public class ErManFileDrawPlugin
extends AbstractFormDrawEdit {
    private static final Log LOGGER = LogFactory.getLog(ErManFileDrawPlugin.class);

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        AttacheHandlerService.getInstance().buildUniqueParam(formShowParameter, "hspm_ermanfile");
        super.loadCustomControlMetas(args);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        AttacheHandlerService.getInstance().setMainPageStyle(this.getView());
        this.setValueFromDb(formShowParameter, "hspm_ermanfile", "erfileid");
        this.getView().setStatus(OperationStatus.VIEW);
        this.getModel().setDataChanged(false);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        AttacheHandlerService.getInstance().commonBtnReg(this.getView(), (HRDataBaseEdit)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if ("edit".equals(source.getKey()) || "edit_label".equals(source.getKey())) {
            this.getModel().setDataChanged(false);
            this.getView().setStatus(OperationStatus.EDIT);
        } else if ("btncancel".equals(source.getKey()) || "btncancel_label".equals(source.getKey())) {
            if (this.getModel().getDataChanged()) {
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                String mainType = (String)formShowParameter.getCustomParam("type");
                this.clickCancelChanged(mainType);
            } else {
                this.getView().setStatus(OperationStatus.VIEW);
                this.getView().invokeOperation("refresh");
            }
        } else if ("btnsave".equals(source.getKey()) || "btnsave_label".equals(source.getKey())) {
            if (this.getModel().getDataEntityType().getProperties().containsKey((Object)"hspm_ermanfile-org_id")) {
                long orgId = this.getModel().getDataEntity().getLong("hspm_ermanfile-org_id");
                LOGGER.info(MessageFormat.format("updateOrgId:{0}", orgId));
            }
            if (this.getModel().getDataEntityType().getProperties().containsKey((Object)"hspm_ermanfile-org")) {
                DynamicObject orgDy = this.getModel().getDataEntity().getDynamicObject("hspm_ermanfile-org");
                LOGGER.info(MessageFormat.format("updateOrgIdObject:{0}", orgDy));
            }
            this.acrossEntitySaveOrUpdate();
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().invokeOperation("refresh");
        }
    }

    public void propertyChanged(PropertyChangedArgs event) {
        super.propertyChanged(event);
        String name = event.getProperty().getName();
        if ("hspm_ermanfile-affiliateadminorg".equals(name)) {
            Long emposeId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("empposrel"));
            ChangeData[] changeSet = event.getChangeSet();
            ChangeData changeData = changeSet[0];
            DynamicObject adminOrgDy = (DynamicObject)changeData.getNewValue();
            long adminOrgId = 0L;
            long dbAdminOrgId = 0L;
            if (adminOrgDy != null) {
                adminOrgId = adminOrgDy.getLong("id");
            }
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_empposorgrel");
            QFilter pkFilter = new QFilter("id", "=", (Object)emposeId);
            DynamicObject dynamicObject = serviceHelper.queryOne("id,adminorg", new QFilter[]{pkFilter});
            if (dynamicObject != null) {
                dbAdminOrgId = dynamicObject.getLong("adminorg.id");
            }
            DynamicObject dataEntity = this.getModel().getDataEntity();
            if (adminOrgId != dbAdminOrgId) {
                this.getModel().setValue("hspm_ermanfile-ismanaged", (Object)"1");
                dataEntity.set("hspm_ermanfile-ismanaged", (Object)"1");
            } else {
                this.getModel().setValue("hspm_ermanfile-ismanaged", (Object)"0");
                dataEntity.set("hspm_ermanfile-ismanaged", (Object)"0");
            }
        }
    }

    protected void drawFormTitleFlex(int index, List<Map<String, Object>> groups, FlexPanelAp flexPanelAp, boolean isNeedTitle) {
        super.drawFormTitleFlex(index, groups, flexPanelAp, false);
    }

    protected Map<String, Object> diffDialogOrForm() {
        Map diffMap = super.diffDialogOrForm();
        diffMap.put("isdia", Boolean.FALSE);
        diffMap.put("across_entity", "across_entity");
        return diffMap;
    }
}

