/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.schedule.draw.dialogform;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.utils.HspmDateUtils;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.base.AbstractFormDrawEdit;

public class PerProTitleEditPlugin
extends AbstractFormDrawEdit {
    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        if (OperationStatus.EDIT.equals((Object)status) || OperationStatus.VIEW.equals((Object)status)) {
            this.setValueFromDb(formShowParameter, "hrpi_perprotitle", null);
            this.setAttachment("hrpi_perprotitle", "attachmentpanelap_std");
        }
        this.getModel().setDataChanged(false);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"btnsave"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if ("btnsave".equals(key)) {
            if (!this.validateDate()) {
                return;
            }
            Map resultMap = new HashMap(16);
            if (OperationStatus.EDIT.equals((Object)status)) {
                resultMap = this.updateAttachData("hrpi_perprotitle", this.getView(), false, null);
            } else if (OperationStatus.ADDNEW.equals((Object)status)) {
                resultMap = this.addAttachData("hrpi_perprotitle", this.getView(), this.getModel().getDataEntity(), false);
            }
            Object pkId = this.getView().getFormShowParameter().getCustomParam("pkid");
            this.successAfterSave(pkId, resultMap, "attachmentpanelap_std", "hrpi_perprotitle");
            AttacheHandlerService.getInstance().closeView(this.getView(), resultMap, this.getView().getParentView());
        }
    }

    public void remove(UploadEvent evt) {
        this.defaultRemoveAttachment(evt);
    }

    public void upload(UploadEvent evt) {
        this.defaultUploadAttachment(evt);
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String fieldKey = propertyChangedArgs.getProperty().getName();
        Object newValue = propertyChangedArgs.getChangeSet()[0].getNewValue();
        if (newValue == null) {
            return;
        }
        switch (fieldKey) {
            case "awardtime": {
                this.validOnAwardTimeChanged((Date)newValue);
                break;
            }
            case "firsttime": {
                this.validOnFirstTimeChanged((Date)newValue);
                break;
            }
            case "secondtime": {
                this.validOnSecondTimeChanged((Date)newValue);
                break;
            }
        }
    }

    private boolean validateDate() {
        boolean isTip = this.checkTipTime();
        Date secondTime = this.getDateIfExist("secondtime");
        Date firstTime = this.getDateIfExist("firsttime");
        Date awardTime = this.getDateIfExist("awardtime");
        Date lastSecond = HspmDateUtils.getMidnight();
        return this.validDate(awardTime, firstTime, isTip, ResManager.loadKDString((String)"\u6388\u4e88\u65e5\u671f\u5e94\u65e9\u4e8e\u7b2c\u4e00\u6b21\u590d\u5ba1\u65e5\u671f\u3002", (String)"PerProTitleEditPlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0])) && this.validDate(awardTime, secondTime, isTip, ResManager.loadKDString((String)"\u6388\u4e88\u65e5\u671f\u5e94\u65e9\u4e8e\u7b2c\u4e8c\u6b21\u590d\u5ba1\u65e5\u671f\u3002", (String)"PerProTitleEditPlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0])) && this.validDate(firstTime, secondTime, isTip, ResManager.loadKDString((String)"\u7b2c\u4e00\u6b21\u590d\u5ba1\u65e5\u671f\u5e94\u65e9\u4e8e\u7b2c\u4e8c\u6b21\u590d\u5ba1\u65e5\u671f\u3002", (String)"PerProTitleEditPlugin_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
    }

    private boolean validOnAwardTimeChanged(Date awardTime) {
        Date secondTime = this.getDateIfExist("secondtime");
        Date firstTime = this.getDateIfExist("firsttime");
        return this.validDate(awardTime, firstTime, true, ResManager.loadKDString((String)"\u6388\u4e88\u65e5\u671f\u5e94\u65e9\u4e8e\u7b2c\u4e00\u6b21\u590d\u5ba1\u65e5\u671f\u3002", (String)"PerProTitleEditPlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0])) && this.validDate(awardTime, secondTime, true, ResManager.loadKDString((String)"\u6388\u4e88\u65e5\u671f\u5e94\u65e9\u4e8e\u7b2c\u4e8c\u6b21\u590d\u5ba1\u65e5\u671f\u3002", (String)"PerProTitleEditPlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
    }

    private boolean validOnFirstTimeChanged(Date firstTime) {
        Date secondTime = this.getDateIfExist("secondtime");
        Date awardTime = this.getDateIfExist("awardtime");
        return this.validDate(awardTime, firstTime, true, ResManager.loadKDString((String)"\u6388\u4e88\u65e5\u671f\u5e94\u65e9\u4e8e\u7b2c\u4e00\u6b21\u590d\u5ba1\u65e5\u671f\u3002", (String)"PerProTitleEditPlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0])) && this.validDate(firstTime, secondTime, true, ResManager.loadKDString((String)"\u7b2c\u4e00\u6b21\u590d\u5ba1\u65e5\u671f\u5e94\u65e9\u4e8e\u7b2c\u4e8c\u6b21\u590d\u5ba1\u65e5\u671f\u3002", (String)"PerProTitleEditPlugin_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
    }

    private boolean validOnSecondTimeChanged(Date secondTime) {
        Date firstTime = this.getDateIfExist("firsttime");
        Date awardTime = this.getDateIfExist("awardtime");
        return this.validDate(awardTime, secondTime, true, ResManager.loadKDString((String)"\u6388\u4e88\u65e5\u671f\u5e94\u65e9\u4e8e\u7b2c\u4e8c\u6b21\u590d\u5ba1\u65e5\u671f\u3002", (String)"PerProTitleEditPlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0])) && this.validDate(firstTime, secondTime, true, ResManager.loadKDString((String)"\u7b2c\u4e00\u6b21\u590d\u5ba1\u65e5\u671f\u5e94\u65e9\u4e8e\u7b2c\u4e8c\u6b21\u590d\u5ba1\u65e5\u671f\u3002", (String)"PerProTitleEditPlugin_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
    }

    protected Map<String, Object> diffDialogOrForm() {
        Map diffMap = super.diffDialogOrForm();
        diffMap.put("attachmentpanelap_std", "attachmentpanelap_std");
        return diffMap;
    }
}

