/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.schedule.service;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class PermissionService {
    private static Log LOGGER = LogFactory.getLog(PermissionService.class);

    public static boolean isSuperUser() {
        long currUserId = RequestContext.get().getCurrUserId();
        return PermissionServiceHelper.isSuperUser((long)currUserId);
    }

    public static List<Long> getUserHasPermOrgs(Long userId, boolean mustQueryAll) {
        HasPermOrgResult result = PermissionServiceHelper.getUserHasPermOrgs((long)userId, (boolean)mustQueryAll);
        if (result.hasAllOrgPerm()) {
            LOGGER.info("getUserHasPermOrgs:{}", (Object)"hasAllOrgPerm");
            return null;
        }
        return result.getHasPermOrgs();
    }

    public static QFilter getBaseDataFilter(String entityID, List<Long> orgID, boolean isRemoveDup) {
        return BaseDataServiceHelper.getBaseDataFilter((String)entityID, orgID, (boolean)isRemoveDup);
    }

    public static List<Long> getUserHasPermOrgs(boolean mustQueryAll) {
        if (PermissionService.isSuperUser()) {
            return null;
        }
        long userId = RequestContext.get().getCurrUserId();
        return PermissionService.getUserHasPermOrgs(userId, mustQueryAll);
    }

    public static QFilter getBaseDataFilterByOrg(String entityName, boolean isRemoveDup) {
        List<Long> userHasPermOrgs = PermissionService.getUserHasPermOrgs(false);
        if (CollectionUtils.isEmpty(userHasPermOrgs)) {
            LOGGER.info("getBaseDataFilterByOrgIsEmpty");
            return null;
        }
        LOGGER.info("userHasPermOrgs:{}", userHasPermOrgs);
        String entityType = FormMetadataCache.getFormConfig((String)entityName).getEntityTypeId();
        return PermissionService.getBaseDataFilter(entityType, userHasPermOrgs, isRemoveDup);
    }

    public static DynamicObject[] getBaseDataDys(String entityName, boolean isRemoveDup) {
        List<Long> userHasPermOrgs = PermissionService.getUserHasPermOrgs(false);
        LOGGER.info("userHasPermOrgs:{}", userHasPermOrgs);
        if (userHasPermOrgs == null) {
            return null;
        }
        if (userHasPermOrgs.size() == 0) {
            return new DynamicObject[0];
        }
        String entityType = FormMetadataCache.getFormConfig((String)entityName).getEntityTypeId();
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
        QFilter baseDataFilterByOrg = PermissionService.getBaseDataFilter(entityType, userHasPermOrgs, isRemoveDup);
        QFilter enableFilter = new QFilter("status", "=", (Object)"C");
        if (baseDataFilterByOrg != null) {
            return helper.query(new QFilter[]{baseDataFilterByOrg, enableFilter});
        }
        return null;
    }
}

