/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hss.business.domain.handle;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hss.common.bean.handle.CurrentNodeBean;
import kd.hr.hss.common.bean.handle.HandleTaskBean;
import kd.hr.hss.common.bean.handle.PreNodeBean;
import kd.hr.hss.common.enums.HandleTypeEnum;
import kd.hr.hss.common.utils.EnumValueUtils;

public class HandleTaskConvertService {
    String HANDRECORD = "handrecord";
    String BILLNAME = "billname";
    String SUBMITDATE = "submitdate";
    String STATUS_D = "lbl_status_d";
    String STATUS_G = "lbl_status_g";
    String APPROVESTATUS = "approvestatus";
    String HEADPICTURE = "headpicture";
    String APPROVER = "approver";
    String PRENODEAPPROVER = "prenodeapprover";
    String PRENODEAPPROVESTATUS = "prenodeapprovestatus";
    String PRENODESUBMITDATE = "prenodesubmitdate";
    String IMG_ICON1 = "imgicon1";
    String IMG_ICON2 = "imgicon2";
    String URL_ICON1 = "/icons/mobile/other/hr_jixningzhong.png";
    String URL_ICON2 = "/icons/mobile/other/hr_chenggong.png";

    public HandleTaskConvertService(AbstractFormPlugin plugin, List<HandleTaskBean> bills) {
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>(bills.size());
        for (HandleTaskBean bill : bills) {
            String status;
            HashMap<String, Object> billMap = new HashMap<String, Object>();
            billMap.put(this.BILLNAME, this.getTextMap(HandleTypeEnum.getDescription((String)bill.getType())));
            if (bill.getSubmitDate() != null) {
                billMap.put(this.SUBMITDATE, this.getTextMap(MessageFormat.format(ResManager.loadKDString((String)"{0} \u63d0\u4ea4", (String)"HandingTaskBillConvertToLabel_1", (String)"hr-hss-business", (Object[])new Object[0]), HRDateTimeUtils.format((Date)bill.getSubmitDate(), (String)"yyyy-MM-dd"))));
            }
            if ("D".equals(status = bill.getBillStatus()) || "B".equals(status)) {
                billMap.put(this.STATUS_D, this.getTextMap(EnumValueUtils.getBillStatusValue((String)status)));
            } else if ("G".equals(status)) {
                billMap.put(this.STATUS_G, this.getTextMap(EnumValueUtils.getBillStatusValue((String)status)));
            }
            this.setCurrentNodeLabel(billMap, bill.getCurrentNodeBean());
            this.setPreNodeLabel(billMap, bill.getPreNodeBean());
            billMap.put(this.IMG_ICON1, this.getImgMap(this.URL_ICON1));
            billMap.put(this.IMG_ICON2, this.getImgMap(this.URL_ICON2));
            list.add(billMap);
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("data", list);
        if (plugin != null) {
            plugin.getPageCache().put("data", SerializationUtils.toJsonString(bills));
            dataMap.put("k", this.HANDRECORD);
            IClientViewProxy proxy = (IClientViewProxy)plugin.getView().getService(IClientViewProxy.class);
            proxy.addAction("u", dataMap);
        }
    }

    private void setPreNodeLabel(Map<String, Object> textMap, PreNodeBean preNode) {
        String name = preNode.getApproverName();
        textMap.put(this.PRENODEAPPROVER, this.getTextMap(MessageFormat.format(ResManager.loadKDString((String)"\u4e0a\u7ea7\u8282\u70b9\uff1a{0}", (String)"HandingTaskBillConvertToLabel_0", (String)"hr-hss-business", (Object[])new Object[0]), HRStringUtils.isEmpty((String)name) ? " " : name)));
        textMap.put(this.PRENODEAPPROVESTATUS, this.getTextMap(preNode.getApproveStatus()));
        if (preNode.getApproveDate() != null) {
            textMap.put(this.PRENODESUBMITDATE, this.getTextMap(HRDateTimeUtils.format((Date)preNode.getApproveDate(), (String)"yyyy-MM-dd HH:mm")));
        }
    }

    private void setCurrentNodeLabel(Map<String, Object> textMap, CurrentNodeBean currentNode) {
        textMap.put(this.APPROVESTATUS, this.getTextMap(currentNode.getApproveStatus()));
        textMap.put(this.HEADPICTURE, this.getImgMap(this.getImageUrl(currentNode.getHeadPicture())));
        textMap.put(this.APPROVER, this.getTextMap(currentNode.getName()));
    }

    private String getImageUrl(String headSculpture) {
        if (HRStringUtils.isNotEmpty((String)headSculpture)) {
            return HRImageUrlUtil.getImageFullUrl((String)headSculpture);
        }
        return headSculpture;
    }

    private Map<String, Object> getImgMap(String image) {
        HashMap<String, Object> iconMap = new HashMap<String, Object>();
        iconMap.put("imageKey", image);
        return iconMap;
    }

    private Map<String, Object> getTextMap(String text) {
        HashMap<String, Object> textMap = new HashMap<String, Object>(16);
        textMap.put("text", text);
        return textMap;
    }
}

