/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hss.business.domain.repository;

import com.google.common.collect.Lists;
import com.kingdee.bos.qing.util.CollectionUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hss.business.domain.repository.BosUserRepository;
import kd.hr.hss.business.domain.service.selfservice.IEmpSelfService;
import kd.hr.hss.common.bean.handle.CurrentNodeBean;
import kd.hr.hss.common.bean.handle.HandleRecordBean;
import kd.hr.hss.common.bean.handle.HandleTaskBean;
import kd.hr.hss.common.bean.handle.PreNodeBean;
import kd.hr.hss.common.enums.HandleTypeEnum;

public class HandleRecordRepository {
    private static final Log LOGGER = LogFactory.getLog(HandleRecordRepository.class);
    private static final HRBaseServiceHelper REG_SERVICE_HELPER = new HRBaseServiceHelper("hdm_regbasebill");
    private static final HRBaseServiceHelper QUIT_SERVICE_HELPER = new HRBaseServiceHelper("htm_quitapplybasebill");
    private static final HandleRecordRepository HANDLE_RECORD_REPOSITORY = new HandleRecordRepository();
    private static final HRBaseServiceHelper WF_HIS_COMMENT_HELPER = new HRBaseServiceHelper("wf_hicomment");
    private static final HRBaseServiceHelper WF_HIS_TASK_HELPER = new HRBaseServiceHelper("wf_hitaskinst");

    public static HandleRecordRepository getInstance() {
        return HANDLE_RECORD_REPOSITORY;
    }

    public List<HandleTaskBean> getQuitApplyTask() {
        QFilter viewFilter = new QFilter("isviewflow", "=", (Object)Boolean.TRUE);
        DynamicObject[] dys = QUIT_SERVICE_HELPER.query("id,billstatus,submitdate", new QFilter[]{this.getHandleRecordFilter(), viewFilter});
        ArrayList list = Lists.newArrayListWithExpectedSize((int)dys.length);
        for (DynamicObject dy : dys) {
            list.add(this.getTaskBean(dy, HandleTypeEnum.QUIT.getType(), "submitdate"));
        }
        return list;
    }

    public List<HandleTaskBean> getRegTask() {
        DynamicObject[] dys = REG_SERVICE_HELPER.query("id,billstatus,submittime", new QFilter[]{this.getHandleRecordFilter()});
        ArrayList list = Lists.newArrayListWithExpectedSize((int)dys.length);
        for (DynamicObject dy : dys) {
            list.add(this.getTaskBean(dy, HandleTypeEnum.REG.getType(), "submittime"));
        }
        return list;
    }

    public HandleTaskBean getTaskBean(DynamicObject dy, String type, String submitTimeName) {
        HandleTaskBean bean = new HandleTaskBean();
        bean.setId(Long.valueOf(dy.getLong("id")));
        bean.setType(type);
        bean.setBillStatus(dy.getString("billstatus"));
        bean.setSubmitDate(dy.getDate(submitTimeName));
        String businessKey = String.valueOf(dy.getLong("id"));
        bean.setCurrentNodeBean(this.getCurrentNode(businessKey));
        bean.setPreNodeBean(this.getPreNode(businessKey));
        return bean;
    }

    public List<HandleRecordBean> getQuitApplyRecord() {
        QFilter personFilter = new QFilter("person", "=", (Object)IEmpSelfService.getInstance().getCurrentPersonId());
        personFilter.and(new QFilter("billstatus", "!=", (Object)"F").and(new QFilter("billstatus", "!=", (Object)"E")));
        QFilter viewFilter = new QFilter("isviewflow", "=", (Object)Boolean.TRUE);
        DynamicObject[] dynamicObjects = QUIT_SERVICE_HELPER.query("id,billstatus,submitdate,creator,createtime,modifytime", new QFilter[]{personFilter, viewFilter});
        ArrayList list = Lists.newArrayListWithExpectedSize((int)dynamicObjects.length);
        for (DynamicObject dy : dynamicObjects) {
            if ("A".equals(dy.getString("billstatus")) && RequestContext.get().getCurrUserId() != dy.getLong("creator.id")) continue;
            HandleRecordBean record = new HandleRecordBean();
            record.setId(dy.getLong("id"));
            record.setType(HandleTypeEnum.QUIT.getType());
            Date date = "A".equals(dy.getString("billstatus")) ? dy.getDate("createtime") : dy.getDate("submitdate");
            record.setDate(HRDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd"));
            record.setModifyTime(HRDateTimeUtils.format((Date)dy.getDate("modifytime"), (String)"yyyy-MM-dd HH:mm:ss"));
            record.setStatus(dy.getString("billstatus"));
            list.add(record);
        }
        return list;
    }

    public List<HandleRecordBean> getRegRecord() {
        QFilter creatorFilter = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId());
        QFilter personFilter = new QFilter("person", "=", (Object)IEmpSelfService.getInstance().getCurrentPersonId());
        DynamicObject[] dynamicObjects = REG_SERVICE_HELPER.query("id,billstatus,createtime,modifytime,submittime", new QFilter[]{creatorFilter, personFilter});
        ArrayList list = Lists.newArrayListWithExpectedSize((int)dynamicObjects.length);
        for (DynamicObject dy : dynamicObjects) {
            HandleRecordBean record = new HandleRecordBean();
            record.setType(HandleTypeEnum.REG.getType());
            record.setId(dy.getLong("id"));
            Date date = "A".equals(dy.getString("billstatus")) ? dy.getDate("createtime") : dy.getDate("submittime");
            record.setDate(HRDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd"));
            record.setModifyTime(HRDateTimeUtils.format((Date)dy.getDate("modifytime"), (String)"yyyy-MM-dd HH:mm:ss"));
            record.setStatus(dy.getString("billstatus"));
            list.add(record);
        }
        return list;
    }

    private QFilter getHandleRecordFilter() {
        QFilter filter = new QFilter("person", "=", (Object)IEmpSelfService.getInstance().getCurrentPersonId());
        ArrayList<String> statuList = new ArrayList<String>(16);
        statuList.add("D");
        statuList.add("B");
        statuList.add("G");
        filter.and(new QFilter("billstatus", "in", statuList));
        return filter;
    }

    public CurrentNodeBean getCurrentNode(String businessKey) {
        Map<String, String> userInfo;
        CurrentNodeBean currentNode = new CurrentNodeBean();
        List userList = WorkflowServiceHelper.getApproverByBusinessKey((String)businessKey);
        LOGGER.info(MessageFormat.format("HandleRecordRepository.getCurrentNode userInfo={0}", userList));
        if (userList != null && !userList.isEmpty() && (userInfo = BosUserRepository.getInstance().getPersonInfo((Long)userList.get(0))) != null) {
            String name = userInfo.get("name");
            if (userList.size() > 1) {
                name = MessageFormat.format(ResManager.loadKDString((String)"{0}\u7b49{1}\u4eba", (String)"HandleRecordRepository_0", (String)"hr-hss-business", (Object[])new Object[0]), name, userList.size());
            }
            currentNode.setName(name);
            currentNode.setHeadPicture(userInfo.get("headsculpture"));
        }
        boolean inProcess = WorkflowServiceHelper.inProcess((String)businessKey);
        List records = WorkflowServiceHelper.getAllApprovalRecord((String)businessKey);
        if (CollectionUtils.isNotEmpty((Collection)records) && inProcess) {
            IApprovalRecordItem recordItem = (IApprovalRecordItem)((IApprovalRecordGroup)records.get(records.size() - 1)).getChildren().get(0);
            currentNode.setApproveStatus(recordItem.getResult());
        }
        return currentNode;
    }

    public PreNodeBean getPreNode(String businessKey) {
        QFilter taskFilter;
        DynamicObject[] query;
        PreNodeBean preNode = new PreNodeBean();
        QFilter keyFilter = new QFilter("businesskey", "=", (Object)businessKey);
        QFilter categoryFilter = new QFilter("category", "!=", (Object)"HRActivity");
        DynamicObject[] categoryDys = WF_HIS_TASK_HELPER.query("id", new QFilter[]{keyFilter, categoryFilter});
        if (categoryDys != null && categoryDys.length != 0 && (query = WF_HIS_COMMENT_HELPER.query("decisiontype,time,userid,taskid,resultname", new QFilter[]{keyFilter, taskFilter = new QFilter("taskid", "in", Arrays.stream(categoryDys).map(row -> row.getLong("id")).collect(Collectors.toList()))}, "step desc", 1)) != null && query.length != 0) {
            DynamicObject comment = query[0];
            Map<String, String> userInfo = BosUserRepository.getInstance().getPersonInfo(comment.getLong("userid"));
            if (userInfo != null) {
                preNode.setApproverName(userInfo.get("name"));
            }
            preNode.setApproveStatus(comment.getString("resultname"));
            preNode.setApproveDate(comment.getDate("time"));
            preNode.setDecisionType(comment.getString("decisiontype"));
        }
        return preNode;
    }
}

