/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hss.business.domain.service.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hss.business.domain.service.selfservice.IEmpSelfService;
import kd.hr.hss.common.constants.PreSetDataValueConstants;

public class EmpSelfServiceImpl
implements IEmpSelfService {
    private static final Log LOGGER = LogFactory.getLog(EmpSelfServiceImpl.class);
    private static final String HRPI_EMPENTREL = "hrpi_empentrel";

    @Override
    public Map<String, Object> getPersonInfo() {
        Map<String, Long> personModelId = this.getPersonModelId();
        if (personModelId == null) {
            LOGGER.info("EmpSelfService,personModelId is null");
            return null;
        }
        HashMap<String, Object> personInfoMap = new HashMap<String, Object>(16);
        Map personInfoRes = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonInfo", (Object[])new Object[]{personModelId.get("person")});
        Map employeeMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"getEmployee", (Object[])new Object[]{personModelId.get("employee")});
        Date startDate = (Date)employeeMap.get("startdate");
        personInfoMap.put("name", personInfoRes.get("name"));
        personInfoMap.put("headsculpture", personInfoRes.get("headsculpture"));
        personInfoMap.put("startdate", startDate);
        personInfoMap.put("company", personInfoRes.get("company"));
        return personInfoMap;
    }

    @Override
    public Long getCurrentPersonId() {
        Map<String, Long> personInfo = this.getPersonModelId();
        if (personInfo != null) {
            return personInfo.get("person");
        }
        return 0L;
    }

    @Override
    public Boolean isShowAppEntry(String metanumber) {
        Map<String, Long> personModelId = this.getPersonModelId();
        if (personModelId == null) {
            return Boolean.FALSE;
        }
        Long employeeId = personModelId.get("employee");
        if (HRStringUtils.equals((String)"htm_quitapplyemp_mob", (String)metanumber)) {
            ArrayList<Long> laborreltypeclsIdList = new ArrayList<Long>(16);
            laborreltypeclsIdList.add(PreSetDataValueConstants.LABORREL_TYPE_CLS_1010);
            laborreltypeclsIdList.add(PreSetDataValueConstants.LABORREL_TYPE_CLS_1020);
            QFilter laborreltypeclsQFilter = new QFilter("laborreltype.laborreltypecls", "in", laborreltypeclsIdList);
            List empentrelList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonSyncService", (String)"listFieldsFilterInfo", (Object[])new Object[]{"id", laborreltypeclsQFilter, HRPI_EMPENTREL, null, null, employeeId});
            return !CollectionUtils.isEmpty((Collection)empentrelList);
        }
        if (HRStringUtils.equals((String)"hdm_selfhelp_entry", (String)metanumber)) {
            QFilter labrelstatusclsQFilter = new QFilter("laborrelstatus.labrelstatuscls", "=", (Object)PreSetDataValueConstants.LABREL_STATUS_CLS_1010);
            List empentrelList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonSyncService", (String)"listFieldsFilterInfo", (Object[])new Object[]{"id", labrelstatusclsQFilter, HRPI_EMPENTREL, null, null, employeeId});
            return !CollectionUtils.isEmpty((Collection)empentrelList);
        }
        return Boolean.TRUE;
    }

    @Override
    public Tuple<Boolean, String> empSelfServiceValidate() {
        Map<String, Long> personModelId = this.getPersonModelId();
        if (personModelId == null || personModelId.get("employee") == null || personModelId.get("employee") == 0L || !this.isEmployed(personModelId.get("employee")).booleanValue()) {
            LOGGER.info("empSelfServiceValidate======HRperson not exist");
            String errMsg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u9879\u4e1a\u52a1\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u64cd\u4f5c", (String)"EmpSelfServiceImpl_0", (String)"hr-hss-business", (Object[])new Object[0]);
            return Tuple.create((Object)Boolean.FALSE, (Object)errMsg);
        }
        return Tuple.create((Object)Boolean.TRUE, null);
    }

    private Map<String, Long> getPersonModelId() {
        Map personModelIdMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonModelId", (Object[])new Object[0]);
        Map personModelInfo = personModelIdMap == null ? null : (Map)personModelIdMap.get("data");
        LOGGER.info(MessageFormat.format("EmpSelfService====getPersonId,personInfo = {0}", personModelInfo));
        return personModelInfo;
    }

    private Boolean isEmployed(Long employeeId) {
        ArrayList<Long> statusClsIdList = new ArrayList<Long>(16);
        statusClsIdList.add(PreSetDataValueConstants.LABREL_STATUS_CLS_1010);
        statusClsIdList.add(PreSetDataValueConstants.LABREL_STATUS_CLS_1020);
        statusClsIdList.add(PreSetDataValueConstants.LABREL_STATUS_CLS_1030);
        QFilter labrelstatusclsQFilter = new QFilter("laborrelstatus.labrelstatuscls", "in", statusClsIdList);
        List empentrelList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonSyncService", (String)"listFieldsFilterInfo", (Object[])new Object[]{"id", labrelstatusclsQFilter, HRPI_EMPENTREL, null, null, employeeId});
        return !CollectionUtils.isEmpty((Collection)empentrelList);
    }
}

