/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hss.formplugin.common;

import java.util.Map;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hss.common.enums.LabelStyleEnum;

public class SelfServicePageUtil {
    public static FlexPanelAp customFlexPane(String apKey, Margin margin, Padding padding, Border border, String width, String height) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(apKey);
        Style style = new Style();
        if (margin != null) {
            style.setMargin(margin);
        }
        if (padding != null) {
            style.setPadding(padding);
        }
        if (border != null) {
            style.setBorder(border);
        }
        if (width != null) {
            flexPanelAp.setWidth(new LocaleString(width));
        }
        if (height != null) {
            flexPanelAp.setHeight(new LocaleString(height));
        }
        flexPanelAp.setStyle(style);
        return flexPanelAp;
    }

    public static LabelAp customLabel(String apKey, LocaleString name, int fontSize, String fontColor) {
        LabelAp labelAp = new LabelAp();
        labelAp.setKey(apKey);
        labelAp.setName(name);
        labelAp.setFontSize(fontSize);
        labelAp.setForeColor(fontColor);
        return labelAp;
    }

    public static void setFlexDirection(FlexPanelAp flexPanelAp, String flexDirection, boolean flexWrap, String justifyContent, String alignItems) {
        if (HRStringUtils.isNotEmpty((String)flexDirection)) {
            flexPanelAp.setDirection(flexDirection);
        }
        flexPanelAp.setWrap(flexWrap);
        if (HRStringUtils.isNotEmpty((String)justifyContent)) {
            flexPanelAp.setJustifyContent(justifyContent);
        }
        if (HRStringUtils.isNotEmpty((String)alignItems)) {
            flexPanelAp.setAlignItems(alignItems);
        }
    }

    public static void setFlexGrowAndShrink(FlexPanelAp flexPanelAp, int grow, int shrink) {
        flexPanelAp.setGrow(grow);
        flexPanelAp.setShrink(shrink);
    }

    public static void showMobFormInContainer(IFormView view, String formId, String targetKey, Map<String, Object> params) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        if (params != null && !params.isEmpty()) {
            showParameter.setCustomParams(params);
        }
        view.showForm((FormShowParameter)showParameter);
    }

    public static VectorAp customStatusVectorAp(String apKey, String foreColor, String fontClass) {
        VectorAp statusIconAp = new VectorAp();
        statusIconAp.setKey(apKey);
        statusIconAp.setGrow(0);
        statusIconAp.setShrink(1);
        statusIconAp.setFontSize(14);
        if (foreColor != null) {
            statusIconAp.setForeColor(foreColor);
        }
        if (fontClass != null) {
            statusIconAp.setfontClass(fontClass);
        }
        statusIconAp.setAlignSelf("center");
        statusIconAp.setNeedHoverClass(false);
        statusIconAp.setClickable(true);
        return statusIconAp;
    }

    public static void setLblText(IFormView view, String key, String text) {
        Label label = (Label)view.getControl(key);
        if (label != null) {
            label.setText(text);
        }
    }

    public static void setAvatar(IFormView formView, String key, String imageUrl) {
        if (HRObjectUtils.isEmpty((Object)imageUrl)) {
            return;
        }
        Image image = (Image)formView.getControl(key);
        image.setUrl(imageUrl);
    }

    public static void showMobileBill(IFormView view, String formId, ShowType type, Map<String, Object> params, Object id) {
        MobileBillShowParameter showParameter = new MobileBillShowParameter();
        showParameter.setFormId(formId);
        if (id != null) {
            showParameter.setPkId(id);
        }
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setHasRight(true);
        showParameter.getOpenStyle().setShowType(type);
        showParameter.setClientParam("requestBeforeClose", (Object)Boolean.TRUE);
        if (params != null && !params.isEmpty()) {
            showParameter.setCustomParams(params);
        }
        view.showForm((FormShowParameter)showParameter);
    }

    public static void showMobileForm(IFormView view, String formId, ShowType type, Map<String, Object> params) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(type);
        showParameter.setClientParam("requestBeforeClose", (Object)Boolean.TRUE);
        if (params != null && !params.isEmpty()) {
            showParameter.setCustomParams(params);
        }
        view.showForm((FormShowParameter)showParameter);
    }

    public static HRFlexPanelAp.Builder createColumnFlexPanel(String key) {
        return new HRFlexPanelAp.Builder(key).setDirection("column").setWrap(false).setJustifyContent("flex-start").setAlignItems("stretch").setHeight("default").setGrow(0).setShrink(0);
    }

    public static void createLabelAp(IFormView view, String key, LabelStyleEnum styleEnum, String text, String type) {
        LabelAp statusLabel = new LabelAp();
        statusLabel.setKey(key);
        statusLabel.setName(new LocaleString(text));
        statusLabel.setFontSize(12);
        statusLabel.setForeColor(styleEnum.getColor());
        statusLabel.setBackColor(styleEnum.getBgColor());
        statusLabel.setLineHeight("16px");
        Padding padding = new Padding();
        padding.setLeft("8px");
        padding.setRight("8px");
        padding.setTop("2px");
        padding.setBottom("2px");
        Border border = new Border();
        String boderLength = "pc".equals(type) ? "1px" : "0.5px";
        String borderStyle = boderLength + "_solid_" + styleEnum.getBorderColor();
        border.setLeft(borderStyle);
        border.setRight(borderStyle);
        border.setTop(borderStyle);
        border.setBottom(borderStyle);
        Style style = new Style();
        style.setPadding(padding);
        style.setBorder(border);
        statusLabel.setStyle(style);
        view.updateControlMetadata(key, statusLabel.createControl());
    }
}

