/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hss.formplugin.selfservice;

import java.text.MessageFormat;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hss.business.domain.service.selfservice.IEmpSelfService;
import kd.hr.hss.formplugin.common.SelfServicePageUtil;

public class AppEntryPlugin
extends AbstractMobFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(AppEntryPlugin.class);
    private static final String APPENTRY_LIST_FLEX = "appentrylistflex";
    private static final String FLEX_APPENTRY = "flexappentry";
    private static final String FLEX_ICON = "flexicon";
    private static final String ICON = "icon";
    private static final String FLEX_APPTILTE = "flexapptiltle";
    private static final String LABEL_NAME = "labelname";
    private static final String LABEL_SUBTILTE = "labelsubtilte";
    private static final String FLEX_FONT = "flexfont";
    private static final String VECTOR_HOUFAN = "vectorhoufan";
    private static final String KDFONT_HOUFAN = "kdfont kdfont-houfan";
    private static final String FLEX_END = "flex-end";
    private static final String FLEX_START = "flex-start";
    private static final String CENTER = "center";
    private static final String SPLIT_STR = "0";

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        this.buildAllAppEntry(args);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (this.isAppEntryFlex(key).booleanValue()) {
            this.showMobileView(key);
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        if (this.isAppEntryFlex(key).booleanValue()) {
            Container container = new Container();
            container.setKey(key);
            container.setView(this.getView());
            container.addClickListener((ClickListener)this);
            args.setControl((Control)container);
        }
    }

    private void buildAllAppEntry(LoadCustomControlMetasArgs args) {
        LOGGER.info(MessageFormat.format("buildAllAppEntry==beforeInvoke=={0}", System.currentTimeMillis()));
        List appEntryConfigList = (List)HRMServiceHelper.invokeHRMPService((String)"hbss", (String)"IHBSSEmpSelfConfigService", (String)"getAllAppEntryConfig", (Object[])new Object[0]);
        LOGGER.info(MessageFormat.format("buildAllAppEntry==afterInvoke=={0}", System.currentTimeMillis()));
        if (appEntryConfigList == null || appEntryConfigList.isEmpty()) {
            return;
        }
        int index = 0;
        FlexPanelAp appentryListFlex = new FlexPanelAp();
        appentryListFlex.setKey(APPENTRY_LIST_FLEX);
        appEntryConfigList.stream().forEach(appEntryConfig -> {
            String metaNumber = (String)appEntryConfig.get("metanumber");
            if (IEmpSelfService.getInstance().isShowAppEntry(metaNumber).booleanValue()) {
                FlexPanelAp appEntryFlex = this.getAppEntryFlex((Map<String, Object>)appEntryConfig, index);
                appentryListFlex.getItems().add(appEntryFlex);
            }
        });
        this.addFlexPane(APPENTRY_LIST_FLEX, appentryListFlex, args);
    }

    private Boolean isAppEntryFlex(String key) {
        String[] keyArr = key.split(SPLIT_STR);
        if (keyArr.length >= 2 && FLEX_APPENTRY.equals(keyArr[0])) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private FlexPanelAp getAppEntryFlex(Map<String, Object> appConfigDy, int index) {
        Margin margin = new Margin();
        margin.setBottom("12px");
        Padding padding = new Padding();
        padding.setBottom("12px");
        padding.setTop("12px");
        padding.setLeft("12px");
        padding.setRight("12px");
        FlexPanelAp appEntryFlex = SelfServicePageUtil.customFlexPane("flexappentry0" + appConfigDy.get("metanumber") + SPLIT_STR + appConfigDy.get("metatype"), margin, padding, null, null, "68px");
        SelfServicePageUtil.setFlexGrowAndShrink(appEntryFlex, 0, 0);
        SelfServicePageUtil.setFlexDirection(appEntryFlex, "row", false, FLEX_START, CENTER);
        appEntryFlex.setBackColor("#FFFFFF");
        appEntryFlex.setRadius("10px");
        appEntryFlex.setClickable(true);
        FlexPanelAp flexIcon = this.buildAppIconFlex((String)appConfigDy.get("appicon"), index);
        FlexPanelAp appTitleFlex = this.buildAppTitleFlex(new LocaleString((String)appConfigDy.get("name")), new LocaleString((String)appConfigDy.get("subtitle")), index);
        FlexPanelAp houfanFlex = this.buildHoufanFlex(index);
        appEntryFlex.getItems().add(flexIcon);
        appEntryFlex.getItems().add(appTitleFlex);
        appEntryFlex.getItems().add(houfanFlex);
        return appEntryFlex;
    }

    private FlexPanelAp buildHoufanFlex(int index) {
        FlexPanelAp houfanFlex = new FlexPanelAp();
        houfanFlex.setKey(FLEX_FONT + index);
        houfanFlex.setHeight(new LocaleString("44px"));
        SelfServicePageUtil.setFlexDirection(houfanFlex, "row", false, FLEX_END, CENTER);
        VectorAp houfanVectorAp = SelfServicePageUtil.customStatusVectorAp(VECTOR_HOUFAN + index, "#CCCCCC", KDFONT_HOUFAN);
        houfanFlex.getItems().add(houfanVectorAp);
        return houfanFlex;
    }

    private FlexPanelAp buildAppIconFlex(String imageUrl, int index) {
        FlexPanelAp appiconFlex = new FlexPanelAp();
        appiconFlex.setKey(FLEX_ICON + index);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setRight("12px");
        style.setMargin(margin);
        appiconFlex.setStyle(style);
        SelfServicePageUtil.setFlexGrowAndShrink(appiconFlex, 0, 0);
        ImageAp imageAp = new ImageAp();
        imageAp.setImageKey(imageUrl);
        imageAp.setKey("imagekey" + index);
        imageAp.setHeight(new LocaleString("44px"));
        imageAp.setWidth(new LocaleString("44px"));
        imageAp.setRadius("100px");
        appiconFlex.getItems().add(imageAp);
        return appiconFlex;
    }

    private FlexPanelAp buildAppTitleFlex(LocaleString title, LocaleString subtitle, int index) {
        FlexPanelAp appTitleFlex = new FlexPanelAp();
        appTitleFlex.setKey(FLEX_APPTILTE + index);
        SelfServicePageUtil.setFlexGrowAndShrink(appTitleFlex, 0, 1);
        SelfServicePageUtil.setFlexDirection(appTitleFlex, "column", false, FLEX_START, "stretch");
        LabelAp titleLabelAp = SelfServicePageUtil.customLabel(LABEL_NAME + index, title, 14, "#333333");
        Style style = new Style();
        Margin margin = new Margin();
        margin.setBottom("4px");
        style.setMargin(margin);
        titleLabelAp.setStyle(style);
        titleLabelAp.setFontWeight("bold");
        LabelAp subtitleLabelAp = SelfServicePageUtil.customLabel(LABEL_SUBTILTE + index, subtitle, 12, "#666666");
        appTitleFlex.getItems().add(titleLabelAp);
        appTitleFlex.getItems().add(subtitleLabelAp);
        return appTitleFlex;
    }

    private void addFlexPane(String id, FlexPanelAp flexPanelAp, LoadCustomControlMetasArgs args) {
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("id", id);
        params.put("items", (String)flexPanelAp.createControl().get("items"));
        args.getItems().add(params);
    }

    private void showMobileView(String flexKey) {
        String[] splitStr = flexKey.split(SPLIT_STR);
        String formId = splitStr[1];
        String metaType = splitStr[2];
        if ("1".equals(metaType)) {
            SelfServicePageUtil.showMobileBill(this.getView().getParentView(), formId, ShowType.Floating, null, null);
        }
        if ("2".equals(metaType)) {
            SelfServicePageUtil.showMobileForm(this.getView().getParentView(), formId, ShowType.Floating, null);
        }
    }
}

