/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hss.formplugin.selfservice;

import java.text.MessageFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hss.business.domain.repository.BosUserRepository;
import kd.hr.hss.business.domain.service.privacy.IPrivacyService;
import kd.hr.hss.business.domain.service.selfservice.IEmpSelfService;
import kd.hr.hss.formplugin.common.SelfServicePageUtil;

public class EmpSelfServicePlugin
extends AbstractMobFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(EmpSelfServicePlugin.class);
    private static final String AVATAR = "avatar";
    private static final String LABEL_NAME = "namelabel";
    private static final String LABEL_SUBTITLE = "subtitlelabel";
    private static final String LABEL_ONBRDDAYS = "onbrddayslabel";
    private static final String LABEL_ENCOCWORDS = "encwordslabel";

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        Tuple valid = IEmpSelfService.getInstance().empSelfServiceValidate();
        if (!((Boolean)valid.item1).booleanValue()) {
            evt.setCancel(true);
            evt.setCancelMessage((String)valid.item2);
            return;
        }
        EmpSelfServicePlugin.handlePrivacyCheck(evt);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        IFormView view = this.getView();
        if (map == null || !Boolean.FALSE.equals(map.get("isAgree"))) {
            view.setVisible(Boolean.TRUE, new String[]{"content_panel"});
            this.handleEmpSelfService();
            return;
        }
        HashMap<String, Object> customs = new HashMap<String, Object>(16);
        customs.put("content", map.get("content"));
        customs.put("name", map.get("name"));
        customs.put("id", map.get("id"));
        SelfServicePageUtil.showMobileForm(this.getView(), "hss_privacymob", ShowType.ReplaceHomePage, customs);
    }

    private void handleEmpSelfService() {
        this.getView().getFormShowParameter().setCaption(ResManager.loadKDString((String)"HR\u81ea\u52a9\u670d\u52a1\u4e2d\u5fc3", (String)"EmpSelfServicePlugin_5", (String)"hr-hss-formplugin", (Object[])new Object[0]));
        LOGGER.info(MessageFormat.format("handleEmpSelfService====beforeGetPersonInfo{0}", System.currentTimeMillis()));
        Map personInfoMap = IEmpSelfService.getInstance().getPersonInfo();
        if (personInfoMap == null) {
            return;
        }
        LOGGER.info(MessageFormat.format("handleEmpSelfService====boforeInitCard{0}", System.currentTimeMillis()));
        this.initHeadCard(personInfoMap);
        LOGGER.info(MessageFormat.format("handleEmpSelfService====afterInitCard{0}", System.currentTimeMillis()));
        SelfServicePageUtil.showMobFormInContainer(this.getView(), "hss_handingtask", "handingtask", null);
        SelfServicePageUtil.showMobFormInContainer(this.getView(), "hss_appentry", "appentry", null);
    }

    private static void handlePrivacyCheck(PreOpenFormEventArgs evt) {
        MobileFormShowParameter showParameter = (MobileFormShowParameter)evt.getSource();
        Tuple result = IPrivacyService.getInstance().queryPrivacy("getPrivacySigningList");
        if (((Boolean)result.item1).booleanValue()) {
            Map respnoseMap = HRJSONUtils.convertJSONObjectToMap((Object)result.item2);
            if (respnoseMap == null) {
                EmpSelfServicePlugin.cancelForm(evt, showParameter, ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff0c\u914d\u7f6e\u9690\u79c1\u58f0\u660e\u3002", (String)"EmpSelfServicePlugin_0", (String)"hr-hss-formplugin", (Object[])new Object[0]));
            } else if (!"1".equals(respnoseMap.get("isAgree"))) {
                Object content = respnoseMap.get("content");
                Object id = respnoseMap.get("id");
                if (content == null || id == null) {
                    EmpSelfServicePlugin.cancelForm(evt, showParameter, ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff0c\u914d\u7f6e\u9690\u79c1\u58f0\u660e\u3002", (String)"EmpSelfServicePlugin_0", (String)"hr-hss-formplugin", (Object[])new Object[0]));
                } else {
                    HashMap customs = new HashMap(16);
                    customs.put("content", content);
                    customs.put("name", respnoseMap.get("name"));
                    customs.put("id", id);
                    customs.put("isAgree", Boolean.FALSE);
                    showParameter.getCustomParams().putAll(customs);
                }
            } else {
                showParameter.getCustomParams().remove("isAgree");
            }
        } else {
            LOGGER.info(MessageFormat.format("EmpSelfServicePlugin.isPrivacyAgree query privacy fail,errMsg:{0}", result.item2));
            EmpSelfServicePlugin.cancelForm(evt, showParameter, ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff1a\u9690\u79c1\u58f0\u660e\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"EmpSelfServicePlugin_1", (String)"hr-hss-formplugin", (Object[])new Object[0]));
        }
    }

    private static void cancelForm(PreOpenFormEventArgs evt, MobileFormShowParameter showParameter, String content) {
        evt.setCancel(true);
        showParameter.setCustomParam("formName", (Object)ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"EmpSelfServicePlugin_2", (String)"hr-hss-formplugin", (Object[])new Object[0]));
        evt.setCancelMessage(String.valueOf(content));
    }

    private void initHeadCard(Map<String, Object> personInfo) {
        if (personInfo == null || personInfo.isEmpty()) {
            return;
        }
        SelfServicePageUtil.setLblText(this.getView(), LABEL_NAME, (String)personInfo.get("name"));
        long diffDay = HRDateTimeUtils.dateDiff((Date)((Date)personInfo.get("startdate")), (Date)new Date()) / 86400000L + 1L;
        if (diffDay <= 7L) {
            String subtitleWords = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6b22\u8fce\u52a0\u5165%s\uff0c\u8fd9\u662f\u60a8\u5165\u804c\u7684\u7b2c", (String)"EmpSelfServicePlugin_3", (String)"hr-hss-formplugin", (Object[])new Object[0]), personInfo.get("company"));
            SelfServicePageUtil.setLblText(this.getView(), LABEL_SUBTITLE, subtitleWords);
        } else {
            SelfServicePageUtil.setLblText(this.getView(), LABEL_SUBTITLE, ResManager.loadKDString((String)"\u6211\u4eec\u5df2\u643a\u624b\u540c\u884c", (String)"EmpSelfServicePlugin_4", (String)"hr-hss-formplugin", (Object[])new Object[0]));
        }
        SelfServicePageUtil.setLblText(this.getView(), LABEL_ONBRDDAYS, String.valueOf(diffDay));
        SelfServicePageUtil.setAvatar(this.getView(), AVATAR, HRImageUrlUtil.getImageFullUrl((String)((String)BosUserRepository.getInstance().getPersonInfo(Long.valueOf(RequestContext.get().getCurrUserId())).get("headsculpture"))));
        LOGGER.info(MessageFormat.format("initHeadCard======beforeGetEncouraget{0}", System.currentTimeMillis()));
        String encWords = (String)HRMServiceHelper.invokeHRMPService((String)"hbss", (String)"IHBSSEmpSelfConfigService", (String)"getEncourageWordsByRand", (Object[])new Object[0]);
        LOGGER.info(MessageFormat.format("initHeadCard======afterGetEncouraget{0}", System.currentTimeMillis()));
        SelfServicePageUtil.setLblText(this.getView(), LABEL_ENCOCWORDS, encWords);
    }
}

