/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hss.common.enums;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;

public enum HandleTypeEnum {
    QUIT("0", "htm_quitapplybasebill", "htm_quitapplyemp_mob"),
    REG("1", "hdm_regbasebill", "hdm_regselfhelpbill_mob");

    private String type;
    private String page;
    private String mobilePage;
    private static final Map<String, HandleTypeEnum> TYPE_CACHE;

    private HandleTypeEnum(String key, String page, String mobilePage) {
        this.type = key;
        this.page = page;
        this.mobilePage = mobilePage;
    }

    public String getType() {
        return this.type;
    }

    public String getPage() {
        return this.page;
    }

    public String getMobilePage() {
        return this.mobilePage;
    }

    public void setMobilePage(String mobilePage) {
        this.mobilePage = mobilePage;
    }

    public static HandleTypeEnum getEnumByType(String type) {
        return TYPE_CACHE.get(type);
    }

    public static String getDescription(String type) {
        HandleTypeEnum handleTypeEnum = HandleTypeEnum.getEnumByType(type);
        if (handleTypeEnum == null) {
            return "";
        }
        switch (handleTypeEnum) {
            case QUIT: {
                return ResManager.loadKDString((String)"\u79bb\u804c\u7533\u8bf7", (String)"HandleTypeEnum_0", (String)"hr-hss-common", (Object[])new Object[0]);
            }
            case REG: {
                return ResManager.loadKDString((String)"\u8f6c\u6b63\u7533\u8bf7", (String)"HandleTypeEnum_1", (String)"hr-hss-common", (Object[])new Object[0]);
            }
        }
        return "";
    }

    static {
        HashMap map = Maps.newHashMapWithExpectedSize((int)HandleTypeEnum.values().length);
        for (HandleTypeEnum typeEnum : HandleTypeEnum.values()) {
            map.put(typeEnum.getType(), typeEnum);
        }
        TYPE_CACHE = Collections.unmodifiableMap(map);
    }
}

