/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hss.common.enums;

public enum LabelStyleEnum {
    PROCESSING("#276FF5", "#F2F9FF", "#85B8FF"),
    FINISHED("#1BA854", "#F2FFF5", "#6DD18E"),
    TERMINATED("#666666", "#F5F5F5", "#CCCCCC"),
    OVERDUE("#FB2323", "#FFF2F4", "#FF8088"),
    ESTIMATE("#666666", "#F5F5F5", "#CCCCCC");

    private String color;
    private String bgColor;
    private String borderColor;

    private LabelStyleEnum(String color, String bgColor, String borderColor) {
        this.color = color;
        this.bgColor = bgColor;
        this.borderColor = borderColor;
    }

    public String getColor() {
        return this.color;
    }

    public String getBgColor() {
        return this.bgColor;
    }

    public String getBorderColor() {
        return this.borderColor;
    }

    public static LabelStyleEnum getBillStatusStyle(String billStatus) {
        LabelStyleEnum styleEnum;
        switch (billStatus) {
            case "D": 
            case "B": {
                styleEnum = PROCESSING;
                break;
            }
            case "C": {
                styleEnum = FINISHED;
                break;
            }
            case "G": {
                styleEnum = OVERDUE;
                break;
            }
            default: {
                styleEnum = TERMINATED;
            }
        }
        return styleEnum;
    }
}

