/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.formplugin.web.basedata;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListColumn;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.hr.ptmm.business.domain.repository.TeamMemberRepository;
import kd.hr.ptmm.common.bean.QuitMemberInfo;
import kd.hr.ptmm.common.constants.ProjectTeamBillConstants;
import kd.hr.ptmm.formplugin.web.basedata.TeamMemDataProvider;
import kd.hr.ptmm.formplugin.web.common.TeamMemberBillPermCommon;
import org.apache.commons.collections4.CollectionUtils;

public class ProjectMemberListPlugin
extends HRCoreBaseBillList
implements ProjectTeamBillConstants {
    public static final Log LOGGER = LogFactory.getLog(ProjectMemberListPlugin.class);
    private static Set<String> fixColumnSet = ImmutableSet.of((Object)"person.headsculpture", (Object)"person.number", (Object)"person.name");

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List listColumns = args.getListColumns();
        for (IListColumn listColumn : listColumns) {
            String fieldName = listColumn.getListFieldKey();
            if (!fixColumnSet.contains(fieldName)) continue;
            listColumn.setFixed(true);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        String formId = this.getView().getFormShowParameter().getFormId();
        if (formId.equals("ptmm_projectteamlistf7tpl")) {
            args.setListDataProvider((IListDataProvider)new TeamMemDataProvider());
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        String formId = this.getView().getFormShowParameter().getFormId();
        if (formId.equals("ptmm_projectteamlistf7tpl")) {
            setFilterEvent.setOrderBy("person.number asc");
        } else {
            setFilterEvent.setOrderBy("joindate desc");
        }
        List qFilters = setFilterEvent.getQFilters();
        boolean lookUp = ((ListShowParameter)this.getView().getFormShowParameter()).isLookUp();
        if (!lookUp) {
            for (QFilter qFilter : setFilterEvent.getQFilters()) {
                if (Objects.isNull(qFilter) || !HRStringUtils.equals((String)"quitdate", (String)qFilter.getProperty())) continue;
                qFilter.__setProperty("servicestate");
                qFilter.__setValue((Object)"C");
                if (qFilter.getValue() instanceof QEmptyValue) {
                    qFilter.__setCP("!=");
                    continue;
                }
                qFilter.__setCP("=");
            }
        }
        setFilterEvent.addCustomQFilter(new QFilter("datastatus", "!=", (Object)EnumHisDataVersionStatus.DELETED.getStatus()));
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        ListSelectedRow currentRow = event.getCurrentRow();
        Object pk = currentRow.getPrimaryKeyValue();
        if (!TeamMemberRepository.getInstance().isExists(pk)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ProjectMemberAdjustListPlugin_0", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter parameter = new BillShowParameter();
        parameter.setPkId(pk);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("ptmm_teammember_info");
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        TeamMemberBillPermCommon.getInstance().visibleBtnByNewPerm(this.getView(), "tbnmemquit");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        int size = ((ListView)this.getView()).getSelectedRows().size();
        if (size > 100) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u9009\u62e9100\u6761\u6570\u636e\u6267\u884c\u3002", (String)"ProjectMemberListPlugin_12", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess() && HRStringUtils.equals((String)operateKey, (String)"memquit")) {
            TeamMemberBillPermCommon.getInstance().verifyNewPerm();
            ArrayList quitMemberInfos = Lists.newArrayListWithExpectedSize((int)16);
            List selRowIds = this.getSelectedRows().stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(selRowIds)) {
                Object treeClickTeamId = this.getCurrentNodeId();
                LOGGER.info("ProjectMemberListPlugin treeClickTeamId:{}", treeClickTeamId);
                if (treeClickTeamId != null) {
                    long value = Long.parseLong(String.valueOf(treeClickTeamId));
                    DynamicObjectCollection projectTeam = QueryServiceHelper.query((String)"haos_projteambaseinfo", (String)"id,enable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)value)});
                    if (projectTeam.size() == 0) {
                        QuitMemberInfo quitMemberInfo = new QuitMemberInfo();
                        quitMemberInfo.setTeamMemberIdList((List)Lists.newArrayListWithExpectedSize((int)16));
                        quitMemberInfos.add(quitMemberInfo);
                    } else {
                        if (!this.checkPermWithDataAndBU(treeClickTeamId)) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u9879\u76ee\u56e2\u961f\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ProjectMemberListPlugin_11", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        QuitMemberInfo quitMemberInfo = new QuitMemberInfo();
                        quitMemberInfo.setProjectTeamId(Long.valueOf(Long.parseLong((String)treeClickTeamId)));
                        quitMemberInfo.setTeamMemberIdList((List)Lists.newArrayListWithExpectedSize((int)16));
                        quitMemberInfos.add(quitMemberInfo);
                    }
                }
            } else {
                DynamicObject[] teamMembers = TeamMemberRepository.getInstance().query("projectteam,projectmember,servicestate", new QFilter[]{new QFilter("id", "in", selRowIds)});
                HashSet proMems = Sets.newHashSetWithExpectedSize((int)16);
                Arrays.stream(teamMembers).forEach(teamMember -> proMems.add(teamMember.getString("projectmember.projectname")));
                if (1 < proMems.size()) {
                    String tip = ResManager.loadKDString((String)"\u6240\u9009\u6210\u5458\u6765\u81ea\u591a\u4e2a\u9879\u76ee\uff0c\u65e0\u6cd5\u521b\u5efa\u9879\u76ee\u6210\u5458\u7ef4\u62a4\u5355\u636e\u3002\u8bf7\u68c0\u67e5\u6240\u9009\u62e9\u6210\u5458\u3002", (String)"ProjectMemberListPlugin_10", (String)"hr-ptmm-formplugin", (Object[])new Object[0]);
                    this.getView().showConfirm(tip, MessageBoxOptions.OK);
                    return;
                }
                HashMap team2MemsMap = Maps.newHashMapWithExpectedSize((int)16);
                Arrays.stream(teamMembers).forEach(teamMember -> {
                    if (team2MemsMap.containsKey(teamMember.getLong("projectteam.id"))) {
                        List mems = (List)team2MemsMap.get(teamMember.getLong("projectteam.id"));
                        mems.add(teamMember.getLong("id"));
                    } else {
                        team2MemsMap.put(teamMember.getLong("projectteam.id"), Lists.newArrayList((Object[])new Long[]{teamMember.getLong("id")}));
                    }
                });
                for (Map.Entry entry : team2MemsMap.entrySet()) {
                    QuitMemberInfo quitMemberInfo = new QuitMemberInfo();
                    quitMemberInfo.setProjectTeamId((Long)entry.getKey());
                    quitMemberInfo.setTeamMemberIdList((List)entry.getValue());
                    quitMemberInfos.add(quitMemberInfo);
                }
            }
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId("ptmm_teammemberbill");
            billShowParameter.setCustomParam("customHREntityNumber", (Object)"ptmm_teammemberbill");
            billShowParameter.setCustomParam("customHRPermItemId", (Object)"47156aff000000ac");
            billShowParameter.setCustomParam("custom_parent_f7_prop", (Object)"projectteam");
            billShowParameter.setCustomParam("quitMember", (Object)quitMemberInfos);
            billShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    private Object getCurrentNodeId() {
        ListView view = (ListView)this.getView();
        ITreeListView treeListView = view.getTreeListView();
        if (treeListView != null) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_projteambaseinfo");
            Object currentNodeId = treeListView.getTreeModel().getCurrentNodeId();
            if (currentNodeId == null) {
                return null;
            }
            boolean exists = helper.isExists(currentNodeId);
            if (exists) {
                return currentNodeId;
            }
        }
        return null;
    }

    private boolean checkPermWithDataAndBU(Object currentNodeId) {
        QFilter permFilter = new QFilter("1", "=", (Object)1);
        String appIdHaos = "217WYC/L9U7E";
        QFilter qFilter = (QFilter)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRuleForBdProp", (Object[])new Object[]{RequestContext.get().getCurrUserId(), appIdHaos, "ptmm_teammemberbill", "projectteam", "47150e89000000ac", null});
        Optional.ofNullable(qFilter).ifPresent(arg_0 -> ((QFilter)permFilter).and(arg_0));
        long value = Long.parseLong(String.valueOf(currentNodeId));
        DynamicObjectCollection projectTeam = QueryServiceHelper.query((String)"haos_projteambaseinfo", (String)"id,enable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)value), permFilter});
        return !projectTeam.isEmpty();
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        super.beforePackageData(e);
        boolean lookUp = ((ListShowParameter)this.getView().getFormShowParameter()).isLookUp();
        if (!lookUp) {
            for (DynamicObject pageDatum : e.getPageData()) {
                String serviceState = pageDatum.getString("servicestate");
                if ("C".equals(serviceState)) continue;
                pageDatum.set("quitdate", null);
            }
        }
    }
}

