/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.formplugin.web.basedata;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListColumn;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.hr.ptmm.formplugin.web.basedata.TeamMemDataProvider;

public class ProjectMemberRoleListPlugin
extends HRCoreBaseBillList {
    private static Set<String> fixColumnSet = ImmutableSet.of((Object)"person.headsculpture", (Object)"person.number", (Object)"person.name");

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List listColumns = args.getListColumns();
        for (IListColumn listColumn : listColumns) {
            String fieldName = listColumn.getListFieldKey();
            if (!fixColumnSet.contains(fieldName)) continue;
            listColumn.setFixed(true);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        String formId = this.getView().getFormShowParameter().getFormId();
        if (formId.equals("ptmm_orgteamtreelistf7")) {
            args.setListDataProvider((IListDataProvider)new TeamMemDataProvider());
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        String formId = this.getView().getFormShowParameter().getFormId();
        if (formId.equals("ptmm_orgteamtreelistf7")) {
            setFilterEvent.setOrderBy("person.number asc");
        }
    }
}

