/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.formplugin.web.bill;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.common.constants.ProjectTeamBillConstants;
import kd.hr.ptmm.common.util.PropUtils;
import kd.hr.ptmm.formplugin.web.common.ProjectTeamFormCommon;

public class ProjectMemberAddPlugin
extends HRCoreBaseBillEdit
implements ProjectTeamBillConstants,
BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(ProjectMemberAddPlugin.class);
    private final Set<String> PERSON_ABOUT_FIELD = ImmutableSet.of((Object)"personnumber", (Object)"personorg", (Object)"position", (Object)"stdposition", (Object)"job");
    private final Set<String> FILTER_CUR_VERSION = ImmutableSet.of((Object)"projectteam", (Object)"projectteamadd", (Object)"projectrole", (Object)"projectroleother");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((BasedataEdit)this.getControl("personfield")).setF7BatchFill(false);
        ((BasedataEdit)this.getControl("adjustreason")).setF7BatchFill(false);
        ((BasedataEdit)this.getControl("projectteamadd")).setF7BatchFill(false);
        ((BasedataEdit)this.getControl("projectrole")).setF7BatchFill(false);
        ((BasedataEdit)this.getControl("projectteam")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("projectteamadd")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("projectrole")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("projectroleother")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("adjustrsn")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("adjustreason")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propName = beforeF7SelectEvent.getProperty().getName();
        List customQFilters = beforeF7SelectEvent.getCustomQFilters();
        EntryGrid entryGridJoin = (EntryGrid)this.getView().getControl("memberjoinentry");
        EntryData gridEntryDataJoin = entryGridJoin.getEntryData();
        DynamicObject[] entryRowsJoin = gridEntryDataJoin.getDataEntitys();
        int curRow = beforeF7SelectEvent.getRow();
        if (this.FILTER_CUR_VERSION.contains(propName)) {
            customQFilters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
        }
        if ("projectteamadd".equals(propName)) {
            long rootProjectTeamId = ProjectTeamFormCommon.getInstance().getRootProjectTeamId(this.getModel());
            QFilter rootProjectTeam = new QFilter("rootprojectteam", "in", (Object)rootProjectTeamId);
            customQFilters.add(rootProjectTeam);
        }
        if ("projectrole".equals(propName)) {
            MulBasedataDynamicObjectCollection value = (MulBasedataDynamicObjectCollection)this.getModel().getValue("projectroleother", curRow);
            List otherRoleIds = value.stream().map(obj -> {
                DynamicObject role = obj.getDynamicObject("fbasedataid");
                return role.getString("number");
            }).collect(Collectors.toList());
            QFilter otherRoleFilter = new QFilter("number", "not in", otherRoleIds);
            QFilter projectTeamFilter = ProjectMemberAddPlugin.getProjectTeamIdFilter(entryRowsJoin[curRow]);
            customQFilters.add(otherRoleFilter);
            customQFilters.add(projectTeamFilter);
        }
        if ("projectroleother".equals(propName)) {
            DynamicObject value = (DynamicObject)this.getModel().getValue("projectrole", curRow);
            if (!HRObjectUtils.isEmpty((Object)value)) {
                QFilter qFilter = new QFilter("number", "not in", (Object)value.getString("number"));
                customQFilters.add(qFilter);
            }
            QFilter projectTeamFilter = ProjectMemberAddPlugin.getProjectTeamIdFilter(entryRowsJoin[curRow]);
            customQFilters.add(projectTeamFilter);
        }
        if ("adjustreason".equals(propName) || "adjustrsn".equals(propName)) {
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("group.id", "=", (Object)1010L));
        }
    }

    private static QFilter getProjectTeamIdFilter(DynamicObject entryRowsJoin) {
        long projectTeamId = entryRowsJoin.getLong("projectteamadd.id");
        return new QFilter("adminorg.id", "=", (Object)projectTeamId);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        int changeRowIndex = changeData.getRowIndex();
        if (HRObjectUtils.isEmpty((Object)changeData.getNewValue())) {
            this.emptyPropProcess(propName, changeRowIndex);
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("memberjoinentry");
        EntryData gridEntryData = entryGrid.getEntryData();
        DynamicObject[] entryRows = gridEntryData.getDataEntitys();
        if ("projectrole".equals(propName)) {
            this.getModel().setValue("teamcharge", null, changeRowIndex);
            this.getView().setEnable(Boolean.TRUE, changeRowIndex, new String[]{"projectroleother"});
            long workRoleId = ((DynamicObject)changeData.getNewValue()).getLong("id");
            long projectTeamId = entryRows[changeRowIndex].getLong("projectteamadd.id");
            List teamMemberRoleSuperIds = PTMMServiceFactory.workRoleHrService.getRoleSuperPersonIds(workRoleId, projectTeamId);
            this.getModel().setValue("teamcharge", (Object)teamMemberRoleSuperIds.toArray(new Long[0]), changeRowIndex);
        }
        if ("personfield".equals(propName) || "projectteamadd".equals(propName)) {
            if ("personfield".equals(propName)) {
                DynamicObject personObj = (DynamicObject)changeData.getNewValue();
                long personId = personObj.getLong("id");
                String certValidateMsg = ProjectTeamFormCommon.getInstance().getCertValidateMsg(personId);
                if (HRStringUtils.isNotEmpty((String)certValidateMsg)) {
                    this.getView().showErrorNotification(certValidateMsg);
                    this.getModel().setValue("personfield", null, changeData.getRowIndex());
                    return;
                }
            }
            if ("projectteamadd".equals(propName)) {
                this.getView().setEnable(Boolean.TRUE, changeRowIndex, new String[]{"projectrole"});
                this.getModel().setValue("projectrole", null, changeRowIndex);
                this.getModel().setValue("projectroleother", null, changeRowIndex);
            }
            this.processPersonOrTeamChange(e, propName, changeRowIndex);
        }
    }

    private void emptyPropProcess(String propName, int changeRowIndex) {
        if ("personfield".equals(propName)) {
            this.PERSON_ABOUT_FIELD.forEach(field -> this.getModel().setValue(field, null, changeRowIndex));
        }
        if ("projectteamadd".equals(propName)) {
            this.getModel().setValue("projectrole", null, changeRowIndex);
            this.getView().setEnable(Boolean.FALSE, changeRowIndex, new String[]{"projectrole"});
        }
        if ("projectrole".equals(propName)) {
            this.getModel().setValue("teamcharge", null, changeRowIndex);
            this.getModel().setValue("projectroleother", null, changeRowIndex);
            this.getView().setEnable(Boolean.FALSE, changeRowIndex, new String[]{"projectroleother"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private void processPersonOrTeamChange(PropertyChangedArgs e, String propName, int changeRowIndex) {
        DynamicObject personObj;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("memberjoinentry");
        EntryData gridEntryData = entryGrid.getEntryData();
        DynamicObject[] dataEntities = gridEntryData.getDataEntitys();
        boolean unique = this.uniqueValidate(propName, changeRowIndex, dataEntities);
        if (unique) {
            return;
        }
        if ("personfield".equals(propName) && !HRObjectUtils.isEmpty((Object)(personObj = (DynamicObject)e.getChangeSet()[0].getNewValue()))) {
            String number = personObj.getString("number");
            long personId = personObj.getLong("id");
            Map personInfos = PTMMServiceFactory.hrpiService.getPrimaryEmpposorgrel(Long.valueOf(personId));
            Object adminOrgId = personInfos.get(PropUtils.getIdLine((String)"adminorg"));
            Object positionId = personInfos.get(PropUtils.getIdLine((String)"position"));
            Object stdPositionId = personInfos.get(PropUtils.getIdLine((String)"stdposition"));
            Object jobId = personInfos.get(PropUtils.getIdLine((String)"job"));
            this.getModel().setValue("personnumber", (Object)number, changeRowIndex);
            ProjectTeamFormCommon.setEntryFilesNull(this.getModel(), changeRowIndex, "personorg", "position", "stdposition", "job");
            this.getModel().setValue("personorg", adminOrgId, changeRowIndex);
            this.getModel().setValue("position", positionId, changeRowIndex);
            this.getModel().setValue("stdposition", stdPositionId, changeRowIndex);
            this.getModel().setValue("job", jobId, changeRowIndex);
        }
    }

    private boolean uniqueValidate(String propName, int changeRowIndex, DynamicObject[] dataEntities) {
        String uniqueId = null;
        HashMap uniquePersonTeam = Maps.newHashMapWithExpectedSize((int)16);
        for (int i = 0; i < dataEntities.length; ++i) {
            long personId = dataEntities[i].getLong(PropUtils.getIdDot((String)"personfield"));
            long projectTeamId = dataEntities[i].getLong(PropUtils.getIdDot((String)"projectteamadd"));
            if (personId == 0L || projectTeamId == 0L) continue;
            String strId = String.valueOf(personId) + projectTeamId;
            if (changeRowIndex == i) {
                uniqueId = strId;
                continue;
            }
            uniquePersonTeam.put(strId, i);
        }
        Integer lineNum = (Integer)uniquePersonTeam.get(uniqueId);
        if (!Objects.isNull(lineNum)) {
            DynamicObject row = dataEntities[lineNum];
            String curPersonNumber = row.getString(PropUtils.getNumberDot((String)"personfield"));
            String curPersonName = row.getString(PropUtils.getNameDot((String)"personfield"));
            String curTeamName = row.getString(PropUtils.getNameDot((String)"projectteamadd"));
            String tip = String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u5728\u7b2c%3$d\u884c\u5df2\u6dfb\u52a0\u81f3\u6b64\u9879\u76ee\u56e2\u961f\uff1a%4$s\u3002", (String)"ProjectMemberAddPlugin_0", (String)"hr-ptmm-formplugin", (Object[])new Object[0]), curPersonName, curPersonNumber, lineNum + 1, curTeamName);
            this.getView().showConfirm(tip, MessageBoxOptions.OK);
            this.getModel().setValue(propName, null, changeRowIndex);
            return true;
        }
        return false;
    }
}

