/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.formplugin.web.bill;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FloatingDirection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.hr.ptmm.business.domain.repository.TeamMemberBillRepository;
import kd.hr.ptmm.business.domain.repository.TeamMemberRoleRepository;
import kd.hr.ptmm.business.domain.service.ITeamMemBillValidateService;
import kd.hr.ptmm.business.domain.validator.DyObjValidateContext;
import kd.hr.ptmm.business.domain.validator.ValidateProducer;
import kd.hr.ptmm.common.constants.ProjectTeamBillConstants;
import kd.hr.ptmm.common.util.AppLogUtils;
import kd.hr.ptmm.common.util.PropUtils;
import kd.hr.ptmm.formplugin.web.bill.ProjectMemberCommonPlugin;
import kd.hr.ptmm.formplugin.web.common.PtmmShowPageUtil;
import kd.hr.ptmm.formplugin.web.common.TeamMemListPluginCommon;
import org.apache.commons.lang.time.DateFormatUtils;

public class ProjectMemberAdjustListPlugin
extends HRCoreBaseBillList
implements ProjectTeamBillConstants,
TeamMemListPluginCommon {
    public static final Log log = LogFactory.getLog(ProjectMemberCommonPlugin.class);
    private static final String CALLBACK_KEY_DELETE = "callback_delete";
    private static final String OP_DONOTHING_DELETELIST = "donothing_deletelist";
    private static Map<String, Long> ADJ_TYPE_MAP = ImmutableMap.of((Object)"memadd", (Object)1010L, (Object)"roleadjust", (Object)1020L, (Object)"memquit", (Object)1030L);

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        setFilterEvent.setOrderBy("createtime desc");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        log.info("ProjectMemberAdjustListPlugin beforeDoOperation");
        IListView listView = (IListView)this.getView();
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)OP_DONOTHING_DELETELIST)) {
            List selRowIds = listView.getSelectedRows().stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
            boolean exists = TeamMemberBillRepository.getInstance().isExists(new QFilter("id", "in", selRowIds));
            if (!exists) {
                listView.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ProjectMemberAdjustListPlugin_0", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        switch (operateKey) {
            case "donothing_deletelist": {
                this.deleteBills();
                args.setCancel(true);
                break;
            }
            case "new": {
                BillShowParameter billShowParameter = new BillShowParameter();
                billShowParameter.setFormId("ptmm_teammemberbill");
                billShowParameter.setCustomParam("adjustrsntype", (Object)String.valueOf(ADJ_TYPE_MAP.get(operateKey)));
                billShowParameter.setCustomParam("custom_parent_f7_prop", (Object)"projectteam");
                billShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
                billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)billShowParameter);
                args.setCancel(true);
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        HashSet adjustNums = Sets.newHashSet((Object[])new String[]{"adjustnum", "adjustnumquit", "adjustnumadd", "adjustnumadj", "adjustnumend"});
        if (adjustNums.contains(fieldName)) {
            args.setCancel(true);
        }
        if ("billno".equals(fieldName)) {
            args.setCancel(true);
            BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
            Object primaryKeyValue = list.getFocusRowPkId();
            DynamicObject dynamicObject = TeamMemberBillRepository.getInstance().queryOriginalOneByPk("billno", primaryKeyValue);
            if (dynamicObject == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u9879\u76ee\u6210\u5458\u7ef4\u62a4\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"ProjectMemberAdjustListPlugin_11", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
                return;
            }
            BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
            ListSelectedRow currentRow = event.getCurrentRow();
            Object pk = currentRow.getPrimaryKeyValue();
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setCustomParam("custom_parent_f7_prop", (Object)"projectteam");
            billShowParameter.setFormId("ptmm_teammemberbill");
            billShowParameter.setCaption(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u9879\u76ee\u6210\u5458\u7ef4\u62a4-%s", (String)"ProjectMemberAdjustListPlugin_12", (String)"hr-ptmm-formplugin", (Object[])new Object[0]), dynamicObject.getString("billno")));
            billShowParameter.setPkId(pk);
            billShowParameter.setStatus(OperationStatus.VIEW);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        BillList billList = (BillList)evt.getSource();
        String focusField = billList.getEntryState().getFocusField();
        ListSelectedRow currentListSelectedRow = evt.getCurrentListSelectedRow();
        if (currentListSelectedRow != null) {
            DynamicObject bill = TeamMemberBillRepository.getInstance().queryOne(currentListSelectedRow.getPrimaryKeyValue());
            String projectName = bill.getString("projectname");
            switch (focusField) {
                case "adjustnum": {
                    if (!this.adjustNumHandle(bill, projectName)) break;
                    return;
                }
                case "adjustnumquit": {
                    if (!this.adjustNumQuitHandle(bill, projectName)) break;
                    return;
                }
                case "adjustnumadd": {
                    if (!this.adjustNumAddHandle(bill, projectName)) break;
                    return;
                }
                case "adjustnumadj": {
                    if (!this.adjustNumAdjHandle(bill, projectName)) break;
                    return;
                }
                case "adjustnumend": {
                    if (!this.adjustNumEndHandle(bill, projectName)) break;
                    return;
                }
            }
        }
    }

    private boolean adjustNumQuitHandle(DynamicObject bill, String projectName) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        String queryProperties = String.join((CharSequence)",", Lists.newArrayList((Object[])new String[]{"memberquitentry.personbaseq", "memberquitentry.quitdate", "memberquitentry.projectrole"}));
        DynamicObject[] bills = TeamMemberBillRepository.getInstance().query(queryProperties, new QFilter[]{new QFilter("id", "=", (Object)bill.getLong("id"))});
        DynamicObject[] entries = (DynamicObject[])bills[0].getDynamicObjectCollection("memberquitentry").toArray((Object[])new DynamicObject[0]);
        if (entries == null || entries.length == 0) {
            return true;
        }
        String formId = "ptmm_tmbillquittips";
        FormShowParameter formShowParameter = this.getFormShowParameter(formId);
        formShowParameter.setCaption(this.getColumnName(projectName, ResManager.loadKDString((String)"\u6210\u5458\u9000\u51fa", (String)"ProjectMemberAdjustListPlugin_7", (String)"hr-ptmm-formplugin", (Object[])new Object[0]), entries.length));
        HashSet teamMemberIds = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject entry : entries) {
            teamMemberIds.add(entry.getLong(PropUtils.getIdDot((String)"personbaseq")));
        }
        DynamicObject[] teamMemRoleList = TeamMemberRoleRepository.getInstance().listOtherRole((Set)teamMemberIds);
        Map<Long, List<DynamicObject>> otherRoleMaps = Arrays.stream(teamMemRoleList).collect(Collectors.groupingBy(dy -> dy.getLong(PropUtils.getIdDot((String)"teammember"))));
        for (DynamicObject entry : entries) {
            HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
            resultMap.put("name", entry.getDynamicObject("personbaseq.person").getString("name"));
            resultMap.put("number", entry.getDynamicObject("personbaseq.person").getString("number"));
            resultMap.put("team", entry.getString("personbaseq.projectteam.name"));
            DynamicObject projectRoleD = entry.getDynamicObject("personbaseq").getDynamicObject("projectrole");
            String projectRole = projectRoleD.getString("name");
            List<DynamicObject> otherRoles = otherRoleMaps.get(entry.getLong("personbaseq.id"));
            String otherRole = null;
            if (!CollectionUtils.isEmpty(otherRoles)) {
                List soleNames = otherRoles.stream().map(sole -> sole.getString(PropUtils.getNameDot((String)"projectrole"))).collect(Collectors.toList());
                otherRole = CollectionUtils.isEmpty(soleNames) ? "" : Joiner.on((char)',').skipNulls().join(soleNames);
            }
            String role = HRStringUtils.isEmpty(otherRole) ? projectRole : projectRole + ',' + otherRole;
            resultMap.put("role", role);
            resultMap.put("quitdate", DateFormatUtils.format((Date)entry.getDate("quitdate"), (String)DateFormatUtils.ISO_DATE_FORMAT.getPattern()));
            result.add(resultMap);
        }
        formShowParameter.setCustomParam("result", (Object)result);
        formShowParameter.setCustomParam("adjustType", (Object)"1030");
        this.getView().showForm(formShowParameter);
        return false;
    }

    private boolean adjustNumAddHandle(DynamicObject bill, String projectName) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        String queryProperties = String.join((CharSequence)",", Lists.newArrayList((Object[])new String[]{"memberadjjentry.personbaseadja", "memberadjjentry.projectroleadja", "memberadjjentry.effectdateadja"}));
        DynamicObject[] bills = TeamMemberBillRepository.getInstance().query(queryProperties, new QFilter[]{new QFilter("id", "=", (Object)bill.getLong("id"))});
        DynamicObject[] entries = (DynamicObject[])bills[0].getDynamicObjectCollection("memberadjjentry").toArray((Object[])new DynamicObject[0]);
        if (entries == null || entries.length == 0) {
            return true;
        }
        for (DynamicObject dynamicObject : entries) {
            HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
            resultMap.put("namea", dynamicObject.getDynamicObject("personbaseadja.person").getString("name"));
            resultMap.put("numbera", dynamicObject.getDynamicObject("personbaseadja.person").getString("number"));
            resultMap.put("teama", dynamicObject.getDynamicObject("personbaseadja.projectteam").getString("name"));
            resultMap.put("rolea", dynamicObject.getDynamicObject("projectroleadja").getString("name"));
            resultMap.put("roleadjusteffectdate", DateFormatUtils.format((Date)dynamicObject.getDate("effectdateadja"), (String)DateFormatUtils.ISO_DATE_FORMAT.getPattern()));
            result.add(resultMap);
        }
        String formId = "ptmm_tmbilladjustaddtips";
        FormShowParameter formShowParameter = this.getFormShowParameter(formId);
        formShowParameter.setCaption(this.getColumnName(projectName, ResManager.loadKDString((String)"\u9879\u76ee\u4efb\u804c\u65b0\u589e", (String)"ProjectMemberAdjustListPlugin_8", (String)"hr-ptmm-formplugin", (Object[])new Object[0]), entries.length));
        formShowParameter.setCustomParam("result", (Object)result);
        formShowParameter.setCustomParam("adjustType", (Object)"1021");
        this.getView().showForm(formShowParameter);
        return false;
    }

    private boolean adjustNumAdjHandle(DynamicObject bill, String projectName) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        String queryProperties = String.join((CharSequence)",", Lists.newArrayList((Object[])new String[]{"memberadjaentry.personbaseadj", "memberadjaentry.projectteamadjnew", "memberadjaentry.projectroleadjnew", "memberadjaentry.effectdateadj"}));
        DynamicObject[] bills = TeamMemberBillRepository.getInstance().query(queryProperties, new QFilter[]{new QFilter("id", "=", (Object)bill.getLong("id"))});
        DynamicObject[] entries = (DynamicObject[])bills[0].getDynamicObjectCollection("memberadjaentry").toArray((Object[])new DynamicObject[0]);
        if (entries == null || entries.length == 0) {
            return true;
        }
        for (DynamicObject dynamicObject : entries) {
            HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
            resultMap.put("namead", dynamicObject.getDynamicObject("personbaseadj.person").getString("name"));
            resultMap.put("numberad", dynamicObject.getDynamicObject("personbaseadj.person").getString("number"));
            resultMap.put("teamad", dynamicObject.getDynamicObject("projectteamadjnew").getString("name"));
            resultMap.put("rolead", dynamicObject.getDynamicObject("projectroleadjnew").getString("name"));
            resultMap.put("adjusteffectdatead", DateFormatUtils.format((Date)dynamicObject.getDate("effectdateadj"), (String)DateFormatUtils.ISO_DATE_FORMAT.getPattern()));
            result.add(resultMap);
        }
        String formId = "ptmm_tmbilladjusttips";
        FormShowParameter formShowParameter = this.getFormShowParameter(formId);
        formShowParameter.setCaption(this.getColumnName(projectName, ResManager.loadKDString((String)"\u89d2\u8272\u8c03\u6574", (String)"ProjectMemberAdjustListPlugin_9", (String)"hr-ptmm-formplugin", (Object[])new Object[0]), entries.length));
        formShowParameter.setCustomParam("result", (Object)result);
        formShowParameter.setCustomParam("adjustType", (Object)"1022");
        this.getView().showForm(formShowParameter);
        return false;
    }

    private boolean adjustNumEndHandle(DynamicObject bill, String projectName) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        String queryProperties = String.join((CharSequence)",", Lists.newArrayList((Object[])new String[]{"memberadjqentry.personbaseadjq", "memberadjqentry.effectdateadjq"}));
        DynamicObject[] bills = TeamMemberBillRepository.getInstance().query(queryProperties, new QFilter[]{new QFilter("id", "=", (Object)bill.getLong("id"))});
        DynamicObject[] entries = (DynamicObject[])bills[0].getDynamicObjectCollection("memberadjqentry").toArray((Object[])new DynamicObject[0]);
        if (entries == null || entries.length == 0) {
            return true;
        }
        for (DynamicObject dynamicObject : entries) {
            HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
            resultMap.put("nameq", dynamicObject.getDynamicObject("personbaseadjq.person").getString("name"));
            resultMap.put("numberq", dynamicObject.getDynamicObject("personbaseadjq.person").getString("number"));
            resultMap.put("teamq", dynamicObject.getDynamicObject("personbaseadjq.projectteam").getString("name"));
            resultMap.put("roleq", dynamicObject.getDynamicObject("personbaseadjq.projectrole").getString("name"));
            resultMap.put("adjusteffectdateq", DateFormatUtils.format((Date)dynamicObject.getDate("effectdateadjq"), (String)DateFormatUtils.ISO_DATE_FORMAT.getPattern()));
            result.add(resultMap);
        }
        String formId = "ptmm_tmbilladjustendtips";
        FormShowParameter formShowParameter = this.getFormShowParameter(formId);
        formShowParameter.setCaption(this.getColumnName(projectName, ResManager.loadKDString((String)"\u89d2\u8272\u4efb\u804c\u7ed3\u675f", (String)"ProjectMemberAdjustListPlugin_10", (String)"hr-ptmm-formplugin", (Object[])new Object[0]), entries.length));
        formShowParameter.setCustomParam("result", (Object)result);
        formShowParameter.setCustomParam("adjustType", (Object)"1023");
        this.getView().showForm(formShowParameter);
        return false;
    }

    private boolean adjustNumHandle(DynamicObject bill, String projectName) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        String queryProperties = String.join((CharSequence)",", Lists.newArrayList((Object[])new String[]{"memberjoinentry.personfield", "memberjoinentry.projectteamadd", "memberjoinentry.projectrole", "memberjoinentry.projectroleother", "memberjoinentry.joinstartdate"}));
        DynamicObject[] bills = TeamMemberBillRepository.getInstance().query(queryProperties, new QFilter[]{new QFilter("id", "=", (Object)bill.getLong("id"))});
        DynamicObject[] entries = (DynamicObject[])bills[0].getDynamicObjectCollection("memberjoinentry").toArray((Object[])new DynamicObject[0]);
        if (entries == null || entries.length == 0) {
            return true;
        }
        String formId = "ptmm_tmbilladdtips";
        FormShowParameter formShowParameter = this.getFormShowParameter(formId);
        formShowParameter.setCaption(this.getColumnName(projectName, ResManager.loadKDString((String)"\u6210\u5458\u65b0\u589e", (String)"ProjectMemberAdjustListPlugin_6", (String)"hr-ptmm-formplugin", (Object[])new Object[0]), entries.length));
        for (DynamicObject entry : entries) {
            HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
            resultMap.put("name", entry.getString(PropUtils.getNameDot((String)"personfield")));
            resultMap.put("number", entry.getString(PropUtils.getNumberDot((String)"personfield")));
            resultMap.put("team", entry.getString(PropUtils.getNameDot((String)"projectteamadd")));
            String role = entry.getString(PropUtils.getNameDot((String)"projectrole"));
            DynamicObjectCollection otherRoles = entry.getDynamicObjectCollection("projectroleother");
            if (!CollectionUtils.isEmpty((Collection)otherRoles)) {
                List names = otherRoles.stream().map(sole -> sole.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.toList());
                String otherRole = CollectionUtils.isEmpty(names) ? "" : Joiner.on((char)',').skipNulls().join(names);
                role = role + "," + otherRole;
            }
            resultMap.put("role", role);
            resultMap.put("adddate", DateFormatUtils.format((Date)entry.getDate("joinstartdate"), (String)DateFormatUtils.ISO_DATE_FORMAT.getPattern()));
            result.add(resultMap);
        }
        formShowParameter.setCustomParam("result", (Object)result);
        formShowParameter.setCustomParam("adjustType", (Object)"1010");
        this.getView().showForm(formShowParameter);
        return false;
    }

    private FormShowParameter getFormShowParameter(String formId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        openStyle.setFloatingDirection(FloatingDirection.RightCenter);
        openStyle.setTargetKey("btntreefilter");
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("560");
        cssValue.setHeight("360px");
        openStyle.setInlineStyleCss(cssValue);
        formShowParameter.setFormId(formId);
        return formShowParameter;
    }

    private String getColumnName(String project, String adjustTypeName, int length) {
        String columnName = project + "_" + adjustTypeName + "\uff08" + length + "\uff09";
        return columnName;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (CALLBACK_KEY_DELETE.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.deleteBill();
        } else {
            this.getView().invokeOperation("refresh");
        }
    }

    private void deleteBills() {
        DynamicObject[] bills = this.initData();
        String curAppId = this.getView().getFormShowParameter().getAppId();
        List dyObjValidateContexts = ITeamMemBillValidateService.getInstance().batchDeleteValidate(Arrays.asList(bills), ValidateProducer.init(Arrays.asList(bills)), curAppId);
        if (dyObjValidateContexts.size() > 1) {
            this.handleBills(dyObjValidateContexts, "ptmm_deleteconfirm");
            return;
        }
        if (dyObjValidateContexts.size() == 1) {
            List errors = dyObjValidateContexts.stream().filter(temp -> temp.getValidatorContext().getValidateResult().size() > 0).collect(Collectors.toList());
            if (!errors.isEmpty()) {
                this.getView().showErrorNotification(((DyObjValidateContext)errors.get(0)).getValidatorContext().getFirValidateResultStr());
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u8bb0\u5f55\u5220\u9664\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProjectMemberAdjustListPlugin_1", (String)"hr-ptmm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACK_KEY_DELETE, (IFormPlugin)this));
        }
    }

    private DynamicObject[] initData() {
        ListSelectedRowCollection listSelectedData = this.getSelectedRows();
        Object[] primaryKeyValues = listSelectedData.getPrimaryKeyValues();
        String queryProperties = String.join((CharSequence)",", Lists.newArrayList((Object[])new String[]{"id", "billno", "adjuststatus", "projectteam", "adjustnum", "adjustnumadd", "adjustnumadj", "adjustnumend", "adjustnumquit"}));
        return TeamMemberBillRepository.getInstance().query(queryProperties, new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
    }

    private void handleBills(List<DyObjValidateContext> dyObjValidateContexts, String confirmPageId) {
        ArrayList<DyObjValidateContext> errors = new ArrayList<DyObjValidateContext>();
        ArrayList<Long> successIds = new ArrayList<Long>();
        for (DyObjValidateContext dyObjValidateContext : dyObjValidateContexts) {
            if (dyObjValidateContext.getValidatorContext().getValidateResult().size() > 0) {
                errors.add(dyObjValidateContext);
                continue;
            }
            successIds.add(dyObjValidateContext.getDynamicObject().getLong("id"));
        }
        String billTypeName = ResManager.loadKDString((String)"\u9879\u76ee\u6210\u5458\u7ef4\u62a4\u5355", (String)"ProjectMemberAdjustListPlugin_5", (String)"hr-ptmm-formplugin", (Object[])new Object[0]);
        String keyWord = ResManager.loadKDString((String)"\u5220\u9664", (String)"ProjectMemberAdjustListPlugin_2", (String)"hr-ptmm-formplugin", (Object[])new Object[0]);
        PtmmShowPageUtil.showMulConfirmPage(dyObjValidateContexts, errors, successIds.toArray(), confirmPageId, billTypeName, keyWord, this.getView());
    }

    private void deleteBill() {
        ListSelectedRowCollection listSelectedRowCollection = this.getSelectedRows();
        Object[] primaryKeyValues = listSelectedRowCollection.getPrimaryKeyValues();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String billFormId = listShowParameter.getBillFormId();
        DynamicObject[] bills = this.initData();
        String curAppId = this.getView().getFormShowParameter().getAppId();
        List dyObjValidateContexts = ITeamMemBillValidateService.getInstance().batchDeleteValidate(Arrays.asList(bills), ValidateProducer.init(Arrays.asList(bills)), curAppId);
        List errors = dyObjValidateContexts.stream().filter(temp -> temp.getValidatorContext().getValidateResult().size() > 0).collect(Collectors.toList());
        if (!errors.isEmpty()) {
            this.getView().showErrorNotification(((DyObjValidateContext)errors.get(0)).getValidatorContext().getFirValidateResultStr());
            return;
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("currbizappid", curAppId);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)billFormId, (Object[])primaryKeyValues, (OperateOption)operateOption);
        if (this.handleOpResult(this.getView(), operationResult)) {
            return;
        }
        String opName = ResManager.loadKDString((String)"\u5220\u9664", (String)"ProjectMemberAdjustListPlugin_2", (String)"hr-ptmm-formplugin", (Object[])new Object[0]);
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u7f16\u53f7%s\uff0c\u5220\u9664\u6210\u529f", "ProjectMemberAdjustListPlugin_3", "hr-ptmm-formplugin");
        AppLogUtils.record((String)billFormId, (String)"delete", (String)opName, (MultiLangEnumBridge)opDesc, (String[])new String[]{listSelectedRowCollection.get(0).getBillNo()});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"ProjectMemberAdjustListPlugin_4", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
        this.getView().invokeOperation("refresh");
    }
}

