/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.formplugin.web.bill;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.ClientActions;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.common.constants.ProjectTeamBillConstants;
import kd.hr.ptmm.common.util.PropUtils;
import kd.hr.ptmm.formplugin.web.bill.service.VerifyProjectChangedService;
import kd.hr.ptmm.formplugin.web.common.ProjectTeamFormCommon;
import org.apache.commons.lang3.ArrayUtils;

public class ProjectMemberAdjustPlugin
extends HRCoreBaseBillEdit
implements ProjectTeamBillConstants,
BeforeF7SelectListener {
    private final Set<String> FILTER_CUR_VERSION = ImmutableSet.of((Object)"projectroleadja", (Object)"projectteamadjnew", (Object)"projectroleadjnew");
    public static final String ROW_HIGHLIGHT_COLOR = "#FB2323";
    public static final String ROW_COLOR = "#333";
    private static final Set<String> RSN_SET = ImmutableSet.of((Object)"adjustreasonadja", (Object)"adjustreasonadj", (Object)"adjustreasonadjq");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((BasedataEdit)this.getControl("personbaseadja")).setF7BatchFill(false);
        ((BasedataEdit)this.getControl("adjustreasonadja")).setF7BatchFill(false);
        ((BasedataEdit)this.getControl("projectroleadja")).setF7BatchFill(false);
        ((BasedataEdit)this.getControl("personbaseadj")).setF7BatchFill(false);
        ((BasedataEdit)this.getControl("adjustreasonadj")).setF7BatchFill(false);
        ((BasedataEdit)this.getControl("projectteamadjnew")).setF7BatchFill(false);
        ((BasedataEdit)this.getControl("projectroleadjnew")).setF7BatchFill(false);
        ((BasedataEdit)this.getControl("personbaseadjq")).setF7BatchFill(false);
        ((BasedataEdit)this.getControl("adjustreasonadjq")).setF7BatchFill(false);
        ((BasedataEdit)this.getControl("personbaseadja")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("adjustreasonadja")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("projectroleadja")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("personbaseadj")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("adjustreasonadj")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("projectteamadjnew")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("projectroleadjnew")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("personbaseadjq")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("adjustreasonadjq")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("personbaseq")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        int changeRowIndex = changeData.getRowIndex();
        EntryGrid entryGridAdj = (EntryGrid)this.getView().getControl("memberadjaentry");
        EntryData gridEntryDataAdj = entryGridAdj.getEntryData();
        DynamicObject[] entryRowsAdj = gridEntryDataAdj.getDataEntitys();
        EntryGrid entryGridJoin = (EntryGrid)this.getView().getControl("memberadjjentry");
        EntryData gridEntryDataJoin = entryGridJoin.getEntryData();
        DynamicObject[] entryRowsJoin = gridEntryDataJoin.getDataEntitys();
        if (HRObjectUtils.isEmpty((Object)changeData.getNewValue())) {
            this.emptyPropProcess(propName, changeRowIndex);
            return;
        }
        DynamicObject propNewObj = null;
        if (changeData.getNewValue() instanceof DynamicObject) {
            propNewObj = (DynamicObject)changeData.getNewValue();
        }
        if (propNewObj == null) {
            return;
        }
        this.entry1F7Filter(propName, changeRowIndex, entryRowsJoin, propNewObj);
        this.entry2F7Filter(propName, changeRowIndex, entryRowsAdj, propNewObj);
        this.entry3F7Filter(propName, changeData, changeRowIndex, propNewObj);
        if (this.entry1Unique(propName, changeRowIndex)) {
            return;
        }
        if (this.entryRoleAdjustRoleUnique(propName, changeRowIndex)) {
            return;
        }
        if (this.entry2Unique(propName, changeRowIndex)) {
            return;
        }
        this.entry3Unique(propName, changeRowIndex);
    }

    private void entry3Unique(String propName, int changeRowIndex) {
        if ("personbaseadjq".equals(propName)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("memberadjqentry");
            EntryData gridEntryData = entryGrid.getEntryData();
            DynamicObject[] dataEntitys = gridEntryData.getDataEntitys();
            DynamicObject changeEntryRow = dataEntitys[changeRowIndex];
            long curTeamMemberRoleId = changeEntryRow.getLong("personbaseadjq.id");
            if (curTeamMemberRoleId == 0L) {
                return;
            }
            int i = 0;
            for (DynamicObject dataEntity : dataEntitys) {
                if (i == changeRowIndex) {
                    ++i;
                    continue;
                }
                long teamMemberRoleId = dataEntity.getLong("personbaseadjq.id");
                if (teamMemberRoleId == 0L) {
                    ++i;
                    continue;
                }
                DynamicObject personObj = dataEntity.getDynamicObject("personbaseadjq.person");
                String personName = personObj.getString("name");
                String personNum = personObj.getString("number");
                String teamName = dataEntity.getString("personbaseadjq.projectteam.name");
                String teamRoleName = dataEntity.getString("personbaseadjq.projectrole.name");
                if (curTeamMemberRoleId == teamMemberRoleId) {
                    String tip = String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u5728\u7b2c%3$d\u884c\u5df2\u7ed3\u675f\u89d2\u8272\u4efb\u804c\uff1a%4$s - %5$s\u3002", (String)"ProjectMemberAdjustPlugin_3", (String)"hr-ptmm-formplugin", (Object[])new Object[0]), personName, personNum, i + 1, teamName, teamRoleName);
                    this.getView().showConfirm(tip, MessageBoxOptions.OK);
                    this.getModel().setValue(propName, null, changeRowIndex);
                    return;
                }
                ++i;
            }
        }
    }

    private boolean entry2Unique(String propName, int changeRowIndex) {
        if ("personbaseadj".equals(propName) || "projectteamadjnew".equals(propName)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("memberadjaentry");
            EntryData gridEntryData = entryGrid.getEntryData();
            DynamicObject[] dataEntities = gridEntryData.getDataEntitys();
            DynamicObject changeEntryRow = dataEntities[changeRowIndex];
            long curTeamMemberRoleId = changeEntryRow.getLong("personbaseadj.person.id");
            long curAfterTeamId = changeEntryRow.getLong("projectteamadjnew.id");
            if (curTeamMemberRoleId == 0L || curAfterTeamId == 0L) {
                return true;
            }
            int i = 0;
            for (DynamicObject dataEntity : dataEntities) {
                if (i == changeRowIndex) {
                    ++i;
                    continue;
                }
                long teamMemberRoleId = dataEntity.getLong("personbaseadj.person.id");
                long afterTeamId = dataEntity.getLong("projectteamadjnew.id");
                if (teamMemberRoleId == 0L || afterTeamId == 0L) {
                    ++i;
                    continue;
                }
                DynamicObject personObj = dataEntity.getDynamicObject("personbaseadj.person");
                String personName = personObj.getString("name");
                String personNum = personObj.getString("number");
                String teamName = dataEntity.getString("projectteamadjnew.name");
                if (curTeamMemberRoleId == teamMemberRoleId && curAfterTeamId == afterTeamId) {
                    String tip = String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u5728\u7b2c%3$d\u884c\u5df2\u8c03\u6574\u81f3\u6b64\u9879\u76ee\u56e2\u961f\uff1a%4$s\u3002", (String)"ProjectMemberAdjustPlugin_4", (String)"hr-ptmm-formplugin", (Object[])new Object[0]), personName, personNum, i + 1, teamName);
                    this.getView().showConfirm(tip, MessageBoxOptions.OK);
                    this.getModel().setValue(propName, null, changeRowIndex);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean entryRoleAdjustRoleUnique(String propName, int changeRowIndex) {
        if ("personbaseadj".equals(propName)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("memberadjaentry");
            EntryData gridEntryData = entryGrid.getEntryData();
            DynamicObject[] dataEntities = gridEntryData.getDataEntitys();
            DynamicObject changeEntryRow = dataEntities[changeRowIndex];
            long changeMemberRoleId = changeEntryRow.getLong("personbaseadj.id");
            if (changeMemberRoleId == 0L) {
                return true;
            }
            int i = 0;
            for (DynamicObject dataEntity : dataEntities) {
                if (i == changeRowIndex) {
                    ++i;
                    continue;
                }
                long memberRoleId = dataEntity.getLong("personbaseadj.id");
                if (memberRoleId == 0L) {
                    ++i;
                    continue;
                }
                if (changeMemberRoleId == memberRoleId) {
                    DynamicObject personObj = dataEntity.getDynamicObject("personbaseadj.person");
                    String personName = personObj.getString("name");
                    String personNum = personObj.getString("number");
                    String projectTeamName = dataEntity.getString("personbaseadj.projectteam.name");
                    String projectRoleName = dataEntity.getString("personbaseadj.projectrole.name");
                    String tip = String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u89d2\u8272\u4efb\u804c\uff08%3$s - %4$s\uff09\u5728\u7b2c%5$d\u884c\u5df2\u5b58\u5728\u8c03\u6574\u3002", (String)"ProjectMemberAdjustPlugin_10", (String)"hr-ptmm-formplugin", (Object[])new Object[0]), personName, personNum, projectTeamName, projectRoleName, i + 1);
                    this.getView().showConfirm(tip, MessageBoxOptions.OK);
                    this.getModel().setValue(propName, null, changeRowIndex);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean entry1Unique(String propName, int changeRowIndex) {
        if ("personbaseadja".equals(propName) || "projectroleadja".equals(propName)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("memberadjjentry");
            EntryData gridEntryData = entryGrid.getEntryData();
            DynamicObject[] dataEntities = gridEntryData.getDataEntitys();
            DynamicObject changeEntryRow = dataEntities[changeRowIndex];
            long curTeamMemberId = changeEntryRow.getLong("personbaseadja.id");
            long curTeamMemberRoleId = changeEntryRow.getLong("projectroleadja.id");
            if (curTeamMemberId == 0L || curTeamMemberRoleId == 0L) {
                return true;
            }
            int i = 0;
            for (DynamicObject dataEntity : dataEntities) {
                if (i == changeRowIndex) {
                    ++i;
                    continue;
                }
                long teamMemberId = dataEntity.getLong("personbaseadja.id");
                long teamMemberRoleId = dataEntity.getLong("projectroleadja.id");
                if (teamMemberId == 0L || teamMemberRoleId == 0L) {
                    ++i;
                    continue;
                }
                DynamicObject personObj = dataEntity.getDynamicObject("personbaseadja.person");
                String personName = personObj.getString("name");
                String personNum = personObj.getString("number");
                String teamName = dataEntity.getString("personbaseadja.projectteam.name");
                String teamRoleName = dataEntity.getString("projectroleadja.name");
                if (curTeamMemberId == teamMemberId && curTeamMemberRoleId == teamMemberRoleId) {
                    String tip = String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u5728\u7b2c%3$d\u884c\u5df2\u6dfb\u52a0\u81f3\u6b64\u9879\u76ee\u89d2\u8272\uff1a%4$s - %5$s\u3002", (String)"ProjectMemberAdjustPlugin_5", (String)"hr-ptmm-formplugin", (Object[])new Object[0]), personName, personNum, i + 1, teamName, teamRoleName);
                    this.getView().showConfirm(tip, MessageBoxOptions.OK);
                    this.getModel().setValue(propName, null, changeRowIndex);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void entry3F7Filter(String propName, ChangeData changeData, int changeRowIndex, DynamicObject propNewObj) {
        if ("personbaseadjq".equals(propName)) {
            this.getModel().setValue("teamchargeadjq", null, changeRowIndex);
            DynamicObject dynamicObject = (DynamicObject)changeData.getNewValue();
            long belongAdminOrgId = PTMMServiceFactory.teamMemberService.getBelongAdminOrgIdByRole(dynamicObject.getLong("id"));
            this.getModel().setValue("projectteamadminadjq", (Object)belongAdminOrgId, changeRowIndex);
            long roleId = propNewObj.getLong("projectrole.id");
            DynamicObject projectRole = PTMMServiceFactory.workRoleHrService.getWorkRoleHrById(roleId);
            this.getModel().setValue("isdutypersadjq", (Object)(projectRole.getBoolean("mainpeoincharge") ? "1" : "0"), changeRowIndex);
            long projectTeamId = propNewObj.getLong("projectteam.id");
            List teamMemberRoleSuperIds = PTMMServiceFactory.workRoleHrService.getRoleSuperPersonIds(roleId, projectTeamId);
            this.getModel().setValue("teamchargeadjq", (Object)teamMemberRoleSuperIds.toArray(new Long[0]), changeRowIndex);
            Map personInfos = PTMMServiceFactory.hrpiService.getPrimaryEmpposorgrel(Long.valueOf(propNewObj.getLong("person.id")));
            Object adminorgId = personInfos.get(PropUtils.getIdLine((String)"adminorg"));
            Object positionId = personInfos.get(PropUtils.getIdLine((String)"position"));
            Object stdpositionId = personInfos.get(PropUtils.getIdLine((String)"stdposition"));
            Object jobId = personInfos.get(PropUtils.getIdLine((String)"job"));
            ProjectTeamFormCommon.setEntryFilesNull(this.getModel(), changeRowIndex, "personorgadjq", "positionadjq", "stdpositionadjq", "jobadjq");
            this.getModel().setValue("personorgadjq", adminorgId, changeRowIndex);
            this.getModel().setValue("positionadjq", positionId, changeRowIndex);
            this.getModel().setValue("stdpositionadjq", stdpositionId, changeRowIndex);
            this.getModel().setValue("jobadjq", jobId, changeRowIndex);
        }
    }

    private void entry2F7Filter(String propName, int changeRowIndex, DynamicObject[] entryRowsAdj, DynamicObject propNewObj) {
        if ("personbaseadj".equals(propName)) {
            this.getModel().setValue("teamchargeadj", null, changeRowIndex);
            long roleId = propNewObj.getLong("projectrole.id");
            DynamicObject projectRole = PTMMServiceFactory.workRoleHrService.getWorkRoleHrById(roleId);
            this.getModel().setValue("isdutypersadj", (Object)(projectRole.getBoolean("mainpeoincharge") ? "1" : "0"), changeRowIndex);
            long projectTeamId = propNewObj.getLong("projectteam.id");
            List teamMemberRoleSuperIds = PTMMServiceFactory.workRoleHrService.getRoleSuperPersonIds(roleId, projectTeamId);
            this.getModel().setValue("teamchargeadj", (Object)teamMemberRoleSuperIds.toArray(new Long[0]), changeRowIndex);
            if (ProjectTeamFormCommon.getInstance().isPageFromProjectTeam(this.getView())) {
                this.getModel().setValue("projectteamadjnew", this.getModel().getValue("projectteam"), changeRowIndex);
            } else {
                this.getModel().setValue("projectteamadjnew", null, changeRowIndex);
            }
            this.getModel().setValue("teamchargeadjnew", null, changeRowIndex);
            this.getModel().setValue("isprincipaladjnew", null, changeRowIndex);
        }
        if ("projectteamadjnew".equals(propName)) {
            this.getModel().setValue("projectroleadjnew", null, changeRowIndex);
            this.getView().setEnable(Boolean.TRUE, changeRowIndex, new String[]{"projectroleadjnew"});
        }
        if ("projectroleadjnew".equals(propName)) {
            this.getModel().setValue("teamchargeadjnew", null, changeRowIndex);
            long superRoleId = propNewObj.getLong("id");
            long projectTeamId = entryRowsAdj[changeRowIndex].getLong("projectteamadjnew.id");
            List teamMemberRoleSuperIds = PTMMServiceFactory.workRoleHrService.getRoleSuperPersonIds(superRoleId, projectTeamId);
            this.getModel().setValue("teamchargeadjnew", (Object)teamMemberRoleSuperIds.toArray(new Long[0]), changeRowIndex);
        }
    }

    private void entry1F7Filter(String propName, int changeRowIndex, DynamicObject[] entryRowsJoin, DynamicObject propNewObj) {
        if ("personbaseadja".equals(propName)) {
            this.getView().setEnable(Boolean.TRUE, changeRowIndex, new String[]{"projectroleadja"});
            this.getModel().setValue("teamchargeadja", null, changeRowIndex);
            this.getModel().setValue("projectroleadja", null, changeRowIndex);
            long belongAdminOrgId = PTMMServiceFactory.teamMemberService.getBelongAdminOrgId(propNewObj.getLong("id"));
            this.getModel().setValue("projectteamadminadja", (Object)belongAdminOrgId, changeRowIndex);
            Map personInfos = PTMMServiceFactory.hrpiService.getPrimaryEmpposorgrel(Long.valueOf(propNewObj.getLong("person.id")));
            Object adminorgId = personInfos.get(PropUtils.getIdLine((String)"adminorg"));
            Object positionId = personInfos.get(PropUtils.getIdLine((String)"position"));
            Object stdpositionId = personInfos.get(PropUtils.getIdLine((String)"stdposition"));
            Object jobId = personInfos.get(PropUtils.getIdLine((String)"job"));
            ProjectTeamFormCommon.setEntryFilesNull(this.getModel(), changeRowIndex, "personorgadja", "positionadja", "stdpositionadja", "jobadja");
            this.getModel().setValue("personorgadja", adminorgId, changeRowIndex);
            this.getModel().setValue("positionadja", positionId, changeRowIndex);
            this.getModel().setValue("stdpositionadja", stdpositionId, changeRowIndex);
            this.getModel().setValue("jobadja", jobId, changeRowIndex);
        }
        if ("projectroleadja".equals(propName)) {
            this.getModel().setValue("teamchargeadja", null, changeRowIndex);
            long superRoleId = propNewObj.getLong("id");
            long projectTeamId = entryRowsJoin[changeRowIndex].getLong("personbaseadja.projectteam.id");
            List teamMemberRoleSuperIds = PTMMServiceFactory.workRoleHrService.getRoleSuperPersonIds(superRoleId, projectTeamId);
            this.getModel().setValue("teamchargeadja", (Object)teamMemberRoleSuperIds.toArray(new Long[0]), changeRowIndex);
        }
    }

    private void emptyPropProcess(String propName, int changeRowIndex) {
        if ("personbaseadja".equals(propName)) {
            this.getModel().setValue("teamchargeadja", null, changeRowIndex);
            this.getModel().setValue("projectroleadja", null, changeRowIndex);
            this.getModel().setValue("projectteamadminadja", null, changeRowIndex);
            this.getView().setEnable(Boolean.FALSE, changeRowIndex, new String[]{"projectroleadja"});
            this.getModel().setValue("personorgadja", null, changeRowIndex);
            this.getModel().setValue("positionadja", null, changeRowIndex);
            this.getModel().setValue("stdpositionadja", null, changeRowIndex);
            this.getModel().setValue("jobadja", null, changeRowIndex);
        }
        if ("personbaseadj".equals(propName)) {
            this.getModel().setValue("isprincipaladjnew", null, changeRowIndex);
            this.getModel().setValue("isdutypersadj", null, changeRowIndex);
            this.getModel().setValue("teamchargeadjnew", null, changeRowIndex);
            this.getModel().setValue("projectroleadjnew", null, changeRowIndex);
            this.getModel().setValue("projectteamadjnew", null, changeRowIndex);
            this.getModel().setValue("teamchargeadjnew", null, changeRowIndex);
        }
        if ("projectroleadja".equals(propName)) {
            this.getModel().setValue("teamchargeadja", null, changeRowIndex);
        }
        if ("personbaseadjq".equals(propName)) {
            this.getModel().setValue("personorgadjq", null, changeRowIndex);
            this.getModel().setValue("teamchargeadjq", null, changeRowIndex);
            this.getModel().setValue("isdutypersadjq", null, changeRowIndex);
            this.getModel().setValue("projectteamadminadjq", null, changeRowIndex);
            this.getModel().setValue("positionadjq", null, changeRowIndex);
            this.getModel().setValue("stdpositionadjq", null, changeRowIndex);
            this.getModel().setValue("jobadjq", null, changeRowIndex);
        }
        if ("projectroleadjnew".equals(propName)) {
            this.getModel().setValue("teamchargeadjnew", null, changeRowIndex);
        }
        if ("personbaseadj".equals(propName)) {
            this.getModel().setValue("teamchargeadj", null, changeRowIndex);
        }
        if ("projectteamadjnew".equals(propName)) {
            this.getView().setEnable(Boolean.FALSE, changeRowIndex, new String[]{"projectroleadjnew"});
            this.getModel().setValue("projectroleadjnew", null, changeRowIndex);
        }
        if ("projectroleadjnew".equals(propName)) {
            this.getModel().setValue("teamchargeadjnew", null, changeRowIndex);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("submit".equals(operateKey) || "save".equals(operateKey)) {
            boolean memberQuitGridData;
            EntryGrid memberJoinGrid = (EntryGrid)this.getView().getControl("memberjoinentry");
            EntryGrid adjJoinGrid = (EntryGrid)this.getView().getControl("memberadjjentry");
            EntryGrid adjGrid = (EntryGrid)this.getView().getControl("memberadjaentry");
            EntryGrid adjQuitGrid = (EntryGrid)this.getView().getControl("memberadjqentry");
            EntryGrid memberQuitGrid = (EntryGrid)this.getView().getControl("memberquitentry");
            boolean memberJoinGridData = (Integer)memberJoinGrid.getEntryData().getData().get("rowcount") == 0;
            boolean adjJoinGridData = (Integer)adjJoinGrid.getEntryData().getData().get("rowcount") == 0;
            boolean adjGridData = (Integer)adjGrid.getEntryData().getData().get("rowcount") == 0;
            boolean adjQuitGridData = (Integer)adjQuitGrid.getEntryData().getData().get("rowcount") == 0;
            boolean bl = memberQuitGridData = (Integer)memberQuitGrid.getEntryData().getData().get("rowcount") == 0;
            if (memberJoinGridData && adjJoinGridData && adjGridData && adjQuitGridData && memberQuitGridData) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u6574\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProjectMemberAdjustPlugin_6", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            LinkedHashSet<String> tipProp = new LinkedHashSet<String>();
            this.entryMemberJoinMustInput(memberJoinGrid, tipProp);
            this.entryRoleJoinMustInput(adjJoinGrid, tipProp);
            this.entryRoleAdjustMustInput(adjGrid, tipProp);
            this.entryRoleQuitMustInput(adjQuitGrid, tipProp);
            this.entryMemberQuitMustInput(memberQuitGrid, tipProp);
            if (!tipProp.isEmpty()) {
                String tipMsg = ResManager.loadKDString((String)"\u201c%s\u201d", (String)"ProjectMemberAddPlugin_12", (String)"hr-ptmm-formplugin", (Object[])new Object[0]);
                String pause = ResManager.loadKDString((String)"\u3001", (String)"ProjectMemberAddPlugin_10", (String)"hr-ptmm-formplugin", (Object[])new Object[0]);
                String tipStr = tipProp.stream().map(tip -> String.format(tipMsg, tip)).collect(Collectors.joining(pause));
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199%s\u3002", (String)"ProjectMemberAddPlugin_11", (String)"hr-ptmm-formplugin", (Object[])new Object[0]), tipStr));
                args.setCancel(true);
                return;
            }
            VerifyProjectChangedService service = new VerifyProjectChangedService(this.getView());
            Map<String, Integer[]> highLightRowMap = service.verifyProjectIsChanged();
            highLightRowMap.values().stream().filter(arr -> arr != null && ((Integer[])arr).length > 0).findFirst().ifPresent(arr -> {
                args.setCancel(true);
                DynamicObject dataEntity = this.getModel().getDataEntity();
                String projectName = dataEntity.getString("projectname");
                this.getView().showConfirm(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u56e2\u961f\u6240\u5c5e\u9879\u76ee\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u68c0\u67e5\u4e0d\u5c5e\u4e8e\u9879\u76ee%s\u4e0b\u7684\u6210\u5458\u7ef4\u62a4\u6570\u636e\u3002", (String)"ProjectMemberAdjustPlugin_11", (String)"hr-ptmm-formplugin", (Object[])new Object[0]), projectName), MessageBoxOptions.OK);
            });
            this.highlightRowByProjectValid(highLightRowMap);
        }
    }

    public void highlightRowByProjectValid(Map<String, Integer[]> highlightRow) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        highlightRow.forEach((entryKey, paramRows) -> {
            int[] rows = ArrayUtils.toPrimitive((Integer[])paramRows);
            ClientActions.createRowStyleBuilder().setRows(rows).setForeColor(ROW_HIGHLIGHT_COLOR).buildStyle().build().invokeControlMethod(proxy, entryKey);
            int size = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection(entryKey).size();
            Set highlightRowSet = Arrays.stream(rows).boxed().collect(Collectors.toSet());
            Set allRowSet = IntStream.range(0, size).boxed().collect(Collectors.toSet());
            allRowSet.removeAll(highlightRowSet);
            int[] allRows = allRowSet.stream().mapToInt(x -> x).toArray();
            ClientActions.createRowStyleBuilder().setRows(allRows).setForeColor(ROW_COLOR).buildStyle().build().invokeControlMethod(proxy, entryKey);
        });
    }

    private void entryMemberQuitMustInput(EntryGrid adjQuitGrid, Set<String> tipProp) {
        EntryData entryData = adjQuitGrid.getEntryData();
        for (DynamicObject dataEntity : entryData.getDataEntitys()) {
            Object adjustReason;
            Object quitDate;
            Object person = dataEntity.get("personbaseq");
            if (HRObjectUtils.isEmpty((Object)person)) {
                tipProp.add(ResManager.loadKDString((String)"\u59d3\u540d", (String)"ProjectMemberQuitPlugin_2", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
            }
            if (HRObjectUtils.isEmpty((Object)(quitDate = dataEntity.get("quitdate")))) {
                tipProp.add(ResManager.loadKDString((String)"\u9000\u51fa\u56e2\u961f\u65e5\u671f", (String)"ProjectMemberQuitPlugin_3", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
            }
            if (!HRObjectUtils.isEmpty((Object)(adjustReason = dataEntity.get("adjustreasonq")))) continue;
            tipProp.add(ResManager.loadKDString((String)"\u8c03\u6574\u539f\u56e0", (String)"ProjectMemberQuitPlugin_4", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
        }
    }

    private void entryMemberJoinMustInput(EntryGrid adjQuitGrid, Set<String> tipProp) {
        EntryData entryData = adjQuitGrid.getEntryData();
        for (DynamicObject dataEntity : entryData.getDataEntitys()) {
            Object isprincipal;
            Object projectrole;
            Object adjustreason;
            Object joinstartdate;
            Object projectteamadd;
            Object personfield = dataEntity.get("personfield");
            if (HRObjectUtils.isEmpty((Object)personfield)) {
                tipProp.add(ResManager.loadKDString((String)"\u59d3\u540d", (String)"ProjectMemberAddPlugin_2", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
            }
            if (HRObjectUtils.isEmpty((Object)(projectteamadd = dataEntity.get("projectteamadd")))) {
                tipProp.add(ResManager.loadKDString((String)"\u9879\u76ee\u56e2\u961f", (String)"ProjectMemberAddPlugin_3", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
            }
            if (HRObjectUtils.isEmpty((Object)(joinstartdate = dataEntity.get("joinstartdate")))) {
                tipProp.add(ResManager.loadKDString((String)"\u52a0\u5165\u56e2\u961f\u65e5\u671f", (String)"ProjectMemberAddPlugin_4", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
            }
            if (HRObjectUtils.isEmpty((Object)(adjustreason = dataEntity.get("adjustreason")))) {
                tipProp.add(ResManager.loadKDString((String)"\u8c03\u6574\u539f\u56e0", (String)"ProjectMemberAddPlugin_5", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
            }
            if (HRObjectUtils.isEmpty((Object)(projectrole = dataEntity.get("projectrole")))) {
                tipProp.add(ResManager.loadKDString((String)"\u9879\u76ee\u89d2\u8272", (String)"ProjectMemberAddPlugin_6", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
            }
            if (!HRObjectUtils.isEmpty((Object)(isprincipal = dataEntity.get("isprincipal")))) continue;
            tipProp.add(ResManager.loadKDString((String)"\u9879\u76ee\u4e3b\u8981\u89d2\u8272", (String)"ProjectMemberAddPlugin_7", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
        }
    }

    private void entryRoleQuitMustInput(EntryGrid adjQuitGrid, Set<String> tipProp) {
        for (DynamicObject dataEntity : adjQuitGrid.getEntryData().getDataEntitys()) {
            Object adjustreason;
            Object joinstartdate;
            Object personfield = dataEntity.get("personbaseadjq");
            if (HRObjectUtils.isEmpty((Object)personfield)) {
                tipProp.add(ResManager.loadKDString((String)"\u59d3\u540d", (String)"ProjectMemberAddPlugin_2", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
            }
            if (HRObjectUtils.isEmpty((Object)(joinstartdate = dataEntity.get("effectdateadjq")))) {
                tipProp.add(ResManager.loadKDString((String)"\u8c03\u6574\u751f\u6548\u65e5\u671f", (String)"ProjectMemberAdjustPlugin_7", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
            }
            if (!HRObjectUtils.isEmpty((Object)(adjustreason = dataEntity.get("adjustreasonadjq")))) continue;
            tipProp.add(ResManager.loadKDString((String)"\u8c03\u6574\u539f\u56e0", (String)"ProjectMemberAddPlugin_5", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
        }
    }

    private void entryRoleAdjustMustInput(EntryGrid adjGrid, Set<String> tipProp) {
        for (DynamicObject dataEntity : adjGrid.getEntryData().getDataEntitys()) {
            Object isprincipal;
            Object projectroleadjnew;
            Object projectrole;
            Object adjustreason;
            Object projectteamadd;
            Object personfield = dataEntity.get("personbaseadj");
            if (HRObjectUtils.isEmpty((Object)personfield)) {
                tipProp.add(ResManager.loadKDString((String)"\u59d3\u540d", (String)"ProjectMemberAddPlugin_2", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
            }
            if (HRObjectUtils.isEmpty((Object)(projectteamadd = dataEntity.get("effectdateadj")))) {
                tipProp.add(ResManager.loadKDString((String)"\u8c03\u6574\u751f\u6548\u65e5\u671f", (String)"ProjectMemberAdjustPlugin_7", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
            }
            if (HRObjectUtils.isEmpty((Object)(adjustreason = dataEntity.get("adjustreasonadj")))) {
                tipProp.add(ResManager.loadKDString((String)"\u8c03\u6574\u539f\u56e0", (String)"ProjectMemberAddPlugin_5", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
            }
            if (HRObjectUtils.isEmpty((Object)(projectrole = dataEntity.get("projectteamadjnew")))) {
                tipProp.add(ResManager.loadKDString((String)"\u9879\u76ee\u56e2\u961f", (String)"ProjectMemberAddPlugin_3", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
            }
            if (HRObjectUtils.isEmpty((Object)(projectroleadjnew = dataEntity.get("projectroleadjnew")))) {
                tipProp.add(ResManager.loadKDString((String)"\u9879\u76ee\u89d2\u8272", (String)"ProjectMemberAddPlugin_6", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
            }
            if (!HRObjectUtils.isEmpty((Object)(isprincipal = dataEntity.get("isprincipaladjnew")))) continue;
            tipProp.add(ResManager.loadKDString((String)"\u9879\u76ee\u4e3b\u8981\u89d2\u8272", (String)"ProjectMemberAddPlugin_7", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
        }
    }

    private void entryRoleJoinMustInput(EntryGrid adjJoinGrid, Set<String> tipProp) {
        for (DynamicObject dataEntity : adjJoinGrid.getEntryData().getDataEntitys()) {
            Object adjustreason;
            Object joinstartdate;
            Object projectteamadd;
            Object projectroleadja;
            Object personfield = dataEntity.get("personbaseadja");
            if (HRObjectUtils.isEmpty((Object)personfield)) {
                tipProp.add(ResManager.loadKDString((String)"\u59d3\u540d", (String)"ProjectMemberAddPlugin_2", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
            }
            if (HRObjectUtils.isEmpty((Object)(projectroleadja = dataEntity.get("effectdateadja")))) {
                tipProp.add(ResManager.loadKDString((String)"\u8c03\u6574\u751f\u6548\u65e5\u671f", (String)"ProjectMemberAdjustPlugin_7", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
            }
            if (HRObjectUtils.isEmpty((Object)(projectteamadd = dataEntity.get("adjustreasonadja")))) {
                tipProp.add(ResManager.loadKDString((String)"\u8c03\u6574\u539f\u56e0", (String)"ProjectMemberAddPlugin_5", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
            }
            if (HRObjectUtils.isEmpty((Object)(joinstartdate = dataEntity.get("projectroleadja")))) {
                tipProp.add(ResManager.loadKDString((String)"\u9879\u76ee\u89d2\u8272", (String)"ProjectMemberAddPlugin_6", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
            }
            if (!HRObjectUtils.isEmpty((Object)(adjustreason = dataEntity.get("isprincipaladja")))) continue;
            tipProp.add(ResManager.loadKDString((String)"\u9879\u76ee\u4e3b\u8981\u89d2\u8272", (String)"ProjectMemberAddPlugin_7", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String baseEntityId;
        String propName = beforeF7SelectEvent.getProperty().getName();
        List customQFilters = beforeF7SelectEvent.getCustomQFilters();
        boolean pageFromProjectTeam = ProjectTeamFormCommon.getInstance().isPageFromProjectTeam(this.getView());
        if (pageFromProjectTeam && ("ptmm_teammember".equals(baseEntityId = ((BasedataProp)beforeF7SelectEvent.getProperty()).getBaseEntityId()) || "ptmm_teammemberrole".equals(baseEntityId))) {
            long projectTeamId = this.getModel().getDataEntity().getLong("projectteam.id");
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("projectteam.id", "=", (Object)projectTeamId));
        }
        if (this.FILTER_CUR_VERSION.contains(propName)) {
            customQFilters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
        }
        DynamicObject[] entryRowsJoin = this.getEntryRows(this.getView(), "memberadjjentry");
        DynamicObject[] entryRowsAdj = this.getEntryRows(this.getView(), "memberadjaentry");
        int curRow = beforeF7SelectEvent.getRow();
        if (RSN_SET.contains(propName)) {
            customQFilters.add(new QFilter(PropUtils.getIdDot((String)"group"), "in", (Object)1020L));
        }
        if ("projectroleadja".equals(propName)) {
            long projectTeamId = entryRowsJoin[curRow].getLong("personbaseadja.projectteam.id");
            QFilter projectTeamFilter = new QFilter("adminorg.id", "=", (Object)projectTeamId);
            customQFilters.add(projectTeamFilter);
        }
        long rootProjectTeamId = ProjectTeamFormCommon.getInstance().getRootProjectTeamId(this.getModel());
        QFilter rootProjectTeam = new QFilter("rootprojectteam", "in", (Object)rootProjectTeamId);
        if ("projectteamadjnew".equals(propName)) {
            customQFilters.add(rootProjectTeam);
        }
        if ("projectroleadjnew".equals(propName)) {
            long projectTeamId = entryRowsAdj[curRow].getLong("projectteamadjnew.id");
            QFilter projetTeamFilter = new QFilter("adminorg.id", "=", (Object)projectTeamId);
            customQFilters.add(projetTeamFilter);
        }
        QFilter serviceB = new QFilter("servicestate", "=", (Object)"B");
        String projectIdentify = ProjectTeamFormCommon.getInstance().getRootProjectIdentify(this.getModel());
        QFilter projectIdentifyFilter = new QFilter("projectmember.projectidentify", "=", (Object)projectIdentify);
        if ("personbaseadja".equals(propName)) {
            customQFilters.add(serviceB);
            customQFilters.add(projectIdentifyFilter);
        }
        if ("personbaseadj".equals(propName) || "personbaseadjq".equals(propName)) {
            customQFilters.add(serviceB);
            customQFilters.add(projectIdentifyFilter);
        }
    }

    private DynamicObject[] getEntryRows(IFormView view, String entryKey) {
        EntryGrid entryGridAdj = (EntryGrid)view.getControl(entryKey);
        EntryData gridEntryDataAdj = entryGridAdj.getEntryData();
        return gridEntryDataAdj.getDataEntitys();
    }
}

