/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.formplugin.web.bill;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hpfs.business.service.cert.HRCertValidateServiceHelper;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.common.bean.QuitMemberInfo;
import kd.hr.ptmm.common.constants.ProjectTeamBillConstants;
import kd.hr.ptmm.common.enums.AdjustBillOpenSource;
import kd.hr.ptmm.common.enums.PersonServiceStatusEnum;
import kd.hr.ptmm.common.util.DateUtils;
import kd.hr.ptmm.common.util.PropUtils;
import kd.hr.ptmm.formplugin.web.bill.UpdateEntryFieldHandlerBelongAdminOrg;
import kd.hr.ptmm.formplugin.web.bill.UpdateEntryFieldHandlerPrincipal;
import kd.hr.ptmm.formplugin.web.common.ProjectTeamFormCommon;
import kd.hr.ptmm.formplugin.web.common.PtmmShowPageUtil;
import org.apache.commons.lang3.tuple.Pair;

public class ProjectMemberCommonPlugin
extends HRCoreBaseBillEdit
implements ProjectTeamBillConstants,
BeforeF7SelectListener,
RowClickEventListener {
    private static final Log log = LogFactory.getLog(ProjectMemberCommonPlugin.class);
    private static final Map<String, String> DELETE_ENTRY = ImmutableMap.of((Object)"deleteentry_join", (Object)"memberjoinentry", (Object)"deleteentry_adjustjoin", (Object)"memberadjjentry", (Object)"deleteentry_adjust", (Object)"memberadjaentry", (Object)"deleteentry_adjustquit", (Object)"memberadjqentry", (Object)"deleteentry_quit", (Object)"memberquitentry");
    private static final Map<String, String> ADJUST_NUM_MAP = ImmutableMap.of((Object)"memberjoinentry", (Object)"adjustnum", (Object)"memberadjjentry", (Object)"adjustnumadd", (Object)"memberadjaentry", (Object)"adjustnumadj", (Object)"memberadjqentry", (Object)"adjustnumend", (Object)"memberquitentry", (Object)"adjustnumquit");
    private static final Map<String, String> TAB_OPERATE = ImmutableMap.of((Object)"memberjoin_tab", (Object)"deleteentry_join", (Object)"rolejoin_tab", (Object)"deleteentry_adjustjoin", (Object)"roleadjust_tab", (Object)"deleteentry_adjust", (Object)"rolequit_tab", (Object)"deleteentry_adjustquit", (Object)"memberquit_tab", (Object)"deleteentry_quit");

    public void initialize() {
        this.getModel().putContextVariable("APPID", (Object)this.getView().getFormShowParameter().getAppId());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((BasedataEdit)this.getControl("projectteam")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ProjectTeamFormCommon.TAB_ENTRY_MAP.keySet().forEach(entryKey -> {
            EntryGrid entryGrid = (EntryGrid)this.getControl((String)entryKey);
            entryGrid.addRowClickListener((RowClickEventListener)this);
        });
    }

    public void afterLoadData(EventObject eventObject) {
        super.afterLoadData(eventObject);
        this.pageInitFlexToggle(Boolean.FALSE);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object paramProjectTeam = showParameter.getCustomParam("projectTeamId");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String openSource = dataEntity.getString("opensource");
        if (Objects.isNull(paramProjectTeam) && HRStringUtils.equals((String)openSource, (String)AdjustBillOpenSource.FROM_PROJECT_TEAM_MAINTAIN.getCode())) {
            this.getView().getFormShowParameter().setCustomParam("projectTeamId", (Object)dataEntity.getLong("projectteam.id"));
            this.getView().cacheFormShowParameter();
        }
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        if (ProjectTeamFormCommon.getInstance().isPageFromProjectTeam(this.getView())) {
            this.getModel().setValue("opensource", (Object)AdjustBillOpenSource.FROM_PROJECT_TEAM_MAINTAIN.getCode());
        }
        if (ProjectTeamFormCommon.getInstance().isPageFromTeamMember(this.getView())) {
            this.getModel().setValue("opensource", (Object)AdjustBillOpenSource.FROM_TEAM_MEMBER_QUIT.getCode());
        }
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
            this.pageInitFlexToggle(Boolean.TRUE);
        }
    }

    private void pageInitFlexToggle(Boolean flag) {
        this.getView().setVisible(flag, new String[]{"initpanalflex"});
        this.getView().setVisible(Boolean.valueOf(flag == false), new String[]{"flex_joindetail", "flex_adjustdetail", "flex_quitdetail", "attachmentpanel"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().getFormShowParameter().setCustomParam("entryWritePluginPath", (Object)"kd.hr.ptmm.formplugin.web.bill.impt.ProjectMemberEntryWriteImpl");
        this.getView().cacheFormShowParameter();
        this.updateEntryFields();
    }

    private void updateEntryFields() {
        UpdateEntryFieldHandlerBelongAdminOrg setEntryBelongAdminOrg = new UpdateEntryFieldHandlerBelongAdminOrg(this.getView());
        setEntryBelongAdminOrg.handler();
        UpdateEntryFieldHandlerPrincipal setEntryPrincipal = new UpdateEntryFieldHandlerPrincipal(this.getView());
        setEntryPrincipal.handler();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        PtmmShowPageUtil.showPageInContainer(this.getView(), "ptmm_billheadadd", "billheadadd", this.getBillHeadAddParam());
        Long projectTeamId = (Long)formShowParameter.getCustomParam("projectTeamId");
        if (!HRObjectUtils.isEmpty((Object)projectTeamId)) {
            this.getModel().setValue("projectteam", (Object)projectTeamId);
        }
        Optional<QuitMemberInfo> quitMemberInfoOptional = ProjectTeamFormCommon.getInstance().getQuitMemberInfo(this.getView());
        quitMemberInfoOptional.ifPresent(quitMemberInfo -> {
            this.getModel().setValue("projectteam", (Object)quitMemberInfo.getProjectTeamId());
            List teamMemberIdList = quitMemberInfo.getTeamMemberIdList();
            for (Long teamMemberId : teamMemberIdList) {
                int newEntryRow = this.getModel().createNewEntryRow("memberquitentry");
                this.getModel().setValue("personbaseq", (Object)teamMemberId, newEntryRow);
            }
            this.selectTab("memberquit_tab");
            this.getView().getFormShowParameter().setCustomParam("quitMember", Collections.emptyList());
            this.getView().cacheFormShowParameter();
        });
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if ("B".equals(billStatus) || "C".equals(billStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit", "bar_modify", "adjustbtn_flex"});
        }
        this.updateTabCount();
        this.visibleTab();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntities;
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        block12: for (RowDataEntity rowDataEntity : rowDataEntities = e.getRowDataEntities()) {
            Object projectTeam = this.getModel().getValue("projectteam");
            switch (entryName) {
                case "memberjoinentry": {
                    this.getModel().setValue("projectteamadd", this.getModel().getValue("projectteam"), rowDataEntity.getRowIndex());
                    if (HRObjectUtils.isEmpty((Object)projectTeam)) {
                        this.getView().setEnable(Boolean.FALSE, rowDataEntity.getRowIndex(), new String[]{"projectrole"});
                    }
                    this.getView().setEnable(Boolean.FALSE, rowDataEntity.getRowIndex(), new String[]{"projectroleother"});
                    this.getModel().setValue("personorg", null, rowDataEntity.getRowIndex());
                    continue block12;
                }
                case "memberadjjentry": {
                    this.getView().setEnable(Boolean.FALSE, rowDataEntity.getRowIndex(), new String[]{"projectroleadja"});
                    this.getModel().setValue("personorgadja", null, rowDataEntity.getRowIndex());
                    continue block12;
                }
                case "memberadjaentry": {
                    this.getView().setEnable(Boolean.FALSE, rowDataEntity.getRowIndex(), new String[]{"projectroleadjnew"});
                    if (!ProjectTeamFormCommon.getInstance().isPageFromProjectTeam(this.getView())) continue block12;
                    this.getModel().setValue("projectteamadjnew", projectTeam, rowDataEntity.getRowIndex());
                    continue block12;
                }
                case "memberadjqentry": {
                    this.getModel().setValue("personorgadjq", null, rowDataEntity.getRowIndex());
                    continue block12;
                }
            }
        }
        this.updateTabDataCount(e.getEntryProp().getName());
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.updateTabDataCount(e.getEntryProp().getName());
        this.visibleTab();
        EntryGrid currentEntryGrid = (EntryGrid)this.getControl(e.getEntryProp().getName());
        if (currentEntryGrid.getEntryData().getDataEntitys().length == 0) {
            for (Map.Entry<String, String> mapEntry : ProjectTeamFormCommon.TAB_ENTRY_MAP.entrySet()) {
                EntryGrid entryGrid = (EntryGrid)this.getControl(mapEntry.getKey());
                if (entryGrid.getEntryData().getDataEntitys().length == 0) continue;
                this.selectTab(mapEntry.getValue());
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        String currentEntryKey = entryGrid.getEntryKey();
        ProjectTeamFormCommon.TAB_ENTRY_MAP.forEach((entryKey, tabKey) -> {
            if (HRStringUtils.equals((String)currentEntryKey, (String)entryKey)) {
                this.selectTab((String)tabKey);
            }
        });
    }

    private Map<String, Object> getBillHeadAddParam() {
        HashMap param = Maps.newHashMapWithExpectedSize((int)4);
        DynamicObject dataEntity = this.getView().getModel().getDataEntity();
        param.put("billno", dataEntity.getString("billno"));
        param.put("creator", dataEntity.getString("creator.name"));
        String formatDate = HRInteDateTimeUtil.formatDate((String)"ptmm_teammemberbill", (String)"createtime", (Date)dataEntity.getDate("createtime"));
        param.put("createtime", formatDate);
        param.put("billstatus", dataEntity.getString("billstatus"));
        param.put("adjuststatus", dataEntity.getString("adjuststatus"));
        return param;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject bill;
        String adjStatus;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof DeleteEntry) {
            DeleteEntry deleteEntry = (DeleteEntry)source;
            OperateOption option = deleteEntry.getOption();
            String opKey = deleteEntry.getOperateKey();
            String entryKey2 = DELETE_ENTRY.get(opKey);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryKey2);
            int size = entryGrid.getSelectRows().length;
            Map variables = option.getVariables();
            if (variables.containsKey(opKey)) {
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u5df2\u9009\u4e2d%s\u6761\u8bb0\u5f55\uff0c\u5220\u9664\u540e\u5c06\u4e0d\u53ef\u6062\u590d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProjectMemberCommonPlugin_2", (String)"hr-ptmm-formplugin", (Object[])new Object[]{size}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(opKey, (IFormPlugin)this));
            args.setCancel(true);
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("modify".equals(operateKey) && !"A".equals(adjStatus = (bill = PTMMServiceFactory.teamMemberBillService.queryOne(this.getModel().getDataEntity().getPkValue())).getString("adjuststatus"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u72b6\u6001\u5fc5\u987b\u662f\u201c\u5f85\u63d0\u4ea4\u201d\u624d\u80fd\u4fee\u6539\u3002", (String)"ProjectMemberCommonPlugin_4", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if ("save".equals(operateKey) || operateKey.contains("submit")) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            this.initProjectName(dataEntity.getDynamicObject("projectteam"));
            ADJUST_NUM_MAP.forEach((entryKey, numKey) -> {
                int size = dataEntity.getDynamicObjectCollection(entryKey).size();
                this.getModel().setValue(numKey, (Object)size);
            });
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String formId = this.getView().getFormShowParameter().getFormId();
        String callBackOpKey = messageBoxClosedEvent.getCallBackId();
        String entryKey = DELETE_ENTRY.get(callBackOpKey);
        if (HRStringUtils.isNotEmpty((String)entryKey) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(callBackOpKey, "1");
            this.getView().invokeOperation(callBackOpKey, operateOption);
        }
        if (formId.equals(callBackOpKey) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getModel().setValue("projectteam", (Object)Long.valueOf(this.getView().getPageCache().get("projectteam")));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        ProjectTeamFormCommon.setBizChanged(this.getModel().getDataEntity(), "billno", "projectnumber", "adjustnum", "adjustnumadd", "adjustnumadj", "adjustnumend", "adjustnumquit", "opensource");
        if (ProjectTeamFormCommon.getInstance().isPageFromProjectTeam(this.getView()) || ProjectTeamFormCommon.getInstance().isPageFromTeamMember(this.getView())) {
            ProjectTeamFormCommon.setBizChanged(this.getModel().getDataEntity(), "projectteam", "projectname");
        }
        ProjectTeamFormCommon.setBizChanged(this.getModel().getDataEntity(true), "projectteamadminadja", "projectname", "projectteamadminadjq", "projectteamadminq", "isdutypersadj", "isdutypersadjq", "isdutypersq");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        int changeRowIndex = changeData.getRowIndex();
        String propName = e.getProperty().getName();
        if ("projectteam".equals(propName)) {
            this.getModel().deleteEntryData("memberjoinentry");
            this.getModel().deleteEntryData("memberadjjentry");
            this.getModel().deleteEntryData("memberadjaentry");
            this.getModel().deleteEntryData("memberadjqentry");
            this.getModel().deleteEntryData("memberquitentry");
            Object newValue = changeData.getNewValue();
            if (!HRObjectUtils.isEmpty((Object)newValue)) {
                this.pageInitFlexToggle(Boolean.FALSE);
                this.initProjectName((DynamicObject)newValue);
            } else {
                this.getModel().setValue("projectname", null);
                this.pageInitFlexToggle(Boolean.TRUE);
            }
            this.visibleTab();
        }
        if (property instanceof DateTimeProp && !HRObjectUtils.isEmpty((Object)changeData.getNewValue())) {
            Date newDate = (Date)changeData.getNewValue();
            Date noTimeDate = DateUtils.getNoTimeDate((Date)newDate);
            this.getModel().setValue(propName, (Object)noTimeDate, changeRowIndex);
        }
    }

    private void initProjectName(DynamicObject projectTeam) {
        if (projectTeam == null) {
            return;
        }
        DynamicObject projectTeamById = PTMMServiceFactory.projectTeamService.getProjectTeamById(projectTeam.getLong("id"));
        DynamicObject rootProjectTeam = projectTeamById.getDynamicObject("rootprojectteam");
        if (!HRObjectUtils.isEmpty((Object)rootProjectTeam)) {
            Object projectName = rootProjectTeam.get("projectname");
            String projectNumber = rootProjectTeam.getString("projectnumber");
            this.getModel().setValue("projectname", projectName);
            this.getModel().setValue("projectnumber", (Object)projectNumber);
        } else {
            Object projectName = projectTeam.get("projectname");
            String projectNumber = projectTeam.getString("projectnumber");
            this.getModel().setValue("projectname", projectName);
            this.getModel().setValue("projectnumber", (Object)projectNumber);
        }
    }

    private void showJoinMemberForm() {
        Set<PersonTeamInfo> joinMemberEntryPersonTeamInfo;
        List personIdList;
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"hrpi_personf7querylist", (boolean)true);
        listShowParameter.setFormId("hrcs_querylistf7");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (ProjectTeamFormCommon.getInstance().isPageFromProjectTeam(this.getView()) && org.apache.commons.collections.CollectionUtils.isNotEmpty(personIdList = (joinMemberEntryPersonTeamInfo = this.getJoinMemberEntryPersonTeamInfo()).stream().map(PersonTeamInfo::getPersonId).collect(Collectors.toList()))) {
            QFilter personQFilter = new QFilter("id", "not in", personIdList);
            qFilters.add(personQFilter);
        }
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        if (qFilters.size() != 0) {
            listFilterParameter.setQFilters(qFilters);
        }
        listShowParameter.setListFilterParameter(listFilterParameter);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "memberjoin_btn");
        listShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showQuitMemberForm() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"ptmm_teammemberf7", (boolean)true);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        QFilter projectQFilter = new QFilter("projectmember.projectidentify", "=", (Object)ProjectTeamFormCommon.getInstance().getRootProjectIdentify(this.getModel()));
        QFilter memberStatusQFilter = new QFilter("servicestate", "=", (Object)PersonServiceStatusEnum.SERVING.getCode());
        listFilterParameter.getQFilters().add(projectQFilter);
        listFilterParameter.getQFilters().add(memberStatusQFilter);
        if (ProjectTeamFormCommon.getInstance().isPageFromProjectTeam(this.getView())) {
            QFilter projectTeamQFilter = new QFilter("projectteam", "=", this.getView().getFormShowParameter().getCustomParam("projectTeamId"));
            listFilterParameter.getQFilters().add(projectTeamQFilter);
        }
        listShowParameter.setListFilterParameter(listFilterParameter);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "memberquit_btn");
        listShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showJoinRoleForm() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"ptmm_teammemberf7", (boolean)true);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        QFilter projectQFilter = new QFilter("projectmember.projectidentify", "=", (Object)ProjectTeamFormCommon.getInstance().getRootProjectIdentify(this.getModel()));
        QFilter memberStatusQFilter = new QFilter("servicestate", "=", (Object)PersonServiceStatusEnum.SERVING.getCode());
        listFilterParameter.getQFilters().add(projectQFilter);
        listFilterParameter.getQFilters().add(memberStatusQFilter);
        if (ProjectTeamFormCommon.getInstance().isPageFromProjectTeam(this.getView())) {
            QFilter projectTeamQFilter = new QFilter("projectteam", "=", this.getView().getFormShowParameter().getCustomParam("projectTeamId"));
            listFilterParameter.getQFilters().add(projectTeamQFilter);
        }
        listShowParameter.setListFilterParameter(listFilterParameter);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rolejoin_btn");
        listShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showAdjustRoleForm() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"ptmm_teammemberrole", (boolean)true);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        QFilter projectQFilter = new QFilter("projectmember.projectidentify", "=", (Object)ProjectTeamFormCommon.getInstance().getRootProjectIdentify(this.getModel()));
        QFilter memberStatusQFilter = new QFilter("servicestate", "=", (Object)PersonServiceStatusEnum.SERVING.getCode());
        listFilterParameter.getQFilters().add(projectQFilter);
        listFilterParameter.getQFilters().add(memberStatusQFilter);
        if (ProjectTeamFormCommon.getInstance().isPageFromProjectTeam(this.getView())) {
            QFilter projectTeamQFilter = new QFilter("projectteam", "=", this.getView().getFormShowParameter().getCustomParam("projectTeamId"));
            listFilterParameter.getQFilters().add(projectTeamQFilter);
        }
        listShowParameter.setListFilterParameter(listFilterParameter);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "roleadjust_btn");
        listShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showQuitRoleForm() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"ptmm_teammemberrole", (boolean)true);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        QFilter projectQFilter = new QFilter("projectmember.projectidentify", "=", (Object)ProjectTeamFormCommon.getInstance().getRootProjectIdentify(this.getModel()));
        QFilter memberStatusQFilter = new QFilter("servicestate", "=", (Object)PersonServiceStatusEnum.SERVING.getCode());
        listFilterParameter.getQFilters().add(projectQFilter);
        listFilterParameter.getQFilters().add(memberStatusQFilter);
        if (ProjectTeamFormCommon.getInstance().isPageFromProjectTeam(this.getView())) {
            QFilter projectTeamQFilter = new QFilter("projectteam", "=", this.getView().getFormShowParameter().getCustomParam("projectTeamId"));
            listFilterParameter.getQFilters().add(projectTeamQFilter);
        }
        listShowParameter.setListFilterParameter(listFilterParameter);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rolequit_btn");
        listShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        boolean success;
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey) && (success = args.getOperationResult().isSuccess())) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
            return;
        }
        if ("modify".equals(operateKey) && (success = args.getOperationResult().isSuccess())) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.EDIT);
            ((BillShowParameter)this.getView().getFormShowParameter()).setBillStatus(BillOperationStatus.EDIT);
            this.getView().invokeOperation("refresh");
        }
        OperationResult operationResult = args.getOperationResult();
        Object source = args.getSource();
        if (operateKey.contains("submit") && (operationResult.isSuccess() || operationResult.getMessage().equals("cancel_ignore"))) {
            operationResult.setShowMessage(false);
            AbstractOperate submit = (AbstractOperate)source;
            List validateInfo = operationResult.getAllErrorOrValidateInfo();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)validateInfo)) {
                for (IOperateInfo iOperateInfo : validateInfo) {
                    this.getView().showErrorNotification(iOperateInfo.getMessage());
                }
            } else {
                OperateOption option = submit.getOption();
                if (option.containsVariable("memberjoinentry")) {
                    String validateRes = option.getVariableValue("memberjoinentry");
                    Pair<List<Map<String, Object>>, List<Map<String, Object>>> listListPair = ProjectTeamFormCommon.getInstance().getValidateResult(validateRes);
                    FormShowParameter formShowParameter = new FormShowParameter();
                    formShowParameter.setFormId("ptmm_teammadjustvalid");
                    formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                    formShowParameter.setCustomParam("valid_error", listListPair.getLeft());
                    formShowParameter.setCustomParam("valid_warn", listListPair.getRight());
                    formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "memberjoinentry"));
                    this.getView().showForm(formShowParameter);
                } else {
                    this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"ProjectMemberCommonPlugin_3", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
                    this.getView().invokeOperation("refresh");
                }
            }
        }
        if (Objects.nonNull(args.getOperationResult()) && args.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "entry_deleterow": {
                    this.deleteEntryRow();
                    break;
                }
                case "entry_joinmember": {
                    this.showJoinMemberForm();
                    break;
                }
                case "entry_rolejoin": {
                    this.showJoinRoleForm();
                    break;
                }
                case "entry_memberquit": {
                    this.showQuitMemberForm();
                    break;
                }
                case "entry_rolequit": {
                    this.showQuitRoleForm();
                    break;
                }
                case "entry_roleadjust": {
                    this.showAdjustRoleForm();
                    break;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection listSelectedRows;
        String formId;
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (Objects.isNull(closedCallBackEvent.getReturnData())) {
            return;
        }
        if ("memberjoinentry".equals(actionId) && !HRObjectUtils.isEmpty((Object)(returnData = closedCallBackEvent.getReturnData())) && String.valueOf(returnData).equals("1")) {
            this.getView().updateView();
        }
        if ((formId = this.getView().getFormShowParameter().getFormId()).equals(actionId) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(listSelectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()))) {
            long beforeId;
            long afterId = (Long)listSelectedRows.get(0).getPrimaryKeyValue();
            if (afterId == (beforeId = this.getModel().getDataEntity().getLong("projectteam.id"))) {
                return;
            }
            this.getView().getPageCache().put("projectteam", String.valueOf(listSelectedRows.get(0).getPrimaryKeyValue()));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u9879\u76ee\u56e2\u961f\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5355\u636e\u8c03\u6574\u660e\u7ec6\u4fe1\u606f\uff0c\u786e\u5b9a\u5207\u6362\uff1f", (String)"ProjectMemberCommonPlugin_5", (String)"hr-ptmm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(actionId));
        }
        this.handleEntryOperateClosedCallBackEvt(closedCallBackEvent);
    }

    private void handleEntryOperateClosedCallBackEvt(ClosedCallBackEvent closedCallBackEvent) {
        if (Objects.isNull(closedCallBackEvent.getReturnData()) || !(closedCallBackEvent.getReturnData() instanceof ListSelectedRowCollection)) {
            return;
        }
        ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (CollectionUtils.isEmpty((Collection)listSelectedRows)) {
            return;
        }
        switch (closedCallBackEvent.getActionId()) {
            case "memberjoin_btn": {
                this.joinMember(listSelectedRows);
                break;
            }
            case "memberquit_btn": {
                this.quitMember(listSelectedRows);
                break;
            }
            case "rolejoin_btn": {
                this.joinRole(listSelectedRows);
                break;
            }
            case "rolequit_btn": {
                this.quitRole(listSelectedRows);
                break;
            }
            case "roleadjust_btn": {
                this.adjustRole(listSelectedRows);
                break;
            }
        }
        this.visibleTab();
    }

    private void joinMember(ListSelectedRowCollection listSelectedRows) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        List personIdList = listSelectedRows.stream().map(row -> Long.parseLong(String.valueOf(row.getPrimaryKeyValue()))).collect(Collectors.toList());
        Map checkResult = HRCertValidateServiceHelper.checkPersonLicenses(personIdList);
        List<Map<String, Object>> succPersonList = this.handleLicenseCheckResult(checkResult);
        if (CollectionUtils.isEmpty(succPersonList)) {
            return;
        }
        Set<PersonTeamInfo> personTeamInfoList = this.getJoinMemberEntryPersonTeamInfo();
        List empPosOrgRels = PTMMServiceFactory.hrpiService.listEmpposorgrels("1010_S", succPersonList.stream().map(person -> (Long)person.get("id")).collect(Collectors.toList()));
        long rootProjectTeamId = model.getDataEntity().getLong(PropUtils.getIdLine((String)"projectteam"));
        PersonTeamInfo personTeamInfo = new PersonTeamInfo();
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        for (Map<String, Object> personInfo : succPersonList) {
            Long personId = (Long)personInfo.get("id");
            personTeamInfo.setPersonId(personId);
            personTeamInfo.setProjectTeamId(rootProjectTeamId);
            Long projectTeam = rootProjectTeamId;
            if (personTeamInfoList.contains(personTeamInfo)) {
                projectTeam = null;
            }
            tableValueSetter.addField("personfield", new Object[]{personId});
            tableValueSetter.addField("projectteamadd", new Object[]{projectTeam});
            tableValueSetter.addField("personnumber", new Object[]{personInfo.get("number")});
            empPosOrgRels.stream().filter(obj -> {
                long personIdTemp = Long.parseLong(String.valueOf(obj.get(PropUtils.getIdLine((String)"person"))));
                return personIdTemp == personId;
            }).findFirst().ifPresent(info -> {
                tableValueSetter.addField("personorg", new Object[]{info.get(PropUtils.getIdLine((String)"adminorg"))});
                tableValueSetter.addField("position", new Object[]{info.get(PropUtils.getIdLine((String)"position"))});
                tableValueSetter.addField("stdposition", new Object[]{info.get(PropUtils.getIdLine((String)"stdposition"))});
                tableValueSetter.addField("job", new Object[]{info.get(PropUtils.getIdLine((String)"job"))});
            });
        }
        model.beginInit();
        model.batchCreateNewEntryRow("memberjoinentry", tableValueSetter);
        model.endInit();
        this.getView().updateView("memberjoinentry");
        if (!CollectionUtils.isEmpty(succPersonList)) {
            this.selectTab("memberjoin_tab");
            this.updateTabDataCount("memberjoinentry");
        }
    }

    private List<Map<String, Object>> handleLicenseCheckResult(Map<Long, Map<String, Object>> licenseCheckResult) {
        ArrayList licenseValidateInfo = new ArrayList(licenseCheckResult.size());
        ArrayList<Map<String, Object>> succPersonList = new ArrayList<Map<String, Object>>(licenseCheckResult.size());
        licenseCheckResult.forEach((personId, personInfo) -> {
            if (!CollectionUtils.isEmpty((Map)personInfo) && !((Boolean)personInfo.get("status")).booleanValue()) {
                String validateInfo = this.getLicenseValidateMsg(personInfo.get("name"), personInfo.get("number"), ResManager.loadKDString((String)"\u52a0\u5165\u56e2\u961f", (String)"ProjectMemberCommonPlugin_8", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
                licenseValidateInfo.add(validateInfo);
            } else {
                succPersonList.add((Map<String, Object>)personInfo);
            }
        });
        if (!CollectionUtils.isEmpty(licenseValidateInfo)) {
            if (licenseValidateInfo.size() > 1) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("ptmm_validatelicensetip");
                showParameter.setCustomParam("tip", licenseValidateInfo);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
            } else {
                this.getView().showErrorNotification((String)licenseValidateInfo.get(0));
            }
        }
        return succPersonList;
    }

    private Set<PersonTeamInfo> getJoinMemberEntryPersonTeamInfo() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection memberJoinEntry = dataEntity.getDynamicObjectCollection("memberjoinentry");
        return memberJoinEntry.stream().filter(memberJoinDO -> Objects.nonNull(memberJoinDO.get("personfield"))).map(memberJoinDO -> {
            long personId = memberJoinDO.getLong(PropUtils.getIdDot((String)"personfield"));
            DynamicObject projectTeamDO = memberJoinDO.getDynamicObject("projectteamadd");
            if (Objects.isNull(projectTeamDO)) {
                projectTeamDO = this.getModel().getDataEntity().getDynamicObject("projectteam");
            }
            return new PersonTeamInfo(personId, projectTeamDO.getLong("id"));
        }).collect(Collectors.toSet());
    }

    private String getLicenseValidateMsg(Object personName, Object personNumber, Object operate) {
        return String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff0c\u65e0\u6cd5\u53d1\u8d77%3$s\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\u8bb8\u53ef\u4fe1\u606f\uff01", (String)"ProjectMemberCommonPlugin_7", (String)"hr-ptmm-formplugin", (Object[])new Object[0]), personName, personNumber, operate);
    }

    private void quitMember(ListSelectedRowCollection listSelectedRows) {
        listSelectedRows.forEach(listSelectedRow -> {
            int newEntryRow = this.getModel().createNewEntryRow("memberquitentry");
            this.getModel().setValue("personbaseq", listSelectedRow.getPrimaryKeyValue(), newEntryRow);
        });
        this.selectTab("memberquit_tab");
    }

    private void joinRole(ListSelectedRowCollection listSelectedRows) {
        listSelectedRows.forEach(listSelectedRow -> {
            int newEntryRow = this.getModel().createNewEntryRow("memberadjjentry");
            this.getModel().setValue("personbaseadja", listSelectedRow.getPrimaryKeyValue(), newEntryRow);
        });
        this.selectTab("rolejoin_tab");
    }

    private void quitRole(ListSelectedRowCollection listSelectedRows) {
        listSelectedRows.forEach(listSelectedRow -> {
            int newEntryRow = this.getModel().createNewEntryRow("memberadjqentry");
            this.getModel().setValue("personbaseadjq", listSelectedRow.getPrimaryKeyValue(), newEntryRow);
        });
        this.selectTab("rolequit_tab");
    }

    private void adjustRole(ListSelectedRowCollection listSelectedRows) {
        listSelectedRows.forEach(listSelectedRow -> {
            int newEntryRow = this.getModel().createNewEntryRow("memberadjaentry");
            this.getModel().setValue("personbaseadj", listSelectedRow.getPrimaryKeyValue(), newEntryRow);
        });
        this.selectTab("roleadjust_tab");
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        IDataEntityProperty property = beforeF7SelectEvent.getProperty();
        String propName = property.getName();
        if ("projectteam".equals(propName)) {
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("iscurrentversion", "=", (Object)"1"));
            Object projectTeam = this.getModel().getValue("projectteam");
            if (!HRObjectUtils.isEmpty((Object)projectTeam)) {
                FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, this.getView().getFormShowParameter().getFormId());
                formShowParameter.setCloseCallBack(closeCallBack);
            }
        }
    }

    private void updateTabCount() {
        ProjectTeamFormCommon.getInstance().updateTabCount(this.getView());
    }

    private void updateTabDataCount(String entryKey) {
        ProjectTeamFormCommon.getInstance().updateTabDataCount(this.getView(), entryKey);
    }

    public void visibleTab() {
        ProjectTeamFormCommon.getInstance().visibleTab(this.getView());
    }

    private void deleteEntryRow() {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
        Tab tab = (Tab)this.getControl("tabap");
        String currentTab = tab.getCurrentTab();
        log.info("currentTab:{},time:{}", (Object)currentTab, (Object)LocalDateTime.now());
        if (HRStringUtils.isEmpty((String)currentTab)) {
            this.getView().invokeOperation("deleteentry_join", operateOption);
            return;
        }
        String operateKey = TAB_OPERATE.get(currentTab);
        if (HRStringUtils.isNotEmpty((String)operateKey)) {
            this.getView().invokeOperation(operateKey, operateOption);
        }
    }

    private void selectTab(String tabKey) {
        Tab tab = (Tab)this.getControl("tabap");
        tab.selectTab(tabKey);
        tab.activeTab(tabKey);
    }

    private static class PersonTeamInfo {
        private Long personId;
        private Long projectTeamId;

        public PersonTeamInfo() {
        }

        public Long getPersonId() {
            return this.personId;
        }

        public Long getProjectTeamId() {
            return this.projectTeamId;
        }

        public void setPersonId(Long personId) {
            this.personId = personId;
        }

        public void setProjectTeamId(Long projectTeamId) {
            this.projectTeamId = projectTeamId;
        }

        public PersonTeamInfo(Long personId, Long projectTeamId) {
            this.personId = personId;
            this.projectTeamId = projectTeamId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PersonTeamInfo that = (PersonTeamInfo)obj;
            return com.google.common.base.Objects.equal((Object)this.personId, (Object)that.personId) && com.google.common.base.Objects.equal((Object)this.projectTeamId, (Object)that.projectTeamId);
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.personId, this.projectTeamId});
        }
    }
}

