/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.formplugin.web.bill;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.ptmm.business.domain.repository.TeamMemberRoleRepository;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.common.constants.ProjectTeamBillConstants;
import kd.hr.ptmm.common.enums.PersonServiceStatusEnum;
import kd.hr.ptmm.common.util.PropUtils;
import kd.hr.ptmm.formplugin.web.bill.ProjectMemberAddPlugin;
import kd.hr.ptmm.formplugin.web.common.ProjectTeamFormCommon;
import org.apache.commons.lang3.tuple.Pair;

public class ProjectMemberQuitPlugin
extends HRCoreBaseBillEdit
implements ProjectTeamBillConstants,
BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(ProjectMemberAddPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((BasedataEdit)this.getControl("personbaseq")).setF7BatchFill(false);
        ((BasedataEdit)this.getControl("personbaseq")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("adjustreasonq")).setF7BatchFill(false);
        ((BasedataEdit)this.getControl("adjustreasonq")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propName = beforeF7SelectEvent.getProperty().getName();
        List customQFilters = beforeF7SelectEvent.getCustomQFilters();
        if ("personbaseq".equals(propName)) {
            String project = ProjectTeamFormCommon.getInstance().getRootProjectIdentify(this.getModel());
            customQFilters.add(new QFilter(PropUtils.getKeyDot((String)"projectmember", (String)"projectidentify"), "=", (Object)project));
            customQFilters.add(new QFilter("servicestate", "=", (Object)PersonServiceStatusEnum.SERVING.getCode()));
        }
        if ("adjustreasonq".equals(propName) || "adjustrsn".equals(propName)) {
            beforeF7SelectEvent.getCustomQFilters().add(QFilter.of((String)"group.id in ? ", (Object[])new Object[]{1030L}));
        }
    }

    public void afterBindData(EventObject e) {
        DynamicObjectCollection memberquitentry = this.getModel().getDataEntity().getDynamicObjectCollection("memberquitentry");
        if (!memberquitentry.isEmpty()) {
            HashMap workRoleTeamMap = Maps.newHashMapWithExpectedSize((int)16);
            HashSet teamMemberIds = Sets.newHashSetWithExpectedSize((int)16);
            for (DynamicObject emp : memberquitentry) {
                workRoleTeamMap.put(emp.getLong("personbaseq." + PropUtils.getIdDot((String)"projectrole")), emp.getLong("personbaseq." + PropUtils.getIdDot((String)"projectteam")));
                teamMemberIds.add(emp.getLong(PropUtils.getIdDot((String)"personbaseq")));
            }
            DynamicObject[] teamMemRoleList = TeamMemberRoleRepository.getInstance().listOtherRole((Set)teamMemberIds);
            Map<Long, List<DynamicObject>> otherRoleMaps = Arrays.stream(teamMemRoleList).collect(Collectors.groupingBy(dy -> dy.getLong(PropUtils.getIdDot((String)"teammember"))));
            Map superiorByRoleAndTeam = PTMMServiceFactory.workRoleHrService.getSuperiorByRoleAndTeam((Map)workRoleTeamMap);
            for (int i = 0; i < memberquitentry.size(); ++i) {
                List superiors;
                List<DynamicObject> otherRoles = otherRoleMaps.get(((DynamicObject)memberquitentry.get(i)).getLong("personbaseq.id"));
                if (!CollectionUtils.isEmpty(otherRoles)) {
                    List soleNames = otherRoles.stream().map(sole -> sole.getString(PropUtils.getNameDot((String)"projectrole"))).collect(Collectors.toList());
                    String otherRole = CollectionUtils.isEmpty(soleNames) ? "" : Joiner.on((char)',').skipNulls().join(soleNames);
                    this.getModel().setValue("projectroleotherq", (Object)otherRole, i);
                }
                if (CollectionUtils.isEmpty((Collection)(superiors = (List)superiorByRoleAndTeam.get(Pair.of((Object)((DynamicObject)memberquitentry.get(i)).getLong("personbaseq." + PropUtils.getIdDot((String)"projectrole")), (Object)((DynamicObject)memberquitentry.get(i)).getLong("personbaseq." + PropUtils.getIdDot((String)"projectteam"))))))) continue;
                List personNames = superiors.stream().map(sole -> sole.getString(PropUtils.getNameDot((String)"person"))).collect(Collectors.toList());
                String teamSupervisor = CollectionUtils.isEmpty(personNames) ? "" : Joiner.on((char)',').skipNulls().join(personNames);
                this.getModel().setValue("teamchargeq", (Object)teamSupervisor, i);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        int changeRowIndex = changeData.getRowIndex();
        if (HRObjectUtils.isEmpty((Object)changeData.getNewValue())) {
            if ("personbaseq".equals(propName)) {
                this.getModel().setValue("teamchargeq", null, changeRowIndex);
                this.getModel().setValue("isdutypersq", null, changeRowIndex);
                this.getModel().setValue("projectroleotherq", null, changeRowIndex);
                this.getModel().setValue("projectteamadminq", null, changeRowIndex);
            }
            return;
        }
        if ("personbaseq".equals(propName)) {
            if (this.processPersonChange(e, propName, changeRowIndex)) {
                return;
            }
            String teamSupervisor = "";
            DynamicObject data = (DynamicObject)changeData.getNewValue();
            DynamicObject role = data.getDynamicObject("projectrole");
            log.info("ProjectMemberQuitPlugin projectrole:{}", (Object)role.getLong("id"));
            DynamicObject[] teamSupervisors = PTMMServiceFactory.workRoleHrService.getRoleSuperPerson(role.getLong("id"), data.getLong(PropUtils.getIdDot((String)"projectteam")));
            List personNames = Arrays.stream(teamSupervisors).map(sole -> sole.getString(PropUtils.getNameDot((String)"person"))).collect(Collectors.toList());
            teamSupervisor = CollectionUtils.isEmpty(personNames) ? "" : Joiner.on((char)',').skipNulls().join(personNames);
            this.getModel().setValue("teamchargeq", (Object)teamSupervisor, changeRowIndex);
            long roleId = data.getLong(PropUtils.getIdDot((String)"projectrole"));
            DynamicObject projectRole1 = PTMMServiceFactory.workRoleHrService.getWorkRoleHrById(roleId);
            this.getModel().setValue("isdutypersq", (Object)(projectRole1.getBoolean("mainpeoincharge") ? "1" : "0"), changeRowIndex);
            DynamicObject[] teamMemRoleList = TeamMemberRoleRepository.getInstance().listOtherRole((Set)Sets.newHashSet((Object[])new Long[]{data.getLong("id")}));
            if (teamMemRoleList.length > 0) {
                Map<Long, List<DynamicObject>> otherRoleMaps = Arrays.stream(teamMemRoleList).collect(Collectors.groupingBy(dy -> dy.getLong(PropUtils.getIdDot((String)"teammember"))));
                List<DynamicObject> otherRoles = otherRoleMaps.get(data.getLong("id"));
                List soleNames = otherRoles.stream().map(sole -> sole.getString(PropUtils.getNameDot((String)"projectrole"))).collect(Collectors.toList());
                String otherRole = CollectionUtils.isEmpty(soleNames) ? "" : Joiner.on((char)',').skipNulls().join(soleNames);
                this.getModel().setValue("projectroleotherq", (Object)otherRole, changeRowIndex);
            }
            long belongAdminOrgId = PTMMServiceFactory.teamMemberService.getBelongAdminOrgId(data.getLong("id"));
            this.getModel().setValue("projectteamadminq", (Object)belongAdminOrgId, changeRowIndex);
        }
    }

    private boolean processPersonChange(PropertyChangedArgs e, String propName, int changeRowIndex) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("memberquitentry");
        EntryData gridEntryData = entryGrid.getEntryData();
        DynamicObject[] dataEntitys = gridEntryData.getDataEntitys();
        String uniqueId = null;
        HashMap uniquePersonTeam = Maps.newHashMapWithExpectedSize((int)16);
        for (int i = 0; i < dataEntitys.length; ++i) {
            long personId = dataEntitys[i].getLong(PropUtils.getIdDot((String)"personbaseq"));
            if (personId == 0L) continue;
            String strId = String.valueOf(personId);
            if (changeRowIndex == i) {
                uniqueId = strId;
                continue;
            }
            uniquePersonTeam.put(strId, i);
        }
        Integer lineNum = (Integer)uniquePersonTeam.get(uniqueId);
        if (!Objects.isNull(lineNum)) {
            DynamicObject row = dataEntitys[lineNum];
            DynamicObject teamMem = row.getDynamicObject("personbaseq");
            String curNumber = teamMem.getString(PropUtils.getNumberDot((String)"person"));
            String curName = teamMem.getString("name");
            String curTeamName = teamMem.getString(PropUtils.getNameDot((String)"projectteam"));
            String tip = String.format(ResManager.loadKDString((String)"%1$s\u5728\u7b2c%2$d\u884c\u5df2\u9000\u51fa\u6b64\u9879\u76ee\u56e2\u961f\uff1a%3$s\u3002", (String)"ProjectMemberQuitPlugin_0", (String)"hr-ptmm-formplugin", (Object[])new Object[0]), curName + "\uff08" + curNumber + "\uff09", lineNum + 1, curTeamName);
            this.getView().showConfirm(tip, MessageBoxOptions.OK);
            this.getModel().setValue(propName, null, changeRowIndex);
            return true;
        }
        return false;
    }
}

