/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.formplugin.web.bill;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.ptmm.common.constants.ProjectTeamBillConstants;
import kd.hr.ptmm.common.constants.TeamAdjustValidateConstants;
import kd.hr.ptmm.formplugin.web.common.ProjectTeamFormCommon;
import kd.hr.ptmm.formplugin.web.common.PtmmShowPageUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ProjectMemberValidateDynamic
extends HRDynamicFormBasePlugin
implements ProjectTeamBillConstants,
TabSelectListener,
TeamAdjustValidateConstants {
    public static final Log log = LogFactory.getLog(ProjectMemberValidateDynamic.class);
    public static final String BTNOK = "btnok";
    public static final String TABAP = "tabap";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u6821\u9a8c\u63d0\u9192", (String)"ProjectMemberValidateDynamic_0", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tabs = (Tab)this.getView().getControl(TABAP);
        tabs.addTabSelectListener((TabSelectListener)this);
        this.addClickListeners(new String[]{BTNOK});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.openErrorTab();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control button = (Control)evt.getSource();
        String key = button.getKey();
        if (BTNOK.equals(key)) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            List dataList = (List)formShowParameter.getCustomParam("valid_error");
            if (CollectionUtils.isNotEmpty((Collection)dataList)) {
                this.getView().close();
            } else {
                String curAppId = this.getView().getFormShowParameter().getAppId();
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("currbizappid", curAppId);
                operateOption.setVariableValue("second_submit", "1");
                OperationResult operationResult = this.getView().getParentView().invokeOperation("submit_effectdata", operateOption);
                if (operationResult.isSuccess()) {
                    this.getView().returnDataToParent((Object)"1");
                    this.getView().close();
                } else {
                    List validateInfo = operationResult.getAllErrorOrValidateInfo();
                    if (CollectionUtils.isNotEmpty((Collection)validateInfo)) {
                        for (IOperateInfo iOperateInfo : validateInfo) {
                            this.getView().showErrorNotification(iOperateInfo.getMessage());
                        }
                    } else if (operateOption.containsVariable("memberjoinentry")) {
                        String validateRes = operateOption.getVariableValue("memberjoinentry");
                        Pair<List<Map<String, Object>>, List<Map<String, Object>>> listListPair = ProjectTeamFormCommon.getInstance().getValidateResult(validateRes);
                        formShowParameter.setCustomParam("valid_error", listListPair.getLeft());
                        formShowParameter.setCustomParam("valid_warn", listListPair.getRight());
                        this.getView().getPageCache().put("tab_riskwarn", null);
                        this.getView().cacheFormShowParameter();
                        this.openErrorTab();
                    }
                }
            }
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        String cacheTabKey = this.getView().getPageCache().get(tabKey);
        if (HRStringUtils.isNotEmpty((String)cacheTabKey)) {
            return;
        }
        if ("tab_riskwarn".equals(tabKey)) {
            this.openWarnTab();
        }
        if ("tab_validfails".equals(tabKey)) {
            this.openErrorTab();
        }
    }

    private void openWarnTab() {
        this.getView().getPageCache().put("tab_riskwarn", "tab_riskwarn");
        List dataList = (List)this.getView().getFormShowParameter().getCustomParam("valid_warn");
        Map<String, Object> formCustomers = this.getFormCustomers(ResManager.loadKDString((String)"\u4ee5\u4e0b\u6570\u636e\u5b58\u5728\u8c03\u6574\u98ce\u9669", (String)"ProjectMemberValidateDynamic_1", (String)"hr-ptmm-formplugin", (Object[])new Object[0]), dataList);
        List<HRExportHeadObject> headDataList = ProjectMemberValidateDynamic.getDisChangeRecordAuditHeadDataList();
        formCustomers.put("filename", String.format(ResManager.loadKDString((String)"\u9879\u76ee\u6210\u5458\u7ef4\u62a4\u5355\u98ce\u9669\u9884\u8b66\u6570\u636e_%s", (String)"ProjectMemberValidateDynamic_2", (String)"hr-ptmm-formplugin", (Object[])new Object[0]), LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE)));
        formCustomers.put("headDataList", headDataList);
        formCustomers.put("exportDataList", dataList);
        PtmmShowPageUtil.showPageInContainer(this.getView(), "ptmm_teammadjustvalidmsg", "flexriskwarn", formCustomers);
    }

    private void openErrorTab() {
        this.getView().getPageCache().put("tab_validfails", "tab_validfails");
        List dataList = (List)this.getView().getFormShowParameter().getCustomParam("valid_error");
        Map<String, Object> formCustomers = this.getFormCustomers(ResManager.loadKDString((String)"\u4ee5\u4e0b\u6570\u636e\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u4e0d\u53ef\u4ee5\u8fdb\u884c\u8c03\u6574", (String)"ProjectMemberValidateDynamic_3", (String)"hr-ptmm-formplugin", (Object[])new Object[0]), dataList);
        List<HRExportHeadObject> headDataList = ProjectMemberValidateDynamic.getDisChangeRecordAuditHeadDataList();
        formCustomers.put("filename", String.format(ResManager.loadKDString((String)"\u9879\u76ee\u6210\u5458\u7ef4\u62a4\u5355\u6821\u9a8c\u4e0d\u901a\u8fc7\u6570\u636e_%s", (String)"ProjectMemberValidateDynamic_4", (String)"hr-ptmm-formplugin", (Object[])new Object[0]), LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE)));
        formCustomers.put("headDataList", headDataList);
        formCustomers.put("exportDataList", dataList);
        PtmmShowPageUtil.showPageInContainer(this.getView(), "ptmm_teammadjustvalidmsg", "flexvalidfails", formCustomers);
    }

    private Map<String, Object> getFormCustomers(String validateDesc, List<Map<String, Object>> dataList) {
        HashMap<String, Object> customerMap = new HashMap<String, Object>(4);
        customerMap.put("entityDataList", dataList);
        customerMap.put("valid_desc", validateDesc);
        return customerMap;
    }

    public static List<HRExportHeadObject> getDisChangeRecordAuditHeadDataList() {
        ArrayList<HRExportHeadObject> headDataList = new ArrayList<HRExportHeadObject>();
        headDataList.add(new HRExportHeadObject("adjusttypename", ResManager.loadKDString((String)"\u8c03\u6574\u7c7b\u578b", (String)"ProjectMemberValidateDynamic_13", (String)"hr-ptmm-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("number", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"ProjectMemberValidateDynamic_5", (String)"hr-ptmm-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"ProjectMemberValidateDynamic_6", (String)"hr-ptmm-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("projectteam", ResManager.loadKDString((String)"\u9879\u76ee\u56e2\u961f", (String)"ProjectMemberValidateDynamic_7", (String)"hr-ptmm-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("projectrole", ResManager.loadKDString((String)"\u9879\u76ee\u89d2\u8272", (String)"ProjectMemberValidateDynamic_8", (String)"hr-ptmm-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("issubmit", ResManager.loadKDString((String)"\u662f\u5426\u53ef\u63d0\u4ea4", (String)"ProjectMemberValidateDynamic_10", (String)"hr-ptmm-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("msg", ResManager.loadKDString((String)"\u98ce\u9669\u63d0\u793a", (String)"ProjectMemberValidateDynamic_9", (String)"hr-ptmm-formplugin", (Object[])new Object[0])));
        return headDataList;
    }
}

