/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.formplugin.web.bill.impt;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.business.domain.service.impl.common.PtmmMultiSheetUtils;
import kd.hr.ptmm.common.bean.ImportBillDataSupplementParam;
import kd.hr.ptmm.common.constants.ProjectTeamBillConstants;
import kd.hr.ptmm.common.entity.VidPropTypeConfig;
import kd.hr.ptmm.common.enums.AdjustTypeEnum;
import kd.hr.ptmm.common.enums.VidPropType;
import kd.hr.ptmm.common.util.MapUtils;
import kd.hr.ptmm.formplugin.web.bill.impt.IProjectMemberEntryWrite;
import kd.hr.ptmm.formplugin.web.bill.impt.ProjectTeamImportCommon;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public abstract class AbstractProjectMemberEntryWrite
implements ProjectTeamBillConstants,
IProjectMemberEntryWrite {
    private static final Log log = LogFactory.getLog(AbstractProjectMemberEntryWrite.class);
    private Map<AdjustTypeEnum, List<ImportBillData>> importBillDataGroup;
    private ImportBillDataSupplementParam importBillDataNumbers;
    private Map<String, DynamicObject> personMap;
    private Map<String, DynamicObject> projectTeamMap;
    private Map<String, DynamicObject> projectRoleMap;
    private Map<String, DynamicObject> adjustReasonMap;
    private Map<Long, Map<String, Object>> personOrgInfos;
    private Map<Pair<Long, Long>, DynamicObject> teamMemberMap;
    private Map<Triple<Long, Long, Long>, DynamicObject> teamMemberRoleMap;
    private Map<Pair<Long, Long>, List<DynamicObject>> superiorByRoleAndTeam = Maps.newHashMap();
    private Map<String, DynamicObject> projectRoleToWorkRoleNumberMap;
    private static final Set<String> PROJECT_ROLE_ENTRY_KEY = ImmutableSet.of((Object)"projectrole", (Object)"projectroleadja", (Object)"projectroleadj", (Object)"projectroleadjnew", (Object)"projectroleadjq", (Object)"projectroleq", (Object[])new String[0]);

    public AbstractProjectMemberEntryWrite() {
        this.importBillDataGroup = Maps.newHashMap();
        this.importBillDataNumbers = new ImportBillDataSupplementParam();
        this.personMap = Maps.newHashMap();
        this.projectTeamMap = Maps.newHashMap();
        this.projectRoleMap = Maps.newHashMap();
        this.adjustReasonMap = Maps.newHashMap();
        this.personOrgInfos = Maps.newHashMap();
        this.teamMemberMap = Maps.newHashMap();
        this.teamMemberRoleMap = Maps.newHashMap();
    }

    protected static JSONObject getDataRow(ImportBillData importBillDatum, String pageKey) {
        JSONObject data = (JSONObject)importBillDatum.getData().get((Object)"data");
        if (HRStringUtils.equals((String)pageKey, (String)"ptmm_entrymemberjoin")) {
            return PtmmMultiSheetUtils.getMemberJoinJson((JSONObject)data);
        }
        return (JSONObject)data.get((Object)pageKey);
    }

    @Override
    public void supplementDataToEntry(AbstractFormDataModel model, List<ImportBillData> importBillDataList, Map<String, DynamicObject> projectRole2WorkRoleMap) {
        this.setProjectRoleToWorkRoleNumberMap(projectRole2WorkRoleMap);
        this.initParam(importBillDataList);
        this.parseExcelDataAndPaddingEntryData(model);
    }

    protected void initParam(List<ImportBillData> importBillDataList) {
        Map<AdjustTypeEnum, List<ImportBillData>> importBillDataListConvert = this.convertImportBillDataList(importBillDataList);
        this.setImportBillDataGroup(importBillDataListConvert);
        this.initSupplementParam(importBillDataList.size());
    }

    protected void parseExcelDataAndPaddingEntryData(AbstractFormDataModel model) {
        this.processExcelNumber();
        this.processBaseByNumberResult();
        this.entryPaddingData(model);
    }

    private void processExcelNumber() {
        this.parseNumberParamMemberJoin();
        this.parseNumberParamRoleJoin();
        this.parseNumberParamRoleAdjust();
        this.parseNumberParamRoleQuit();
        this.parseNumberParamMemberQuit();
        this.queryDataByNumber();
    }

    private void processBaseByNumberResult() {
        this.parseBaseByNumberResultMemberJoin();
        this.parseBaseByNumberResultRoleJoin();
        this.parseBaseByNumberResultRoleAdjust();
        this.parseBaseByNumberResultRoleQuit();
        this.parseBaseByNumberResultMemberQuit();
        this.queryDataByNumberQueryResult();
        this.parseBaseQuitSuperiorByNumberResultMemberQuit();
        this.queryDataQuitMemberByNumberQueryResult();
    }

    private void entryPaddingData(AbstractFormDataModel model) {
        this.entryPaddingDataMemberJoin(model);
        this.entryPaddingDataRoleJoin(model);
        this.entryPaddingDataRoleAdjust(model);
        this.entryPaddingDataRoleQuit(model);
        this.entryPaddingDataMemberQuit(model);
    }

    private Map<AdjustTypeEnum, List<ImportBillData>> convertImportBillDataList(List<ImportBillData> importBillDataList) {
        return importBillDataList.stream().collect(Collectors.groupingBy(ProjectTeamImportCommon::getEntryType));
    }

    private void initSupplementParam(int size) {
        ImportBillDataSupplementParam dataNumbers = new ImportBillDataSupplementParam();
        dataNumbers.setPersonNumbers((Set)Sets.newHashSetWithExpectedSize((int)size));
        dataNumbers.setAdjustReasonNumbers((Set)Sets.newHashSetWithExpectedSize((int)size));
        dataNumbers.setProjectTeamNumbers((Set)Sets.newHashSetWithExpectedSize((int)size));
        dataNumbers.setProjectRoleNumbers((Set)Sets.newHashSetWithExpectedSize((int)size));
        dataNumbers.setOrgInfoRoleNumbers((Set)Sets.newHashSetWithExpectedSize((int)size));
        dataNumbers.setSuperiorRoleTeam((Map)Maps.newHashMapWithExpectedSize((int)size));
        dataNumbers.setTeamMemberKeys((List)Lists.newArrayListWithExpectedSize((int)size));
        dataNumbers.setTeamMemberRoleKeys((List)Lists.newArrayListWithExpectedSize((int)size));
        this.setImportBillDataNumbers(dataNumbers);
    }

    abstract void parseNumberParamMemberJoin();

    abstract void parseNumberParamRoleJoin();

    abstract void parseNumberParamRoleAdjust();

    abstract void parseNumberParamRoleQuit();

    abstract void parseNumberParamMemberQuit();

    abstract void parseBaseByNumberResultMemberJoin();

    abstract void parseBaseByNumberResultRoleJoin();

    abstract void parseBaseByNumberResultRoleAdjust();

    abstract void parseBaseByNumberResultRoleQuit();

    abstract void parseBaseByNumberResultMemberQuit();

    abstract void parseBaseQuitSuperiorByNumberResultMemberQuit();

    private void queryDataByNumber() {
        Map personMapByNumber = PTMMServiceFactory.hrpiService.personMapByNumber((Collection)this.getImportBillDataNumbers().getPersonNumbers());
        this.setPersonMap(personMapByNumber);
        Map projectTeamMapByNumber = PTMMServiceFactory.projectTeamService.projectTeamMapByNumber((Collection)this.getImportBillDataNumbers().getProjectTeamNumbers());
        this.setProjectTeamMap(projectTeamMapByNumber);
        Map projectRoleMapByNumber = PTMMServiceFactory.workRoleHrService.projectRoleMapByNumber((Collection)this.getImportBillDataNumbers().getProjectRoleNumbers());
        this.setProjectRoleMap(projectRoleMapByNumber);
        Map adjustReasonMapByNumber = PTMMServiceFactory.adjustReasonService.adjustReasonMapByNumber((Collection)this.getImportBillDataNumbers().getAdjustReasonNumbers());
        this.setAdjustReasonMap(adjustReasonMapByNumber);
        List personIds = personMapByNumber.values().stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
        Map empPosOrgRelations = PTMMServiceFactory.hrpiService.listEmployeePositionOrgRelationsMapByPersonId(personIds);
        this.setPersonOrgInfos(empPosOrgRelations);
    }

    private void queryDataByNumberQueryResult() {
        ImportBillDataSupplementParam importBillDataNumbers = this.getImportBillDataNumbers();
        DynamicObject[] projectTeamObjs = PTMMServiceFactory.teamMemberService.listTeamMemberByPersonAndTeam(importBillDataNumbers.getTeamMemberKeys());
        Map<Pair<Long, Long>, DynamicObject> teamMemberMap = Arrays.stream(projectTeamObjs).collect(Collectors.toMap(obj -> Pair.of((Object)obj.getLong("person.id"), (Object)obj.getLong("projectteam.id")), Function.identity(), (v1, v2) -> v1));
        this.setTeamMemberMap(teamMemberMap);
        DynamicObject[] teamMemberRoles = PTMMServiceFactory.teamMemberService.listTeamMemberRoleTriple(importBillDataNumbers.getTeamMemberRoleKeys());
        Map<Triple<Long, Long, Long>, DynamicObject> teamMemberRoleMap = Arrays.stream(teamMemberRoles).collect(Collectors.toMap(obj -> Triple.of((Object)obj.getLong("person_id"), (Object)obj.getLong("projectteam_id"), (Object)obj.getLong("projectrole_id")), Function.identity(), (v1, v2) -> v1));
        this.setTeamMemberRoleMap(teamMemberRoleMap);
        Map superiorByRoleAndTeam = PTMMServiceFactory.workRoleHrService.getSuperiorByRoleAndTeam(importBillDataNumbers.getSuperiorRoleTeam());
        this.setSuperiorByRoleAndTeam(superiorByRoleAndTeam);
    }

    private void queryDataQuitMemberByNumberQueryResult() {
        Map superiorByRoleAndTeam = PTMMServiceFactory.workRoleHrService.getSuperiorByRoleAndTeam(this.getImportBillDataNumbers().getSuperiorRoleTeam());
        this.setSuperiorByRoleAndTeam(superiorByRoleAndTeam);
    }

    abstract void entryPaddingDataMemberJoin(AbstractFormDataModel var1);

    abstract void entryPaddingDataRoleJoin(AbstractFormDataModel var1);

    abstract void entryPaddingDataRoleAdjust(AbstractFormDataModel var1);

    abstract void entryPaddingDataRoleQuit(AbstractFormDataModel var1);

    abstract void entryPaddingDataMemberQuit(AbstractFormDataModel var1);

    public ImportBillDataSupplementParam getImportBillDataNumbers() {
        return this.importBillDataNumbers;
    }

    public void setImportBillDataNumbers(ImportBillDataSupplementParam importBillDataNumbers) {
        this.importBillDataNumbers = importBillDataNumbers;
    }

    protected void setOrgInfo(TableValueSetter tableValueSetter, Map<String, Object> personInfos, Map<VidPropType, List<String>> vidPropConfigMap) {
        vidPropConfigMap.forEach((valType, propList) -> {
            if (MapUtils.isNotEmpty((Map)personInfos)) {
                String personInfoKey = (String)VidPropTypeConfig.PROP_TYPE_KEY_STR.get(valType);
                Object val = personInfos.get(personInfoKey + "_id");
                String entryKey = (String)propList.get(0);
                tableValueSetter.addField(entryKey, new Object[]{val});
            }
        });
    }

    protected void addFieldStr(JSONObject dataRow, TableValueSetter tableValueSetter, String key) {
        String strVal = this.getStrValue(dataRow, key);
        tableValueSetter.addField(key, new Object[]{strVal});
    }

    protected String getStrValue(JSONObject data, String key) {
        Object val = data.get((Object)key);
        if (val instanceof JSONObject) {
            JSONObject valJson = (JSONObject)val;
            String importKey = String.valueOf(valJson.get((Object)"importprop"));
            String excelVal = String.valueOf(valJson.get((Object)importKey));
            if (PROJECT_ROLE_ENTRY_KEY.contains(key)) {
                DynamicObject dynamicObject = this.getProjectRoleToWorkRoleNumberMap().get(excelVal);
                excelVal = dynamicObject.getString("number");
            }
            return excelVal;
        }
        return Objects.isNull(val) ? "" : String.valueOf(val);
    }

    protected void addFieldDate(JSONObject dataRow, TableValueSetter tableValueSetter, String key) {
        String dateVal = this.getStrValue(dataRow, key);
        try {
            tableValueSetter.addField(key, new Object[]{HRDateTimeUtils.parseDate((String)dateVal)});
        }
        catch (ParseException e) {
            log.error("addFieldDate error, key:{} val:{}", (Object)key, (Object)dateVal);
        }
    }

    protected void addFieldBoolean(JSONObject dataRow, TableValueSetter tableValueSetter, String key) {
        String booleanVal = this.getStrValue(dataRow, key);
        tableValueSetter.addField(key, new Object[]{Boolean.parseBoolean(booleanVal) ? "1" : "0"});
    }

    protected void addFieldBase(JSONObject dataRow, TableValueSetter tableValueSetter, String key, Map<String, DynamicObject> valMap) {
        this.addFieldBase(dataRow, tableValueSetter, key, valMap, key);
    }

    protected void addFieldBase(JSONObject dataRow, TableValueSetter tableValueSetter, String excelKey, Map<String, DynamicObject> valMap, String entryKey) {
        String jsonNumber = this.getStrValue(dataRow, excelKey);
        Optional.ofNullable(valMap.get(jsonNumber)).ifPresent(obj -> tableValueSetter.addField(entryKey, new Object[]{obj.getLong("id")}));
    }

    protected long getBaseId(JSONObject dataRow, String excelKey, Map<String, DynamicObject> valMap) {
        String jsonNumber = this.getStrValue(dataRow, excelKey);
        DynamicObject dynamicObject = valMap.get(jsonNumber);
        if (HRObjectUtils.isEmpty((Object)dynamicObject)) {
            return 0L;
        }
        return dynamicObject.getLong("id");
    }

    public Map<AdjustTypeEnum, List<ImportBillData>> getImportBillDataGroup() {
        return this.importBillDataGroup;
    }

    public void setImportBillDataGroup(Map<AdjustTypeEnum, List<ImportBillData>> importBillDataGroup) {
        this.importBillDataGroup = importBillDataGroup;
    }

    public Map<String, DynamicObject> getPersonMap() {
        return this.personMap;
    }

    public void setPersonMap(Map<String, DynamicObject> personMap) {
        this.personMap = personMap;
    }

    public Map<String, DynamicObject> getProjectTeamMap() {
        return this.projectTeamMap;
    }

    public void setProjectTeamMap(Map<String, DynamicObject> projectTeamMap) {
        this.projectTeamMap = projectTeamMap;
    }

    public Map<String, DynamicObject> getProjectRoleMap() {
        return this.projectRoleMap;
    }

    public void setProjectRoleMap(Map<String, DynamicObject> projectRoleMap) {
        this.projectRoleMap = projectRoleMap;
    }

    public Map<Long, Map<String, Object>> getPersonOrgInfos() {
        return this.personOrgInfos;
    }

    public void setPersonOrgInfos(Map<Long, Map<String, Object>> personOrgInfos) {
        this.personOrgInfos = personOrgInfos;
    }

    public Map<Pair<Long, Long>, DynamicObject> getTeamMemberMap() {
        return this.teamMemberMap;
    }

    public void setTeamMemberMap(Map<Pair<Long, Long>, DynamicObject> teamMemberMap) {
        this.teamMemberMap = teamMemberMap;
    }

    public Map<Triple<Long, Long, Long>, DynamicObject> getTeamMemberRoleMap() {
        return this.teamMemberRoleMap;
    }

    public void setTeamMemberRoleMap(Map<Triple<Long, Long, Long>, DynamicObject> teamMemberRoleMap) {
        this.teamMemberRoleMap = teamMemberRoleMap;
    }

    public Map<String, DynamicObject> getAdjustReasonMap() {
        return this.adjustReasonMap;
    }

    public void setAdjustReasonMap(Map<String, DynamicObject> adjustReasonMap) {
        this.adjustReasonMap = adjustReasonMap;
    }

    public Map<Pair<Long, Long>, List<DynamicObject>> getSuperiorByRoleAndTeam() {
        return this.superiorByRoleAndTeam;
    }

    public void setSuperiorByRoleAndTeam(Map<Pair<Long, Long>, List<DynamicObject>> superiorByRoleAndTeam) {
        this.superiorByRoleAndTeam = superiorByRoleAndTeam;
    }

    public Map<String, DynamicObject> getProjectRoleToWorkRoleNumberMap() {
        return this.projectRoleToWorkRoleNumberMap;
    }

    public void setProjectRoleToWorkRoleNumberMap(Map<String, DynamicObject> projectRoleToWorkRoleNumberMap) {
        this.projectRoleToWorkRoleNumberMap = projectRoleToWorkRoleNumberMap;
    }
}

