/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.formplugin.web.bill.impt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.data.ImportLogHelper;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.imp.BatchImportSheetHandler;
import kd.hr.hbp.formplugin.web.multimport.HRMultipleEntitiesImportPlugin;
import kd.hr.hbp.formplugin.web.multimport.MultiEntityImportFailedSheetHandler;
import kd.hr.ptmm.common.constants.ProjectTeamBillConstants;
import kd.hr.ptmm.formplugin.web.bill.impt.ProjectTeamImportCommon;
import kd.hr.ptmm.formplugin.web.bill.impt.ValidateFailException;
import kd.hr.ptmm.formplugin.web.bill.impt.validate.AbsProjectMemberImportValidate;
import kd.hr.ptmm.formplugin.web.bill.impt.validate.ProjectMemberImportValidateAdd;

public class ProjectMemberBatchImport
extends HRMultipleEntitiesImportPlugin
implements ProjectTeamBillConstants {
    private static final Log LOG = LogFactory.getLog(ProjectMemberBatchImport.class);
    private final Map<String, ImportLogger> importLoggerMap = Maps.newHashMap();
    private final Map<String, String> urlResolveResult = Maps.newHashMap();
    private static final int BATCH_POLL_QUEUE_TIMEOUT = 20;
    private Boolean resolveExcelResult;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveExcel() {
        LOG.info("ProjectMemberBatchImport--begin to resolveExcel");
        String maxCount = System.getProperty("hr.hrmp.hbp.multisheetexport");
        if (HRStringUtils.isNotEmpty((String)maxCount)) {
            this.ctx.setBatchEntryRowSize(Integer.parseInt(maxCount));
        }
        FileService service = FileServiceFactory.getAttachmentFileService();
        ExcelReader excelReader = new ExcelReader();
        for (String url : this.ctx.getAllUrls()) {
            try {
                InputStream in = service.getInputStream(url);
                Throwable throwable = null;
                try {
                    excelReader.read(in, (SheetHandler)new BatchImportSheetHandler(this.ctx, url, this.importLoggerMap));
                    this.resolveExcelResult = Boolean.TRUE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Exception exc) {
                this.resolveExcelResult = Boolean.FALSE;
                ImportLogger logger = this.ctx.getLogger(url);
                String errMessage = exc.getMessage();
                if (exc instanceof KDBizException) {
                    logger.log(Integer.valueOf(0), errMessage);
                } else {
                    logger.log(Integer.valueOf(3), ImportLogger.formatException((Throwable)exc));
                }
                LOG.error((Throwable)exc);
                JSONObject json = new JSONObject();
                json.put("errCode", (Object)errMessage);
                this.ctx.getDataQueue(url).add(new ImportBillData(json, 0, 0, null));
            }
            finally {
                this.ctx.setResolveComplete(url);
                if (!Objects.nonNull(this.resolveExcelResult) || !this.resolveExcelResult.booleanValue()) continue;
                this.urlResolveResult.put(url, "1");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importData() throws Throwable {
        boolean haveException = false;
        try {
            for (String url : this.ctx.getAllUrls()) {
                ArrayList delRows = new ArrayList();
                ImportLogger importLogger = this.ctx.getLogger(url);
                importLogger.setDelRows(delRows);
                try {
                    List<ImportBillData> importBillDataList = this.getAllDataFromQueue(url);
                    Map logCache = importLogger.getLogCache();
                    if (!CollectionUtils.isEmpty((Map)logCache)) {
                        logCache.forEach((key, value) -> {
                            importLogger.fail();
                            importLogger.log(key, value.stream().map(ImportLogger.ImportLog::toString).collect(Collectors.joining(";")));
                        });
                        this.ctx.feedbackProgress(ProjectTeamImportCommon.generateRandom(100), importLogger, null);
                        throw new ValidateFailException();
                    }
                    this.doImportData(importBillDataList);
                }
                catch (Exception exception) {
                    LOG.error("ProjectMemberBatchImport.import error: ", (Throwable)exception);
                    if (!(exception instanceof ValidateFailException)) {
                        importLogger.log(Integer.valueOf(0), (Throwable)exception);
                    }
                    if (haveException) continue;
                    haveException = true;
                }
            }
        }
        finally {
            HashMap<String, Object> retData = new HashMap<String, Object>();
            retData.put("complete", Boolean.TRUE);
            retData.put("info", this.ctx.getUrlLoggers());
            int total = 0;
            int failed = 0;
            for (String url : this.ctx.getAllUrls()) {
                ImportLogger logger = this.ctx.getLogger(url);
                total += logger.getTotal();
                failed += logger.getFailed();
                if (logger.getFailed() <= 0 && logger.getRowIndex() >= logger.getLastRowIndex() - 1) continue;
                this.outputFailedForData(url, logger);
            }
            ImportLogHelper.logAll((Object)this.ctx.getLogId(), (String)JSON.toJSONString(retData), (int)total, (int)failed);
            if (haveException) {
                this.ctx.feedbackProgress(100, total, total);
            } else {
                this.ctx.feedbackProgress(100, null, null);
            }
        }
    }

    private void outputFailedForData(String url, ImportLogger importLogger) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        try {
            new ExcelReader().read(service.getInputStream(url), (SheetHandler)new MultiEntityImportFailedSheetHandler(this.ctx, importLogger, service, this.importLoggerMap, this.isDistributeFullData()));
        }
        catch (Exception e) {
            LOG.error("ProjectMemberBatchImport--outputFailedForData error,", (Throwable)e);
            importLogger.log(Integer.valueOf(0), (Throwable)e);
        }
    }

    private List<ImportBillData> getAllDataFromQueue(String url) {
        LinkedBlockingQueue dataQ = this.ctx.getDataQueue(url);
        ArrayList<ImportBillData> rowDataList = new ArrayList<ImportBillData>();
        while (!(!CollectionUtils.isEmpty(this.urlResolveResult) && HRStringUtils.equals((String)"1", (String)String.valueOf(this.urlResolveResult.get(url))) || Objects.nonNull(this.resolveExcelResult) && !this.resolveExcelResult.booleanValue())) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            Queues.drain((BlockingQueue)dataQ, rowDataList, (int)dataQ.size(), (long)20L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.checkResolveData(rowDataList);
        rowDataList.stream().collect(Collectors.groupingBy(this::getDataEntityName)).forEach((entityName, billDataList) -> {
            ImportLogger importLogger = this.importLoggerMap.get(entityName);
            importLogger.setTotal(importLogger.getTotal() + billDataList.size());
        });
        return rowDataList;
    }

    protected void doImportData(List<ImportBillData> importBillDataList) {
        Map option = this.ctx.getOption();
        String optionCode = (String)option.get("importtype");
        IFormView billView = this.getBillView();
        AbsProjectMemberImportValidate validate = null;
        switch (optionCode) {
            case "new": {
                validate = new ProjectMemberImportValidateAdd(billView, this.ctx, importBillDataList, this.importLoggerMap);
                break;
            }
            case "override": 
            case "overridenew": {
                break;
            }
        }
        if (validate != null) {
            validate.execute();
        }
    }

    private IFormView getBillView() {
        Map option = this.ctx.getOption();
        if (CollectionUtils.isEmpty((Map)option)) {
            return new BillView();
        }
        Map customParams = (Map)option.get("customParams");
        Object pageId = customParams.get("pageId");
        return Optional.ofNullable(SessionManager.getCurrent().getView(String.valueOf(pageId))).orElseGet(BillView::new);
    }

    private void checkResolveData(List<ImportBillData> importBillDataList) {
        if (CollectionUtils.isEmpty(importBillDataList)) {
            return;
        }
        if (importBillDataList.get(0).getData().containsKey((Object)"errCode")) {
            LOG.error("ProjectMemberBatchImport--doImportData error:{}", (Object)importBillDataList.get(0).getData().toJSONString());
            throw new KDBizException((String)importBillDataList.get(0).getData().get((Object)"errCode"));
        }
    }

    private String getDataEntityName(ImportBillData rowData) {
        return (String)((JSONObject)rowData.getData().get((Object)"data")).keySet().iterator().next();
    }
}

