/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.formplugin.web.bill.impt;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.common.bean.ImportBillDataSupplementParam;
import kd.hr.ptmm.common.entity.VidPropTypeConfig;
import kd.hr.ptmm.common.enums.AdjustTypeEnum;
import kd.hr.ptmm.formplugin.web.bill.impt.AbstractProjectMemberEntryWrite;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class ProjectMemberEntryWriteImpl
extends AbstractProjectMemberEntryWrite {
    private static final Log log = LogFactory.getLog(ProjectMemberEntryWriteImpl.class);

    @Override
    public void parseNumberParamMemberJoin() {
        List<ImportBillData> importBillData = this.getImportBillDataGroup().get(AdjustTypeEnum.MEMBER_JOIN);
        if (CollectionUtils.isEmpty(importBillData)) {
            return;
        }
        ImportBillDataSupplementParam params = this.getImportBillDataNumbers();
        for (ImportBillData importBillDatum : importBillData) {
            JSONObject dataRow = ProjectMemberEntryWriteImpl.getDataRow(importBillDatum, "ptmm_entrymemberjoin");
            String personNumber = this.getStrValue(dataRow, "personnumber");
            params.getPersonNumbers().add(personNumber);
            String adjustReasonNumber = this.getStrValue(dataRow, "adjustreason");
            params.getAdjustReasonNumbers().add(adjustReasonNumber);
            String projectTeamNumber = this.getStrValue(dataRow, "projectteamadd");
            params.getProjectTeamNumbers().add(projectTeamNumber);
            String projectRoleNumber = this.getStrValue(dataRow, "projectrole");
            params.getProjectRoleNumbers().add(projectRoleNumber);
            String projectRoleOtherNumber = this.getStrValue(dataRow, "projectroleother");
            String[] projectOtherNumberArr = projectRoleOtherNumber.split(",");
            Set projectRoleNumbers = params.getProjectRoleNumbers();
            Map<String, DynamicObject> projectRoleToWorkRoleNumberMap = this.getProjectRoleToWorkRoleNumberMap();
            for (String projectOtherRoleNumber : projectOtherNumberArr) {
                DynamicObject workRoleObj = projectRoleToWorkRoleNumberMap.get(projectOtherRoleNumber);
                if (HRObjectUtils.isEmpty((Object)workRoleObj)) continue;
                String workRoleNumber = workRoleObj.getString("number");
                projectRoleNumbers.add(workRoleNumber);
            }
        }
    }

    @Override
    public void parseNumberParamRoleJoin() {
        List<ImportBillData> importBillData = this.getImportBillDataGroup().get(AdjustTypeEnum.ROLE_JOIN);
        if (CollectionUtils.isEmpty(importBillData)) {
            return;
        }
        ImportBillDataSupplementParam params = this.getImportBillDataNumbers();
        for (ImportBillData importBillDatum : importBillData) {
            JSONObject dataRow = ProjectMemberEntryWriteImpl.getDataRow(importBillDatum, "ptmm_entryrolejoin");
            String personNumber = this.getStrValue(dataRow, "numberadja");
            params.getPersonNumbers().add(personNumber);
            String adjustReasonNumber = this.getStrValue(dataRow, "adjustreasonadja");
            params.getAdjustReasonNumbers().add(adjustReasonNumber);
            String projectTeamNumber = this.getStrValue(dataRow, "projectteamadja");
            params.getProjectTeamNumbers().add(projectTeamNumber);
            String projectRoleNumber = this.getStrValue(dataRow, "projectroleadja");
            params.getProjectRoleNumbers().add(projectRoleNumber);
        }
    }

    @Override
    public void parseNumberParamRoleAdjust() {
        List<ImportBillData> importBillData = this.getImportBillDataGroup().get(AdjustTypeEnum.ROLE_ADJUST);
        if (CollectionUtils.isEmpty(importBillData)) {
            return;
        }
        Set personNumbers = this.getImportBillDataNumbers().getPersonNumbers();
        Set projectTeamNumbers = this.getImportBillDataNumbers().getProjectTeamNumbers();
        Set projectRoleNumbers = this.getImportBillDataNumbers().getProjectRoleNumbers();
        Set adjustReasonNumbers = this.getImportBillDataNumbers().getAdjustReasonNumbers();
        for (ImportBillData importBillDatum : importBillData) {
            JSONObject dataRow = ProjectMemberEntryWriteImpl.getDataRow(importBillDatum, "ptmm_entryroleadjust");
            String personNumber = this.getStrValue(dataRow, "numberadj");
            personNumbers.add(personNumber);
            String adjustReasonNumber = this.getStrValue(dataRow, "adjustreasonadj");
            adjustReasonNumbers.add(adjustReasonNumber);
            String projectTeamNumber = this.getStrValue(dataRow, "projectteamadj");
            projectTeamNumbers.add(projectTeamNumber);
            String projectRoleNumber = this.getStrValue(dataRow, "projectroleadj");
            projectRoleNumbers.add(projectRoleNumber);
            String projectTeamNumberAfter = this.getStrValue(dataRow, "projectteamadjnew");
            projectTeamNumbers.add(projectTeamNumberAfter);
            String projectRoleNumberAfter = this.getStrValue(dataRow, "projectroleadjnew");
            projectRoleNumbers.add(projectRoleNumberAfter);
        }
    }

    @Override
    public void parseNumberParamRoleQuit() {
        List<ImportBillData> importBillData = this.getImportBillDataGroup().get(AdjustTypeEnum.ROLE_QUIT);
        if (CollectionUtils.isEmpty(importBillData)) {
            return;
        }
        ImportBillDataSupplementParam params = this.getImportBillDataNumbers();
        for (ImportBillData importBillDatum : importBillData) {
            JSONObject dataRow = ProjectMemberEntryWriteImpl.getDataRow(importBillDatum, "ptmm_entryrolequit");
            String personNumber = this.getStrValue(dataRow, "numberadjq");
            params.getPersonNumbers().add(personNumber);
            String adjustReasonNumber = this.getStrValue(dataRow, "adjustreasonadjq");
            params.getAdjustReasonNumbers().add(adjustReasonNumber);
            String projectTeamNumber = this.getStrValue(dataRow, "projectteamadjq");
            params.getProjectTeamNumbers().add(projectTeamNumber);
            String projectRoleNumber = this.getStrValue(dataRow, "projectroleadjq");
            params.getProjectRoleNumbers().add(projectRoleNumber);
        }
    }

    @Override
    public void parseNumberParamMemberQuit() {
        List<ImportBillData> importBillData = this.getImportBillDataGroup().get(AdjustTypeEnum.MEMBER_QUIT);
        if (CollectionUtils.isEmpty(importBillData)) {
            return;
        }
        Set personNumbers = this.getImportBillDataNumbers().getPersonNumbers();
        Set projectTeamNumbers = this.getImportBillDataNumbers().getProjectTeamNumbers();
        Set adjustReasonNumbers = this.getImportBillDataNumbers().getAdjustReasonNumbers();
        for (ImportBillData importBillDatum : importBillData) {
            JSONObject dataRow = ProjectMemberEntryWriteImpl.getDataRow(importBillDatum, "ptmm_entrymemberquit");
            String personNumber = this.getStrValue(dataRow, "numberq");
            personNumbers.add(personNumber);
            String adjustReasonNumber = this.getStrValue(dataRow, "adjustreasonq");
            adjustReasonNumbers.add(adjustReasonNumber);
            String projectTeamNumber = this.getStrValue(dataRow, "projectteamq");
            projectTeamNumbers.add(projectTeamNumber);
        }
    }

    @Override
    public void parseBaseByNumberResultMemberJoin() {
        Map<AdjustTypeEnum, List<ImportBillData>> importBillDataGroup = this.getImportBillDataGroup();
        List<ImportBillData> importBillData = importBillDataGroup.get(AdjustTypeEnum.MEMBER_JOIN);
        if (CollectionUtils.isEmpty(importBillData)) {
            return;
        }
        Map<String, DynamicObject> projectTeamMap = this.getProjectTeamMap();
        Map<String, DynamicObject> projectRoleMap = this.getProjectRoleMap();
        Map superiorRoleTeam = this.getImportBillDataNumbers().getSuperiorRoleTeam();
        for (ImportBillData importBillDatum : importBillData) {
            JSONObject dataRow = ProjectMemberEntryWriteImpl.getDataRow(importBillDatum, "ptmm_entrymemberjoin");
            long projectRoleId = this.getBaseId(dataRow, "projectrole", projectRoleMap);
            long projectTeamId = this.getBaseId(dataRow, "projectteamadd", projectTeamMap);
            superiorRoleTeam.put(projectRoleId, projectTeamId);
        }
    }

    @Override
    public void parseBaseByNumberResultRoleJoin() {
        Map<AdjustTypeEnum, List<ImportBillData>> importBillDataGroup = this.getImportBillDataGroup();
        List<ImportBillData> importBillData = importBillDataGroup.get(AdjustTypeEnum.ROLE_JOIN);
        if (CollectionUtils.isEmpty(importBillData)) {
            return;
        }
        Map<String, DynamicObject> personNumberMap = this.getPersonMap();
        Map<String, DynamicObject> projectTeamMap = this.getProjectTeamMap();
        Map<String, DynamicObject> projectRoleMap = this.getProjectRoleMap();
        List teamMemberKeys = this.getImportBillDataNumbers().getTeamMemberKeys();
        for (ImportBillData importBillDatum : importBillData) {
            JSONObject dataRow = ProjectMemberEntryWriteImpl.getDataRow(importBillDatum, "ptmm_entryrolejoin");
            String personNumber = this.getStrValue(dataRow, "numberadja");
            String projectTeamNumber = this.getStrValue(dataRow, "projectteamadja");
            DynamicObject personObj = personNumberMap.get(personNumber);
            DynamicObject projectTeamObj = projectTeamMap.get(projectTeamNumber);
            teamMemberKeys.add(Pair.of((Object)personObj.getLong("id"), (Object)projectTeamObj.getLong("id")));
        }
        Map superiorRoleTeam = this.getImportBillDataNumbers().getSuperiorRoleTeam();
        for (ImportBillData importBillDatum : importBillData) {
            JSONObject dataRow = ProjectMemberEntryWriteImpl.getDataRow(importBillDatum, "ptmm_entryrolejoin");
            long projectRoleId = this.getBaseId(dataRow, "projectroleadja", projectRoleMap);
            long projectTeamId = this.getBaseId(dataRow, "projectteamadja", projectTeamMap);
            superiorRoleTeam.put(projectRoleId, projectTeamId);
        }
    }

    @Override
    public void parseBaseByNumberResultRoleAdjust() {
        Map<AdjustTypeEnum, List<ImportBillData>> importBillDataGroup = this.getImportBillDataGroup();
        List<ImportBillData> importBillData = importBillDataGroup.get(AdjustTypeEnum.ROLE_ADJUST);
        if (CollectionUtils.isEmpty(importBillData)) {
            return;
        }
        Map<String, DynamicObject> personNumberMap = this.getPersonMap();
        Map<String, DynamicObject> projectTeamMap = this.getProjectTeamMap();
        Map<String, DynamicObject> projectRoleMap = this.getProjectRoleMap();
        List teamMemberRoleKeys = this.getImportBillDataNumbers().getTeamMemberRoleKeys();
        for (ImportBillData importBillDatum : importBillData) {
            JSONObject dataRow = ProjectMemberEntryWriteImpl.getDataRow(importBillDatum, "ptmm_entryroleadjust");
            String personNumber = this.getStrValue(dataRow, "numberadj");
            String projectTeamNumber = this.getStrValue(dataRow, "projectteamadj");
            String projectRoleNumber = this.getStrValue(dataRow, "projectroleadj");
            DynamicObject personObj = personNumberMap.get(personNumber);
            DynamicObject projectTeamObj = projectTeamMap.get(projectTeamNumber);
            DynamicObject projectRoleObj = projectRoleMap.get(projectRoleNumber);
            teamMemberRoleKeys.add(Triple.of((Object)personObj.getLong("id"), (Object)projectTeamObj.getLong("id"), (Object)projectRoleObj.getLong("id")));
        }
        Map superiorRoleTeam = this.getImportBillDataNumbers().getSuperiorRoleTeam();
        for (ImportBillData importBillDatum : importBillData) {
            JSONObject dataRow = ProjectMemberEntryWriteImpl.getDataRow(importBillDatum, "ptmm_entryroleadjust");
            long projectTeamId = this.getBaseId(dataRow, "projectteamadj", projectTeamMap);
            long projectRoleId = this.getBaseId(dataRow, "projectroleadj", projectRoleMap);
            superiorRoleTeam.put(projectRoleId, projectTeamId);
            long projectTeamIdAfter = this.getBaseId(dataRow, "projectteamadjnew", projectTeamMap);
            long projectRoleIdAfter = this.getBaseId(dataRow, "projectroleadjnew", projectRoleMap);
            superiorRoleTeam.put(projectRoleIdAfter, projectTeamIdAfter);
        }
    }

    @Override
    public void parseBaseByNumberResultRoleQuit() {
        Map<AdjustTypeEnum, List<ImportBillData>> importBillDataGroup = this.getImportBillDataGroup();
        List<ImportBillData> importBillData = importBillDataGroup.get(AdjustTypeEnum.ROLE_QUIT);
        if (CollectionUtils.isEmpty(importBillData)) {
            return;
        }
        Map<String, DynamicObject> personNumberMap = this.getPersonMap();
        Map<String, DynamicObject> projectTeamMap = this.getProjectTeamMap();
        Map<String, DynamicObject> projectRoleMap = this.getProjectRoleMap();
        List teamMemberRoleKeys = this.getImportBillDataNumbers().getTeamMemberRoleKeys();
        for (ImportBillData importBillDatum : importBillData) {
            JSONObject dataRow = ProjectMemberEntryWriteImpl.getDataRow(importBillDatum, "ptmm_entryrolequit");
            String personNumber = this.getStrValue(dataRow, "numberadjq");
            String projectTeamNumber = this.getStrValue(dataRow, "projectteamadjq");
            String projectRoleNumber = this.getStrValue(dataRow, "projectroleadjq");
            DynamicObject personObj = personNumberMap.get(personNumber);
            DynamicObject projectTeamObj = projectTeamMap.get(projectTeamNumber);
            DynamicObject projectRoleObj = projectRoleMap.get(projectRoleNumber);
            teamMemberRoleKeys.add(Triple.of((Object)personObj.getLong("id"), (Object)projectTeamObj.getLong("id"), (Object)projectRoleObj.getLong("id")));
        }
        Map superiorRoleTeam = this.getImportBillDataNumbers().getSuperiorRoleTeam();
        for (ImportBillData importBillDatum : importBillData) {
            JSONObject dataRow = ProjectMemberEntryWriteImpl.getDataRow(importBillDatum, "ptmm_entryrolequit");
            long projectTeamId = this.getBaseId(dataRow, "projectteamadjq", projectTeamMap);
            long projectRoleId = this.getBaseId(dataRow, "projectroleadjq", projectRoleMap);
            superiorRoleTeam.put(projectRoleId, projectTeamId);
        }
    }

    @Override
    public void parseBaseByNumberResultMemberQuit() {
        Map<AdjustTypeEnum, List<ImportBillData>> importBillDataGroup = this.getImportBillDataGroup();
        List<ImportBillData> importBillData = importBillDataGroup.get(AdjustTypeEnum.MEMBER_QUIT);
        if (CollectionUtils.isEmpty(importBillData)) {
            return;
        }
        Map<String, DynamicObject> personNumberMap = this.getPersonMap();
        Map<String, DynamicObject> projectTeamMap = this.getProjectTeamMap();
        List teamMemberKeys = this.getImportBillDataNumbers().getTeamMemberKeys();
        for (ImportBillData importBillDatum : importBillData) {
            JSONObject dataRow = ProjectMemberEntryWriteImpl.getDataRow(importBillDatum, "ptmm_entrymemberquit");
            String personNumber = this.getStrValue(dataRow, "numberq");
            String projectTeamNumber = this.getStrValue(dataRow, "projectteamq");
            DynamicObject personObj = personNumberMap.get(personNumber);
            DynamicObject projectTeamObj = projectTeamMap.get(projectTeamNumber);
            teamMemberKeys.add(Pair.of((Object)personObj.getLong("id"), (Object)projectTeamObj.getLong("id")));
        }
    }

    @Override
    public void parseBaseQuitSuperiorByNumberResultMemberQuit() {
        Map<AdjustTypeEnum, List<ImportBillData>> importBillDataGroup = this.getImportBillDataGroup();
        List<ImportBillData> importBillData = importBillDataGroup.get(AdjustTypeEnum.MEMBER_QUIT);
        if (CollectionUtils.isEmpty(importBillData)) {
            return;
        }
        Map<String, DynamicObject> personNumberMap = this.getPersonMap();
        Map<String, DynamicObject> projectTeamMap = this.getProjectTeamMap();
        Map superiorRoleTeam = this.getImportBillDataNumbers().getSuperiorRoleTeam();
        for (ImportBillData importBillDatum : importBillData) {
            JSONObject dataRow = ProjectMemberEntryWriteImpl.getDataRow(importBillDatum, "ptmm_entrymemberquit");
            String personNumber = this.getStrValue(dataRow, "numberq");
            String projectTeamNumber = this.getStrValue(dataRow, "projectteamq");
            DynamicObject personObj = personNumberMap.get(personNumber);
            DynamicObject projectTeamObj = projectTeamMap.get(projectTeamNumber);
            long projectTeamId = projectTeamObj.getLong("id");
            Pair teamKey = Pair.of((Object)personObj.getLong("id"), (Object)projectTeamId);
            DynamicObject teamMember = this.getTeamMemberMap().get(teamKey);
            long projectRoleId = teamMember.getLong("projectrole.id");
            superiorRoleTeam.put(projectRoleId, projectTeamId);
        }
    }

    @Override
    public void entryPaddingDataMemberJoin(AbstractFormDataModel model) {
        JSONObject dataRow;
        Map<AdjustTypeEnum, List<ImportBillData>> importBillDataGroup = this.getImportBillDataGroup();
        List<ImportBillData> importBillData = importBillDataGroup.get(AdjustTypeEnum.MEMBER_JOIN);
        if (CollectionUtils.isEmpty(importBillData)) {
            return;
        }
        Map<String, DynamicObject> personNumberMap = this.getPersonMap();
        Map<String, DynamicObject> adjustReasonObjsMap = this.getAdjustReasonMap();
        Map<String, DynamicObject> projectTeamMap = this.getProjectTeamMap();
        Map<String, DynamicObject> projectRoleMap = this.getProjectRoleMap();
        Map<Long, Map<String, Object>> personOrgInfoMap = this.getPersonOrgInfos();
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        for (ImportBillData importBillDatum : importBillData) {
            dataRow = ProjectMemberEntryWriteImpl.getDataRow(importBillDatum, "ptmm_entrymemberjoin");
            this.addFieldStr(dataRow, tableValueSetter, "personnumber");
            this.addFieldBase(dataRow, tableValueSetter, "personnumber", personNumberMap, "personfield");
            this.addFieldDate(dataRow, tableValueSetter, "joinstartdate");
            this.addFieldBase(dataRow, tableValueSetter, "adjustreason", adjustReasonObjsMap);
            this.addFieldBase(dataRow, tableValueSetter, "projectteamadd", projectTeamMap);
            this.addFieldBase(dataRow, tableValueSetter, "projectrole", projectRoleMap);
            this.addFieldBoolean(dataRow, tableValueSetter, "isprincipal");
            String strValue = this.getStrValue(dataRow, "personnumber");
            Optional.ofNullable(personNumberMap.get(strValue)).ifPresent(dyObj -> {
                long personId = dyObj.getLong("id");
                Map personInfos = (Map)personOrgInfoMap.get(personId);
                this.setOrgInfo(tableValueSetter, personInfos, VidPropTypeConfig.PROP_TYPE_MAP_JOIN);
            });
            this.addFieldToTableValueSetter(dataRow, tableValueSetter, AdjustTypeEnum.MEMBER_JOIN);
        }
        model.beginInit();
        int[] newRows = model.batchCreateNewEntryRow("memberjoinentry", tableValueSetter);
        for (int i = 0; i < importBillData.size(); ++i) {
            dataRow = ProjectMemberEntryWriteImpl.getDataRow(importBillData.get(i), "ptmm_entrymemberjoin");
            this.setMemberJoinOtherRole(model, projectRoleMap, dataRow, newRows[i]);
            long projectRoleId = this.getBaseId(dataRow, "projectrole", projectRoleMap);
            long projectTeamId = this.getBaseId(dataRow, "projectteamadd", projectTeamMap);
            List<DynamicObject> memberRoles = this.getSuperiorByRoleAndTeam().get(Pair.of((Object)projectRoleId, (Object)projectTeamId));
            if (!CollectionUtils.isEmpty(memberRoles)) {
                Long[] personIds = (Long[])memberRoles.stream().map(obj -> obj.getLong("person.id")).toArray(Long[]::new);
                model.setValue("teamcharge", (Object)personIds, newRows[i]);
            }
            this.setValueByModel(model, newRows[i], AdjustTypeEnum.MEMBER_JOIN);
        }
        model.endInit();
    }

    private void setMemberJoinOtherRole(AbstractFormDataModel model, Map<String, DynamicObject> projectRoleMap, JSONObject dataRow, int newRows) {
        JSONObject otherRole = dataRow.getJSONObject("projectroleother");
        if (Objects.isNull(otherRole)) {
            return;
        }
        Object otherRoleNumber = otherRole.get((Object)"number");
        if (Objects.isNull(otherRoleNumber)) {
            return;
        }
        String projectRoleOther = (String)otherRoleNumber;
        String[] projectOtherNumberArr = projectRoleOther.split(",");
        ArrayList projectRoleList = Lists.newArrayListWithCapacity((int)projectOtherNumberArr.length);
        for (String projectOtherNumber : projectOtherNumberArr) {
            DynamicObject workRole = this.getProjectRoleToWorkRoleNumberMap().get(projectOtherNumber);
            String workRoleNumber = workRole.getString("number");
            Optional.ofNullable(projectRoleMap.get(workRoleNumber)).ifPresent(obj -> projectRoleList.add(obj.getLong("id")));
        }
        model.setValue("projectroleother", (Object)projectRoleList.toArray(new Long[0]), newRows);
    }

    @Override
    public void entryPaddingDataRoleJoin(AbstractFormDataModel model) {
        JSONObject dataRow;
        Map<AdjustTypeEnum, List<ImportBillData>> importBillDataGroup = this.getImportBillDataGroup();
        List<ImportBillData> importBillData = importBillDataGroup.get(AdjustTypeEnum.ROLE_JOIN);
        if (CollectionUtils.isEmpty(importBillData)) {
            return;
        }
        Map<String, DynamicObject> personNumberMap = this.getPersonMap();
        Map<String, DynamicObject> adjustReasonObjsMap = this.getAdjustReasonMap();
        Map<String, DynamicObject> projectTeamMap = this.getProjectTeamMap();
        Map<String, DynamicObject> projectRoleMap = this.getProjectRoleMap();
        Map<Long, Map<String, Object>> personOrgInfoMap = this.getPersonOrgInfos();
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        for (ImportBillData importBillDatum : importBillData) {
            dataRow = ProjectMemberEntryWriteImpl.getDataRow(importBillDatum, "ptmm_entryrolejoin");
            String personNumber = this.getStrValue(dataRow, "numberadja");
            String projectTeamNumber = this.getStrValue(dataRow, "projectteamadja");
            DynamicObject personObj = personNumberMap.get(personNumber);
            DynamicObject projectTeamObj = projectTeamMap.get(projectTeamNumber);
            Pair teamKey = Pair.of((Object)personObj.getLong("id"), (Object)projectTeamObj.getLong("id"));
            DynamicObject teamMember = this.getTeamMemberMap().get(teamKey);
            if (!HRObjectUtils.isEmpty((Object)teamMember)) {
                long belongAdminOrgId = teamMember.getDynamicObject("projectteam").getLong("belongadminorg.id");
                tableValueSetter.addField("personbaseadja", new Object[]{teamMember.getLong("id")});
                tableValueSetter.addField("projectteamadminadja", new Object[]{belongAdminOrgId});
            }
            this.addFieldDate(dataRow, tableValueSetter, "effectdateadja");
            this.addFieldBase(dataRow, tableValueSetter, "adjustreasonadja", adjustReasonObjsMap);
            this.addFieldBase(dataRow, tableValueSetter, "projectroleadja", projectRoleMap);
            this.addFieldBoolean(dataRow, tableValueSetter, "isprincipaladja");
            String strValue = this.getStrValue(dataRow, "numberadja");
            Optional.ofNullable(personNumberMap.get(strValue)).ifPresent(dyObj -> {
                long personId = dyObj.getLong("id");
                Map personInfos = (Map)personOrgInfoMap.get(personId);
                this.setOrgInfo(tableValueSetter, personInfos, VidPropTypeConfig.PROP_TYPE_MAP_JOIN_ADJUST);
            });
            this.addFieldToTableValueSetter(dataRow, tableValueSetter, AdjustTypeEnum.ROLE_JOIN);
        }
        model.beginInit();
        int[] newRows = model.batchCreateNewEntryRow("memberadjjentry", tableValueSetter);
        for (int i = 0; i < importBillData.size(); ++i) {
            dataRow = ProjectMemberEntryWriteImpl.getDataRow(importBillData.get(i), "ptmm_entryrolejoin");
            long projectRoleId = this.getBaseId(dataRow, "projectroleadja", projectRoleMap);
            long projectTeamId = this.getBaseId(dataRow, "projectteamadja", projectTeamMap);
            List<DynamicObject> memberRoles = this.getSuperiorByRoleAndTeam().get(Pair.of((Object)projectRoleId, (Object)projectTeamId));
            if (!CollectionUtils.isEmpty(memberRoles)) {
                Long[] personIds = (Long[])memberRoles.stream().map(obj -> obj.getLong("person.id")).toArray(Long[]::new);
                model.setValue("teamchargeadja", (Object)personIds, newRows[i]);
            }
            this.setValueByModel(model, newRows[i], AdjustTypeEnum.ROLE_JOIN);
        }
        model.endInit();
    }

    @Override
    public void entryPaddingDataRoleAdjust(AbstractFormDataModel model) {
        JSONObject dataRow;
        Map<AdjustTypeEnum, List<ImportBillData>> importBillDataGroup = this.getImportBillDataGroup();
        List<ImportBillData> importBillData = importBillDataGroup.get(AdjustTypeEnum.ROLE_ADJUST);
        if (CollectionUtils.isEmpty(importBillData)) {
            return;
        }
        Map<String, DynamicObject> personNumberMap = this.getPersonMap();
        Map<String, DynamicObject> adjustReasonObjsMap = this.getAdjustReasonMap();
        Map<String, DynamicObject> projectTeamMap = this.getProjectTeamMap();
        Map<String, DynamicObject> projectRoleMap = this.getProjectRoleMap();
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        for (ImportBillData importBillDatum : importBillData) {
            dataRow = ProjectMemberEntryWriteImpl.getDataRow(importBillDatum, "ptmm_entryroleadjust");
            String personNumber = this.getStrValue(dataRow, "numberadj");
            String projectTeamNumber = this.getStrValue(dataRow, "projectteamadj");
            String projectRoleNumber = this.getStrValue(dataRow, "projectroleadj");
            DynamicObject personObj = personNumberMap.get(personNumber);
            DynamicObject projectTeamObj = projectTeamMap.get(projectTeamNumber);
            DynamicObject projectRoleObj = projectRoleMap.get(projectRoleNumber);
            Triple teamKey = Triple.of((Object)personObj.getLong("id"), (Object)projectTeamObj.getLong("id"), (Object)projectRoleObj.getLong("id"));
            DynamicObject teamMemberRole = this.getTeamMemberRoleMap().get(teamKey);
            if (!HRObjectUtils.isEmpty((Object)teamMemberRole)) {
                tableValueSetter.addField("personbaseadj", new Object[]{teamMemberRole.getLong("id")});
                tableValueSetter.addField("isdutypersadj", new Object[]{teamMemberRole.getBoolean("mainpeoincharge") ? "1" : "0"});
            }
            this.addFieldDate(dataRow, tableValueSetter, "effectdateadj");
            this.addFieldBase(dataRow, tableValueSetter, "adjustreasonadj", adjustReasonObjsMap);
            this.addFieldBase(dataRow, tableValueSetter, "projectteamadjnew", projectTeamMap);
            this.addFieldBase(dataRow, tableValueSetter, "projectroleadjnew", projectRoleMap);
            this.addFieldBoolean(dataRow, tableValueSetter, "isprincipaladjnew");
            this.addFieldToTableValueSetter(dataRow, tableValueSetter, AdjustTypeEnum.ROLE_ADJUST);
        }
        model.beginInit();
        int[] newRows = model.batchCreateNewEntryRow("memberadjaentry", tableValueSetter);
        for (int i = 0; i < importBillData.size(); ++i) {
            dataRow = ProjectMemberEntryWriteImpl.getDataRow(importBillData.get(i), "ptmm_entryroleadjust");
            Map<Pair<Long, Long>, List<DynamicObject>> superiorByRoleAndTeam = this.getSuperiorByRoleAndTeam();
            long projectRoleId = this.getBaseId(dataRow, "projectroleadj", projectRoleMap);
            long projectTeamId = this.getBaseId(dataRow, "projectteamadj", projectTeamMap);
            List<DynamicObject> memberRoles = superiorByRoleAndTeam.get(Pair.of((Object)projectRoleId, (Object)projectTeamId));
            if (!CollectionUtils.isEmpty(memberRoles)) {
                Long[] personIds = (Long[])memberRoles.stream().map(obj -> obj.getLong("person.id")).toArray(Long[]::new);
                model.setValue("teamchargeadj", (Object)personIds, newRows[i]);
            }
            long projectTeamIdAfter = this.getBaseId(dataRow, "projectteamadjnew", projectTeamMap);
            long projectRoleIdAfter = this.getBaseId(dataRow, "projectroleadjnew", projectRoleMap);
            List<DynamicObject> memberRolesAfter = superiorByRoleAndTeam.get(Pair.of((Object)projectRoleIdAfter, (Object)projectTeamIdAfter));
            if (!CollectionUtils.isEmpty(memberRolesAfter)) {
                Long[] personIds = (Long[])memberRolesAfter.stream().map(obj -> obj.getLong("person.id")).toArray(Long[]::new);
                model.setValue("teamchargeadjnew", (Object)personIds, newRows[i]);
            }
            this.setValueByModel(model, newRows[i], AdjustTypeEnum.ROLE_ADJUST);
        }
        model.endInit();
    }

    @Override
    public void entryPaddingDataRoleQuit(AbstractFormDataModel model) {
        JSONObject dataRow;
        Map<AdjustTypeEnum, List<ImportBillData>> importBillDataGroup = this.getImportBillDataGroup();
        List<ImportBillData> importBillData = importBillDataGroup.get(AdjustTypeEnum.ROLE_QUIT);
        if (CollectionUtils.isEmpty(importBillData)) {
            return;
        }
        Map<String, DynamicObject> personNumberMap = this.getPersonMap();
        Map<String, DynamicObject> adjustReasonObjsMap = this.getAdjustReasonMap();
        Map<String, DynamicObject> projectTeamMap = this.getProjectTeamMap();
        Map<String, DynamicObject> projectRoleMap = this.getProjectRoleMap();
        Map<Long, Map<String, Object>> personOrgInfoMap = this.getPersonOrgInfos();
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        for (ImportBillData importBillDatum : importBillData) {
            dataRow = ProjectMemberEntryWriteImpl.getDataRow(importBillDatum, "ptmm_entryrolequit");
            String personNumber = this.getStrValue(dataRow, "numberadjq");
            String projectTeamNumber = this.getStrValue(dataRow, "projectteamadjq");
            String projectRoleNumber = this.getStrValue(dataRow, "projectroleadjq");
            DynamicObject personObj = personNumberMap.get(personNumber);
            DynamicObject projectTeamObj = projectTeamMap.get(projectTeamNumber);
            DynamicObject projectRoleObj = projectRoleMap.get(projectRoleNumber);
            Triple teamKey = Triple.of((Object)personObj.getLong("id"), (Object)projectTeamObj.getLong("id"), (Object)projectRoleObj.getLong("id"));
            DynamicObject teamMemberRole = this.getTeamMemberRoleMap().get(teamKey);
            if (!HRObjectUtils.isEmpty((Object)teamMemberRole)) {
                tableValueSetter.addField("personbaseadjq", new Object[]{teamMemberRole.getLong("id")});
                tableValueSetter.addField("projectteamadminadjq", new Object[]{projectTeamObj.getLong("belongadminorg")});
                tableValueSetter.addField("isdutypersadjq", new Object[]{teamMemberRole.getBoolean("mainpeoincharge") ? "1" : "0"});
            }
            this.addFieldDate(dataRow, tableValueSetter, "effectdateadjq");
            this.addFieldBase(dataRow, tableValueSetter, "adjustreasonadjq", adjustReasonObjsMap);
            String strValue = this.getStrValue(dataRow, "numberadjq");
            Optional.ofNullable(personNumberMap.get(strValue)).ifPresent(dyObj -> {
                long personId = dyObj.getLong("id");
                Map personInfos = (Map)personOrgInfoMap.get(personId);
                this.setOrgInfo(tableValueSetter, personInfos, VidPropTypeConfig.PROP_TYPE_MAP_QUIT_ADJUST);
            });
            this.addFieldToTableValueSetter(dataRow, tableValueSetter, AdjustTypeEnum.ROLE_QUIT);
        }
        model.beginInit();
        int[] newRows = model.batchCreateNewEntryRow("memberadjqentry", tableValueSetter);
        for (int i = 0; i < importBillData.size(); ++i) {
            dataRow = ProjectMemberEntryWriteImpl.getDataRow(importBillData.get(i), "ptmm_entryrolequit");
            long projectTeamId = this.getBaseId(dataRow, "projectteamadjq", projectTeamMap);
            long projectRoleId = this.getBaseId(dataRow, "projectroleadjq", projectRoleMap);
            List<DynamicObject> memberRoles = this.getSuperiorByRoleAndTeam().get(Pair.of((Object)projectRoleId, (Object)projectTeamId));
            if (!CollectionUtils.isEmpty(memberRoles)) {
                Long[] personIds = (Long[])memberRoles.stream().map(obj -> obj.getLong("person.id")).toArray(Long[]::new);
                model.setValue("teamchargeadjq", (Object)personIds, newRows[i]);
            }
            this.setValueByModel(model, newRows[i], AdjustTypeEnum.ROLE_QUIT);
        }
        model.endInit();
    }

    @Override
    public void entryPaddingDataMemberQuit(AbstractFormDataModel model) {
        DynamicObject projectTeamObj;
        DynamicObject personObj;
        String projectTeamNumber;
        String personNumber;
        JSONObject dataRow;
        Map<AdjustTypeEnum, List<ImportBillData>> importBillDataGroup = this.getImportBillDataGroup();
        List<ImportBillData> importBillData = importBillDataGroup.get(AdjustTypeEnum.MEMBER_QUIT);
        if (CollectionUtils.isEmpty(importBillData)) {
            return;
        }
        Map<String, DynamicObject> personNumberMap = this.getPersonMap();
        Map<String, DynamicObject> adjustReasonObjsMap = this.getAdjustReasonMap();
        Map<String, DynamicObject> projectTeamMap = this.getProjectTeamMap();
        Set teamMemberIds = Arrays.stream(this.getTeamMemberMap().values().toArray(new DynamicObject[0])).map(obj -> obj.getLong("id")).collect(Collectors.toSet());
        Map otherRoleMap = PTMMServiceFactory.teamMemberService.listOtherRoleMap(teamMemberIds);
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        for (ImportBillData importBillDatum : importBillData) {
            dataRow = ProjectMemberEntryWriteImpl.getDataRow(importBillDatum, "ptmm_entrymemberquit");
            personNumber = this.getStrValue(dataRow, "numberq");
            projectTeamNumber = this.getStrValue(dataRow, "projectteamq");
            personObj = personNumberMap.get(personNumber);
            projectTeamObj = projectTeamMap.get(projectTeamNumber);
            Pair teamKey = Pair.of((Object)personObj.getLong("id"), (Object)projectTeamObj.getLong("id"));
            DynamicObject teamMember = this.getTeamMemberMap().get(teamKey);
            if (!HRObjectUtils.isEmpty((Object)teamMember)) {
                long belongAdminOrgId = teamMember.getDynamicObject("projectteam").getLong("belongadminorg.id");
                tableValueSetter.addField("personbaseq", new Object[]{teamMember.getLong("id")});
                tableValueSetter.addField("projectteamadminq", new Object[]{belongAdminOrgId});
                boolean principal = teamMember.getDynamicObject("projectrole").getBoolean("mainpeoincharge");
                tableValueSetter.addField("isdutypersq", new Object[]{principal ? "1" : "0"});
            }
            this.addFieldDate(dataRow, tableValueSetter, "quitdate");
            this.addFieldBase(dataRow, tableValueSetter, "adjustreasonq", adjustReasonObjsMap);
            this.addFieldToTableValueSetter(dataRow, tableValueSetter, AdjustTypeEnum.MEMBER_QUIT);
        }
        model.beginInit();
        int[] newRows = model.batchCreateNewEntryRow("memberquitentry", tableValueSetter);
        for (int i = 0; i < importBillData.size(); ++i) {
            long teamMemberId;
            List otherRoles;
            dataRow = ProjectMemberEntryWriteImpl.getDataRow(importBillData.get(i), "ptmm_entrymemberquit");
            personNumber = this.getStrValue(dataRow, "numberq");
            projectTeamNumber = this.getStrValue(dataRow, "projectteamq");
            personObj = personNumberMap.get(personNumber);
            projectTeamObj = projectTeamMap.get(projectTeamNumber);
            long projectTeamId = projectTeamObj.getLong("id");
            Pair teamKey = Pair.of((Object)personObj.getLong("id"), (Object)projectTeamId);
            DynamicObject teamMember = this.getTeamMemberMap().get(teamKey);
            long projectRoleId = teamMember.getLong("projectrole.id");
            List<DynamicObject> memberRoles = this.getSuperiorByRoleAndTeam().get(Pair.of((Object)projectRoleId, (Object)projectTeamId));
            if (!CollectionUtils.isEmpty(memberRoles)) {
                String nameStr = memberRoles.stream().map(obj -> obj.getString("person.name")).collect(Collectors.joining(","));
                model.setValue("teamchargeq", (Object)nameStr, newRows[i]);
            }
            if (!CollectionUtils.isEmpty((Collection)(otherRoles = (List)otherRoleMap.get(teamMemberId = teamMember.getLong("id"))))) {
                String otherRoleName = otherRoles.stream().map(obj -> obj.getString("projectrole.name")).collect(Collectors.joining(","));
                model.setValue("projectroleotherq", (Object)otherRoleName, newRows[i]);
            }
            this.setValueByModel(model, newRows[i], AdjustTypeEnum.MEMBER_QUIT);
        }
        model.endInit();
    }
}

