/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.formplugin.web.bill.impt;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.multimpt.MultiEntityImportDataPlugin;
import kd.hr.ptmm.common.constants.ProjectTeamBillConstants;
import kd.hr.ptmm.common.enums.AdjustBillOpenSource;
import kd.hr.ptmm.formplugin.web.common.ProjectTeamFormCommon;

public class ProjectMemberImportPlugin
extends MultiEntityImportDataPlugin
implements ProjectTeamBillConstants {
    private static final Log log = LogFactory.getLog(ProjectMemberImportPlugin.class);
    public static final String DONOTHING_IMPORT = "donothing_import";
    public static final String DOWNLOAD_TEMPLATE = "download_template";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)DONOTHING_IMPORT)) {
            Object entryWritePluginPath = this.getView().getFormShowParameter().getCustomParam("entryWritePluginPath");
            HashMap<String, Object> customParams = new HashMap<String, Object>(8);
            customParams.put("pageId", this.getView().getPageId());
            customParams.put("entryWritePluginPath", entryWritePluginPath);
            FormShowParameter showParameter = this.createShowParameter(customParams);
            this.getView().showForm(showParameter);
            args.setCancel(true);
        }
        if (DOWNLOAD_TEMPLATE.equals(operateKey)) {
            this.openDownloadTemplatePage();
            args.setCancel(true);
        }
    }

    private FormShowParameter createShowParameter(Map<String, Object> customParams) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrcs_multientityimptstart");
        String billFormId = null;
        String listName = null;
        Object entityId = null;
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        if (view instanceof IBillView) {
            billFormId = view.getEntityId();
            String caption = formShowParameter.getCaption();
            listName = StringUtils.isNotBlank((CharSequence)caption) ? caption : (formShowParameter.getFormConfig() != null ? formShowParameter.getFormConfig().getCaption().toString() : "");
        }
        showParameter.setCustomParam("customParams", customParams);
        showParameter.setCustomParam("oppluginPath", (Object)this.getImportOpPlugin());
        showParameter.setCustomParam("ServiceAppId", (Object)formShowParameter.getServiceAppId());
        showParameter.setCustomParam("CheckRightAppId", (Object)formShowParameter.getCheckRightAppId());
        showParameter.setCustomParam("BillFormId", (Object)this.getCustomTemplateBillFormId());
        showParameter.setCustomParam("ListName", (Object)listName);
        showParameter.setCustomParam("entityid", Optional.ofNullable(this.getCustomEntityId()).orElse((String)entityId));
        this.setVisibleFormShowParameter(showParameter);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "ptmm_entrymemberjoin");
        showParameter.setCloseCallBack(closeCallBack);
        return showParameter;
    }

    private void openDownloadTemplatePage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrcs_dlmultientitytmpl");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("BillFormId", (Object)this.getCustomTemplateBillFormId());
        showParameter.setCustomParam("TemplateType", (Object)"IMPT");
        this.getView().showForm(showParameter);
    }

    private void setVisibleFormShowParameter(FormShowParameter parameter) {
        HashMap<String, Boolean> buttonVisible = new HashMap<String, Boolean>(4);
        buttonVisible.put("radiofield1", Boolean.FALSE);
        buttonVisible.put("radiofield2", Boolean.FALSE);
        for (Map.Entry entry : buttonVisible.entrySet()) {
            parameter.setCustomParam((String)entry.getKey(), entry.getValue());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedcallbackevent) {
        String importSucFlag;
        super.closedCallBack(closedcallbackevent);
        String actionId = closedcallbackevent.getActionId();
        if ("ptmm_entrymemberjoin".equals(actionId) && HRStringUtils.isNotEmpty((String)(importSucFlag = this.getPageCache().get("import_data_success")))) {
            this.getPageCache().put("import_data_success", null);
            ProjectTeamFormCommon.TAB_ENTRY_MAP.forEach((entryKey, tabKey) -> this.getView().updateView(entryKey));
            ProjectTeamFormCommon.getInstance().visibleTab(this.getView());
            ProjectTeamFormCommon.getInstance().updateTabCount(this.getView());
        }
    }

    private String getCustomTemplateBillFormId() {
        String openSource = this.getModel().getDataEntity().getString("opensource");
        if (HRStringUtils.equals((String)openSource, (String)AdjustBillOpenSource.FROM_PROJECT_TEAM_MAINTAIN.getCode())) {
            return "ptmm_entrymemberjoininpjt";
        }
        return "ptmm_entrymemberjoin";
    }

    public String getCustomEntityId() {
        return "ptmm_entrymemberjoin";
    }

    public String getImportOpPlugin() {
        return "kd.hr.ptmm.formplugin.web.bill.impt.ProjectMemberBatchImport";
    }
}

