/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.formplugin.web.bill.impt.validate;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.ptmm.business.domain.impt.bo.ImportDataValidateBO;
import kd.hr.ptmm.business.domain.status.dto.ValidateMsg;
import kd.hr.ptmm.common.constants.ProjectTeamBillConstants;
import kd.hr.ptmm.formplugin.web.bill.impt.ProjectTeamImportCommon;
import kd.hr.ptmm.formplugin.web.bill.impt.ValidateFailException;
import kd.hr.ptmm.formplugin.web.common.ProjectTeamFormCommon;
import org.apache.http.util.Asserts;

public abstract class AbsProjectMemberImportValidate
implements ProjectTeamBillConstants {
    protected static final Log LOG = LogFactory.getLog(AbsProjectMemberImportValidate.class);
    protected IFormView formView;
    protected ImportContext context;
    protected List<ImportBillData> importBillDataList;
    protected Map<String, ImportLogger> importLoggerMap;
    protected static final ValidateFailException VALIDATE_FAIL_EXCEPTION = new ValidateFailException();

    public void execute() {
        Asserts.notNull((Object)this.context, (String)"context");
        if (CollectionUtils.isEmpty(this.importBillDataList)) {
            return;
        }
        this.beforeValidate();
        this.doValidate();
        this.afterValidate();
    }

    abstract void beforeValidate();

    abstract void doValidate();

    void afterValidate() {
        this.formView.getPageCache().put("import_data_success", "1");
        this.formView.getPageCache().saveChanges();
        this.genTempView().sendFormAction(this.formView);
        this.context.feedbackProgress(99, this.importBillDataList.size(), 0);
    }

    protected String getEntityName(ImportBillData rowData) {
        return (String)((JSONObject)rowData.getData().get((Object)"data")).keySet().iterator().next();
    }

    protected int getRowNum(ImportBillData data) {
        if (Objects.isNull(data)) {
            return 0;
        }
        JSONObject jsonObject = data.getData();
        return jsonObject.getInteger("rownum");
    }

    protected JSONObject getRowData(ImportBillData importBillData) {
        if (Objects.isNull(importBillData)) {
            return new JSONObject();
        }
        JSONObject jsonObject = importBillData.getData();
        return jsonObject.getJSONObject("data");
    }

    protected JSONObject getRowInfo(ImportBillData importBillData, String sheetKey) {
        JSONObject rowData = this.getRowData(importBillData);
        return rowData.getJSONObject(sheetKey);
    }

    protected JSONObject getRowInfo(ImportBillData importBillData) {
        String entityName = this.getEntityName(importBillData);
        return this.getRowInfo(importBillData, entityName);
    }

    protected JSONObject getCellInfo(ImportBillData importBillData, String cellKey) {
        JSONObject rowInfo = this.getRowInfo(importBillData);
        return rowInfo.getJSONObject(cellKey);
    }

    protected String getCellInfoNumber(ImportBillData importBillData, String cellKey) {
        JSONObject cellInfo = this.getCellInfo(importBillData, cellKey);
        if (Objects.isNull(cellInfo)) {
            return "";
        }
        return cellInfo.getString("number");
    }

    protected JSONObject genProjectTeamJsonObj(DynamicObject projectTeamDO) {
        Asserts.notNull((Object)projectTeamDO, (String)"projectTeamDO");
        JSONObject projectTeamAdd = new JSONObject();
        projectTeamAdd.put("importprop", (Object)"number");
        projectTeamAdd.put("number", (Object)projectTeamDO.getString("number"));
        projectTeamAdd.put("name", (Object)projectTeamDO.getString("name"));
        return projectTeamAdd;
    }

    protected List<ImportDataValidateBO> genValidateBO(List<ImportBillData> importBillDataList) {
        String projectIdentify = ProjectTeamFormCommon.getInstance().getRootProjectIdentify(this.formView.getModel());
        return importBillDataList.stream().map(data -> {
            ImportDataValidateBO importDataValidateBO = new ImportDataValidateBO();
            importDataValidateBO.setImportBillData(data);
            importDataValidateBO.setDataModel(this.formView.getModel());
            importDataValidateBO.setProjectIdentify(projectIdentify);
            importDataValidateBO.setAdjustEntryEnum(ProjectTeamImportCommon.getEntryType(data));
            return importDataValidateBO;
        }).collect(Collectors.toList());
    }

    protected boolean checkHaveFail(List<ImportDataValidateBO> importDataValidateBOList) {
        return this.importLoggerMap.values().stream().anyMatch(importLogger -> importLogger.getFailed() > 0) || importDataValidateBOList.stream().anyMatch(bo -> !bo.isSuccess());
    }

    protected void recordValidateFailData(List<ImportDataValidateBO> importDataValidateBOList) {
        if (CollectionUtils.isEmpty(importDataValidateBOList)) {
            return;
        }
        List<ImportDataValidateBO> failBOList = importDataValidateBOList.stream().filter(bo -> !bo.isSuccess()).collect(Collectors.toList());
        failBOList.forEach(importDataValidateBO -> {
            ImportBillData importBillData = importDataValidateBO.getImportBillData();
            List validateMsgList = importDataValidateBO.getValidateMsgList();
            List validateInfoList = validateMsgList.stream().map(ValidateMsg::getMsgInfo).filter(Objects::nonNull).collect(Collectors.toList());
            String entityName = (String)((JSONObject)importBillData.getData().get((Object)"data")).keySet().iterator().next();
            ImportLogger logger = this.importLoggerMap.get(entityName);
            logger.fail();
            logger.log(importBillData.getData().getInteger("rownum"), Joiner.on((char)';').skipNulls().join(validateInfoList));
        });
    }

    private IFormView genTempView() {
        HashMap<String, String> mapParam = new HashMap<String, String>(1);
        mapParam.put("formId", this.context.getBillFormId());
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(mapParam);
        IFormView formView = parameter.createViewForWebApi();
        formView.initialize(parameter);
        return formView;
    }
}

