/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.formplugin.web.bill.impt.validate;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.multimport.HRMultiEntityFeedBackProgress;
import kd.hr.ptmm.business.domain.impt.bo.ImportDataValidateBO;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.formplugin.web.bill.impt.IProjectMemberEntryWrite;
import kd.hr.ptmm.formplugin.web.bill.impt.ProjectTeamImportCommon;
import kd.hr.ptmm.formplugin.web.bill.impt.validate.AbsProjectMemberImportValidate;
import kd.hr.ptmm.formplugin.web.common.ProjectTeamFormCommon;

public class ProjectMemberImportValidateAdd
extends AbsProjectMemberImportValidate {
    private static final Map<String, List<String>> ENTRY_PROJECTTEAM_MAP = Maps.newHashMap();
    private Map<String, DynamicObject> projectRole2WorkRoleMap;

    public ProjectMemberImportValidateAdd(IFormView formView, ImportContext context, List<ImportBillData> dataList, Map<String, ImportLogger> importLoggerMap) {
        this.formView = formView;
        this.context = context;
        this.importBillDataList = dataList;
        this.importLoggerMap = importLoggerMap;
        this.initProjectRole2WorkRoleMap(dataList);
    }

    @Override
    void beforeValidate() {
        this.checkDataNumber(this.importBillDataList);
        this.checkTemplate(this.importBillDataList);
        this.supplyProjectTeam(this.importBillDataList);
        this.checkDateValid(this.importBillDataList);
    }

    @Override
    void doValidate() {
        List<ImportDataValidateBO> importDataValidateBOs = this.genValidateBO(this.importBillDataList);
        LOG.info("ProjectMemberImportValidate.validateBO:{}", importDataValidateBOs);
        List validateResDtos = PTMMServiceFactory.importValidateService.projectMembersImportValidate(importDataValidateBOs, this.projectRole2WorkRoleMap);
        if (this.checkHaveFail(validateResDtos)) {
            this.recordValidateFailData(validateResDtos);
            HRMultiEntityFeedBackProgress.feedbackProgressDealWith((ImportContext)this.context, (Map)this.importLoggerMap);
            throw VALIDATE_FAIL_EXCEPTION;
        }
    }

    @Override
    void afterValidate() {
        Map option = this.context.getOption();
        Map customParams = (Map)option.get("customParams");
        LOG.info("supplementDataToEntry_begin");
        String entryWritePath = String.valueOf(customParams.get("entryWritePluginPath"));
        try {
            IProjectMemberEntryWrite importPlugin = (IProjectMemberEntryWrite)Class.forName(entryWritePath).newInstance();
            importPlugin.supplementDataToEntry((AbstractFormDataModel)this.formView.getModel(), this.importBillDataList, this.projectRole2WorkRoleMap);
        }
        catch (Exception e) {
            LOG.error("supplementDataToEntry_error", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", "padding data to entry error"), new Object[0]);
        }
        LOG.info("supplementDataToEntry_end");
        super.afterValidate();
    }

    private void checkTemplate(List<ImportBillData> importBillDataList) {
        if (!ProjectTeamFormCommon.getInstance().isPageFromProjectTeam(this.formView)) {
            for (ImportBillData data : importBillDataList) {
                String entityName = this.getEntityName(data);
                ImportLogger importLogger = (ImportLogger)this.importLoggerMap.get(entityName);
                int rowNum = this.getRowNum(data);
                JSONObject entryJson = this.getRowInfo(data, entityName);
                switch (entityName) {
                    case "ptmm_entrymemberjoin": 
                    case "ptmm_entrymemberjoininpjt": {
                        if (!Objects.isNull(entryJson.get((Object)"projectteamadd"))) break;
                        importLogger.fail();
                        importLogger.log(Integer.valueOf(rowNum), ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u9879\u672a\u586b\u5199\uff1a\u9879\u76ee\u56e2\u961f.\u9879\u76ee\u56e2\u961f\u7f16\u7801", (String)"ProjectMemberImportValidateAdd_1", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    case "ptmm_entryrolejoin": {
                        if (!Objects.isNull(entryJson.get((Object)"projectteamadja"))) break;
                        importLogger.fail();
                        importLogger.log(Integer.valueOf(rowNum), ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u9879\u672a\u586b\u5199\uff1a\u9879\u76ee\u56e2\u961f.\u9879\u76ee\u56e2\u961f\u7f16\u7801", (String)"ProjectMemberImportValidateAdd_1", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    case "ptmm_entryroleadjust": {
                        if (Objects.isNull(entryJson.get((Object)"projectteamadj"))) {
                            importLogger.fail();
                            importLogger.log(Integer.valueOf(rowNum), ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u9879\u672a\u586b\u5199\uff1a\u8c03\u6574\u524d\u9879\u76ee\u56e2\u961f.\u9879\u76ee\u56e2\u961f\u7f16\u7801", (String)"ProjectMemberImportValidateAdd_2", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
                        }
                        if (!Objects.isNull(entryJson.get((Object)"projectteamadjnew"))) break;
                        importLogger.fail();
                        importLogger.log(Integer.valueOf(rowNum), ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u9879\u672a\u586b\u5199\uff1a\u8c03\u6574\u540e\u9879\u76ee\u56e2\u961f.\u9879\u76ee\u56e2\u961f\u7f16\u7801", (String)"ProjectMemberImportValidateAdd_3", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    case "ptmm_entryrolequit": {
                        if (!Objects.isNull(entryJson.get((Object)"projectteamadjq"))) break;
                        importLogger.fail();
                        importLogger.log(Integer.valueOf(rowNum), ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u9879\u672a\u586b\u5199\uff1a\u9879\u76ee\u56e2\u961f.\u9879\u76ee\u56e2\u961f\u7f16\u7801", (String)"ProjectMemberImportValidateAdd_1", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    case "ptmm_entrymemberquit": {
                        if (!Objects.isNull(entryJson.get((Object)"projectteamq"))) break;
                        importLogger.fail();
                        importLogger.log(Integer.valueOf(rowNum), ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u9879\u672a\u586b\u5199\uff1a\u9879\u76ee\u56e2\u961f.\u9879\u76ee\u56e2\u961f\u7f16\u7801", (String)"ProjectMemberImportValidateAdd_1", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
                        break;
                    }
                }
                this.context.feedbackProgress(ProjectTeamImportCommon.generateRandom(100), importLogger, null);
            }
        }
    }

    private void checkDataNumber(List<ImportBillData> importBillDataList) {
        AtomicBoolean hasFail = new AtomicBoolean(false);
        this.importLoggerMap.forEach((entityName, importLogger) -> importBillDataList.stream().filter(data -> HRStringUtils.equals((String)this.getEntityName((ImportBillData)data), (String)entityName)).skip(1000L).collect(Collectors.toList()).forEach(importBillData -> {
            importLogger.fail();
            importLogger.log(Integer.valueOf(this.getRowNum((ImportBillData)importBillData)), ResManager.loadKDString((String)"\u6bcf\u9875\u6700\u591a\u7ef4\u62a41000\u6761", (String)"ProjectMemberImportValidateAdd_0", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
            hasFail.set(true);
        }));
        if (hasFail.get()) {
            HRMultiEntityFeedBackProgress.feedbackProgressDealWith((ImportContext)this.context, (Map)this.importLoggerMap);
            throw VALIDATE_FAIL_EXCEPTION;
        }
    }

    private void supplyProjectTeam(List<ImportBillData> importBillDataList) {
        if (!ProjectTeamFormCommon.getInstance().isPageFromProjectTeam(this.formView)) {
            return;
        }
        DynamicObject dataEntity = this.formView.getModel().getDataEntity(true);
        DynamicObject projectTeamDO = dataEntity.getDynamicObject("projectteam");
        importBillDataList.forEach(data -> {
            String entityName = this.getEntityName((ImportBillData)data);
            JSONObject entryJson = this.getRowInfo((ImportBillData)data, entityName);
            JSONObject projectTeamJsonObj = this.genProjectTeamJsonObj(projectTeamDO);
            ENTRY_PROJECTTEAM_MAP.get(entityName).forEach(projectTeamField -> entryJson.put(projectTeamField, (Object)projectTeamJsonObj));
        });
    }

    private void checkDateValid(List<ImportBillData> importBillDataList) {
        for (ImportBillData data : importBillDataList) {
            String entityName = this.getEntityName(data);
            ImportLogger importLogger = (ImportLogger)this.importLoggerMap.get(entityName);
            int rowNum = this.getRowNum(data);
            JSONObject entryJson = this.getRowInfo(data, entityName);
            switch (entityName) {
                case "ptmm_entrymemberjoin": 
                case "ptmm_entrymemberjoininpjt": {
                    String joinStartDate = entryJson.getString("joinstartdate");
                    if (!HRStringUtils.isNotEmpty((String)joinStartDate) || !this.dateNotValid(joinStartDate)) break;
                    importLogger.fail();
                    importLogger.log(Integer.valueOf(rowNum), ResManager.loadKDString((String)"\u8bf7\u6309\u7167\u65e5\u671f\u683c\u5f0f\u586b\u5199\uff0c\u4f8b\uff1a2023-01-01", (String)"ProjectMemberImportValidateAdd_4", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "ptmm_entryrolejoin": {
                    String effectDataAdjustJoin = entryJson.getString("effectdateadja");
                    if (!HRStringUtils.isNotEmpty((String)effectDataAdjustJoin) || !this.dateNotValid(effectDataAdjustJoin)) break;
                    importLogger.fail();
                    importLogger.log(Integer.valueOf(rowNum), ResManager.loadKDString((String)"\u8bf7\u6309\u7167\u65e5\u671f\u683c\u5f0f\u586b\u5199\uff0c\u4f8b\uff1a2023-01-01", (String)"ProjectMemberImportValidateAdd_4", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "ptmm_entryroleadjust": {
                    String effectDataAdjust = entryJson.getString("effectdateadj");
                    if (!HRStringUtils.isNotEmpty((String)effectDataAdjust) || !this.dateNotValid(effectDataAdjust)) break;
                    importLogger.fail();
                    importLogger.log(Integer.valueOf(rowNum), ResManager.loadKDString((String)"\u8bf7\u6309\u7167\u65e5\u671f\u683c\u5f0f\u586b\u5199\uff0c\u4f8b\uff1a2023-01-01", (String)"ProjectMemberImportValidateAdd_4", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "ptmm_entryrolequit": {
                    String effectDataAdjustQuit = entryJson.getString("effectdateadjq");
                    if (!HRStringUtils.isNotEmpty((String)effectDataAdjustQuit) || !this.dateNotValid(effectDataAdjustQuit)) break;
                    importLogger.fail();
                    importLogger.log(Integer.valueOf(rowNum), ResManager.loadKDString((String)"\u8bf7\u6309\u7167\u65e5\u671f\u683c\u5f0f\u586b\u5199\uff0c\u4f8b\uff1a2023-01-01", (String)"ProjectMemberImportValidateAdd_4", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "ptmm_entrymemberquit": {
                    String quitDate = entryJson.getString("quitdate");
                    if (!HRStringUtils.isNotEmpty((String)quitDate) || !this.dateNotValid(quitDate)) break;
                    importLogger.fail();
                    importLogger.log(Integer.valueOf(rowNum), ResManager.loadKDString((String)"\u8bf7\u6309\u7167\u65e5\u671f\u683c\u5f0f\u586b\u5199\uff0c\u4f8b\uff1a2023-01-01", (String)"ProjectMemberImportValidateAdd_4", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
                    break;
                }
            }
        }
    }

    private boolean dateNotValid(String dateStr) {
        try {
            LocalDate.parse(dateStr);
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    private void initProjectRole2WorkRoleMap(List<ImportBillData> importBillDataList) {
        ArrayList projectRoleNumberList = new ArrayList(importBillDataList.size());
        importBillDataList.stream().collect(Collectors.groupingBy(ProjectTeamImportCommon::getEntryType)).forEach((entryType, importBillDataListTemp) -> {
            switch (entryType) {
                case MEMBER_JOIN: {
                    importBillDataListTemp.forEach(data -> {
                        projectRoleNumberList.add(this.getCellInfoNumber((ImportBillData)data, "projectrole"));
                        String otherRole = this.getCellInfoNumber((ImportBillData)data, "projectroleother");
                        if (HRStringUtils.isNotEmpty((String)otherRole)) {
                            projectRoleNumberList.addAll(Arrays.asList(otherRole.split(",")));
                        }
                    });
                    break;
                }
                case ROLE_JOIN: {
                    importBillDataListTemp.forEach(data -> projectRoleNumberList.add(this.getCellInfoNumber((ImportBillData)data, "projectroleadja")));
                    break;
                }
                case ROLE_ADJUST: {
                    importBillDataListTemp.forEach(data -> projectRoleNumberList.add(this.getCellInfoNumber((ImportBillData)data, "projectroleadj")));
                    importBillDataListTemp.forEach(data -> projectRoleNumberList.add(this.getCellInfoNumber((ImportBillData)data, "projectroleadjnew")));
                    break;
                }
                case ROLE_QUIT: {
                    importBillDataListTemp.forEach(data -> projectRoleNumberList.add(this.getCellInfoNumber((ImportBillData)data, "projectroleadjq")));
                }
            }
        });
        this.projectRole2WorkRoleMap = PTMMServiceFactory.workRoleHrService.getWorkRoleByProjectRoleNum(projectRoleNumberList);
    }

    static {
        ENTRY_PROJECTTEAM_MAP.put("ptmm_entrymemberjoin", Collections.singletonList("projectteamadd"));
        ENTRY_PROJECTTEAM_MAP.put("ptmm_entrymemberjoininpjt", Collections.singletonList("projectteamadd"));
        ENTRY_PROJECTTEAM_MAP.put("ptmm_entryrolejoin", Collections.singletonList("projectteamadja"));
        ENTRY_PROJECTTEAM_MAP.put("ptmm_entryroleadjust", Lists.newArrayList((Object[])new String[]{"projectteamadj", "projectteamadjnew"}));
        ENTRY_PROJECTTEAM_MAP.put("ptmm_entryrolequit", Collections.singletonList("projectteamadjq"));
        ENTRY_PROJECTTEAM_MAP.put("ptmm_entrymemberquit", Collections.singletonList("projectteamq"));
    }
}

