/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.formplugin.web.bill.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.ptmm.business.domain.repository.ProjectMemberRepository;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.common.constants.ProjectTeamBillConstants;
import kd.hr.ptmm.common.util.PropUtils;
import org.apache.http.util.Asserts;

public class VerifyProjectChangedService
implements ProjectTeamBillConstants {
    private IFormView formView;
    private DynamicObject dynamicObject;
    private Map<Long, String> projectTeam2ProjectIdentify;
    Function<String, Integer[]> joinMemberFun = projectIdentify -> {
        DynamicObject dataEntity = this.formView.getModel().getDataEntity(true);
        DynamicObjectCollection joinMemberEntry = dataEntity.getDynamicObjectCollection("memberjoinentry");
        ArrayList<Integer> rowIndex = new ArrayList<Integer>(joinMemberEntry.size());
        for (int i = 0; i < joinMemberEntry.size(); ++i) {
            DynamicObject joinMemberDO = (DynamicObject)joinMemberEntry.get(i);
            DynamicObject projectTeamDO = joinMemberDO.getDynamicObject("projectteamadd");
            String identify = this.getProjectIdentifyFormTeam(projectTeamDO);
            if (HRStringUtils.equals((String)projectIdentify, (String)identify)) continue;
            rowIndex.add(i);
        }
        return rowIndex.toArray(new Integer[0]);
    };
    Function<String, Integer[]> roleJoinFun = projectIdentify -> {
        DynamicObjectCollection roleJoinEntry = this.dynamicObject.getDynamicObjectCollection("memberadjjentry");
        List<Long> projectMemberIdList = roleJoinEntry.stream().map(roleJoinDO -> {
            DynamicObject teamMemberDO = roleJoinDO.getDynamicObject("personbaseadja");
            return teamMemberDO.getLong(PropUtils.getIdDot((String)"projectmember"));
        }).collect(Collectors.toList());
        DynamicObject[] projectMemberDOArr = this.queryProjectMember(projectMemberIdList);
        ArrayList rowIndex = new ArrayList(roleJoinEntry.size());
        for (int i = 0; i < roleJoinEntry.size(); ++i) {
            DynamicObject joinRoleDO = (DynamicObject)roleJoinEntry.get(i);
            DynamicObject teamMemberDO = joinRoleDO.getDynamicObject("personbaseadja");
            long projectMemberId = teamMemberDO.getLong(PropUtils.getIdDot((String)"projectmember"));
            Integer finalI = i;
            Arrays.stream(projectMemberDOArr).filter(projectMemberDO -> projectMemberDO.getLong("id") == projectMemberId).findFirst().ifPresent(projectMemberDO -> {
                String identify = projectMemberDO.getString("projectidentify");
                if (!HRStringUtils.equals((String)identify, (String)projectIdentify)) {
                    rowIndex.add(finalI);
                }
            });
        }
        return rowIndex.toArray(new Integer[0]);
    };
    Function<String, Integer[]> roleAdjustFun = projectIdentify -> {
        DynamicObjectCollection roleJoinEntry = this.dynamicObject.getDynamicObjectCollection("memberadjaentry");
        List<Long> projectMemberIdList = roleJoinEntry.stream().map(roleJoinDO -> {
            DynamicObject teamMemberDO = roleJoinDO.getDynamicObject("personbaseadj");
            return teamMemberDO.getLong(PropUtils.getIdDot((String)"projectmember"));
        }).collect(Collectors.toList());
        DynamicObject[] projectMemberDOArr = this.queryProjectMember(projectMemberIdList);
        ArrayList<Integer> rowIndex = new ArrayList<Integer>(roleJoinEntry.size());
        for (int i = 0; i < roleJoinEntry.size(); ++i) {
            DynamicObject roleJoinDO2 = (DynamicObject)roleJoinEntry.get(i);
            DynamicObject teamMemberRoleDO = roleJoinDO2.getDynamicObject("personbaseadj");
            long projectMemberId = teamMemberRoleDO.getLong(PropUtils.getIdDot((String)"projectmember"));
            Integer finalI = i;
            Arrays.stream(projectMemberDOArr).filter(projectMemberDO -> projectMemberDO.getLong("id") == projectMemberId).findFirst().ifPresent(projectMemberDO -> {
                String identify = projectMemberDO.getString("projectidentify");
                if (!HRStringUtils.equals((String)identify, (String)projectIdentify)) {
                    rowIndex.add(finalI);
                }
            });
            DynamicObject projectTeamNewDO = roleJoinDO2.getDynamicObject("projectteamadjnew");
            String projectIdentifyFormTeam = this.getProjectIdentifyFormTeam(projectTeamNewDO);
            if (HRStringUtils.equals((String)projectIdentifyFormTeam, (String)projectIdentify) || rowIndex.contains(finalI)) continue;
            rowIndex.add(finalI);
        }
        return rowIndex.toArray(new Integer[0]);
    };
    Function<String, Integer[]> roleQuitFun = projectIdentify -> {
        DynamicObject dataEntity = this.formView.getModel().getDataEntity(true);
        DynamicObjectCollection roleQuitEntry = dataEntity.getDynamicObjectCollection("memberadjqentry");
        List<Long> projectMemberIdList = roleQuitEntry.stream().map(roleJoinDO -> {
            DynamicObject teamMemberDO = roleJoinDO.getDynamicObject("personbaseadjq");
            return teamMemberDO.getLong(PropUtils.getIdDot((String)"projectmember"));
        }).collect(Collectors.toList());
        DynamicObject[] projectMemberDOArr = this.queryProjectMember(projectMemberIdList);
        ArrayList rowIndex = new ArrayList(roleQuitEntry.size());
        for (int i = 0; i < roleQuitEntry.size(); ++i) {
            DynamicObject roleQuitDO = (DynamicObject)roleQuitEntry.get(i);
            DynamicObject teamMemberRoleDO = roleQuitDO.getDynamicObject("personbaseadjq");
            long projectMemberId = teamMemberRoleDO.getLong(PropUtils.getIdDot((String)"projectmember"));
            Integer finalI = i;
            Arrays.stream(projectMemberDOArr).filter(projectMemberDO -> projectMemberDO.getLong("id") == projectMemberId).findFirst().ifPresent(projectMemberDO -> {
                String identify = projectMemberDO.getString("projectidentify");
                if (!HRStringUtils.equals((String)identify, (String)projectIdentify)) {
                    rowIndex.add(finalI);
                }
            });
        }
        return rowIndex.toArray(new Integer[0]);
    };
    Function<String, Integer[]> memberQuitFun = projectIdentify -> {
        DynamicObject dataEntity = this.formView.getModel().getDataEntity(true);
        DynamicObjectCollection joinQuitEntry = dataEntity.getDynamicObjectCollection("memberquitentry");
        List<Long> projectMemberIdList = joinQuitEntry.stream().map(memberQuitDO -> {
            DynamicObject teamMemberDO = memberQuitDO.getDynamicObject("personbaseq");
            return teamMemberDO.getLong(PropUtils.getIdDot((String)"projectmember"));
        }).collect(Collectors.toList());
        DynamicObject[] projectMemberDOArr = this.queryProjectMember(projectMemberIdList);
        ArrayList rowIndex = new ArrayList(joinQuitEntry.size());
        for (int i = 0; i < joinQuitEntry.size(); ++i) {
            DynamicObject memberQuitDO2 = (DynamicObject)joinQuitEntry.get(i);
            DynamicObject teamMemberDO = memberQuitDO2.getDynamicObject("personbaseq");
            long projectMemberId = teamMemberDO.getLong(PropUtils.getIdDot((String)"projectmember"));
            Integer finalI = i;
            Arrays.stream(projectMemberDOArr).filter(projectMemberDO -> projectMemberDO.getLong("id") == projectMemberId).findFirst().ifPresent(projectMemberDO -> {
                String identify = projectMemberDO.getString("projectidentify");
                if (!HRStringUtils.equals((String)identify, (String)projectIdentify)) {
                    rowIndex.add(finalI);
                }
            });
        }
        return rowIndex.toArray(new Integer[0]);
    };

    public VerifyProjectChangedService(IFormView formView) {
        this.formView = formView;
        this.dynamicObject = formView.getModel().getDataEntity(true);
        this.projectTeam2ProjectIdentify = this.initTeam2Identify(this.dynamicObject);
    }

    private Map<Long, String> initTeam2Identify(DynamicObject dynamicObject) {
        HashSet<Long> projectTeamIdSet = new HashSet<Long>();
        projectTeamIdSet.add(dynamicObject.getLong(PropUtils.getIdDot((String)"projectteam")));
        dynamicObject.getDynamicObjectCollection("memberjoinentry").forEach(dy -> projectTeamIdSet.add(dy.getLong(PropUtils.getIdDot((String)"projectteamadd"))));
        dynamicObject.getDynamicObjectCollection("memberadjaentry").forEach(dy -> projectTeamIdSet.add(dy.getLong(PropUtils.getIdDot((String)"projectteamadjnew"))));
        return PTMMServiceFactory.projectTeamService.listProjectTeamProjectIdentify(projectTeamIdSet);
    }

    public Map<String, Integer[]> verifyProjectIsChanged() {
        DynamicObject projectTeamDO = this.dynamicObject.getDynamicObject("projectteam");
        if (Objects.isNull(projectTeamDO)) {
            return Collections.emptyMap();
        }
        String projectIdentify = this.getProjectIdentifyFormTeam(projectTeamDO);
        HashMap<String, Integer[]> map = new HashMap<String, Integer[]>(5);
        map.put("memberjoinentry", this.joinMemberFun.apply(projectIdentify));
        map.put("memberadjjentry", this.roleJoinFun.apply(projectIdentify));
        map.put("memberadjaentry", this.roleAdjustFun.apply(projectIdentify));
        map.put("memberadjqentry", this.roleQuitFun.apply(projectIdentify));
        map.put("memberquitentry", this.memberQuitFun.apply(projectIdentify));
        return map;
    }

    private DynamicObject[] queryProjectMember(List<Long> projectMemberIdList) {
        QFilter qFilter = new QFilter("id", "in", projectMemberIdList);
        return ProjectMemberRepository.getInstance().query("projectidentify", qFilter.toArray());
    }

    private String getProjectIdentifyFormTeam(DynamicObject projectTeamDO) {
        Asserts.notNull((Object)projectTeamDO, (String)"projectTeamDO");
        Asserts.check((!CollectionUtils.isEmpty(this.projectTeam2ProjectIdentify) ? 1 : 0) != 0, (String)"projectTeam2ProjectIdentify");
        String identify = this.projectTeam2ProjectIdentify.get(projectTeamDO.getLong("id"));
        Asserts.check((boolean)HRStringUtils.isNotEmpty((String)identify), (String)"identify");
        return identify;
    }
}

