/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.formplugin.web.common;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.EntryGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.service.cert.HRCertValidateServiceHelper;
import kd.hr.ptmm.business.domain.repository.TeamMemberRepository;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.business.domain.status.dto.ValidateMsg;
import kd.hr.ptmm.business.domain.status.dto.ValidateResDto;
import kd.hr.ptmm.common.bean.QuitMemberInfo;
import kd.hr.ptmm.common.constants.ProjectTeamBillConstants;
import kd.hr.ptmm.common.constants.member.TeamMemberConstants;
import kd.hr.ptmm.common.enums.AdjustTypeEnum;
import kd.hr.ptmm.common.enums.PersonServiceStatusEnum;
import kd.hr.ptmm.common.util.PtmmJSONUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ProjectTeamFormCommon
implements TeamMemberConstants,
ProjectTeamBillConstants {
    public static final Map<String, String> TAB_ENTRY_MAP = ImmutableMap.of((Object)"memberjoinentry", (Object)"memberjoin_tab", (Object)"memberadjjentry", (Object)"rolejoin_tab", (Object)"memberadjaentry", (Object)"roleadjust_tab", (Object)"memberadjqentry", (Object)"rolequit_tab", (Object)"memberquitentry", (Object)"memberquit_tab");
    private static final Log log = LogFactory.getLog(ProjectTeamFormCommon.class);

    public void visibleTab(IFormView view) {
        AtomicBoolean showNoEntryDataFlex = new AtomicBoolean(true);
        TAB_ENTRY_MAP.forEach((entry, tab) -> {
            boolean flag;
            EntryGrid entryGrid = (EntryGrid)view.getControl(entry);
            boolean bl = flag = entryGrid.getEntryData().getDataEntitys().length != 0;
            if (flag) {
                showNoEntryDataFlex.set(false);
            }
            view.setVisible(Boolean.valueOf(flag), new String[]{tab});
        });
        view.setVisible(Boolean.valueOf(showNoEntryDataFlex.get()), new String[]{"noentrydata_flex"});
        view.setVisible(Boolean.valueOf(!showNoEntryDataFlex.get()), new String[]{"tabap"});
    }

    private ProjectTeamFormCommon() {
    }

    public static ProjectTeamFormCommon getInstance() {
        return DispatchFormCommonMethodHolder.INSTANCE;
    }

    public static void setBizChanged(DynamicObject dataEntity, String ... propKeys) {
        ProjectTeamFormCommon.setBizChanged(dataEntity, false, propKeys);
    }

    public static void setBizChanged(DynamicObject dataEntity, boolean isChanged, String ... propKeys) {
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        for (String propKey : propKeys) {
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)propKey);
            if (property == null) continue;
            dataEntityState.setBizChanged(property.getOrdinal(), isChanged);
            if (!(property instanceof BasedataProp)) continue;
            property = (IDataEntityProperty)properties.get((Object)(propKey + "_id"));
            Optional.ofNullable(property).ifPresent(p -> dataEntityState.setBizChanged(p.getOrdinal(), isChanged));
        }
        List collectionProperties = properties.getCollectionProperties(false);
        for (ICollectionProperty collectionProperty : collectionProperties) {
            if (!(collectionProperty instanceof EntryProp)) continue;
            String entryKey = collectionProperty.getName();
            DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection(entryKey);
            ProjectTeamFormCommon.entryPropertyBizChange(isChanged, entryColl, propKeys);
        }
    }

    private static void entryPropertyBizChange(boolean isChanged, DynamicObjectCollection entryColl, String[] propKeys) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)entryColl)) {
            for (DynamicObject entryDynamicObject : entryColl) {
                DataEntityState entryEntityState = entryDynamicObject.getDataEntityState();
                for (String propKey : propKeys) {
                    IDataEntityProperty propId;
                    DataEntityPropertyCollection entityProperties = entryColl.getDynamicObjectType().getProperties();
                    IDataEntityProperty prop = (IDataEntityProperty)entityProperties.get((Object)propKey);
                    if (prop != null) {
                        entryEntityState.setBizChanged(prop.getOrdinal(), isChanged);
                    }
                    if (!(prop instanceof BasedataProp) || (propId = (IDataEntityProperty)entityProperties.get((Object)(propKey + "_id"))) == null) continue;
                    entryEntityState.setBizChanged(propId.getOrdinal(), isChanged);
                }
            }
        }
    }

    public Pair<List<Map<String, Object>>, List<Map<String, Object>>> convertValidateRes(List<ValidateResDto> validateResDtos) {
        ArrayList<Map<String, Object>> errorDataList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> warnDataList = new ArrayList<Map<String, Object>>();
        for (ValidateResDto validateResDto : validateResDtos) {
            StringBuilder errorDataMsgSb = new StringBuilder();
            StringBuilder warnDataMsgSb = new StringBuilder();
            for (ValidateMsg msg : validateResDto.getMsgs()) {
                if ("error".equals(msg.getMsgType())) {
                    errorDataMsgSb.append(msg.getMsgInfo());
                    continue;
                }
                warnDataMsgSb.append(msg.getMsgInfo());
            }
            if (errorDataMsgSb.length() > 0) {
                Map<String, Object> errorData = this.getOneLineData(validateResDto, errorDataMsgSb.toString(), ResManager.loadKDString((String)"\u5426", (String)"ProjectTeamFormCommon_1", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
                errorDataList.add(errorData);
            }
            if (warnDataMsgSb.length() <= 0) continue;
            Map<String, Object> warnData = this.getOneLineData(validateResDto, warnDataMsgSb.toString(), ResManager.loadKDString((String)"\u662f", (String)"ProjectTeamFormCommon_0", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
            warnDataList.add(warnData);
        }
        return Pair.of(errorDataList, warnDataList);
    }

    private Map<String, Object> getOneLineData(ValidateResDto validateResDto, String msg, String isSubmit) {
        String adjustType = validateResDto.getAdjustType();
        String personNum = validateResDto.getPersonNum();
        String personName = validateResDto.getPersonName();
        String teamName = validateResDto.getTeamName();
        String roleName = validateResDto.getRoleName();
        HashMap errorData = Maps.newHashMapWithExpectedSize((int)16);
        errorData.put("adjusttypename", AdjustTypeEnum.getEnumByCode((String)adjustType).getName());
        errorData.put("adjusttype", adjustType);
        errorData.put("number", personNum);
        errorData.put("name", personName);
        errorData.put("projectteam", teamName);
        errorData.put("projectrole", roleName);
        errorData.put("issubmit", isSubmit);
        errorData.put("msg", msg);
        return errorData;
    }

    public Pair<List<Map<String, Object>>, List<Map<String, Object>>> getValidateResult(String validateRes) {
        TypeReference<List<ValidateResDto>> typeReference = new TypeReference<List<ValidateResDto>>(){};
        List validateResDtos = (List)PtmmJSONUtils.deserialize((String)validateRes, (TypeReference)typeReference);
        return ProjectTeamFormCommon.getInstance().convertValidateRes(validateResDtos);
    }

    public String getProjectName(IDataModel model) {
        DynamicObject dataEntity = model.getDataEntity();
        ILocaleString projectName = dataEntity.getLocaleString("projectname");
        if (Objects.isNull(projectName)) {
            return "";
        }
        return projectName.getLocaleValue();
    }

    public String getProjectNameStr(IDataModel model) {
        DynamicObject dataEntity = model.getDataEntity();
        return dataEntity.getString("projectname");
    }

    public long getRootProjectTeamId(IDataModel model) {
        DynamicObject dataEntity = model.getDataEntity();
        DynamicObject projectTeam = dataEntity.getDynamicObject("projectteam");
        if (HRObjectUtils.isEmpty((Object)projectTeam)) {
            return 0L;
        }
        return projectTeam.getLong("rootprojectteam.id");
    }

    public String getRootProjectIdentify(IDataModel model) {
        DynamicObject dataEntity = model.getDataEntity();
        DynamicObject projectTeam = dataEntity.getDynamicObject("projectteam");
        if (HRObjectUtils.isEmpty((Object)projectTeam)) {
            return "";
        }
        long teamId = projectTeam.getLong("rootprojectteam.id");
        Map projectIdentify = PTMMServiceFactory.projectTeamService.listProjectTeamProjectIdentify(Collections.singleton(teamId));
        return (String)projectIdentify.get(teamId);
    }

    public String getCertValidateMsg(Long personId) {
        String busMsg = ResManager.loadKDString((String)"\u52a0\u5165\u56e2\u961f", (String)"ProjectTeamFormCommon_2", (String)"hr-ptmm-formplugin", (Object[])new Object[0]);
        return HRCertValidateServiceHelper.getValidataMsg((Long)personId, (String)busMsg);
    }

    public boolean isPageFromProjectTeam(IFormView formView) {
        FormShowParameter showParameter = formView.getFormShowParameter();
        return Objects.nonNull(showParameter.getCustomParam("projectTeamId"));
    }

    public boolean isPageFromTeamMember(IFormView formView) {
        FormShowParameter showParameter = formView.getFormShowParameter();
        Object quitMember = showParameter.getCustomParam("quitMember");
        return Objects.nonNull(quitMember);
    }

    public Optional<QuitMemberInfo> getQuitMemberInfo(IFormView formView) {
        FormShowParameter showParameter = formView.getFormShowParameter();
        Object quitMember = showParameter.getCustomParam("quitMember");
        if (Objects.isNull(quitMember)) {
            return Optional.empty();
        }
        List quitMemberInfoList = JSONObject.parseArray((String)quitMember.toString(), QuitMemberInfo.class);
        if (CollectionUtils.isEmpty((Collection)quitMemberInfoList)) {
            return Optional.empty();
        }
        if (quitMemberInfoList.size() > 1) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6210\u5458\u6765\u81ea\u591a\u4e2a\u9879\u76ee\u56e2\u961f\uff0c\u65e0\u6cd5\u5e26\u5165\u6210\u5458\u4fe1\u606f\u3002", (String)"ProjectMemberCommonPlugin_6", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
            return Optional.empty();
        }
        QuitMemberInfo quitMemberInfo = (QuitMemberInfo)quitMemberInfoList.get(0);
        QFilter qFilter = new QFilter("id", "in", (Object)quitMemberInfo.getTeamMemberIdList());
        quitMemberInfo.setTeamMemberIdList(Arrays.stream(TeamMemberRepository.getInstance().query("servicestate", qFilter.toArray())).filter(teamMemberDO -> HRStringUtils.equals((String)teamMemberDO.getString("servicestate"), (String)PersonServiceStatusEnum.SERVING.getCode())).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList()));
        return Optional.of(quitMemberInfo);
    }

    public void updateTabCount(IFormView view) {
        TAB_ENTRY_MAP.forEach((entryKey, tabKey) -> {
            EntryGrid adjQuitGrid = (EntryGrid)view.getControl(entryKey);
            this.updateTabDataCount(view, (String)tabKey, adjQuitGrid.getEntryData().getDataEntitys().length);
        });
    }

    public void updateTabDataCount(IFormView view, String entryKey) {
        String curTabKey = TAB_ENTRY_MAP.get(entryKey);
        EntryGrid entryGrid = (EntryGrid)view.getControl(entryKey);
        int size = (Integer)entryGrid.getEntryData().getData().get("rowcount");
        this.updateTabDataCount(view, curTabKey, size);
    }

    private void updateTabDataCount(IFormView view, String curTabKey, int size) {
        TabPage curTab = (TabPage)view.getControl(curTabKey);
        curTab.setText(ResManager.getLocaleString((String)String.format(this.getTabDesc(curTabKey), size), (String)"", (String)"hr-ptmm-formplugin"));
    }

    private String getTabDesc(String tabKey) {
        String tabDesc;
        switch (tabKey) {
            case "memberjoin_tab": {
                tabDesc = ResManager.loadKDString((String)"\u6210\u5458\u65b0\u589e\uff08%s\uff09", (String)"ProjectMemberAdjustPlugin_8", (String)"hr-ptmm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "rolejoin_tab": {
                tabDesc = ResManager.loadKDString((String)"\u9879\u76ee\u4efb\u804c\u65b0\u589e\uff08%s\uff09", (String)"ProjectMemberAdjustPlugin_0", (String)"hr-ptmm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "roleadjust_tab": {
                tabDesc = ResManager.loadKDString((String)"\u89d2\u8272\u8c03\u6574\uff08%s\uff09", (String)"ProjectMemberAdjustPlugin_1", (String)"hr-ptmm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "rolequit_tab": {
                tabDesc = ResManager.loadKDString((String)"\u89d2\u8272\u4efb\u804c\u7ed3\u675f\uff08%s\uff09", (String)"ProjectMemberAdjustPlugin_2", (String)"hr-ptmm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "memberquit_tab": {
                tabDesc = ResManager.loadKDString((String)"\u6210\u5458\u9000\u51fa\uff08%s\uff09", (String)"ProjectMemberAdjustPlugin_9", (String)"hr-ptmm-formplugin", (Object[])new Object[0]);
                break;
            }
            default: {
                tabDesc = "";
            }
        }
        return tabDesc;
    }

    public static void setEntryFilesNull(IDataModel model, int rowIndex, String ... fields) {
        for (String field : fields) {
            model.setValue(field, null, rowIndex);
        }
    }

    private static class DispatchFormCommonMethodHolder {
        private static final ProjectTeamFormCommon INSTANCE = new ProjectTeamFormCommon();

        private DispatchFormCommonMethodHolder() {
        }
    }
}

