/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.formplugin.web.common;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.ptmm.business.domain.validator.DyObjValidateContext;
import kd.hr.ptmm.business.util.PtmmExcelUtils;
import kd.hr.ptmm.common.enums.AdjustStatusEnum;

public class PtmmShowPageUtil {
    public static void showPageInContainer(IFormView view, String formId, String targetKey, Map<String, Object> customs) {
        FormShowParameter showParameter = new FormShowParameter();
        PtmmShowPageUtil.showPageInContainer(view, showParameter, formId, targetKey, customs);
    }

    public static void showPageInContainer(IFormView view, FormShowParameter showParameter, String formId, String targetKey, Map<String, Object> customs) {
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        if (!HRObjectUtils.isEmpty(customs)) {
            showParameter.setCustomParams(customs);
        }
        view.showForm(showParameter);
    }

    public static void showMulConfirmPage(List<DyObjValidateContext> dyObjValidateContexts, List<DyObjValidateContext> errors, Object[] ids, String confirmPageId, String billTypeName, String keyWord, IFormView view) {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("sumlabel", dyObjValidateContexts.size());
        params.put("incongruentlabel", errors.size());
        params.put("coincidentlabel", dyObjValidateContexts.size() - errors.size());
        params.put("filename", String.format(ResManager.loadKDString((String)"%1$s%2$s\u786e\u8ba4\u6570\u636e_%3$s", (String)"PtmmShowPageUtil_0", (String)"hr-ptmm-formplugin", (Object[])new Object[0]), billTypeName, keyWord, LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE)));
        params.put("headDataList", PtmmExcelUtils.initMemAdjustConfirmExcelHead((String)keyWord));
        params.put("exportDataList", PtmmExcelUtils.initMemAdjustConfirmExportData(dyObjValidateContexts));
        params.put("ids", ids);
        String secondConfirmExportName = String.format(ResManager.loadKDString((String)"\u6279\u91cf%1$s%2$s\u5904\u7406\u7ed3\u679c_%3$s", (String)"PtmmShowPageUtil_1", (String)"hr-ptmm-formplugin", (Object[])new Object[0]), keyWord, billTypeName, LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        params.put("secondconfirm_exporttitle", secondConfirmExportName);
        PtmmShowPageUtil.showFormViewOfModal(view, confirmPageId, params);
    }

    public static void showFormViewOfModal(IFormView view, String formId, Map<String, Object> params) {
        FormShowParameter showParameter = new FormShowParameter();
        Object caption = params.get("caption");
        if (!Objects.isNull(caption)) {
            showParameter.setCaption((String)caption);
        }
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParams(params);
        view.showForm(showParameter);
    }

    public static void showAdjustBillSecondConfirmForDelete(AbstractBillPlugIn plugin, Map<String, List<DynamicObject>> operationResult, int successNum, int failNum, String secondConfirmExportName, String billFormId, Map<String, String> failId2ErrorMsg) {
        List<HRExportHeadObject> headDataList = PtmmShowPageUtil.getAdjustBillHeadDataList(billFormId);
        List<Map<String, Object>> exportDataList = PtmmShowPageUtil.getAdjustBillTemplateExportDataList(operationResult, ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u8fd8\u6709\u672a\u68c0\u6d4b\u901a\u8fc7\u7684\u4fe1\u606f", (String)"PtmmShowPageUtil_2", (String)"hr-ptmm-formplugin", (Object[])new Object[0]), failId2ErrorMsg);
        FormShowParameter formShowParameter = PtmmShowPageUtil.getResultPage("", String.valueOf(successNum), ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"PtmmShowPageUtil_3", (String)"hr-ptmm-formplugin", (Object[])new Object[0]), String.valueOf(failNum), ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"PtmmShowPageUtil_4", (String)"hr-ptmm-formplugin", (Object[])new Object[0]), secondConfirmExportName, exportDataList, headDataList);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "ptmm_listresult"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u7ed3\u679c", (String)"PtmmShowPageUtil_5", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
        plugin.getView().showForm(formShowParameter);
    }

    public static List<HRExportHeadObject> getAdjustBillHeadDataList(String billFormId) {
        ArrayList<HRExportHeadObject> headdatalist = new ArrayList<HRExportHeadObject>();
        headdatalist.add(new HRExportHeadObject("billno", ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"PtmmShowPageUtil_6", (String)"hr-ptmm-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("adjuststatus", ResManager.loadKDString((String)"\u8c03\u6574\u72b6\u6001", (String)"PtmmShowPageUtil_7", (String)"hr-ptmm-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("projectteam", ResManager.loadKDString((String)"\u9879\u76ee\u56e2\u961f", (String)"PtmmShowPageUtil_8", (String)"hr-ptmm-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("adjustnum", ResManager.loadKDString((String)"\u8c03\u6574\u4eba\u6570", (String)"PtmmShowPageUtil_9", (String)"hr-ptmm-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("isSuccess", ResManager.loadKDString((String)"\u64cd\u4f5c\u7ed3\u679c", (String)"PtmmShowPageUtil_11", (String)"hr-ptmm-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("reason", ResManager.loadKDString((String)"\u4e0d\u53ef\u5220\u9664\u539f\u56e0", (String)"PtmmShowPageUtil_12", (String)"hr-ptmm-formplugin", (Object[])new Object[0])));
        return headdatalist;
    }

    public static List<Map<String, Object>> getAdjustBillTemplateExportDataList(Map<String, List<DynamicObject>> source, String defaultFailReason, Map<String, String> failId2ErrorMsg) {
        ArrayList<Map<String, Object>> exportdatalist = new ArrayList<Map<String, Object>>();
        List<DynamicObject> success = source.get("success");
        List<DynamicObject> fail = source.get("fail");
        PtmmShowPageUtil.buildAdjustBillExceportInfo(success, exportdatalist, ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"PtmmShowPageUtil_3", (String)"hr-ptmm-formplugin", (Object[])new Object[0]), "", null);
        PtmmShowPageUtil.buildAdjustBillExceportInfo(fail, exportdatalist, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"PtmmShowPageUtil_4", (String)"hr-ptmm-formplugin", (Object[])new Object[0]), defaultFailReason, failId2ErrorMsg);
        return exportdatalist;
    }

    public static FormShowParameter getResultPage(String workNumber, String successPerson, String successOperation, String failPerson, String failOperation, String excelName, List<Map<String, Object>> exportDataList, List<HRExportHeadObject> headDataList) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
        formShowParameter.setFormId("ptmm_listresult");
        formShowParameter.setCustomParam("successperson", (Object)successPerson);
        formShowParameter.setCustomParam("successoperation", (Object)successOperation);
        formShowParameter.setCustomParam("worknumber", (Object)workNumber);
        formShowParameter.setCustomParam("failperson", (Object)failPerson);
        formShowParameter.setCustomParam("failoperation", (Object)failOperation);
        formShowParameter.setCustomParam("excelname", (Object)excelName);
        formShowParameter.setCustomParam("exportdatalist", exportDataList);
        formShowParameter.setCustomParam("headdatalist", headDataList);
        return formShowParameter;
    }

    private static void buildAdjustBillExceportInfo(List<DynamicObject> source, List<Map<String, Object>> exportdatalist, String isSuccess, String defaultFailReason, Map<String, String> failId2ErrorMsg) {
        List temp = Optional.ofNullable(source).orElseGet(() -> new ArrayList());
        for (DynamicObject bill : temp) {
            HashMap<String, Object> map = new HashMap<String, Object>(source.size());
            map.put("billno", bill.getString("billno"));
            map.put("adjuststatus", AdjustStatusEnum.getName((String)bill.getString("adjuststatus")));
            map.put("projectteam", bill.getDynamicObject("projectteam").getLocaleString("name").toString());
            int num = bill.getInt("adjustnum") + bill.getInt("adjustnumadd") + bill.getInt("adjustnumadj") + bill.getInt("adjustnumend") + bill.getInt("adjustnumquit");
            map.put("adjustnum", num);
            map.put("isSuccess", isSuccess);
            String reason = defaultFailReason;
            if (null != failId2ErrorMsg && failId2ErrorMsg.size() > 0) {
                reason = failId2ErrorMsg.get(bill.getString("id"));
            }
            map.put("reason", reason);
            exportdatalist.add(map);
        }
    }
}

