/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.formplugin.web.common;

import java.time.LocalDateTime;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.http.util.Asserts;

public class TeamMemberBillPermCommon {
    private static final Log LOG = LogFactory.getLog(TeamMemberBillPermCommon.class);

    private TeamMemberBillPermCommon() {
    }

    public static TeamMemberBillPermCommon getInstance() {
        return Holder.INSTANCE;
    }

    public void verifyNewPerm() {
        boolean permission = this.hasNewPerm();
        if (!permission) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u201c\u9879\u76ee\u6210\u5458\u7ef4\u62a4\u201c\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TeamMemberBillPermCommon_0", (String)"hr-ptmm-formplugin", (Object[])new Object[0]));
        }
    }

    public boolean hasNewPerm() {
        String appId = AppMetadataCache.getAppInfo((String)"homs").getId();
        boolean hasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"ptmm_teammemberbill", (String)"47156aff000000ac");
        LOG.info("TeamMemberBillPermCommon hasNewPerm: {}", (Object)hasPerm);
        return hasPerm;
    }

    public void visibleBtnByNewPerm(IFormView formView, String btnKey) {
        Asserts.notNull((Object)formView, (String)"formView");
        Asserts.check((boolean)HRStringUtils.isNotEmpty((String)btnKey), (String)"btnKey");
        Map<String, Object> map = this.getBaseAppParam();
        if (Objects.isNull(map)) {
            LOG.warn("TeamMemberBillPermCommon.getBaseAppParam returnNull,time:{}", (Object)LocalDateTime.now());
            return;
        }
        Object parameter = map.get("enable_nopermbtnhide");
        if (Objects.isNull(parameter)) {
            return;
        }
        if (parameter instanceof Boolean && ((Boolean)parameter).booleanValue()) {
            LOG.info("TeamMemberBillPermCommon readParam_nopermbtnhide: {}", parameter);
            if (!this.hasNewPerm()) {
                formView.setVisible(Boolean.FALSE, new String[]{btnKey});
            }
        }
    }

    private Map<String, Object> getBaseAppParam() {
        long orgId = RequestContext.get().getOrgId();
        String appId = AppMetadataCache.getAppInfo((String)"base").getId();
        AppParam appParam = new AppParam(appId, Long.valueOf(orgId));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
    }

    private static class Holder {
        private static final TeamMemberBillPermCommon INSTANCE = new TeamMemberBillPermCommon();

        private Holder() {
        }
    }
}

