/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.formplugin.web.member;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.common.constants.member.TeamMemberConstants;
import org.apache.http.util.Asserts;

public class TeamMemberContactPlugin
extends HRDynamicFormBasePlugin
implements TeamMemberConstants {
    public void preOpenForm(PreOpenFormEventArgs preOpenFormEventArgs) {
        super.preOpenForm(preOpenFormEventArgs);
        preOpenFormEventArgs.getFormShowParameter().setStatus(OperationStatus.VIEW);
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        long personId = this.getPersonId();
        List personContactInfo = PTMMServiceFactory.personService.getPersonContactInfo(Collections.singletonList(personId));
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        personContactInfo.stream().findFirst().ifPresent(contactInfo -> dataEntityType.getProperties().stream().map(IMetadata::getName).filter(property -> Objects.nonNull(contactInfo.get(property))).forEach(property -> this.getModel().setValue(property, contactInfo.get(property))));
    }

    private long getPersonId() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object personId = showParameter.getCustomParam("personId");
        Asserts.notNull((Object)personId, (String)"personId");
        return Long.parseLong(personId.toString());
    }
}

