/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.formplugin.web.member;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.ptmm.business.domain.repository.ProjectMemberRepository;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.common.constants.member.TeamMemberHeadConstants;
import kd.hr.ptmm.common.enums.PersonServiceStatusEnum;
import kd.hr.ptmm.common.enums.PosPatternEnum;
import org.apache.http.util.Asserts;

public class TeamMemberHeadPlugin
extends HRDynamicFormBasePlugin
implements TeamMemberHeadConstants {
    public void preOpenForm(PreOpenFormEventArgs preOpenFormEventArgs) {
        super.preOpenForm(preOpenFormEventArgs);
        FormShowParameter showParameter = preOpenFormEventArgs.getFormShowParameter();
        showParameter.setStatus(OperationStatus.VIEW);
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        this.initPage();
        this.updateStatus();
    }

    private void initPage() {
        Map headParam = PTMMServiceFactory.personService.getTeamMemberHeadParam(Long.valueOf(this.getPersonId()));
        headParam.forEach((key, labelValue) -> {
            if (HRStringUtils.equals((String)key, (String)"apositiontype")) {
                if (HRStringUtils.equals((String)String.valueOf(labelValue), (String)PosPatternEnum.POSITION.getCode())) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flex_stdposition", "flex_job"});
                }
                if (HRStringUtils.equals((String)String.valueOf(labelValue), (String)PosPatternEnum.STD_POSITION.getCode())) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flex_position", "flex_job"});
                }
                if (HRStringUtils.equals((String)String.valueOf(labelValue), (String)PosPatternEnum.JOB.getCode())) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flex_position", "flex_stdposition"});
                }
                return;
            }
            Control control = this.getView().getControl(key);
            if (Objects.isNull(control)) {
                return;
            }
            String labelValueStr = String.valueOf(labelValue);
            if (control instanceof Label) {
                if (Objects.isNull(labelValue) || HRStringUtils.isEmpty((String)labelValueStr)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flex_" + key});
                }
                ((Label)control).setText(labelValueStr);
            }
            if (control instanceof Image) {
                String defaultHead = "/images/pc/emotion/default_person_82_82.png";
                if (HRStringUtils.isNotEmpty((String)labelValueStr) && !defaultHead.contains(labelValueStr)) {
                    ((Image)control).setUrl(HRImageUrlUtil.getImageFullUrl((String)labelValueStr));
                } else {
                    ((Image)control).setUrl(defaultHead);
                }
            }
        });
    }

    private void updateStatus() {
        String serviceStatus = this.getServiceStatus();
        Label statusLbl = (Label)this.getControl("status");
        PersonServiceStatusEnum statusEnum = PersonServiceStatusEnum.getEnumByCode((String)serviceStatus);
        statusLbl.setText(statusEnum.getName().loadKDString());
        HashMap ctrl = Maps.newHashMapWithExpectedSize((int)1);
        ctrl.put("fc", statusEnum.getForeColor());
        ctrl.put("bc", statusEnum.getBackgroundColor());
        HashMap borderMap = new HashMap();
        HashMap<String, String> map = new HashMap<String, String>();
        String borderColor = statusEnum.getBorderColor();
        map.put("t", borderColor);
        map.put("r", borderColor);
        map.put("l", borderColor);
        map.put("b", borderColor);
        borderMap.put("b", map);
        ctrl.put("s", borderMap);
        this.getView().updateControlMetadata("status", (Map)ctrl);
    }

    private String getServiceStatus() {
        DynamicObject[] projectMemberDOs = this.getProjectMemberDOs();
        if (Arrays.stream(projectMemberDOs).anyMatch(dy -> HRStringUtils.equals((String)dy.getString("servicestate"), (String)PersonServiceStatusEnum.SERVING.getCode()))) {
            return PersonServiceStatusEnum.SERVING.getCode();
        }
        if (Arrays.stream(projectMemberDOs).anyMatch(dy -> HRStringUtils.equals((String)dy.getString("servicestate"), (String)PersonServiceStatusEnum.TO_BE_ADDED.getCode()))) {
            return PersonServiceStatusEnum.TO_BE_ADDED.getCode();
        }
        return PersonServiceStatusEnum.EXITED.getCode();
    }

    private DynamicObject[] getProjectMemberDOs() {
        String project = this.getProject();
        long personId = this.getPersonId();
        QFilter projectQFilter = new QFilter("projectidentify", "=", (Object)project);
        QFilter personQFilter = new QFilter("person", "=", (Object)personId);
        return ProjectMemberRepository.getInstance().loadDynamicObjectArray(new QFilter[]{projectQFilter, personQFilter});
    }

    private String getProject() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object projectName = showParameter.getCustomParam("project");
        Asserts.notNull((Object)projectName, (String)"project");
        return String.valueOf(projectName);
    }

    private long getPersonId() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object personId = showParameter.getCustomParam("personId");
        Asserts.notNull((Object)personId, (String)"personId");
        return Long.parseLong(String.valueOf(personId));
    }
}

