/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.formplugin.web.member;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.ptmm.business.domain.repository.ProjectMemberRepository;
import kd.hr.ptmm.business.domain.repository.TeamMemberRepository;
import kd.hr.ptmm.common.constants.member.TeamMemberConstants;
import kd.hr.ptmm.common.enums.PersonServiceStatusEnum;
import org.apache.http.util.Asserts;

public class TeamMemberInfoPlugin
extends HRDynamicFormBasePlugin
implements TeamMemberConstants {
    private static final Set<String> OPEN_RELATE_FORM_KEY = Sets.newHashSetWithExpectedSize((int)2);

    public void preOpenForm(PreOpenFormEventArgs preOpenFormEventArgs) {
        super.preOpenForm(preOpenFormEventArgs);
        BillShowParameter showParameter = (BillShowParameter)preOpenFormEventArgs.getFormShowParameter();
        showParameter.setStatus(OperationStatus.VIEW);
        this.setCapture(showParameter);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"flex_contactinfo", "flex_emergencyperson", "lbl_emergencyperson", "lbl_contactinfo"});
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.showFormInContainer("ptmm_teammember_head", "flex_head");
        this.showFormInContainer("ptmm_teamworkrecord", "flex_teamworkrecord");
        DynamicObject[] projectMemberDOs = this.getProjectMemberDOs();
        this.setJoinProjectDate(projectMemberDOs);
        this.setQuitProjectDate(projectMemberDOs);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Container && OPEN_RELATE_FORM_KEY.contains(key = ((Container)source).getKey())) {
            this.showRelatedForm(key);
        }
    }

    private void setJoinProjectDate(DynamicObject[] projectMemberDOs) {
        Arrays.stream(projectMemberDOs).filter(dynamicObject -> Objects.nonNull(dynamicObject.get("joindate"))).min(Comparator.comparing(dy -> dy.getDate("joindate"))).ifPresent(dy -> this.getModel().setValue("project_joindate", (Object)dy.getDate("joindate")));
    }

    private void setQuitProjectDate(DynamicObject[] projectMemberDOs) {
        boolean existsServingOrToBeAdd = Arrays.stream(projectMemberDOs).anyMatch(dy -> HRStringUtils.equals((String)PersonServiceStatusEnum.SERVING.getCode(), (String)dy.getString("servicestate")) || HRStringUtils.equals((String)PersonServiceStatusEnum.TO_BE_ADDED.getCode(), (String)dy.getString("servicestate")));
        if (existsServingOrToBeAdd) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"project_quitdate"});
            return;
        }
        Arrays.stream(projectMemberDOs).filter(dy -> Objects.nonNull(dy.get("quitdate"))).max(Comparator.comparing(dy -> dy.getDate("quitdate"))).ifPresent(dy -> this.getModel().setValue("project_quitdate", (Object)dy.getDate("quitdate")));
    }

    private DynamicObject[] getProjectMemberDOs() {
        String project = this.getProject();
        long personId = this.getPersonId();
        QFilter projectQFilter = new QFilter("projectidentify", "=", (Object)project);
        QFilter personQFilter = new QFilter("person", "=", (Object)personId);
        return ProjectMemberRepository.getInstance().loadDynamicObjectArray(new QFilter[]{projectQFilter, personQFilter});
    }

    private void setCapture(BillShowParameter showParameter) {
        String selectProperties = String.join((CharSequence)",", "person", "projectmember");
        DynamicObject teamMemberDt = TeamMemberRepository.getInstance().queryOne(selectProperties, this.getTeamMemberId(showParameter));
        Asserts.notNull((Object)teamMemberDt, (String)"teamMemberDt");
        DynamicObject personDt = teamMemberDt.getDynamicObject("person");
        Asserts.notNull((Object)personDt, (String)"personDt");
        DynamicObject projectMemberDO = teamMemberDt.getDynamicObject("projectmember");
        Asserts.notNull((Object)projectMemberDO, (String)"projectMemberDO");
        String capture = String.join((CharSequence)"-", personDt.getString("name"), projectMemberDO.getString("projectname"));
        showParameter.setCaption(capture);
    }

    private void showFormInContainer(String formId, String container) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setHasRight(true);
        showParameter.getOpenStyle().setTargetKey(container);
        showParameter.setSendToClient(true);
        showParameter.setCustomParam("teamMemberId", this.getTeamMemberId());
        showParameter.setCustomParam("personId", (Object)this.getPersonId());
        showParameter.setCustomParam("project", (Object)this.getProject());
        this.getView().showForm(showParameter);
    }

    private void showRelatedForm(String key) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ptmm_teammember_related");
        showParameter.setHasRight(true);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("openKey", (Object)key);
        showParameter.setCustomParam("teamMemberId", this.getTeamMemberId());
        showParameter.setCustomParam("personId", (Object)this.getPersonId());
        showParameter.setCustomParam("project", (Object)this.getProject());
        this.getView().showForm(showParameter);
    }

    private Object getTeamMemberId() {
        BillShowParameter showParameter = (BillShowParameter)this.getView().getFormShowParameter();
        return this.getTeamMemberId(showParameter);
    }

    private Object getTeamMemberId(BillShowParameter showParameter) {
        return showParameter.getPkId();
    }

    private long getPersonId() {
        String personId = this.getPageCache().get("personId");
        if (HRStringUtils.isNotEmpty((String)personId)) {
            return Long.parseLong(personId);
        }
        String selectProperties = String.join((CharSequence)",", "person", "projectname");
        DynamicObject teamMemberDt = TeamMemberRepository.getInstance().queryOne(selectProperties, this.getTeamMemberId());
        Asserts.notNull((Object)teamMemberDt, (String)"teamMemberDt");
        DynamicObject personDt = teamMemberDt.getDynamicObject("person");
        personId = personDt.getString("id");
        this.cachePersonId(personId);
        return Long.parseLong(personId);
    }

    private void cachePersonId(String personId) {
        this.getPageCache().put("personId", personId);
    }

    private String getProject() {
        String projectStr = this.getPageCache().get("project");
        if (HRStringUtils.isNotEmpty((String)projectStr)) {
            return projectStr;
        }
        Object teamMemberId = this.getTeamMemberId();
        DynamicObject teamMemberDO = TeamMemberRepository.getInstance().queryOne("projectmember", teamMemberId);
        DynamicObject projectMemberDO = teamMemberDO.getDynamicObject("projectmember");
        Asserts.notNull((Object)projectMemberDO, (String)"projectMember");
        String project = projectMemberDO.getString("projectidentify");
        this.getPageCache().put("project", project);
        return project;
    }

    static {
        OPEN_RELATE_FORM_KEY.add("flex_contactinfo");
        OPEN_RELATE_FORM_KEY.add("flex_emergencyperson");
    }
}

