/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.formplugin.web.member;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.ptmm.common.constants.member.TeamMemberConstants;
import org.apache.http.util.Asserts;

public class TeamMemberRelatedInfoPlugin
extends HRDynamicFormBasePlugin
implements TeamMemberConstants {
    private static final Map<String, String> OPEN_RELATE_FORM_MAP = Maps.newHashMapWithExpectedSize((int)8);
    private static final Map<String, String> FLEX_LABEL_MAP = Maps.newHashMapWithExpectedSize((int)8);

    public void preOpenForm(PreOpenFormEventArgs preOpenFormEventArgs) {
        super.preOpenForm(preOpenFormEventArgs);
        preOpenFormEventArgs.getFormShowParameter().setStatus(OperationStatus.VIEW);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"flex_contactinfo", "flex_emergencyperson", "lbl_emergencyperson", "lbl_contactinfo"});
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.showFormInContainer("ptmm_teammember_head", "flex_head");
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String openKey = (String)showParameter.getCustomParam("openKey");
        if (Objects.isNull(openKey)) {
            openKey = "flex_contactinfo";
        }
        this.openRelatedPage(openKey);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Container && OPEN_RELATE_FORM_MAP.containsKey(key = ((Container)source).getKey())) {
            this.openRelatedPage(key);
        }
    }

    private void openRelatedPage(String pageKey) {
        this.showFormInContainer(OPEN_RELATE_FORM_MAP.get(pageKey), "relatedpage");
        this.setColorForClick(pageKey);
    }

    private void setColorForClick(String key) {
        OPEN_RELATE_FORM_MAP.keySet().forEach(flexKey -> {
            HashMap flexMap = Maps.newHashMapWithExpectedSize((int)8);
            HashMap labelMap = Maps.newHashMapWithExpectedSize((int)8);
            HashMap borderMap = Maps.newHashMapWithExpectedSize((int)1);
            if (HRStringUtils.equals((String)key, (String)flexKey)) {
                flexMap.put("bc", "themeColor|20");
                labelMap.put("fc", "themeColor");
                borderMap.put("l", "4px_solid_themeColor");
            } else {
                flexMap.put("bc", "#ffffff");
                labelMap.put("fc", "#333333");
                borderMap.put("l", null);
            }
            HashMap styleMap = Maps.newHashMapWithExpectedSize((int)1);
            styleMap.put("b", borderMap);
            flexMap.put("s", styleMap);
            this.getView().updateControlMetadata(flexKey, (Map)flexMap);
            String labelKey = FLEX_LABEL_MAP.get(flexKey);
            this.getView().updateControlMetadata(labelKey, (Map)labelMap);
        });
    }

    private void showFormInContainer(String formId, String container) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setHasRight(true);
        showParameter.getOpenStyle().setTargetKey(container);
        showParameter.setSendToClient(true);
        showParameter.setCustomParam("personId", (Object)this.getPersonId());
        showParameter.setCustomParam("teamMemberId", (Object)this.getTeamMemberId());
        showParameter.setCustomParam("project", (Object)this.getProject());
        this.getView().showForm(showParameter);
    }

    private long getPersonId() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object id = showParameter.getCustomParam("personId");
        Asserts.notNull((Object)id, (String)"personId");
        return Long.parseLong(id.toString());
    }

    private long getTeamMemberId() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object id = showParameter.getCustomParam("teamMemberId");
        Asserts.notNull((Object)id, (String)"teamMemberId");
        return Long.parseLong(id.toString());
    }

    private String getProject() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object projectName = showParameter.getCustomParam("project");
        Asserts.notNull((Object)projectName, (String)"project");
        return String.valueOf(projectName);
    }

    static {
        OPEN_RELATE_FORM_MAP.put("flex_contactinfo", "ptmm_contactinfo");
        OPEN_RELATE_FORM_MAP.put("flex_emergencyperson", "ptmm_emergencyperson");
        FLEX_LABEL_MAP.put("flex_contactinfo", "lbl_contactinfo");
        FLEX_LABEL_MAP.put("flex_emergencyperson", "lbl_emergencyperson");
    }
}

