/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.formplugin.web.member;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseList;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.common.bean.PersonRelatedInfo;
import kd.hr.ptmm.common.constants.member.TeamMemberRoleConstants;
import kd.hr.ptmm.formplugin.web.common.TeamMemberBillPermCommon;

public class TeamMemberRoleODCBaseList
extends HRCoreBaseList
implements TeamMemberRoleConstants {
    private static final String LIST_KEY_GENDER = "gender";

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        Stream.of("person.headsculpture", "person.number", "person.name").filter(column -> Objects.nonNull(args.getListColumn(column))).forEach(column -> args.getListColumn(column).setFixed(true));
    }

    public void setFilter(SetFilterEvent setFilter) {
        super.setFilter(setFilter);
        setFilter.getQFilters().add(new QFilter("projectteam", "=", (Object)this.getProjectTeamId()));
        setFilter.getQFilters().add(new QFilter("iscurrentversion", "=", (Object)"1"));
        for (QFilter qFilter : setFilter.getQFilters()) {
            if (Objects.isNull(qFilter) || !HRStringUtils.equals((String)"quitdate", (String)qFilter.getProperty())) continue;
            qFilter.__setProperty("servicestate");
            qFilter.__setValue((Object)"C");
            if (qFilter.getValue() instanceof QEmptyValue) {
                qFilter.__setCP("!=");
                continue;
            }
            qFilter.__setCP("=");
        }
        setFilter.addCustomQFilter(new QFilter("datastatus", "!=", (Object)EnumHisDataVersionStatus.DELETED.getStatus()));
    }

    public void beforePackageData(BeforePackageDataEvent beforePackageDataEvent) {
        super.beforePackageData(beforePackageDataEvent);
        DynamicObjectCollection pageData = beforePackageDataEvent.getPageData();
        List personIdList = pageData.stream().map(data -> data.getDynamicObject("person").getLong("id")).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(personIdList)) {
            return;
        }
        List personBasicInfo = PTMMServiceFactory.personService.getPersonBasicInfo(personIdList);
        this.cachePersonRelatedInfo(personBasicInfo);
        pageData.stream().filter(data -> Objects.nonNull(data.get("quitdate")) && !HRStringUtils.equals((String)data.getString("servicestate"), (String)"C")).forEach(data -> data.set("quitdate", null));
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        super.packageData(packageDataEvent);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)packageDataEvent.getSource();
        String fieldKey = columnDesc.getFieldKey();
        if (HRStringUtils.equals((String)fieldKey, (String)LIST_KEY_GENDER)) {
            List<PersonRelatedInfo> personRelatedInfo = this.getPersonRelatedInfo();
            long personId = packageDataEvent.getRowData().getDynamicObject("person").getLong("id");
            personRelatedInfo.stream().filter(info -> info.getPersonId().equals(personId)).findFirst().ifPresent(info -> packageDataEvent.setFormatValue((Object)info.getGender()));
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        TeamMemberBillPermCommon.getInstance().visibleBtnByNewPerm(this.getView(), "btn_maintain");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"member_maintain")) {
            TeamMemberBillPermCommon.getInstance().verifyNewPerm();
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId("ptmm_teammemberbill");
            billShowParameter.setCustomParam("customHREntityNumber", (Object)"ptmm_teammemberbill");
            billShowParameter.setCustomParam("customHRPermItemId", (Object)"47156aff000000ac");
            billShowParameter.setCustomParam("custom_parent_f7_prop", (Object)"projectteam");
            billShowParameter.setCustomParam("projectTeamId", (Object)this.getProjectTeamId());
            billShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("canceltobejoined".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void cachePersonRelatedInfo(List<Map<String, Object>> personBasicInfo) {
        List personRelatedInfos = personBasicInfo.stream().map(basicInfo -> {
            Long personId = Long.parseLong(String.valueOf(basicInfo.get("person_id")));
            String gender = String.valueOf(basicInfo.get(LIST_KEY_GENDER));
            return new PersonRelatedInfo(personId, gender);
        }).collect(Collectors.toList());
        this.getPageCache().put("basicInfo", JSON.toJSONString(personRelatedInfos));
    }

    private List<PersonRelatedInfo> getPersonRelatedInfo() {
        String s = this.getPageCache().get("basicInfo");
        if (HRStringUtils.isEmpty((String)s)) {
            return Collections.emptyList();
        }
        return JSON.parseArray((String)s, PersonRelatedInfo.class);
    }

    private Long getProjectTeamId() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object projectTeamId = showParameter.getCustomParam("currentObjectPKId");
        if (Objects.isNull(projectTeamId)) {
            return 0L;
        }
        return Long.parseLong(projectTeamId.toString());
    }
}

