/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.formplugin.web.member;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.ptmm.business.domain.repository.TeamMemberRoleRepository;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.common.constants.member.TeamMemberRoleConstants;
import kd.hr.ptmm.common.constants.member.TeamWorkRecordConstants;
import kd.hr.ptmm.common.enums.PersonServiceStatusEnum;
import org.apache.http.util.Asserts;

public class TeamWorkRecordPlugin
extends HRDynamicFormBasePlugin
implements TeamMemberRoleConstants,
TeamWorkRecordConstants {
    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        DynamicObject[] teamMemberRoles = this.getTeamMemberRole();
        this.setValueToEntryEntity(teamMemberRoles);
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        super.propertyChanged(propertyChangedArgs);
        IDataEntityProperty property = propertyChangedArgs.getProperty();
        if (HRStringUtils.equals((String)property.getName(), (String)"onlyvalid")) {
            boolean isOnlyValid = (Boolean)propertyChangedArgs.getChangeSet()[0].getNewValue();
            DynamicObject[] teamMemberRole = this.getTeamMemberRole(isOnlyValid);
            this.setValueToEntryEntity(teamMemberRole);
        }
    }

    private void setValueToEntryEntity(DynamicObject[] teamMemberRoles) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        cardEntry.setChildVisible(false, teamMemberRoles.length - 1, new String[]{"cardentryflexpanelap1"});
        List<String> extendFieldList = this.getExtendFieldList();
        for (int i = 0; i < teamMemberRoles.length; ++i) {
            DynamicObject dynamicObject = teamMemberRoles[i];
            tableValueSetter.addField("startdate", new Object[]{HRInteDateTimeUtil.formatDate((String)"ptmm_teammemberrole", (String)"joindate", (Date)dynamicObject.getDate("joindate"))});
            tableValueSetter.addField("enddate", new Object[]{this.getEndDate(cardEntry, i, dynamicObject)});
            tableValueSetter.addField("projectteam", new Object[]{dynamicObject.getDynamicObject("projectteam").getString("name")});
            tableValueSetter.addField("projectrole", new Object[]{dynamicObject.getDynamicObject("projectrole").getString("name")});
            String isPrincipal = dynamicObject.getString("isprincipal");
            tableValueSetter.addField("isprincipal", new Object[]{isPrincipal});
            cardEntry.setChildVisible(HRStringUtils.equals((String)isPrincipal, (String)"1"), i, new String[]{"lblisprincipal"});
            tableValueSetter.addField("servicestatus", new Object[]{dynamicObject.getString("servicestate")});
            tableValueSetter.addField("adminorg", new Object[]{dynamicObject.getDynamicObject("projectteam").getDynamicObject("belongadminorg").getString("name")});
            DynamicObject roleType = dynamicObject.getDynamicObject("projectrole").getDynamicObject("roletype");
            tableValueSetter.addField("roletype", new Object[]{Objects.isNull(roleType) ? "-" : roleType.getString("name")});
            boolean mainInCharge = dynamicObject.getDynamicObject("projectrole").getBoolean("mainpeoincharge");
            tableValueSetter.addField("ismaincharge", new Object[]{mainInCharge ? "1" : "0"});
            tableValueSetter.addField("teamsupervisor", new Object[]{this.getTeamSupervisor(dynamicObject.getDynamicObject("projectteam").getLong("id"), dynamicObject.getDynamicObject("projectrole"))});
            for (String extendField : extendFieldList) {
                DynamicProperty extendFieldProp = dynamicObject.getDynamicObjectType().getProperty(extendField);
                tableValueSetter.addField(extendField, new Object[]{this.convertValue(dynamicObject.get(extendField), (IDataEntityProperty)extendFieldProp)});
            }
        }
        model.batchCreateNewEntryRow("entryentity", tableValueSetter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private List<String> getExtendFieldList() {
        Set<String> excludeExtendFieldSet = this.getDefaultIgnoreFieldSet();
        Object excludeExtendFields = this.getView().getFormShowParameter().getCustomParam("excludeExtendFields");
        if (excludeExtendFields instanceof String) {
            String[] split;
            for (String str : split = ((String)excludeExtendFields).split(",")) {
                excludeExtendFieldSet.add(str.trim());
            }
        }
        DynamicObjectType collectionItemPropertyType = ((DynamicCollectionProperty)this.getModel().getDataEntityType().getProperty("entryentity")).getDynamicCollectionItemPropertyType();
        return collectionItemPropertyType.getProperties().stream().map(IMetadata::getName).filter(key -> !excludeExtendFieldSet.contains(key)).collect(Collectors.toList());
    }

    private Set<String> getDefaultIgnoreFieldSet() {
        HashSet<String> fieldSet = new HashSet<String>();
        fieldSet.add("id");
        fieldSet.add("seq");
        fieldSet.add("ismaincharge");
        fieldSet.add("isprincipal");
        fieldSet.add("projectrole");
        fieldSet.add("projectteam");
        fieldSet.add("teamsupervisor");
        fieldSet.add("roletype");
        fieldSet.add("servicestatus");
        fieldSet.add("startdate");
        fieldSet.add("enddate");
        fieldSet.add("adminorg");
        return fieldSet;
    }

    private Object getEndDate(CardEntry cardEntry, int rowIndex, DynamicObject dynamicObject) {
        String endDate;
        if (!HRStringUtils.equals((String)dynamicObject.getString("servicestate"), (String)PersonServiceStatusEnum.EXITED.getCode())) {
            endDate = ResManager.loadKDString((String)"\u81f3\u4eca", (String)"TeamWorkRecordPlugin_0", (String)"hr-ptmm-formplugin", (Object[])new Object[0]);
            cardEntry.setChildVisible(false, rowIndex, new String[]{"lbl_to"});
        } else {
            endDate = HRInteDateTimeUtil.formatDate((String)"ptmm_teammemberrole", (String)"quitdate", (Date)dynamicObject.getDate("quitdate"));
        }
        return endDate;
    }

    private String getTeamSupervisor(long projectTeamId, DynamicObject roleDO) {
        DynamicObject[] roleSuperPerson = PTMMServiceFactory.workRoleHrService.getRoleSuperPerson(roleDO.getLong("id"), projectTeamId);
        if (roleSuperPerson.length == 0) {
            return "-";
        }
        List personNameList = Arrays.stream(roleSuperPerson).map(dy -> dy.getString("person.name")).collect(Collectors.toList());
        return CollectionUtils.isEmpty(personNameList) ? "-" : Joiner.on((String)",").join(personNameList);
    }

    private DynamicObject[] getTeamMemberRole() {
        return this.getTeamMemberRole(false);
    }

    private DynamicObject[] getTeamMemberRole(boolean isOnlyValid) {
        String selectProperties = String.join((CharSequence)",", "joindate", "quitdate", "projectteam", "projectrole", "isprincipal", "servicestate", "teammember", "person", "projectmember");
        String extendFields = String.join((CharSequence)",", this.getExtendFieldList());
        selectProperties = String.join((CharSequence)",", selectProperties, extendFields);
        QFilter projectQFilter = new QFilter("projectmember.projectidentify", "=", (Object)this.getProject());
        projectQFilter.and(new QFilter("person", "=", (Object)this.getPersonId()));
        QFilter currentVQFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter statusQFilter = null;
        if (isOnlyValid) {
            statusQFilter = new QFilter("servicestate", "=", (Object)PersonServiceStatusEnum.SERVING.getCode());
        }
        String orderBy = String.join((CharSequence)" ", "joindate", "desc");
        return TeamMemberRoleRepository.getInstance().query(selectProperties, new QFilter[]{projectQFilter, statusQFilter, currentVQFilter}, orderBy);
    }

    private String getProject() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object projectName = showParameter.getCustomParam("project");
        Asserts.notNull((Object)projectName, (String)"project");
        return String.valueOf(projectName);
    }

    private long getPersonId() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object id = showParameter.getCustomParam("personId");
        Asserts.notNull((Object)id, (String)"personId");
        return Long.parseLong(String.valueOf(id));
    }

    private String convertValue(Object value, IDataEntityProperty prop) {
        if (value == null) {
            return "";
        }
        if (prop instanceof BasedataProp) {
            DynamicProperty name = ((DynamicObject)value).getDynamicObjectType().getProperty("name");
            if (name != null) {
                return ((DynamicObject)value).getString("name");
            }
            return "";
        }
        if (prop instanceof MulBasedataProp) {
            return this.getMultiBaseDataString((MulBasedataDynamicObjectCollection)value);
        }
        if (prop instanceof ComboProp) {
            return ((ComboProp)prop).getItemByName((String)value);
        }
        if (prop instanceof DateTimeProp) {
            return DateUtils.formatDate((Date)((Date)value), (Object[])new Object[0]);
        }
        return value.toString();
    }

    private String getMultiBaseDataString(MulBasedataDynamicObjectCollection collection) {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < collection.size(); ++index) {
            DynamicObject fbasedataid = ((DynamicObject)collection.get(index)).getDynamicObject("fbasedataid");
            if (fbasedataid.getDynamicObjectType().getProperty("name") == null) continue;
            if (index == collection.size() - 1) {
                if (fbasedataid == null) continue;
                sb.append(fbasedataid.getString("name"));
                continue;
            }
            if (fbasedataid == null) continue;
            sb.append(fbasedataid.getString("name")).append(",");
        }
        return sb.length() != 0 ? sb.toString() : "";
    }
}

