/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.formplugin.web.template;

import java.util.EventObject;
import java.util.Map;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.ptmm.common.bean.StatusColorMapping;
import kd.hr.ptmm.common.constants.ProjectTeamBillConstants;
import kd.hr.ptmm.common.enums.AdjustStatusEnum;
import kd.hr.ptmm.common.enums.BillStatusColorEnum;
import kd.hr.ptmm.common.util.BillStatusColorUtil;

public class BillHeadAddPlugin
extends HRDynamicFormBasePlugin
implements ProjectTeamBillConstants {
    private static final Log log = LogFactory.getLog(BillHeadAddPlugin.class);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String adjustStatus = (String)customParams.get("adjuststatus");
        String name = AdjustStatusEnum.getEnumByCode((String)adjustStatus).getName();
        customParams.put("billstatus", name);
        this.writeLapsValue(customParams);
        Object obj = customParams.get("adjuststatus");
        if (!HRObjectUtils.isEmpty(obj)) {
            String dispatchStatus = String.valueOf(obj);
            BillStatusColorEnum colorEnum = this.getDispatchChangeColorByStatus(dispatchStatus);
            this.getView().updateControlMetadata("billstatus", BillStatusColorUtil.getStatusColorMap((BillStatusColorEnum)colorEnum));
        } else {
            this.getView().updateControlMetadata("billstatus", BillStatusColorUtil.getStatusColorMap((BillStatusColorEnum)BillStatusColorEnum.ONGOING));
        }
    }

    private BillStatusColorEnum getDispatchChangeColorByStatus(String dispatchStatus) {
        return StatusColorMapping.STATUS_COLOR_MAP.getOrDefault(dispatchStatus, BillStatusColorEnum.ONGOING);
    }

    private void writeLapsValue(Map<String, Object> customParams) {
        customParams.forEach((key, labelValue) -> {
            Label label = (Label)this.getView().getControl(key);
            if (!HRObjectUtils.isEmpty((Object)label)) {
                if (!HRObjectUtils.isEmpty((Object)labelValue)) {
                    label.setText(labelValue.toString());
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{key});
                }
            }
        });
    }
}

