/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.formplugin.web.template;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.ptmm.business.domain.validator.DyObjValidateContext;

public interface MulConfirmPluginCommon {
    public static final Log log = LogFactory.getLog(MulConfirmPluginCommon.class);

    default public void handleFailedOpMsg(Map<String, String> failId2ErrorMsg, OperationResult opResult) {
        List allErrorOrValidateInfo = opResult.getAllErrorOrValidateInfo();
        allErrorOrValidateInfo.stream().forEach(iOperateInfo -> {
            String msg = iOperateInfo.getMessage();
            log.info("MulConfirmPluginCommon msg: {} iOperateInfo.getPkValue(): {} iOperateInfo.getMessage(): {}", new Object[]{msg, iOperateInfo.getPkValue(), iOperateInfo.getMessage()});
            failId2ErrorMsg.put(iOperateInfo.getPkValue().toString(), msg);
        });
    }

    default public void buildValidateResult(List<DynamicObject> firSuccessList, List<Long> firSuccessIds, List<DynamicObject> failList, Map<String, String> failId2ErrorMsg, List<DyObjValidateContext> dyObjValidateContexts) {
        for (DyObjValidateContext dyObjValidateContext : dyObjValidateContexts) {
            if (dyObjValidateContext.getValidatorContext().getValidateResult().size() > 0) {
                String errorMsg = dyObjValidateContext.getValidatorContext().getValidateResultStr();
                failId2ErrorMsg.put(dyObjValidateContext.getDynamicObject().getString("id"), errorMsg);
                failList.add(dyObjValidateContext.getDynamicObject());
                continue;
            }
            firSuccessList.add(dyObjValidateContext.getDynamicObject());
            firSuccessIds.add(dyObjValidateContext.getDynamicObject().getLong("id"));
        }
    }
}

