/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.formplugin.web.template;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.ptmm.business.domain.repository.TeamMemberBillRepository;
import kd.hr.ptmm.business.domain.service.ITeamMemBillValidateService;
import kd.hr.ptmm.business.domain.validator.ValidateProducer;
import kd.hr.ptmm.common.util.AppLogUtils;
import kd.hr.ptmm.formplugin.web.common.PtmmShowPageUtil;
import kd.hr.ptmm.formplugin.web.template.MulConfirmPluginCommon;

public class MulDeleteConfirmPlugin
extends HRDataBaseEdit
implements MulConfirmPluginCommon {
    private static final String BTN_OK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button button = (Button)this.getControl(BTN_OK);
        button.addClickListener((ClickListener)this);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("ptmm_listresult")) {
            this.getView().close();
        }
    }

    public void click(EventObject evt) {
        JSONArray ids = (JSONArray)this.getView().getFormShowParameter().getCustomParam("ids");
        if (Objects.isNull(ids) || ids.size() == 0) {
            this.getView().close();
            return;
        }
        this.deleteAdjustBill(ids);
    }

    private void deleteAdjustBill(JSONArray ids) {
        ArrayList firSuccessList = new ArrayList();
        ArrayList firSuccessIds = new ArrayList();
        ArrayList<DynamicObject> successList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> failList = new ArrayList<DynamicObject>();
        HashMap failId2ErrorMsg = Maps.newHashMapWithExpectedSize((int)4);
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        String queryProperties = String.join((CharSequence)",", Lists.newArrayList((Object[])new String[]{"id", "billno", "adjuststatus", "projectteam", "adjustnum", "adjustnumadd", "adjustnumadj", "adjustnumend", "adjustnumquit"}));
        DynamicObject[] reQueryDataList = TeamMemberBillRepository.getInstance().query(queryProperties, new QFilter[]{qFilter});
        String curAppId = this.getView().getParentView().getFormShowParameter().getAppId();
        List dyObjValidateContexts = ITeamMemBillValidateService.getInstance().batchDeleteValidate(Arrays.asList(reQueryDataList), ValidateProducer.init(Arrays.asList(reQueryDataList)), curAppId);
        this.buildValidateResult(firSuccessList, firSuccessIds, failList, failId2ErrorMsg, dyObjValidateContexts);
        Object[] idArray = firSuccessIds.toArray();
        OperateOption option = OperateOption.create();
        option.setVariableValue("currbizappid", curAppId);
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"delete", (String)"ptmm_teammemberbill", (Object[])idArray, (OperateOption)option);
        log.info("MulDeleteConfirmPlugin deleteAdjustBill opResult: {}", (Object)JSONObject.toJSONString((Object)opResult));
        List successPkIds = opResult.getSuccessPkIds();
        for (DynamicObject firSuccess : firSuccessList) {
            if (successPkIds.contains(firSuccess.getLong("id"))) {
                successList.add(firSuccess);
                continue;
            }
            failList.add(firSuccess);
        }
        this.handleFailedOpMsg(failId2ErrorMsg, opResult);
        for (DynamicObject success : successList) {
            String opName = ResManager.loadKDString((String)"\u5220\u9664", (String)"MulDeleteConfirmPlugin_0", (String)"hr-ptmm-formplugin", (Object[])new Object[0]);
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u7f16\u53f7%s\uff0c\u5220\u9664\u6210\u529f", "MulDeleteConfirmPlugin_1", "hr-ptmm-formplugin");
            AppLogUtils.record((String)"ptmm_teammemberbill", (String)"delete", (String)opName, (MultiLangEnumBridge)opDesc, (String[])new String[]{success.getString("billno")});
        }
        HashMap operationResult = Maps.newHashMapWithExpectedSize((int)4);
        operationResult.put("success", successList);
        operationResult.put("fail", failList);
        String secondConfirmExportName = (String)this.getView().getFormShowParameter().getCustomParam("secondconfirm_exporttitle");
        PtmmShowPageUtil.showAdjustBillSecondConfirmForDelete((AbstractBillPlugIn)this, operationResult, successList.size(), failList.size(), secondConfirmExportName, "hr-ptmm-formplugin", failId2ErrorMsg);
    }
}

