/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.formplugin.web.template;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.mvc.cache.PageCache;
import kd.hr.hbp.business.servicehelper.HRExportDataHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.HRTypesContainer;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;

public class SecondConfirmEdit
extends HRCoreBaseBillEdit {
    private static final Log logger = LogFactory.getLog(SecondConfirmEdit.class);
    private static final String VIEWDETAILS = "viewdetails";
    private static final String OPFLEXPANELAP0 = "opflexpanelap0";
    private static final String OPFLEXPANELAP1 = "opflexpanelap1";
    private static final String SUCCESSFLEXPANELAP = "successflexpanelap";
    private static final String FAILFLEXPANELAP = "failflexpanelap";
    private static final int NUMBER_EIGHT = 8;

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        String successPerson = (String)formShowParameter.getCustomParam("successperson");
        String successOperation = (String)formShowParameter.getCustomParam("successoperation");
        String failPerson = (String)formShowParameter.getCustomParam("failperson");
        String failOperation = (String)formShowParameter.getCustomParam("failoperation");
        PageCache pageCache = new PageCache(formShowParameter.getPageId());
        FlexPanelAp opFlexPanelAp = this.getPage(successPerson, successOperation, failPerson, failOperation, pageCache);
        FlexPanelAp opFlexPanelAp0 = new FlexPanelAp();
        opFlexPanelAp0.setKey(OPFLEXPANELAP0);
        opFlexPanelAp0.getItems().add(opFlexPanelAp);
        HashMap<String, String> opFlexMap = new HashMap<String, String>(8);
        opFlexMap.put("id", OPFLEXPANELAP0);
        opFlexMap.put("items", (String)opFlexPanelAp0.createControl().get("items"));
        e.getItems().add(opFlexMap);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{VIEWDETAILS});
    }

    public void click(EventObject evt) {
        Control sControl = (Control)evt.getSource();
        if (sControl.getKey().equals(VIEWDETAILS)) {
            this.exportExcel();
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        PageCache pageCache = new PageCache(formShowParameter.getPageId());
        if (key.contains("failoperation")) {
            Map failOpMap = (Map)formShowParameter.getCustomParam("failopmap");
            for (int i = 0; i < failOpMap.size(); ++i) {
                if (!key.equals("failoperation" + i)) continue;
                Map opParam = (Map)failOpMap.get(pageCache.get("failoperation" + i));
                this.execuOpera(opParam.get("classname").toString(), opParam.get("methodname").toString(), opParam.get("parameters"), this.getView());
                break;
            }
        }
    }

    private void exportExcel() {
        String excelName = (String)this.getView().getFormShowParameter().getCustomParam("excelname");
        List exportDataList = (List)this.getView().getFormShowParameter().getCustomParam("exportdatalist");
        List headDataList = new ArrayList();
        try {
            headDataList = (List)HRJSONUtils.cast((String)this.getView().getFormShowParameter().getCustomParam("headdatalist").toString(), List.class, (Class[])new Class[]{HRExportHeadObject.class});
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        String exportUrl = null;
        try {
            exportUrl = HRExportDataHelper.getExportExcelUrl((String)excelName, (List)exportDataList, headDataList);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        if (!HRStringUtils.isEmpty((String)exportUrl)) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.addAction("download", (Object)exportUrl);
        }
    }

    private void execuOpera(String className, String methodName, Object parameters, IFormView formView) {
        try {
            Class cls = HRTypesContainer.getOrRegister((String)className);
            Method method = cls.getDeclaredMethod(methodName, Object.class, IFormView.class);
            int modifiers = method.getModifiers();
            if (Modifier.isStatic(modifiers)) {
                method.invoke((Object)cls, parameters, formView);
            } else {
                method.invoke(cls.newInstance(), parameters, formView);
            }
            this.getView().getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ptmm_listresult"));
            this.getView().close();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private FlexPanelAp getPage(String successPerson, String successOperation, String failPerson, String failOperation, PageCache pageCache) {
        FlexPanelAp opFlexPanelAp = new FlexPanelAp();
        opFlexPanelAp.setKey(OPFLEXPANELAP1);
        opFlexPanelAp.setDirection("row");
        opFlexPanelAp.setAlignItems("stretch");
        opFlexPanelAp.setJustifyContent("center");
        opFlexPanelAp.setWrap(false);
        FlexPanelAp successflexpanelap = this.createRowPanel(SUCCESSFLEXPANELAP);
        LabelAp lblSuccessPerson = this.createLabel("successperson", successPerson);
        lblSuccessPerson.setFontSize(16);
        lblSuccessPerson.setForeColor("#26B175");
        lblSuccessPerson.setStyle(this.createNumStyle());
        LabelAp lblSuccessOperation = this.createLabel("successoperation", successOperation);
        successflexpanelap.getItems().add(lblSuccessPerson);
        successflexpanelap.getItems().add(lblSuccessOperation);
        FlexPanelAp failflexpanelap = this.createRowPanel(FAILFLEXPANELAP);
        LabelAp lblFailPerson = this.createLabel("failperson", failPerson);
        lblFailPerson.setFontSize(16);
        lblFailPerson.setForeColor("#FF3737");
        lblFailPerson.setStyle(this.createNumStyle());
        LabelAp lblFailOperation = this.createLabel("failoperation", failOperation);
        failflexpanelap.getItems().add(lblFailPerson);
        failflexpanelap.getItems().add(lblFailOperation);
        opFlexPanelAp.getItems().add(successflexpanelap);
        opFlexPanelAp.getItems().add(failflexpanelap);
        return opFlexPanelAp;
    }

    private LabelAp createLabel(String key, String name) {
        LabelAp lbl = new LabelAp();
        lbl.setKey(key);
        lbl.setName(new LocaleString(name));
        lbl.setFontSize(14);
        return lbl;
    }

    private Style createNumStyle() {
        Style style = new Style();
        Margin margin = new Margin();
        margin.setRight("5px");
        style.setMargin(margin);
        return style;
    }

    private FlexPanelAp createColumnPanel(String key) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(key);
        flexPanelAp.setAlignItems("center");
        flexPanelAp.setJustifyContent("center");
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("120px");
        style.setMargin(margin);
        flexPanelAp.setStyle(style);
        return flexPanelAp;
    }

    private FlexPanelAp createRowPanel(String key) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(key);
        flexPanelAp.setAlignItems("center");
        flexPanelAp.setAlignSelf("stretch");
        flexPanelAp.setJustifyContent("center");
        flexPanelAp.setDirection("row");
        return flexPanelAp;
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        this.getView().getParentView().getParentView().invokeOperation("refresh");
        this.getView().sendFormAction(this.getView().getParentView().getParentView());
    }
}

