/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.opplugin.web;

import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.common.constants.ProjectTeamBillConstants;

public class TeamMemberAdjustBillOp
extends HRCoreBaseBillOp
implements ProjectTeamBillConstants {
    private static final Log log = LogFactory.getLog(TeamMemberAdjustBillOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("adjuststatus");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] bills = e.getDataEntities();
        boolean submitExt = this.getOption().containsVariable("submit_ext");
        if (!submitExt) {
            PTMMServiceFactory.teamMemberBillService.updateTeamMemberBaseAndEntryStatus(bills);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] bills = e.getDataEntities();
        Long[] billIds = (Long[])Arrays.stream(bills).map(bill -> bill.getLong("id")).toArray(Long[]::new);
        DynamicObject[] dbBills = PTMMServiceFactory.teamMemberBillService.queryArray(billIds);
        PTMMServiceFactory.teamMemberBillService.doUpdateVid(Arrays.asList(dbBills));
        for (DynamicObject dataEntity : dbBills) {
            dataEntity.set("billstatus", (Object)"C");
        }
        PTMMServiceFactory.teamMemberBillService.updateStatusByRowStatus(dbBills);
        PTMMServiceFactory.teamMemberBillService.update(dbBills);
    }
}

