/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.opplugin.web;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;
import kd.hr.ptmm.business.domain.repository.TeamMemberRoleRepository;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.business.domain.status.dto.ProjectTemaRoleInfoDto;
import kd.hr.ptmm.business.domain.status.dto.ValidateParamDto;
import kd.hr.ptmm.business.domain.status.dto.ValidateResDto;
import kd.hr.ptmm.common.constants.ProjectTeamBillConstants;
import kd.hr.ptmm.common.enums.AdjustEntryEnum;
import kd.hr.ptmm.common.util.PropUtils;
import kd.hr.ptmm.common.util.PtmmJSONUtils;
import org.apache.commons.collections4.CollectionUtils;

public class TeamMemberAdjustBillValidateOp
extends HRCoreBaseBillOp
implements ProjectTeamBillConstants {
    private static final Log log = LogFactory.getLog(TeamMemberAdjustBillValidateOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("adjuststatus");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        if ("true".equals(this.getOption().getVariableValue("checked_submit", "false"))) {
            return;
        }
        DynamicObject adjEntity = e.getDataEntities()[0];
        log.info("TeamMemberAdjustBillOp.beforeExecuteOperationTransaction_start_time:{},billNo:{}", (Object)LocalDateTime.now(), (Object)adjEntity.getString("billno"));
        List<ValidateParamDto> validateParamDtos = this.getJoinParams(adjEntity);
        validateParamDtos.addAll(this.getAdjustParams(adjEntity));
        validateParamDtos.addAll(this.getQuitParams(adjEntity));
        this.updateRootProjectTeamInfo(validateParamDtos);
        log.info("TeamMemberAdjustBillOp.beforeExecuteOperationTransaction_end_time:{}", (Object)LocalDateTime.now());
        List validateResDtos = PTMMServiceFactory.validateService.projectMembersValidate(validateParamDtos);
        if (CollectionUtils.isNotEmpty((Collection)validateResDtos)) {
            if (this.operateOption.containsVariable("second_submit")) {
                boolean existError = validateResDtos.stream().anyMatch(obj -> obj.getMsgs().stream().anyMatch(msg -> "error".equals(msg.getMsgType())));
                if (existError) {
                    this.processValidateResult(e, validateResDtos);
                }
            } else {
                this.processValidateResult(e, validateResDtos);
            }
        }
    }

    private void updateRootProjectTeamInfo(List<ValidateParamDto> validateParamDtos) {
        List teamIds = validateParamDtos.stream().map(ValidateParamDto::getTeamId).collect(Collectors.toList());
        Map rootObjs = PTMMServiceFactory.projectTeamService.listProjectTeamRootTeamMapById(teamIds);
        for (ValidateParamDto validateParamDto : validateParamDtos) {
            Long teamId = validateParamDto.getTeamId();
            DynamicObject rootProjectTeam = (DynamicObject)rootObjs.get(teamId);
            validateParamDto.setProjectName(rootProjectTeam.getString("projectname"));
            validateParamDto.setProjectIdentify(rootProjectTeam.getString("projectidentify"));
        }
    }

    private List<ValidateParamDto> getJoinParams(DynamicObject adjEntity) {
        DynamicObjectCollection entityCol = adjEntity.getDynamicObjectCollection("memberjoinentry");
        ArrayList validateParamDtos = Lists.newArrayListWithExpectedSize((int)entityCol.size());
        List<Long> personIds = entityCol.stream().map(obj -> obj.getLong(PropUtils.getIdDot((String)"personfield"))).collect(Collectors.toList());
        Map<Long, Map<String, Object>> personIdMap = this.getHrpiPersonMap(personIds);
        int indexInitMemberAdd = 0;
        for (DynamicObject dynamicObject : entityCol) {
            ValidateParamDto validateParamDto = new ValidateParamDto();
            DynamicObject personObj = this.setPersonAttr(dynamicObject, validateParamDto, "personfield");
            this.setHrpiPersonAttr(personIdMap, validateParamDto, personObj.getLong("id"));
            validateParamDto.setBillNo(adjEntity.getString("billno"));
            validateParamDto.setValidateIndex(indexInitMemberAdd++);
            validateParamDto.setBillId(Long.valueOf(adjEntity.getLong("id")));
            validateParamDto.setValidateType(AdjustEntryEnum.JOIN);
            validateParamDto.setTeamId(Long.valueOf(dynamicObject.getLong("projectteamadd.id")));
            validateParamDto.setTeamName(dynamicObject.getString("projectteamadd.name"));
            validateParamDto.setRoleId(Long.valueOf(dynamicObject.getLong("projectrole.id")));
            validateParamDto.setRoleName(dynamicObject.getString("projectrole.name"));
            validateParamDto.setEffectTime(dynamicObject.getDate("joinstartdate"));
            validateParamDto.setIsprincipal(dynamicObject.getBoolean("isprincipal"));
            DynamicObjectCollection otherProjectRoles = dynamicObject.getDynamicObjectCollection("projectroleother");
            ArrayList otherProjectIds = Lists.newArrayListWithCapacity((int)otherProjectRoles.size());
            ArrayList otherProjectObjs = Lists.newArrayListWithCapacity((int)otherProjectRoles.size());
            for (DynamicObject otherProjectRoleBase : otherProjectRoles) {
                DynamicObject otherProjectRole = otherProjectRoleBase.getDynamicObject("fbasedataid");
                long projectId = otherProjectRole.getLong("id");
                String projectName = otherProjectRole.getString("name");
                otherProjectIds.add(projectId);
                ProjectTemaRoleInfoDto projectTemaRoleInfoDto = new ProjectTemaRoleInfoDto();
                projectTemaRoleInfoDto.setProjectRoleId(Long.valueOf(projectId));
                projectTemaRoleInfoDto.setProjectRoleName(projectName);
                otherProjectObjs.add(projectTemaRoleInfoDto);
            }
            validateParamDto.setOtherRoleIds((List)otherProjectIds);
            validateParamDto.setProjectTemaOtherRoleInfo((List)otherProjectObjs);
            validateParamDtos.add(validateParamDto);
        }
        return validateParamDtos;
    }

    private List<ValidateParamDto> getAdjustParams(DynamicObject adjEntity) {
        ArrayList validateParamDtos = Lists.newArrayListWithExpectedSize((int)1);
        DynamicObjectCollection adjJoinEntry = adjEntity.getDynamicObjectCollection("memberadjjentry");
        DynamicObjectCollection adjChangeEntry = adjEntity.getDynamicObjectCollection("memberadjaentry");
        DynamicObjectCollection adjQuitEntry = adjEntity.getDynamicObjectCollection("memberadjqentry");
        Set<Long> allPersonIds = this.getAllPersonIds(adjEntity);
        Map<Long, Map<String, Object>> personIdMap = this.getHrpiPersonMap(Lists.newArrayList(allPersonIds));
        int indexInitRoleAdd = 10000;
        for (Object dynamicObject : adjJoinEntry) {
            ValidateParamDto validateParamDto = new ValidateParamDto();
            DynamicObject personObj = this.setPersonAttr((DynamicObject)dynamicObject, validateParamDto, "personbaseadja.person");
            this.setHrpiPersonAttr(personIdMap, validateParamDto, personObj.getLong("id"));
            validateParamDto.setBillNo(adjEntity.getString("billno"));
            validateParamDto.setValidateIndex(indexInitRoleAdd++);
            validateParamDto.setBillId(Long.valueOf(adjEntity.getLong("id")));
            validateParamDto.setValidateType(AdjustEntryEnum.ADJUST_JOIN);
            validateParamDto.setTeamMemberJoinDate(dynamicObject.getDate("personbaseadja.joindate"));
            validateParamDto.setTeamId(Long.valueOf(dynamicObject.getLong("personbaseadja.projectteam.id")));
            validateParamDto.setTeamDO(dynamicObject.getDynamicObject("personbaseadja"));
            validateParamDto.setTeamName(dynamicObject.getString("personbaseadja.projectteam.name"));
            validateParamDto.setRoleId(Long.valueOf(dynamicObject.getLong("projectroleadja.id")));
            validateParamDto.setRoleName(dynamicObject.getString("projectroleadja.name"));
            validateParamDto.setEffectTime(dynamicObject.getDate("effectdateadja"));
            validateParamDto.setIsprincipal(dynamicObject.getBoolean("isprincipaladja"));
            validateParamDtos.add(validateParamDto);
        }
        int indexInitRoleAdjust = 20000;
        for (DynamicObject dynamicObject : adjChangeEntry) {
            ValidateParamDto validateParamDto = new ValidateParamDto();
            DynamicObject personObj = this.setPersonAttr(dynamicObject, validateParamDto, "personbaseadj.person");
            this.setHrpiPersonAttr(personIdMap, validateParamDto, personObj.getLong("id"));
            validateParamDto.setBillNo(adjEntity.getString("billno"));
            validateParamDto.setValidateIndex(indexInitRoleAdjust++);
            validateParamDto.setBillId(Long.valueOf(adjEntity.getLong("id")));
            validateParamDto.setValidateType(AdjustEntryEnum.ADJUST_ADJ);
            validateParamDto.setTeamId(Long.valueOf(dynamicObject.getLong("projectteamadjnew.id")));
            validateParamDto.setTeamName(dynamicObject.getString("projectteamadjnew.name"));
            validateParamDto.setRoleId(Long.valueOf(dynamicObject.getLong("projectroleadjnew.id")));
            validateParamDto.setRoleName(dynamicObject.getString("projectroleadjnew.name"));
            validateParamDto.setBeforeTeamName(dynamicObject.getString("personbaseadj.projectteam.name"));
            validateParamDto.setBeforeTeamDO(dynamicObject.getDynamicObject("personbaseadj.teammember"));
            validateParamDto.setTeamMemberJoinDate(dynamicObject.getDate("personbaseadj.joindate"));
            validateParamDto.setBeforeTeamId(Long.valueOf(dynamicObject.getLong("personbaseadj.projectteam.id")));
            validateParamDto.setBeforeRoleId(Long.valueOf(dynamicObject.getLong("personbaseadj.projectrole.id")));
            validateParamDto.setBeforeRoleName(dynamicObject.getString("personbaseadj.projectrole.name"));
            validateParamDto.setBeforeRoleDO(dynamicObject.getDynamicObject("personbaseadj"));
            validateParamDto.setEffectTime(dynamicObject.getDate("effectdateadj"));
            validateParamDto.setIsprincipal(dynamicObject.getBoolean("isprincipaladjnew"));
            validateParamDtos.add(validateParamDto);
        }
        int indexInitRoleQuit = 30000;
        for (DynamicObject dynamicObject : adjQuitEntry) {
            ValidateParamDto validateParamDto = new ValidateParamDto();
            DynamicObject personObj = this.setPersonAttr(dynamicObject, validateParamDto, "personbaseadjq.person");
            this.setHrpiPersonAttr(personIdMap, validateParamDto, personObj.getLong("id"));
            validateParamDto.setBillNo(adjEntity.getString("billno"));
            validateParamDto.setValidateIndex(indexInitRoleQuit++);
            validateParamDto.setBillId(Long.valueOf(adjEntity.getLong("id")));
            validateParamDto.setValidateType(AdjustEntryEnum.ADJUST_QUIT);
            validateParamDto.setTeamId(Long.valueOf(dynamicObject.getLong("personbaseadjq.projectteam.id")));
            validateParamDto.setTeamName(dynamicObject.getString("personbaseadjq.projectteam.name"));
            validateParamDto.setTeamDO(dynamicObject.getDynamicObject("personbaseadjq.teammember"));
            validateParamDto.setRoleId(Long.valueOf(dynamicObject.getLong("personbaseadjq.projectrole.id")));
            validateParamDto.setRoleName(dynamicObject.getString("personbaseadjq.projectrole.name"));
            validateParamDto.setRoleDO(dynamicObject.getDynamicObject("personbaseadjq"));
            validateParamDto.setEffectTime(dynamicObject.getDate("effectdateadjq"));
            validateParamDtos.add(validateParamDto);
        }
        return validateParamDtos;
    }

    private List<ValidateParamDto> getQuitParams(DynamicObject adjEntity) {
        DynamicObjectCollection entityCol = adjEntity.getDynamicObjectCollection("memberquitentry");
        ArrayList validateParamDtos = Lists.newArrayListWithExpectedSize((int)entityCol.size());
        HashSet personIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet teamMemIds = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject obj2 : entityCol) {
            personIds.add(obj2.getLong("personbaseq.person.id"));
            teamMemIds.add(obj2.getLong("personbaseq.id"));
        }
        Map<Long, Map<String, Object>> personIdMap = this.getHrpiPersonMap(Lists.newArrayList((Iterable)personIds));
        DynamicObject[] teamMemRoleList = TeamMemberRoleRepository.getInstance().listOtherRole((Set)teamMemIds);
        Map<Long, List<DynamicObject>> otherRoleMaps = Arrays.stream(teamMemRoleList).collect(Collectors.groupingBy(dy -> dy.getLong("teammember.id")));
        int indexInitMemberQuit = 40000;
        for (DynamicObject colDynamicObject : entityCol) {
            ValidateParamDto validateParamDto = new ValidateParamDto();
            DynamicObject personObj = this.setPersonAttr(colDynamicObject, validateParamDto, "personbaseq.person");
            this.setHrpiPersonAttr(personIdMap, validateParamDto, personObj.getLong("id"));
            validateParamDto.setBillNo(adjEntity.getString("billno"));
            validateParamDto.setValidateIndex(indexInitMemberQuit++);
            validateParamDto.setBillId(Long.valueOf(adjEntity.getLong("id")));
            validateParamDto.setValidateType(AdjustEntryEnum.QUIT);
            validateParamDto.setTeamMemberJoinDate(colDynamicObject.getDate("personbaseq.joindate"));
            validateParamDto.setTeamId(Long.valueOf(colDynamicObject.getLong("personbaseq.projectteam.id")));
            validateParamDto.setTeamDO(colDynamicObject.getDynamicObject("personbaseq"));
            validateParamDto.setTeamName(colDynamicObject.getString("personbaseq.projectteam.name"));
            validateParamDto.setRoleId(Long.valueOf(colDynamicObject.getLong("personbaseq.projectrole.id")));
            validateParamDto.setRoleName(colDynamicObject.getString("personbaseq.projectrole.name"));
            validateParamDto.setEffectTime(colDynamicObject.getDate("quitdate"));
            if (otherRoleMaps.containsKey(colDynamicObject.getLong("personbaseq.id"))) {
                validateParamDto.setOtherRoleIds(otherRoleMaps.get(colDynamicObject.getLong("personbaseq.id")).stream().map(obj -> obj.getLong("projectrole.id")).collect(Collectors.toList()));
            }
            validateParamDtos.add(validateParamDto);
        }
        return validateParamDtos;
    }

    private void processValidateResult(BeforeOperationArgs e, List<ValidateResDto> validateResDtos) {
        this.sortValidateResData(validateResDtos);
        String validateResJson = PtmmJSONUtils.serialize(validateResDtos);
        this.getOption().setVariableValue("memberjoinentry", validateResJson);
        e.setCancelMessage("cancel_ignore");
        e.setCancel(true);
    }

    private Map<Long, Map<String, Object>> getHrpiPersonMap(List<Long> personIds) {
        List maps = PTMMServiceFactory.hrpiService.listEmpposorgrels("1010_S", personIds);
        return maps.stream().collect(Collectors.toMap(map -> {
            Object personIdObj = map.get("person_id");
            if (personIdObj instanceof String) {
                return Long.parseLong(String.valueOf(personIdObj));
            }
            return (Long)personIdObj;
        }, mm -> mm, (v1, v2) -> v1));
    }

    private DynamicObject setPersonAttr(DynamicObject dynamicObject, ValidateParamDto validateParamDto, String personKey) {
        DynamicObject personObj = dynamicObject.getDynamicObject(personKey);
        validateParamDto.setPersonName(personObj.getString("name"));
        validateParamDto.setPersonNum(personObj.getString("number"));
        validateParamDto.setPersonId(Long.valueOf(personObj.getLong("id")));
        return personObj;
    }

    private void setHrpiPersonAttr(Map<Long, Map<String, Object>> personIdMap, ValidateParamDto validateParamDto, Long personId) {
        Map<String, Object> personMap = personIdMap.get(personId);
        if (!HRObjectUtils.isEmpty(personMap)) {
            validateParamDto.setDepempId(this.getLongId(personMap.get("depemp_id")));
            validateParamDto.setCmpempId(this.getLongId(personMap.get("cmpemp_id")));
            validateParamDto.setEmployeeId(this.getLongId(personMap.get("employee_id")));
        } else {
            validateParamDto.setDepempId(Long.valueOf(0L));
            validateParamDto.setCmpempId(Long.valueOf(0L));
            validateParamDto.setEmployeeId(Long.valueOf(0L));
        }
    }

    private Long getLongId(Object objId) {
        if (objId instanceof String) {
            return Long.parseLong(String.valueOf(objId));
        }
        return (Long)objId;
    }

    private Set<Long> getAllPersonIds(DynamicObject adjEntity) {
        DynamicObjectCollection adjJoinEntry = adjEntity.getDynamicObjectCollection("memberadjjentry");
        DynamicObjectCollection adjChangeEntry = adjEntity.getDynamicObjectCollection("memberadjaentry");
        DynamicObjectCollection adjQuitEntry = adjEntity.getDynamicObjectCollection("memberadjqentry");
        HashSet allPersonIds = Sets.newHashSet();
        Set joinPersonIds = adjJoinEntry.stream().map(obj -> obj.getLong(PropUtils.getIdDot((String)"personbaseadja.person"))).collect(Collectors.toSet());
        allPersonIds.addAll(joinPersonIds);
        Set adjPersonIds = adjChangeEntry.stream().map(obj -> obj.getLong(PropUtils.getIdDot((String)"personbaseadj.person"))).collect(Collectors.toSet());
        allPersonIds.addAll(adjPersonIds);
        Set quitPersonIds = adjQuitEntry.stream().map(obj -> obj.getLong(PropUtils.getIdDot((String)"personbaseadjq.person"))).collect(Collectors.toSet());
        allPersonIds.addAll(quitPersonIds);
        return allPersonIds;
    }

    private void sortValidateResData(List<ValidateResDto> validateResDtos) {
        validateResDtos.sort(Comparator.comparingInt(ValidateResDto::getValidateIndex));
        for (ValidateResDto validateResDto : validateResDtos) {
            List validMsg = validateResDto.getMsgs();
            validMsg.sort(Comparator.comparingInt(validateMsg -> validateMsg.getValidateType().getValue()));
        }
    }
}

