/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.opplugin.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;
import kd.hr.ptmm.business.domain.bo.CancelBo;
import kd.hr.ptmm.business.domain.repository.ProjectMemberRepository;
import kd.hr.ptmm.business.domain.repository.TeamMemberBillRepository;
import kd.hr.ptmm.business.domain.repository.TeamMemberRepository;
import kd.hr.ptmm.business.domain.repository.TeamMemberRoleRepository;
import kd.hr.ptmm.common.enums.AdjustStatusEnum;
import kd.hr.ptmm.common.util.OpConfirmHelper;
import kd.hr.ptmm.opplugin.validator.TeamMemberCancelValidator;

public class TeamMemberCancelToBeJoinedOp
extends HRCoreBaseBillOp {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("servicestate");
        e.getFieldKeys().add("person.number");
        e.getFieldKeys().add("teammember.id");
        e.getFieldKeys().add("projectmember.id");
        e.getFieldKeys().add("projectteam.id");
        e.getFieldKeys().add("person.id");
        e.getFieldKeys().add("joinbillno");
        e.getFieldKeys().add("endbillno");
        e.getFieldKeys().add("isteammainrole");
        e.getFieldKeys().add("projectrole");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new TeamMemberCancelValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String msg = ResManager.loadKDString((String)"\u79fb\u9664\u5f85\u52a0\u5165\u7684\u9879\u76ee\u6210\u5458\u540e\u65e0\u6cd5\u6062\u590d\uff0c\u5982\u9700\u518d\u6b21\u52a0\u5165\u56e2\u961f\u9700\u8981\u91cd\u65b0\u63d0\u5355", (String)"TeamMemberCancelToBeJoinedOp_0", (String)"hr-ptmm-opplugin", (Object[])new Object[0]);
        OpConfirmHelper.showConfirmMessage((OperateOption)this.getOption(), (String)"kd.hr.ptmm.opplugin.web.TeamMemberCancelToBeJoinedOp", (String)msg);
        OpConfirmHelper.checkPermissionAndThrowKDBizException((String)this.billEntityType.getName(), (String)((String)this.operateMeta.get("key")), (String)"homs");
        List<CancelBo> cancelBoList = this.analyseCancelScene(e.getDataEntities());
        Map<String, List<CancelBo>> cancelTypeVsCancelBoList = cancelBoList.stream().collect(Collectors.groupingBy(CancelBo::getCancelType));
        this.cancelJoin(cancelTypeVsCancelBoList.getOrDefault("1", Collections.emptyList()));
        this.cancelNewTeamMemberRole(cancelTypeVsCancelBoList.getOrDefault("2", Collections.emptyList()));
        this.cancelAdjustTeamMemberRole(cancelTypeVsCancelBoList.getOrDefault("3", Collections.emptyList()));
        Object[] toDeleteTeamMemberRoleIdArr = cancelBoList.stream().map(CancelBo::getTeamMemberRole).map(teamMemberRole -> teamMemberRole.getLong("id")).toArray();
        TeamMemberRoleRepository.getInstance().deleteByPks(toDeleteTeamMemberRoleIdArr);
        Set<Long> projectMemberIdSet = cancelBoList.stream().map(CancelBo::getTeamMemberRole).map(teamMemberRole -> teamMemberRole.getLong("projectmember.id")).collect(Collectors.toSet());
        this.updateOrDeleteProjectMember(projectMemberIdSet);
        this.updateBillData(cancelBoList);
    }

    private void updateOrDeleteProjectMember(Set<Long> projectMemberIdSet) {
        DynamicObject[] toBeUpdateProjectMemberArr;
        DynamicObject[] dbTeamMemberRoles = TeamMemberRoleRepository.getInstance().queryByProjectMember("id, servicestate, projectmember.id, quitdate", projectMemberIdSet);
        DynamicObject[] dbProjectMembers = ProjectMemberRepository.getInstance().queryById("id, servicestate, quitdate", projectMemberIdSet);
        Map<Long, List<DynamicObject>> projectMemberIdVsDbTMR = Arrays.stream(dbTeamMemberRoles).collect(Collectors.groupingBy(teamMemberRole -> teamMemberRole.getLong("projectmember.id")));
        Object[] toDeleteProjectMemberIdArr = Arrays.stream(dbProjectMembers).map(dbProjectMember -> dbProjectMember.getLong("id")).filter(id -> !projectMemberIdVsDbTMR.containsKey(id)).toArray();
        if (toDeleteProjectMemberIdArr.length != 0) {
            ProjectMemberRepository.getInstance().delete(toDeleteProjectMemberIdArr);
        }
        if ((toBeUpdateProjectMemberArr = (DynamicObject[])Arrays.stream(dbProjectMembers).filter(dbProjectMember -> projectMemberIdVsDbTMR.containsKey(dbProjectMember.getLong("id"))).filter(dbProjectMember -> !"C".equals(dbProjectMember.getString("servicestate"))).peek(dbProjectMember -> {
            Optional<Date> max;
            List dbTeamMemberRoleList = (List)projectMemberIdVsDbTMR.get(dbProjectMember.getLong("id"));
            boolean allQuitTMR = dbTeamMemberRoleList.stream().allMatch(dbTeamMemberRole -> "C".equals(dbTeamMemberRole.getString("servicestate")));
            if (allQuitTMR && (max = dbTeamMemberRoleList.stream().filter(dbTeamMemberRole -> "C".equals(dbTeamMemberRole.getString("servicestate"))).map(dbTeamMemberRole -> dbTeamMemberRole.getDate("quitdate")).max(Comparator.naturalOrder())).isPresent()) {
                dbProjectMember.set("servicestate", (Object)"C");
                dbProjectMember.set("quitdate", (Object)max.get());
            }
        }).toArray(DynamicObject[]::new)).length != 0) {
            ProjectMemberRepository.getInstance().update(toBeUpdateProjectMemberArr);
        }
    }

    private void updateBillData(List<CancelBo> cancelBoList) {
        HashSet finishRowIdSet = new HashSet();
        cancelBoList.stream().filter(cancelBo -> "2".equals(cancelBo.getCancelType()) || "3".equals(cancelBo.getCancelType()) || "1".equals(cancelBo.getCancelType()) && cancelBo.isJoinFinish()).map(CancelBo::getEntryRow).map(row -> row.getLong("id")).forEach(finishRowIdSet::add);
        Set billNoSet = cancelBoList.stream().map(CancelBo::getBillNo).collect(Collectors.toSet());
        DynamicObject[] teamMemberBillsAllData = TeamMemberBillRepository.getInstance().queryByBillNo("id, adjuststatus, memberjoinentry.id, memberjoinentry.adjuststatusjoin, memberadjjentry.id, memberadjjentry.adjuststatusadja, memberadjaentry.id, memberadjaentry.adjuststatusadj, memberadjqentry.id, memberadjqentry.adjuststatusadjq, memberquitentry.id, memberquitentry.adjuststatusquit", billNoSet);
        Arrays.stream(teamMemberBillsAllData).map(teamMemberBill -> teamMemberBill.getDynamicObjectCollection("memberjoinentry")).flatMap(Collection::stream).filter(memberJoinRow -> finishRowIdSet.contains(memberJoinRow.getLong("id"))).forEach(memberJoinRow -> memberJoinRow.set("adjuststatusjoin", (Object)"B"));
        Arrays.stream(teamMemberBillsAllData).map(teamMemberBill -> teamMemberBill.getDynamicObjectCollection("memberadjjentry")).flatMap(Collection::stream).filter(memberJoinRow -> finishRowIdSet.contains(memberJoinRow.getLong("id"))).forEach(memberJoinRow -> memberJoinRow.set("adjuststatusadja", (Object)"B"));
        Arrays.stream(teamMemberBillsAllData).map(teamMemberBill -> teamMemberBill.getDynamicObjectCollection("memberadjaentry")).flatMap(Collection::stream).filter(memberJoinRow -> finishRowIdSet.contains(memberJoinRow.getLong("id"))).forEach(memberJoinRow -> memberJoinRow.set("adjuststatusadj", (Object)"B"));
        Arrays.stream(teamMemberBillsAllData).forEach(teamMemberBill -> {
            if (this.allEntryProcessed((DynamicObject)teamMemberBill)) {
                teamMemberBill.set("adjuststatus", (Object)AdjustStatusEnum.PROCESSED.getCode());
            } else if (this.oneEntryProcessed((DynamicObject)teamMemberBill)) {
                teamMemberBill.set("adjuststatus", (Object)AdjustStatusEnum.WAITPROCESS.getCode());
            }
        });
        TeamMemberBillRepository.getInstance().update(teamMemberBillsAllData);
    }

    private void cancelAdjustTeamMemberRole(List<CancelBo> cancelBoList) {
        if (cancelBoList.size() == 0) {
            return;
        }
        Map<String, List<CancelBo>> isTeamMainRoleVSCancelBoList = cancelBoList.stream().collect(Collectors.groupingBy(cancelBo -> cancelBo.getTeamMemberRole().getString("isteammainrole")));
        List mainTeamMemberRoleCancelBoList = isTeamMainRoleVSCancelBoList.getOrDefault("1", Collections.emptyList());
        if (mainTeamMemberRoleCancelBoList.size() != 0) {
            Object[] teamMemberIdArr = mainTeamMemberRoleCancelBoList.stream().map(CancelBo::getTeamMemberRole).map(teamMemberRole -> teamMemberRole.getLong("teammember.id")).distinct().toArray();
            TeamMemberRepository.getInstance().deleteByPks(teamMemberIdArr);
        }
        List oldTeamMemberRoleIdList = cancelBoList.stream().map(CancelBo::getEntryRow).map(row -> row.getLong("personbaseadj.id")).collect(Collectors.toList());
        DynamicObject[] dbOldTeamMembers = TeamMemberRoleRepository.getInstance().queryById("id, quitdate, endbillno, teammember.id", oldTeamMemberRoleIdList);
        Arrays.stream(dbOldTeamMembers).forEach(dbOldTeamMember -> {
            dbOldTeamMember.set("quitdate", null);
            dbOldTeamMember.set("endbillno", null);
        });
        TeamMemberRoleRepository.getInstance().update(dbOldTeamMembers);
        Set teamMemberIdSet = Arrays.stream(dbOldTeamMembers).map(dy -> dy.getLong("teammember.id")).collect(Collectors.toSet());
        DynamicObject[] teamMembers = TeamMemberRepository.getInstance().queryById("id, quitdate, endbillno", teamMemberIdSet);
        Arrays.stream(teamMembers).forEach(teamMember -> {
            teamMember.set("quitdate", null);
            teamMember.set("endbillno", null);
        });
        TeamMemberRepository.getInstance().update(teamMembers);
    }

    private void cancelNewTeamMemberRole(List<CancelBo> cancelBoList) {
        if (cancelBoList.size() == 0) {
            return;
        }
    }

    private void cancelJoin(List<CancelBo> cancelBoList) {
        if (cancelBoList.size() == 0) {
            return;
        }
        Set teamMemberIdSet = cancelBoList.stream().map(CancelBo::getTeamMemberRole).map(teamMemberRole -> teamMemberRole.getLong("teammember.id")).collect(Collectors.toSet());
        DynamicObject[] dbTeamMemberRoles = TeamMemberRoleRepository.getInstance().queryToBeEffectByTeamMember("id, projectrole.id, teammember.id, isteammainrole, isprincipal", teamMemberIdSet);
        Map<Long, List<DynamicObject>> teamMemberIdVsTeamMemberRole = Arrays.stream(dbTeamMemberRoles).collect(Collectors.groupingBy(teamMemberRole -> teamMemberRole.getLong("teammember.id")));
        Map<DynamicObject, List<CancelBo>> entryRowVsCancelBoList = cancelBoList.stream().collect(Collectors.groupingBy(CancelBo::getEntryRow));
        ArrayList<CancelBo> cancelAllTeamMemberRoleList = new ArrayList<CancelBo>();
        ArrayList<CancelBo> cancelPartTeamMemberRoleList = new ArrayList<CancelBo>();
        entryRowVsCancelBoList.forEach((row, boList) -> {
            Set teamMemberRoleIdSet = boList.stream().map(canCelBo -> canCelBo.getTeamMemberRole().getLong("id")).collect(Collectors.toSet());
            long teamMemberId = ((CancelBo)boList.get(0)).getTeamMemberRole().getLong("teammember.id");
            List dbToBeEffectTeamMemberRoleList = (List)teamMemberIdVsTeamMemberRole.get(teamMemberId);
            Set dbTeamMemberRoleSet = dbToBeEffectTeamMemberRoleList.stream().map(teamMemberRole -> teamMemberRole.getLong("id")).collect(Collectors.toSet());
            if (dbTeamMemberRoleSet.equals(teamMemberRoleIdSet)) {
                cancelAllTeamMemberRoleList.addAll((Collection<CancelBo>)boList);
                boList.forEach(cancelBo -> cancelBo.setJoinFinish(true));
            } else {
                cancelPartTeamMemberRoleList.addAll((Collection<CancelBo>)boList);
                boList.forEach(cancelBo -> cancelBo.setJoinFinish(false));
            }
        });
        if (cancelAllTeamMemberRoleList.size() != 0) {
            this.canCelAllTeamMemberRole(cancelAllTeamMemberRoleList);
        }
        if (cancelPartTeamMemberRoleList.size() != 0) {
            this.cancelPartTeamMemberRole(Arrays.asList(dbTeamMemberRoles), cancelPartTeamMemberRoleList);
        }
    }

    private void cancelPartTeamMemberRole(List<DynamicObject> DbTeamMemberRoleList, List<CancelBo> cancelPartTeamMemberRoleList) {
        Set teamMemberRoleIdSet = cancelPartTeamMemberRoleList.stream().map(canCelBo -> canCelBo.getTeamMemberRole().getLong("id")).collect(Collectors.toSet());
        List leftDBTeamMemberRoleList = DbTeamMemberRoleList.stream().filter(dbTeamMemberRole -> {
            long dbTeamMemberRoleId = dbTeamMemberRole.getLong("id");
            return !teamMemberRoleIdSet.contains(dbTeamMemberRoleId);
        }).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> teamMemberVsLeftDBTeamMemberRoleList = leftDBTeamMemberRoleList.stream().collect(Collectors.groupingBy(dbTeamMemberRole -> dbTeamMemberRole.getLong("teammember.id")));
        List nextMainTeamMemberRoleList = teamMemberVsLeftDBTeamMemberRoleList.values().stream().map(list -> {
            boolean nonLeftTeamMainRole = list.stream().noneMatch(dbTeamMemberRole -> "1".equals(dbTeamMemberRole.getString("isteammainrole")));
            if (nonLeftTeamMainRole) {
                Optional<DynamicObject> idFirstDy = list.stream().filter(dbTeamMemberRole -> !"1".equals(dbTeamMemberRole.getString("isteammainrole"))).min((dy, dy2) -> dy.getLong("id") - dy2.getLong("id") > 0L ? 1 : -1);
                return idFirstDy.orElse(null);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (nextMainTeamMemberRoleList.size() == 0) {
            return;
        }
        Map<Long, DynamicObject> teamMemberVsTeamMemberRole = nextMainTeamMemberRoleList.stream().collect(Collectors.toMap(teamMemberRole -> teamMemberRole.getLong("teammember.id"), teamMemeRole -> teamMemeRole));
        DynamicObject[] teamMembers = TeamMemberRepository.getInstance().queryById("id, projectrole.id, isprincipal", teamMemberVsTeamMemberRole.keySet());
        Arrays.stream(teamMembers).forEach(teamMember -> {
            long teamMemberId = teamMember.getLong("id");
            DynamicObject teamMemberRole = (DynamicObject)teamMemberVsTeamMemberRole.get(teamMemberId);
            teamMember.set("projectrole", teamMemberRole.get("projectrole"));
            teamMember.set("isprincipal", teamMemberRole.get("isprincipal"));
        });
        TeamMemberRepository.getInstance().update(teamMembers);
        teamMemberVsTeamMemberRole.values().forEach(teamMemberRole -> teamMemberRole.set("isteammainrole", (Object)"1"));
        TeamMemberRoleRepository.getInstance().update(teamMemberVsTeamMemberRole.values().toArray(new DynamicObject[0]));
    }

    private void canCelAllTeamMemberRole(List<CancelBo> cancelAllTeamMemberRoleList) {
        Object[] teamMemberIdArr = cancelAllTeamMemberRoleList.stream().map(CancelBo::getTeamMemberRole).map(dy -> dy.getLong("teammember.id")).distinct().toArray();
        TeamMemberRepository.getInstance().deleteByPks(teamMemberIdArr);
        this.deleteOrUpdateProjectMember(cancelAllTeamMemberRoleList);
    }

    private void deleteOrUpdateProjectMember(List<CancelBo> cancelAllTeamMemberRoleList) {
        List projectMemberIdList = cancelAllTeamMemberRoleList.stream().map(CancelBo::getTeamMemberRole).map(dy -> dy.getLong("projectmember.id")).collect(Collectors.toList());
        Set toBeCancelTeamMemberRoleIdSet = cancelAllTeamMemberRoleList.stream().map(CancelBo::getTeamMemberRole).map(teamMemberRole -> teamMemberRole.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] dbSameProjectMemberTMR = TeamMemberRoleRepository.getInstance().queryByProjectMember("id, projectmember.id, servicestate, quitdate", projectMemberIdList);
        Set canNotDeleteProjectMemberIdSet = Arrays.stream(dbSameProjectMemberTMR).filter(dbTeamMemberRole -> {
            long dbTeamMemberRoleId = dbTeamMemberRole.getLong("id");
            return !toBeCancelTeamMemberRoleIdSet.contains(dbTeamMemberRoleId);
        }).map(dbTeamMemberRole -> dbTeamMemberRole.getLong("projectmember.id")).collect(Collectors.toSet());
        Object[] canDeleteProjectMemberIdArr = cancelAllTeamMemberRoleList.stream().map(CancelBo::getTeamMemberRole).map(dy -> dy.getLong("projectmember.id")).filter(projectMemberId -> !canNotDeleteProjectMemberIdSet.contains(projectMemberId)).distinct().toArray();
        ProjectMemberRepository.getInstance().deleteByPks(canDeleteProjectMemberIdArr);
    }

    private List<CancelBo> analyseCancelScene(DynamicObject[] teamMemberRoles) {
        Set billNoSet = Arrays.stream(teamMemberRoles).map(this::getBillNo).filter(Objects::nonNull).collect(Collectors.toSet());
        DynamicObject[] bills = TeamMemberBillRepository.getInstance().queryByBillNo("id, billno, memberjoinentry.personfield, memberjoinentry.projectrole, memberjoinentry.projectroleother, memberadjjentry.personbaseadja, memberadjjentry.projectroleadja, memberadjaentry.personbaseadj, memberadjaentry.projectroleadjnew", billNoSet);
        Map<String, DynamicObject> billNoVsBill = Arrays.stream(bills).collect(Collectors.toMap(bill -> bill.getString("billno"), bill -> bill));
        return Arrays.stream(teamMemberRoles).map(teamMemberRole -> {
            String billNo = this.getBillNo((DynamicObject)teamMemberRole);
            DynamicObject bill = (DynamicObject)billNoVsBill.get(billNo);
            CancelTypeAndEntryRow cancelTypeAndEntryRow = this.analyseMemberRoleSource(bill, (DynamicObject)teamMemberRole);
            CancelBo cancelBo = new CancelBo();
            cancelBo.setTeamMemberRole(teamMemberRole);
            cancelBo.setCancelType(cancelTypeAndEntryRow.cancelType);
            cancelBo.setEntryRow(cancelTypeAndEntryRow.entryRow);
            cancelBo.setBillNo(bill.getString("billno"));
            return cancelBo;
        }).collect(Collectors.toList());
    }

    private CancelTypeAndEntryRow analyseMemberRoleSource(DynamicObject bill, DynamicObject teamMemberRole) {
        CancelTypeAndEntryRow joinCancelTypeAndEntryRow = this.isMemberJoinCreated(bill, teamMemberRole);
        if (!"-1".equals(joinCancelTypeAndEntryRow.cancelType)) {
            return joinCancelTypeAndEntryRow;
        }
        CancelTypeAndEntryRow adjustACancelTypeAndEntryRow = this.isMemberAdjustACreated(bill, teamMemberRole);
        if (!"-1".equals(adjustACancelTypeAndEntryRow.cancelType)) {
            return adjustACancelTypeAndEntryRow;
        }
        CancelTypeAndEntryRow adjustJCancelTypeAndEntryRow = this.isMemberAdjustJCreated(bill, teamMemberRole);
        if (!"-1".equals(adjustJCancelTypeAndEntryRow.cancelType)) {
            return adjustJCancelTypeAndEntryRow;
        }
        CancelTypeAndEntryRow defaultCancelTypeAndEntryRow = new CancelTypeAndEntryRow();
        defaultCancelTypeAndEntryRow.cancelType = "-1";
        return defaultCancelTypeAndEntryRow;
    }

    private CancelTypeAndEntryRow isMemberAdjustJCreated(DynamicObject bill, DynamicObject teamMemberRole) {
        CancelTypeAndEntryRow cancelTypeAndEntryRow = new CancelTypeAndEntryRow();
        cancelTypeAndEntryRow.cancelType = "3";
        long personId = teamMemberRole.getLong("person.id");
        long projectRoleId = teamMemberRole.getLong("projectrole.id");
        Optional<DynamicObject> matched = bill.getDynamicObjectCollection("memberadjaentry").stream().filter(row -> row.getLong("personbaseadj.person.id") == personId).filter(row -> row.getLong("projectroleadjnew.id") == projectRoleId).findAny();
        if (matched.isPresent()) {
            cancelTypeAndEntryRow.entryRow = matched.get();
        } else {
            cancelTypeAndEntryRow.cancelType = "-1";
        }
        return cancelTypeAndEntryRow;
    }

    private CancelTypeAndEntryRow isMemberAdjustACreated(DynamicObject bill, DynamicObject teamMemberRole) {
        CancelTypeAndEntryRow cancelTypeAndEntryRow = new CancelTypeAndEntryRow();
        cancelTypeAndEntryRow.cancelType = "2";
        long teamMemberId = teamMemberRole.getLong("teammember.id");
        long projectRoleId = teamMemberRole.getLong("projectrole.id");
        Optional<DynamicObject> matched = bill.getDynamicObjectCollection("memberadjjentry").stream().filter(row -> row.getLong("personbaseadja.id") == teamMemberId).filter(row -> row.getLong("projectroleadja.id") == projectRoleId).findAny();
        if (matched.isPresent()) {
            cancelTypeAndEntryRow.entryRow = matched.get();
        } else {
            cancelTypeAndEntryRow.cancelType = "-1";
        }
        return cancelTypeAndEntryRow;
    }

    private CancelTypeAndEntryRow isMemberJoinCreated(DynamicObject bill, DynamicObject teamMemberRole) {
        CancelTypeAndEntryRow cancelTypeAndEntryRow = new CancelTypeAndEntryRow();
        cancelTypeAndEntryRow.cancelType = "1";
        long personId = teamMemberRole.getLong("person.id");
        Optional<DynamicObject> matched = bill.getDynamicObjectCollection("memberjoinentry").stream().filter(row -> row.getLong("personfield.id") == personId).findAny();
        if (matched.isPresent()) {
            cancelTypeAndEntryRow.entryRow = matched.get();
        } else {
            cancelTypeAndEntryRow.cancelType = "-1";
        }
        return cancelTypeAndEntryRow;
    }

    private String getBillNo(DynamicObject teamMemberRole) {
        String joinBillNo = teamMemberRole.getString("joinbillno");
        if (StringUtils.isNotEmpty((CharSequence)joinBillNo)) {
            return joinBillNo;
        }
        String endBillNo = teamMemberRole.getString("endbillno");
        if (StringUtils.isNotEmpty((CharSequence)endBillNo)) {
            return endBillNo;
        }
        return null;
    }

    private boolean allEntryProcessed(DynamicObject teamMemberBill) {
        BiFunction<DynamicObjectCollection, String, Boolean> entryNameVsEntryFieldVsResult = (dynamicCollection, entryField) -> dynamicCollection.stream().map(row -> row.getString(entryField)).allMatch("B"::equals);
        return Stream.of(entryNameVsEntryFieldVsResult.apply(teamMemberBill.getDynamicObjectCollection("memberjoinentry"), "adjuststatusjoin"), entryNameVsEntryFieldVsResult.apply(teamMemberBill.getDynamicObjectCollection("memberadjaentry"), "adjuststatusadj"), entryNameVsEntryFieldVsResult.apply(teamMemberBill.getDynamicObjectCollection("memberadjjentry"), "adjuststatusadja"), entryNameVsEntryFieldVsResult.apply(teamMemberBill.getDynamicObjectCollection("memberadjqentry"), "adjuststatusadjq"), entryNameVsEntryFieldVsResult.apply(teamMemberBill.getDynamicObjectCollection("memberquitentry"), "adjuststatusquit")).allMatch(processedFlag -> processedFlag);
    }

    private boolean oneEntryProcessed(DynamicObject teamMemberBill) {
        BiFunction<DynamicObjectCollection, String, Boolean> entryNameVsEntryFieldVsResult = (dynamicCollection, entryField) -> dynamicCollection.stream().map(row -> row.getString(entryField)).anyMatch("B"::equals);
        return Stream.of(entryNameVsEntryFieldVsResult.apply(teamMemberBill.getDynamicObjectCollection("memberjoinentry"), "adjuststatusjoin"), entryNameVsEntryFieldVsResult.apply(teamMemberBill.getDynamicObjectCollection("memberadjaentry"), "adjuststatusadj"), entryNameVsEntryFieldVsResult.apply(teamMemberBill.getDynamicObjectCollection("memberadjjentry"), "adjuststatusadja"), entryNameVsEntryFieldVsResult.apply(teamMemberBill.getDynamicObjectCollection("memberadjqentry"), "adjuststatusadjq"), entryNameVsEntryFieldVsResult.apply(teamMemberBill.getDynamicObjectCollection("memberquitentry"), "adjuststatusquit")).anyMatch(processedFlag -> processedFlag);
    }

    static class CancelTypeAndEntryRow {
        DynamicObject entryRow;
        String cancelType;

        CancelTypeAndEntryRow() {
        }
    }
}

