/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.domain.adapter;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.ptmm.business.domain.bo.TeamMemberRoleHisBO;
import kd.hr.ptmm.business.domain.repository.ProjectMemberRepository;
import kd.hr.ptmm.business.domain.service.ChangeMemberHisFunc;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.common.constants.member.TeamMemberRoleHisConstants;
import kd.hr.ptmm.common.enums.PersonServiceStatusEnum;
import kd.hr.ptmm.common.util.PropUtils;
import kd.hr.ptmm.common.util.PtmmDateUtils;

public class TeamMemberRoleHisServiceAdapter
implements TeamMemberRoleHisConstants {
    private static final Log LOG = LogFactory.getLog(TeamMemberRoleHisServiceAdapter.class);

    public void createRoleHisByTeamMemberRole(List<DynamicObject> teamMemberRoleDOList) {
        if (CollectionUtils.isEmpty(teamMemberRoleDOList)) {
            return;
        }
        LOG.info("createRoleHisByTeamMemberRole teamMemberRoleId:{}", teamMemberRoleDOList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        List<DynamicObject> workRoleDOList = teamMemberRoleDOList.stream().map(teamMemberRoleDO -> teamMemberRoleDO.getDynamicObject("projectrole")).collect(Collectors.toList());
        Map<Long, Long> work2ProjectRole = PTMMServiceFactory.workRoleHrService.getProjectRoleByWorkRole(workRoleDOList);
        Map<Long, String> memberRole2ProjectIdentifyMap = this.getMemberRole2ProjectIdentify(teamMemberRoleDOList);
        List<TeamMemberRoleHisBO> teamMemberRoleHisBOList = teamMemberRoleDOList.stream().filter(teamMemberRoleDO -> HRStringUtils.equals((String)teamMemberRoleDO.getString("servicestate"), (String)PersonServiceStatusEnum.SERVING.getCode())).map(teamMemberRoleDO -> new TeamMemberRoleHisBO().setProjectTeamId(this.getPropertyId((DynamicObject)teamMemberRoleDO, "projectteam")).setWorkRoleId(this.getPropertyId((DynamicObject)teamMemberRoleDO, "projectrole")).setProjectRoleId((Long)work2ProjectRole.get(this.getPropertyId((DynamicObject)teamMemberRoleDO, "projectrole"))).setProjectMemberId(this.getPropertyId((DynamicObject)teamMemberRoleDO, "projectmember")).setTeamMemberId(this.getPropertyId((DynamicObject)teamMemberRoleDO, "teammember")).setTeamMemberRoleId(teamMemberRoleDO.getLong("id")).setTeamMainRole(teamMemberRoleDO.getBoolean("isteammainrole")).setPrincipal(teamMemberRoleDO.getBoolean("isprincipal")).setServiceState(teamMemberRoleDO.getString("servicestate")).setStartDate(teamMemberRoleDO.getDate("joindate")).setEndDate(teamMemberRoleDO.getDate("quitdate")).setProjectName(teamMemberRoleDO.getLocaleString("projectname")).setPersonId(this.getPropertyId((DynamicObject)teamMemberRoleDO, "person")).setProjectTeamBoId(this.getPropertyId((DynamicObject)teamMemberRoleDO, "projectteam")).setProjectRoleBoId((Long)work2ProjectRole.get(this.getPropertyId((DynamicObject)teamMemberRoleDO, "projectrole"))).setProjectIdentify((String)memberRole2ProjectIdentifyMap.get(teamMemberRoleDO.getLong("id")))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(teamMemberRoleHisBOList)) {
            LOG.warn("createRoleHisByTeamMemberRole no suitable teamMemberRole");
            return;
        }
        PTMMServiceFactory.memberRoleHisService.createRoleHisObj(teamMemberRoleHisBOList);
    }

    public void quitRoleHisByTeamMemberRole(List<DynamicObject> teamMemberRoleDOList) {
        if (CollectionUtils.isEmpty(teamMemberRoleDOList)) {
            LOG.warn("quitRoleHisByTeamMemberRole no data,time:{}", (Object)LocalDate.now());
            return;
        }
        LOG.info("quitRoleHisByTeamMemberRole.param:{}", teamMemberRoleDOList.stream().map(dy -> dy.get("id")).collect(Collectors.toList()));
        ArrayList<ChangeMemberHisFunc<DynamicObject[]>> funcList = new ArrayList<ChangeMemberHisFunc<DynamicObject[]>>(10);
        teamMemberRoleDOList.stream().collect(Collectors.groupingBy(dy -> {
            Date quitDate = dy.getDate("quitdate");
            return PtmmDateUtils.date2LocalDate((Date)quitDate);
        })).forEach((quitLocalDate, memberRoleDOList) -> {
            Date quitDate = HRDateTimeUtils.localDate2Date((LocalDate)quitLocalDate);
            List<Long> teamMemberRoleIdList = memberRoleDOList.stream().map(teamMemberRoleDO -> teamMemberRoleDO.getLong("id")).collect(Collectors.toList());
            ChangeMemberHisFunc<DynamicObject[]> changeMemberHisFunc = ChangeMemberHisFunc.changeByTeamMemberRole(teamMemberRoleIdList, quitLocalDate, teamMemberRoleHisDOArr -> {
                for (DynamicObject teamMemberRoleHisDO : teamMemberRoleHisDOArr) {
                    teamMemberRoleDOList.stream().filter(role -> role.getLong("id") == teamMemberRoleHisDO.getLong(PropUtils.getIdDot((String)"teammemberrole"))).findFirst().ifPresent(teamMemberRoleDO -> {
                        Objects.requireNonNull(quitDate);
                        teamMemberRoleHisDO.set("servicestate", (Object)PersonServiceStatusEnum.EXITED.getCode());
                        if (HRDateTimeUtils.dayAfter((Date)quitDate, (Date)teamMemberRoleHisDO.getDate("startdate")) || HRDateTimeUtils.dayEquals((Date)quitDate, (Date)teamMemberRoleHisDO.getDate("startdate"))) {
                            teamMemberRoleHisDO.set("bsed", (Object)quitDate);
                            teamMemberRoleHisDO.set("enddate", (Object)quitDate);
                        }
                        teamMemberRoleHisDO.set("bsled", (Object)HRDateTimeUtils.getSysMaxDate());
                    });
                }
            });
            funcList.add(changeMemberHisFunc);
        });
        PTMMServiceFactory.memberRoleHisService.changeRoleHisVersion(funcList);
    }

    private Map<Long, String> getMemberRole2ProjectIdentify(List<DynamicObject> teamMemberRoleDOList) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)teamMemberRoleDOList.size());
        List projectMemberIdList = teamMemberRoleDOList.stream().map(dynamicObject -> this.getPropertyId((DynamicObject)dynamicObject, "projectmember")).collect(Collectors.toList());
        QFilter idsQFilter = new QFilter("id", "in", projectMemberIdList);
        DynamicObject[] projectMemberDOArr = ProjectMemberRepository.getInstance().query("projectidentify", idsQFilter.toArray());
        for (DynamicObject teamMemberRoleDO : teamMemberRoleDOList) {
            Long projectMemberId = this.getPropertyId(teamMemberRoleDO, "projectmember");
            if (Objects.isNull(projectMemberId)) continue;
            Arrays.stream(projectMemberDOArr).filter(dynamicObject -> dynamicObject.getLong("id") == projectMemberId.longValue()).findFirst().ifPresent(projectMemberDO -> map.put(teamMemberRoleDO.getLong("id"), projectMemberDO.getString("projectidentify")));
        }
        return map;
    }

    private Long getPropertyId(DynamicObject dynamicObject, String property) {
        Object object = dynamicObject.get(property);
        if (object instanceof DynamicObject) {
            return ((DynamicObject)object).getLong("id");
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        return null;
    }
}

