/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.domain.repository;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.ptmm.common.constants.member.TeamMemberConstants;
import org.apache.commons.collections.CollectionUtils;

public class ProjectMemberRepository
extends HRBaseServiceHelper
implements TeamMemberConstants {
    private static final ProjectMemberRepository INSTANCE = new ProjectMemberRepository("ptmm_projectmember");

    public static ProjectMemberRepository getInstance() {
        return INSTANCE;
    }

    public ProjectMemberRepository(String entityName) {
        super(entityName);
    }

    private QFilter getCurVersionQFilter() {
        return new QFilter("iscurrentversion", "=", (Object)"1");
    }

    public DynamicObject[] listProjectMember(String projectIdentify) {
        QFilter projectNameFilter = new QFilter("projectidentify", "=", (Object)projectIdentify);
        return this.loadDynamicObjectArray(new QFilter[]{projectNameFilter, INSTANCE.getCurVersionQFilter()});
    }

    public DynamicObject[] listProjectMember(Collection<String> projectNames, List<Long> personIds) {
        QFilter projectNameFilter = new QFilter("projectidentify", "in", projectNames);
        QFilter personFilter = new QFilter("person.id", "in", personIds);
        QFilter serviceStatusFilter = new QFilter("servicestate", "!=", (Object)"C");
        return this.loadDynamicObjectArray(new QFilter[]{projectNameFilter, INSTANCE.getCurVersionQFilter(), personFilter, serviceStatusFilter});
    }

    public DynamicObject[] listProjectMember(Set<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new DynamicObject[0];
        }
        String selectProperties = String.join((CharSequence)",", "servicestate", "quitdate");
        QFilter idsQFilter = new QFilter("id", "in", ids);
        return this.query(selectProperties, new QFilter[]{idsQFilter, this.getCurVersionQFilter()});
    }

    public void deleteByPks(Object[] pks) {
        this.delete(pks);
    }

    public DynamicObject[] queryOriginalByProjectIdentifyAndPersonIds(String selectFields, Set<Long> personIdSet, String projectIdentify) {
        QFilter personFilter = new QFilter("person", "in", personIdSet);
        QFilter projectFilter = new QFilter("projectidentify", "=", (Object)projectIdentify);
        return this.queryOriginalArray(selectFields, new QFilter[]{personFilter, projectFilter, INSTANCE.getCurVersionQFilter()});
    }

    public DynamicObject[] queryById(String selectFields, Collection<Long> idCollection) {
        QFilter idFilter = new QFilter("id", "in", idCollection);
        return this.query(selectFields, new QFilter[]{idFilter});
    }

    public DynamicObject[] loadMemberHisByPersonIds(Collection<Long> personIds, boolean isQuit) {
        String[] stringArray;
        QFilter personIdFilter = new QFilter("person.id", "in", personIds);
        personIdFilter.and("iscurrentversion", "=", (Object)"1");
        if (isQuit) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "A";
            stringArray = stringArray2;
            stringArray2[1] = "B";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "C";
        }
        String[] serviceStatus = stringArray;
        personIdFilter.and("servicestate", "in", (Object)serviceStatus);
        return this.loadDynamicObjectArray(new QFilter[]{personIdFilter});
    }
}

