/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.domain.repository;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.ptmm.common.enums.AdjustStatusEnum;

public class TeamMemberBillRepository
extends HRBaseServiceHelper {
    private static final TeamMemberBillRepository INSTANCE = new TeamMemberBillRepository("ptmm_teammemberbill");

    public static TeamMemberBillRepository getInstance() {
        return INSTANCE;
    }

    public TeamMemberBillRepository(String entityName) {
        super(entityName);
    }

    public DynamicObject[] queryAlrSubmitBill() {
        QFilter statusQFilter = new QFilter("adjuststatus", "in", (Object)Lists.newArrayList((Object[])new String[]{AdjustStatusEnum.ALREADYSUBMIT.getCode(), AdjustStatusEnum.WAITPROCESS.getCode()}));
        return this.loadDynamicObjectArray(new QFilter[]{statusQFilter});
    }

    public DynamicObject[] listTeamMemberBill(Long projectTeamId) {
        QFilter projectNameFilter = new QFilter("projectteam.id", "in", (Object)projectTeamId);
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"A");
        return INSTANCE.query("fid,projectname", new QFilter[]{projectNameFilter, billStatusFilter});
    }

    public DynamicObject[] querySubmittedByCancelToBeJoinedPersonNumberAndProjectTeamId(String selectFields, long projectTeamId, Set<String> personNumberSet) {
        QFilter projectTeamIdFilter = new QFilter("projectteam", "=", (Object)projectTeamId);
        QFilter joinPersonNumberFilter = new QFilter("memberjoinentry.personfield.number", "in", personNumberSet);
        QFilter submittedFilter = new QFilter("adjuststatus", "in", (Object)new String[]{AdjustStatusEnum.ALREADYSUBMIT.getCode(), AdjustStatusEnum.WAITPROCESS.getCode()});
        return INSTANCE.query(selectFields, new QFilter[]{projectTeamIdFilter, joinPersonNumberFilter, submittedFilter});
    }

    public DynamicObject[] queryByPk(String selectFields, Set<Long> billIdSet) {
        QFilter idFilter = new QFilter("id", "in", billIdSet);
        return INSTANCE.query(selectFields, new QFilter[]{idFilter});
    }

    public DynamicObject queryOriginalOneByPk(String selectFields, Object billId) {
        QFilter idFilter = new QFilter("id", "=", billId);
        return INSTANCE.queryOriginalOne(selectFields, new QFilter[]{idFilter});
    }

    public DynamicObject[] queryByBillNo(String selectFields, Collection<String> billNoCollection) {
        QFilter billNoFilter = new QFilter("billno", "in", billNoCollection);
        return INSTANCE.query(selectFields, new QFilter[]{billNoFilter});
    }
}

