/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.domain.repository;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.ptmm.common.constants.member.TeamMemberConstants;

public class TeamMemberRepository
extends HRBaseServiceHelper
implements TeamMemberConstants {
    private static final TeamMemberRepository INSTANCE = new TeamMemberRepository("ptmm_teammember");

    public static TeamMemberRepository getInstance() {
        return INSTANCE;
    }

    public TeamMemberRepository(String entityName) {
        super(entityName);
    }

    private QFilter getCurVersionQFilter() {
        return new QFilter("iscurrentversion", "=", (Object)"1");
    }

    public DynamicObject[] listTeamMember(List<Long> teamIds, List<Long> personIds) {
        return this.query("projectmember,person,projectteam,servicestate,joindate,quitdate,isprincipal,projectrole,belongadminorg", new QFilter[]{new QFilter("projectteam.id", "in", teamIds), new QFilter("person.id", "in", personIds), new QFilter("servicestate", "=", (Object)"B")});
    }

    public DynamicObject[] listTeamMember(List<Long> teamIds) {
        return this.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", teamIds)});
    }

    public DynamicObject[] listNoQuitTeamMember(Set<Long> projectMemberIds) {
        String selectProperties = String.join((CharSequence)",", "servicestate", "quitdate", "projectmember", "endbillno");
        QFilter idsQFilter = new QFilter("projectmember", "in", projectMemberIds);
        QFilter serviceStateQFilter = new QFilter("servicestate", "in", (Object)Lists.newArrayList((Object[])new String[]{"A", "B"}));
        return this.query(selectProperties, new QFilter[]{idsQFilter, serviceStateQFilter, this.getCurVersionQFilter()});
    }

    public DynamicObject[] listByTeamIds(Set<Long> teamIds) {
        String selectProperties = String.join((CharSequence)",", "person,projectteam");
        QFilter projectTeamIdsQFilter = new QFilter("projectteam", "in", teamIds);
        QFilter serviceStateQFilter = new QFilter("servicestate", "in", (Object)Lists.newArrayList((Object[])new String[]{"B"}));
        return this.query(selectProperties, new QFilter[]{projectTeamIdsQFilter, serviceStateQFilter});
    }

    public DynamicObject[] queryOriginalByDepemp(String selectFields, Set<Long> depempSet) {
        QFilter depempFilter = new QFilter("depemp", "in", depempSet);
        return this.queryOriginalArray(selectFields, new QFilter[]{depempFilter});
    }

    public void deleteByPks(Object[] pks) {
        this.delete(pks);
    }

    public DynamicObject[] queryById(String selectFields, Collection<Long> idCollection) {
        QFilter idFilter = new QFilter("id", "in", idCollection);
        return this.query(selectFields, new QFilter[]{idFilter});
    }

    public DynamicObject[] listTeamMemberByProjectMemberId(Set<Long> projectMemberIds, boolean isQuit) {
        String[] stringArray;
        QFilter idsQFilter = new QFilter("projectmember", "in", projectMemberIds);
        if (isQuit) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "A";
            stringArray = stringArray2;
            stringArray2[1] = "B";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "C";
        }
        String[] serviceStatus = stringArray;
        idsQFilter.and("servicestate", "in", (Object)serviceStatus);
        return this.loadDynamicObjectArray(new QFilter[]{idsQFilter, this.getCurVersionQFilter()});
    }
}

