/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.domain.repository;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.ptmm.common.constants.member.TeamMemberRoleConstants;
import kd.hr.ptmm.common.enums.PersonServiceStatusEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class TeamMemberRoleRepository
extends HRBaseServiceHelper
implements TeamMemberRoleConstants {
    private static final TeamMemberRoleRepository INSTANCE = new TeamMemberRoleRepository("ptmm_teammemberrole");

    public static TeamMemberRoleRepository getInstance() {
        return INSTANCE;
    }

    public TeamMemberRoleRepository(String entityName) {
        super("ptmm_teammemberrole");
    }

    private QFilter getCurVersionQFilter() {
        return new QFilter("iscurrentversion", "=", (Object)"1");
    }

    public DynamicObject[] listTeamMemberRole(List<Long> roleIds) {
        return this.query("id,person,joindate,quitdate,isprincipal,isteammainrole,joinbillno,endbillno,teammember,servicestate,projectteam,projectrole,adjustreason,modifier,modifytime,disabledate,firstbsed,changebsed,bred,brled,brfd,boid,datastatus", new QFilter[]{new QFilter("id", "in", roleIds), this.getCurVersionQFilter()});
    }

    public DynamicObject[] listTeamMemberRoleByProjectMemberId(List<Long> projectMemberIds) {
        return this.query("id,person,joindate,quitdate,isprincipal,isteammainrole,joinbillno,endbillno,teammember,servicestate,projectteam,projectrole,adjustreason,modifier,modifytime,projectmember.id,projectmember.servicestate,projectmember.joindate,projectmember.quitdate,disabledate,firstbsed,changebsed,bred,brled,brfd,boid,datastatus", new QFilter[]{new QFilter("projectmember.id", "in", projectMemberIds), this.getCurVersionQFilter()});
    }

    public DynamicObject[] listTeamMemberRoleArr(List<Long> roleIds) {
        return this.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", roleIds), this.getCurVersionQFilter()});
    }

    public DynamicObject[] listTeamMemberRoleArrByBillNo(String[] billNos) {
        QFilter serviceStatusFilter = new QFilter("servicestate", "!=", (Object)"C");
        QFilter joinBillFilter = new QFilter("joinbillno", "in", (Object)billNos);
        QFilter quitBillFilter = new QFilter("endbillno", "in", (Object)billNos);
        return this.loadDynamicObjectArray(new QFilter[]{serviceStatusFilter, joinBillFilter.or(quitBillFilter), this.getCurVersionQFilter()});
    }

    public DynamicObject[] listOtherRoleByBillNos(String[] billNos) {
        QFilter quitBillFilter = new QFilter("endbillno", "in", (Object)billNos);
        QFilter isTeamMainRoleQFilter = new QFilter("isteammainrole", "=", (Object)"0");
        return this.loadDynamicObjectArray(new QFilter[]{quitBillFilter, isTeamMainRoleQFilter, this.getCurVersionQFilter()});
    }

    public DynamicObject[] listTeamMemberRoleTriple(List<Triple<Long, Long, Long>> uniqueKey) {
        List personIds = uniqueKey.stream().map(Triple::getLeft).collect(Collectors.toList());
        List teamIds = uniqueKey.stream().map(Triple::getMiddle).collect(Collectors.toList());
        List roleIds = uniqueKey.stream().map(Triple::getRight).collect(Collectors.toList());
        QFilter serviceStatusFilter = new QFilter("servicestate", "!=", (Object)"C");
        QFilter personFilter = new QFilter("person.id", "in", personIds);
        QFilter teamFilter = new QFilter("projectteam.id", "in", teamIds);
        QFilter roleFilter = new QFilter("projectrole.id", "in", roleIds);
        return this.queryOriginalArray("id,person.id person_id, projectrole.mainpeoincharge mainpeoincharge,projectrole.id projectrole_id,projectteam.id projectteam_id, projectteam.belongadminorg.id belongadminorg_id", new QFilter[]{serviceStatusFilter, personFilter, teamFilter, roleFilter, this.getCurVersionQFilter()});
    }

    public Map<Pair<Long, Long>, DynamicObject> listTeamMemberRoleMap(List<Long> roleIds) {
        DynamicObject[] projectMemberObjs = this.listTeamMemberRole(roleIds);
        return Arrays.stream(projectMemberObjs).collect(Collectors.toMap(obj -> Pair.of((Object)obj.getLong("id"), (Object)obj.getLong("id")), obj -> obj, (v1, v2) -> v1));
    }

    public DynamicObject[] listNoQuitTeamMemberRole(Set<Long> teamMemberIds) {
        if (CollectionUtils.isEmpty(teamMemberIds)) {
            return new DynamicObject[0];
        }
        String selectProperties = String.join((CharSequence)",", "servicestate", "quitdate", "teammember", "projectmember", "endbillno", "isteammainrole", "person", "personrolerel");
        QFilter teamMemberIdsQFilter = new QFilter("teammember", "in", teamMemberIds);
        QFilter serviceStateQFilter = new QFilter("servicestate", "in", (Object)Lists.newArrayList((Object[])new String[]{"B"}));
        return this.query(selectProperties, new QFilter[]{teamMemberIdsQFilter, serviceStateQFilter, this.getCurVersionQFilter()});
    }

    public DynamicObject[] listOtherRole(Set<Long> teamMemberIds) {
        if (CollectionUtils.isEmpty(teamMemberIds)) {
            return new DynamicObject[0];
        }
        QFilter teamMemberIdsQFilter = new QFilter("teammember", "in", teamMemberIds);
        QFilter isTeamMainRoleQFilter = new QFilter("isteammainrole", "=", (Object)"0");
        QFilter serviceStateQFilter = new QFilter("servicestate", "in", (Object)Lists.newArrayList((Object[])new String[]{"B"}));
        return this.query("projectrole,teammember,person", new QFilter[]{teamMemberIdsQFilter, isTeamMainRoleQFilter, serviceStateQFilter, this.getCurVersionQFilter()});
    }

    public DynamicObject[] listNoQuitProjectMemberRole(Set<Long> projectMemberIds, Set<Long> quitTeamMemberIds) {
        if (CollectionUtils.isEmpty(projectMemberIds)) {
            return new DynamicObject[0];
        }
        String selectProperties = String.join((CharSequence)",", "projectmember,servicestate");
        QFilter projectTeamMemberIdsQFilter = new QFilter("projectmember", "in", projectMemberIds);
        QFilter teamMemberIdsQFilter = new QFilter("teammember", "not in", quitTeamMemberIds);
        QFilter serviceStateQFilter = new QFilter("servicestate", "in", (Object)Lists.newArrayList((Object[])new String[]{"A", "B"}));
        return this.query(selectProperties, new QFilter[]{projectTeamMemberIdsQFilter, teamMemberIdsQFilter, serviceStateQFilter, this.getCurVersionQFilter()});
    }

    public DynamicObject[] listQuitProjectMemberRole(Set<Long> projectMemberIds, Set<Long> quitTeamMemberIds) {
        if (CollectionUtils.isEmpty(projectMemberIds)) {
            return new DynamicObject[0];
        }
        String selectProperties = String.join((CharSequence)",", "projectmember,servicestate");
        QFilter projectTeamMemberIdsQFilter = new QFilter("projectmember", "in", projectMemberIds);
        QFilter teamMemberIdsQFilter = new QFilter("teammember", "in", quitTeamMemberIds);
        QFilter serviceStateQFilter = new QFilter("servicestate", "in", (Object)Lists.newArrayList((Object[])new String[]{"A"}));
        return this.query(selectProperties, new QFilter[]{projectTeamMemberIdsQFilter, teamMemberIdsQFilter, serviceStateQFilter, this.getCurVersionQFilter()});
    }

    public DynamicObject[] getOtherRoleByTeamMember(long teamMemberId) {
        QFilter statusQFilter = new QFilter("servicestate", "=", (Object)PersonServiceStatusEnum.SERVING.getCode());
        QFilter teamMemberQFilter = new QFilter("teammember", "=", (Object)teamMemberId);
        QFilter otherRoleQFilter = new QFilter("isteammainrole", "=", (Object)"0");
        return TeamMemberRoleRepository.getInstance().query("projectrole", new QFilter[]{statusQFilter, teamMemberQFilter, otherRoleQFilter});
    }

    public DynamicObject[] queryOriginalByTeamMember(String selectFields, Set<Long> teamMemberSet) {
        QFilter teamMemberQFilter = new QFilter("teammember", "in", teamMemberSet);
        return this.queryOriginalArray(selectFields, new QFilter[]{teamMemberQFilter});
    }

    public DynamicObject[] getProjectTeamMainRole(List<Long> projectTeamIds, List<Long> personIds) {
        return this.query("projectteam.id,person.id,teammember.id,createtime,servicestate,joindate", new QFilter[]{new QFilter("projectteam.id", "in", projectTeamIds), new QFilter("person.id", "in", personIds), new QFilter("isteammainrole", "=", (Object)"1"), new QFilter("servicestate", "!=", (Object)"C")});
    }

    public DynamicObject[] listByTeamIds(Set<Long> teamIds) {
        QFilter projectTeamIdsQFilter = new QFilter("projectteam", "in", teamIds);
        QFilter serviceStateQFilter = new QFilter("servicestate", "in", (Object)Lists.newArrayList((Object[])new String[]{"B"}));
        return this.query("projectrole,projectteam,person", new QFilter[]{projectTeamIdsQFilter, serviceStateQFilter});
    }

    public DynamicObject[] listMemberRoleByProjectMemberId(long id) {
        QFilter projectMemberId = new QFilter("projectmember.id", "=", (Object)id);
        return this.listMemberRoleByProjectMemberId(new QFilter[]{projectMemberId, this.getCurVersionQFilter()});
    }

    public DynamicObject[] listMemberRoleByProjectMemberIds(List<Long> ids) {
        QFilter projectMemberIds = new QFilter("projectmember.id", "in", ids);
        return this.listMemberRoleByProjectMemberId(new QFilter[]{projectMemberIds, this.getCurVersionQFilter()});
    }

    public DynamicObject[] listMemberRoleByProjectMemberId(QFilter[] filters) {
        return this.query("id,projectmember,joindate,quitdate,servicestate", filters);
    }

    public void deleteByPks(Object[] pks) {
        this.delete(pks);
    }

    public DynamicObject[] queryOriginalByPersonIds(String selectFields, Set<Long> personIdSet) {
        QFilter personFilter = new QFilter("person", "in", personIdSet);
        return this.queryOriginalArray(selectFields, new QFilter[]{personFilter});
    }

    public DynamicObject[] queryOriginalByProjectTeamAndPersonIds(String selectFields, Set<Long> personIdSet, long projectTeamId) {
        QFilter personFilter = new QFilter("person", "in", personIdSet);
        QFilter projectTeamFilter = new QFilter("projectteam", "=", (Object)projectTeamId);
        return this.queryOriginalArray(selectFields, new QFilter[]{personFilter, projectTeamFilter, INSTANCE.getCurVersionQFilter()});
    }

    public DynamicObject[] queryById(String selectFields, Collection<Long> idCollection) {
        QFilter idFilter = new QFilter("id", "in", idCollection);
        return this.query(selectFields, new QFilter[]{idFilter});
    }

    public DynamicObject[] queryToBeEffectByTeamMember(String selectFields, Collection<Long> teamMemberIdCollection) {
        QFilter teamMemberFilter = new QFilter("teammember", "in", teamMemberIdCollection);
        QFilter serviceStatusFilter = new QFilter("servicestate", "=", (Object)"A");
        return this.query(selectFields, new QFilter[]{teamMemberFilter, serviceStatusFilter});
    }

    public DynamicObject[] queryByProjectMember(String selectFields, Collection<Long> projectMemberIdCollection) {
        QFilter projectMemberFilter = new QFilter("projectmember", "in", projectMemberIdCollection);
        return this.query(selectFields, new QFilter[]{projectMemberFilter});
    }

    public DynamicObject[] loadTeamMemberRoleByTeamMemberId(Set<Long> teamMemberIds, boolean isQuit) {
        String[] stringArray;
        QFilter teamMemberIdsQFilter = new QFilter("projectmember", "in", teamMemberIds);
        if (isQuit) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "A";
            stringArray = stringArray2;
            stringArray2[1] = "B";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "C";
        }
        String[] serviceStatus = stringArray;
        QFilter serviceStateQFilter = new QFilter("servicestate", "in", (Object)serviceStatus);
        return this.loadDynamicObjectArray(new QFilter[]{teamMemberIdsQFilter, serviceStateQFilter, this.getCurVersionQFilter()});
    }
}

