/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.domain.service;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.ptmm.business.domain.validator.DyObjValidateContext;
import kd.hr.ptmm.business.domain.validator.ValidateContext;

public interface IPreOpValidateService {
    default public boolean preOpValidate(List<DynamicObject> bills, List<DyObjValidateContext> dyObjValidateContexts, String operationKey, String entityNumber, String currAppId) {
        List ids = bills.stream().map(temp -> (Long)temp.get("id")).collect(Collectors.toList());
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("currbizappid", currAppId);
        OperationResult opResult = OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])ids.toArray(), (OperateOption)operateOption);
        List allErrorOrValidateInfo = opResult.getAllErrorOrValidateInfo();
        if (!CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
            HashMap failId2ErrorMsg = Maps.newHashMapWithExpectedSize((int)bills.size());
            allErrorOrValidateInfo.stream().forEach(iOperateInfo -> failId2ErrorMsg.put(iOperateInfo.getPkValue().toString(), iOperateInfo.getMessage()));
            dyObjValidateContexts.forEach(dyObjValidateContext -> {
                if (failId2ErrorMsg.containsKey(dyObjValidateContext.getDynamicObject().getString("id"))) {
                    ValidateContext validatorContext = dyObjValidateContext.getValidatorContext();
                    Map<String, String> validateResult = validatorContext.getValidateResult();
                    validateResult.put("id", (String)failId2ErrorMsg.get(dyObjValidateContext.getDynamicObject().getString("id")));
                }
            });
            return false;
        }
        return true;
    }
}

