/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.domain.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.ptmm.business.domain.bo.MainRoleSynModel;
import kd.hr.ptmm.business.domain.bo.TeamMemberRoleHisBO;
import kd.hr.ptmm.business.domain.repository.TeamMemberRepository;
import kd.hr.ptmm.business.domain.repository.TeamMemberRoleHisRepository;
import kd.hr.ptmm.business.domain.repository.TeamMemberRoleRepository;
import kd.hr.ptmm.business.domain.service.ChangeMemberHisFunc;
import kd.hr.ptmm.business.domain.service.impl.TeamMemberRoleHisServiceImpl;
import kd.hr.ptmm.business.util.IdCreator;

public class MainRoleSynService {
    MainRoleSynModel mainRoleSynModel;
    IdCreator idCreator = new IdCreator();
    Date now;

    public MainRoleSynService(MainRoleSynModel mainRoleSynModel) {
        this.mainRoleSynModel = mainRoleSynModel;
    }

    public void update2MainRole() {
        this.init();
        Map<Long, Date> nextMainTeamMemberRoleVsConstituteDate = this.mainRoleSynModel.getNextMainTeamMemberRoleVsConstituteDate();
        Set<Long> nextMainTeamMemberRoleSet = nextMainTeamMemberRoleVsConstituteDate.keySet();
        if (nextMainTeamMemberRoleSet.size() == 0) {
            return;
        }
        DynamicObject[] teamMemberRoles = TeamMemberRoleRepository.getInstance().loadDynamicObjectArray(nextMainTeamMemberRoleSet.toArray(new Object[0]));
        List<DynamicObject> copyTeamMemberRoleList = Arrays.stream(teamMemberRoles).map(teamMemberRole -> {
            DynamicObject tempTeamMemberRole = TeamMemberRoleRepository.getInstance().generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)teamMemberRole, (DynamicObject)tempTeamMemberRole);
            tempTeamMemberRole.set("id", (Object)teamMemberRole.getLong("id"));
            return tempTeamMemberRole;
        }).collect(Collectors.toList());
        Map<Long, Long> teamMemberRoleIdVsNewTeamMemberId = Arrays.stream(teamMemberRoles).collect(Collectors.toMap(teamMemberRole -> teamMemberRole.getLong("id"), teamMemberRole -> this.idCreator.getId()));
        Map<Long, Long> teamMemberRoleIdVsNewTeamMemberRoleId = Arrays.stream(teamMemberRoles).collect(Collectors.toMap(teamMemberRole -> teamMemberRole.getLong("id"), teamMemberRole -> this.idCreator.getId()));
        this.updateOrAddTeamMemberRole(teamMemberRoles, teamMemberRoleIdVsNewTeamMemberId, teamMemberRoleIdVsNewTeamMemberRoleId);
        this.addTeamMember(copyTeamMemberRoleList, teamMemberRoleIdVsNewTeamMemberId);
        this.changeOrAddTeamMemberRoleHis(nextMainTeamMemberRoleSet, teamMemberRoleIdVsNewTeamMemberId, teamMemberRoleIdVsNewTeamMemberRoleId);
    }

    private void changeOrAddTeamMemberRoleHis(Set<Long> nextMainTeamMemberRoleSet, Map<Long, Long> teamMemberRoleIdVsNewTeamMemberId, Map<Long, Long> teamMemberRoleIdVsNewTeamMemberRoleId) {
        Map<Long, Date> nextMainTeamMemberRoleVsConstituteDate = this.mainRoleSynModel.getNextMainTeamMemberRoleVsConstituteDate();
        ArrayList changeTeamMemberRoleHisList = new ArrayList();
        ArrayList<TeamMemberRoleHisBO> addTeamMemberRoleHisBOList = new ArrayList<TeamMemberRoleHisBO>();
        DynamicObject[] teamMemberRoleHiss = TeamMemberRoleHisRepository.getInstance().loadCurrentVersionByTeamMemberRoleId(nextMainTeamMemberRoleSet);
        Arrays.stream(teamMemberRoleHiss).forEach(teamMemberRoleHis -> {
            Date startDate = teamMemberRoleHis.getDate("startdate");
            long teamMemberRoleId = teamMemberRoleHis.getLong("teammemberrole.id");
            Date newStartDate = (Date)nextMainTeamMemberRoleVsConstituteDate.get(teamMemberRoleId);
            if (newStartDate.after(startDate)) {
                TeamMemberRoleHisBO teamMemberRoleHisBO = new TeamMemberRoleHisBO();
                teamMemberRoleHisBO.setPersonId(teamMemberRoleHis.getLong("person.id"));
                teamMemberRoleHisBO.setPrincipal(teamMemberRoleHis.getBoolean("isprincipal"));
                teamMemberRoleHisBO.setProjectIdentify(teamMemberRoleHis.getString("projectidentify"));
                teamMemberRoleHisBO.setProjectMemberId(teamMemberRoleHis.getLong("projectmember.id"));
                teamMemberRoleHisBO.setProjectName(teamMemberRoleHis.getLocaleString("projectname"));
                teamMemberRoleHisBO.setProjectRoleBoId(teamMemberRoleHis.getLong("projectroleboid"));
                teamMemberRoleHisBO.setProjectRoleId(teamMemberRoleHis.getLong("projectrole.id"));
                teamMemberRoleHisBO.setProjectTeamBoId(teamMemberRoleHis.getLong("projectteamboid"));
                teamMemberRoleHisBO.setProjectTeamId(teamMemberRoleHis.getLong("projectteam.id"));
                teamMemberRoleHisBO.setServiceState(teamMemberRoleHis.getString("servicestate"));
                teamMemberRoleHisBO.setWorkRoleId(teamMemberRoleHis.getLong("workrole.id"));
                teamMemberRoleHisBO.setBelongAdminOrgId(teamMemberRoleHis.getLong("belongadminorg.id"));
                teamMemberRoleHisBO.setEndDate(teamMemberRoleHis.getDate("enddate"));
                teamMemberRoleHisBO.setStartDate(newStartDate);
                teamMemberRoleHisBO.setTeamMemberRoleId((Long)teamMemberRoleIdVsNewTeamMemberRoleId.get(teamMemberRoleId));
                teamMemberRoleHisBO.setTeamMainRole(true);
                teamMemberRoleHisBO.setTeamMemberId((Long)teamMemberRoleIdVsNewTeamMemberId.get(teamMemberRoleId));
                addTeamMemberRoleHisBOList.add(teamMemberRoleHisBO);
                teamMemberRoleHis.set("modifytime", (Object)this.now);
                teamMemberRoleHis.set("quitdate", (Object)HRDateTimeUtils.addDay((Date)startDate, (long)-1L));
                changeTeamMemberRoleHisList.add(teamMemberRoleHis);
            } else {
                teamMemberRoleHis.set("isteammainrole", (Object)"1");
                teamMemberRoleHis.set("modifytime", (Object)this.now);
                teamMemberRoleHis.set("bsed", (Object)this.now);
                teamMemberRoleHis.set("teammember", teamMemberRoleIdVsNewTeamMemberId.get(teamMemberRoleId));
                teamMemberRoleHis.set("teammember_id", teamMemberRoleIdVsNewTeamMemberId.get(teamMemberRoleId));
                changeTeamMemberRoleHisList.add(teamMemberRoleHis);
            }
        });
        ArrayList<ChangeMemberHisFunc<DynamicObject[]>> changeMemberHisFuncList = new ArrayList<ChangeMemberHisFunc<DynamicObject[]>>();
        changeMemberHisFuncList.add(() -> changeTeamMemberRoleHisList.toArray(new DynamicObject[0]));
        TeamMemberRoleHisServiceImpl teamMemberRoleHisService = new TeamMemberRoleHisServiceImpl();
        teamMemberRoleHisService.changeRoleHisVersion(changeMemberHisFuncList);
        teamMemberRoleHisService.createRoleHisObj(addTeamMemberRoleHisBOList);
    }

    private void init() {
        this.now = new Date();
    }

    private void updateOrAddTeamMemberRole(DynamicObject[] teamMemberRoles, Map<Long, Long> memberRoleIdVsNewTeamMemberId, Map<Long, Long> teamMemberRoleIdVsNewTeamMemberId) {
        Map<Long, Date> nextMainTeamMemberRoleVsConstituteDate = this.mainRoleSynModel.getNextMainTeamMemberRoleVsConstituteDate();
        DynamicObject[] updateOrNewTeamMemberRoles = (DynamicObject[])Arrays.stream(teamMemberRoles).map(teamMemberRole -> {
            ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
            Date joinDate = teamMemberRole.getDate("joindate");
            long teamMemberRoleId = teamMemberRole.getLong("id");
            Date newJoinDate = (Date)nextMainTeamMemberRoleVsConstituteDate.get(teamMemberRoleId);
            if (newJoinDate.after(joinDate)) {
                DynamicObject newTeamMemberRole = TeamMemberRoleRepository.getInstance().generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)teamMemberRole, (DynamicObject)newTeamMemberRole);
                newTeamMemberRole.set("id", memberRoleIdVsNewTeamMemberId.get(teamMemberRoleId));
                newTeamMemberRole.set("modifytime", (Object)this.now);
                newTeamMemberRole.set("isteammainrole", (Object)"1");
                newTeamMemberRole.set("joindate", (Object)newJoinDate);
                newTeamMemberRole.set("bsed", (Object)newTeamMemberRole.getDate("joindate"));
                newTeamMemberRole.set("teammember", teamMemberRoleIdVsNewTeamMemberId.get(teamMemberRoleId));
                newTeamMemberRole.set("teammember_id", teamMemberRoleIdVsNewTeamMemberId.get(teamMemberRoleId));
                result.add(newTeamMemberRole);
                teamMemberRole.set("modifytime", (Object)this.now);
                teamMemberRole.set("quitdate", (Object)HRDateTimeUtils.addDay((Date)newJoinDate, (long)-1L));
                result.add((DynamicObject)teamMemberRole);
            } else {
                teamMemberRole.set("isteammainrole", (Object)"1");
                teamMemberRole.set("modifytime", (Object)this.now);
                teamMemberRole.set("teammember", teamMemberRoleIdVsNewTeamMemberId.get(teamMemberRoleId));
                teamMemberRole.set("teammember_id", teamMemberRoleIdVsNewTeamMemberId.get(teamMemberRoleId));
                result.add((DynamicObject)teamMemberRole);
            }
            return result;
        }).flatMap(Collection::stream).toArray(DynamicObject[]::new);
        TeamMemberRoleRepository.getInstance().update(updateOrNewTeamMemberRoles);
    }

    private void addTeamMember(List<DynamicObject> copyTeamMemberRoleList, Map<Long, Long> teamMemberRoleIdVsNewTeamMemberId) {
        Map<Long, Date> nextMainTeamMemberRoleVsConstituteDate = this.mainRoleSynModel.getNextMainTeamMemberRoleVsConstituteDate();
        DynamicObject[] teamMembers = (DynamicObject[])copyTeamMemberRoleList.stream().map(teamMemberRole -> {
            long teamMemberRoleId = teamMemberRole.getLong("id");
            Date joinDate = teamMemberRole.getDate("joindate");
            Date newJoinDate = (Date)nextMainTeamMemberRoleVsConstituteDate.get(teamMemberRoleId);
            DynamicObject newTeamMember = TeamMemberRepository.getInstance().generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)teamMemberRole, (DynamicObject)newTeamMember);
            newTeamMember.set("joindate", (Object)(newJoinDate.after(joinDate) ? newJoinDate : joinDate));
            newTeamMember.set("bsed", (Object)newTeamMember.getDate("joindate"));
            newTeamMember.set("modifytime", (Object)this.now);
            newTeamMember.set("createtime", (Object)this.now);
            newTeamMember.set("id", teamMemberRoleIdVsNewTeamMemberId.get(teamMemberRoleId));
            return newTeamMember;
        }).toArray(DynamicObject[]::new);
        TeamMemberRepository.getInstance().save(teamMembers);
    }
}

